/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.ReportConstants;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRChartDataItem;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.chart.CategoryChartValue;
import com.security.ireport.engine.definition.chart.ChartValue;
import com.security.ireport.engine.definition.chart.PieChartValue;
import com.security.ireport.engine.definition.chart.TimeChartValue;
import com.security.ireport.engine.definition.chart.XYChartValue;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ChartValueFactory {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static Map<String, ChartValue[]> getChartValues(IRChart reportChart, Map<?, ?> parameters, IDataSourceCollector collector, long reportSessionId) throws ProviderException {
        HashMap<String, ChartValue[]> valuesMap = new HashMap<String, ChartValue[]>();
        Map<Object, Object> valueListMap = new HashMap();
        if (collector != null) {
            collector.loadData(0L, 0L, null);
            long size = collector.getCurPageCount();
            int chartType = ReportConstants.getChartType(reportChart);
            if (ChartValueFactory.isBarChartValue(chartType)) {
                valueListMap = ChartValueFactory.getBarChartValue(reportChart, collector, size, reportSessionId);
            }
            if (ChartValueFactory.isCompBarChartValue(chartType)) {
                valueListMap = ChartValueFactory.getCompBarChartValue(reportChart, collector, size, reportSessionId);
            }
            if (ChartValueFactory.isLineChartValue(chartType)) {
                valueListMap = ChartValueFactory.getCompLineChartValue(reportChart, collector, size, reportSessionId);
            } else if (ChartValueFactory.isPieChartValue(chartType)) {
                valueListMap = ChartValueFactory.getPieChartValue(reportChart, collector, size, reportSessionId);
            } else if (ChartValueFactory.isXYChartValue(chartType)) {
                valueListMap = ChartValueFactory.getXYChartValue(reportChart, collector, size, reportSessionId);
            } else if (ChartValueFactory.isTimeSeriesValue(chartType)) {
                valueListMap = ChartValueFactory.getTimeSeriesValue(reportChart, collector, size, reportSessionId);
            } else if (ChartValueFactory.isHoriBarChartValue(chartType)) {
                valueListMap = ChartValueFactory.getHoriBarChartValue(reportChart, collector, size, reportSessionId);
            }
            Iterator<Map.Entry<Object, Object>> valueIterator = valueListMap.entrySet().iterator();
            ChartValue[] chartValues = null;
            while (valueIterator.hasNext()) {
                Map.Entry<Object, Object> entry = valueIterator.next();
                String chartValueKey = (String)entry.getKey();
                List chartValueList = (List)entry.getValue();
                chartValues = new ChartValue[chartValueList.size()];
                chartValueList.toArray(chartValues);
                valuesMap.put(chartValueKey, chartValues);
            }
        } else {
            LOG.error((Object)("chart '" + reportChart.getId() + "' dataSource is error"));
        }
        return valuesMap;
    }

    private static boolean isBarChartValue(int chartType) {
        boolean isBarChartValue = false;
        if (chartType == 0 || chartType == 20 || chartType == 5 || chartType == 8 || chartType == 17) {
            isBarChartValue = true;
        }
        return isBarChartValue;
    }

    private static boolean isLineChartValue(int chartType) {
        boolean isBarChartValue = false;
        if (chartType == 23) {
            isBarChartValue = true;
        }
        return isBarChartValue;
    }

    private static boolean isCompBarChartValue(int chartType) {
        boolean isCompBarChartValue = false;
        if (chartType == 24) {
            isCompBarChartValue = true;
        }
        return isCompBarChartValue;
    }

    private static boolean isHoriBarChartValue(int chartType) {
        boolean isHoriBarChartValue = false;
        if (chartType == 30) {
            isHoriBarChartValue = true;
        }
        return isHoriBarChartValue;
    }

    private static boolean isPieChartValue(int chartType) {
        boolean isPieChartValue = false;
        if (chartType == 1 || chartType == 21 || chartType == 4) {
            isPieChartValue = true;
        }
        return isPieChartValue;
    }

    private static boolean isXYChartValue(int chartType) {
        boolean isXYChartValue = false;
        if (chartType == 2 || chartType == 6 || chartType == 13 || chartType == 14) {
            isXYChartValue = true;
        }
        return isXYChartValue;
    }

    private static boolean isTimeSeriesValue(int chartType) {
        boolean isTimeSeriesValue = false;
        if (3 == chartType || 7 == chartType || 15 == chartType || 16 == chartType || 18 == chartType) {
            isTimeSeriesValue = true;
        }
        return isTimeSeriesValue;
    }

    private static Map<String, List<ChartValue>> getBarChartValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        if (reportChart.getIRDataSet().isAutoExpand()) {
            return ChartValueFactory.getBarChartValueAutoExpand(reportChart, collector, size, reportSessionId);
        }
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        if (size <= 0L) {
            return valueListMap;
        }
        String groupField = reportChart.getIRDataSet().getGroup();
        for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
            CategoryChartValue catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, 0, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(item.getKey());
                catValue.setCategory(item.getKey());
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(item.getKey(), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatStr);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, 0, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(0L, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getCompBarChartValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        if (reportChart.getIRDataSet().isAutoExpand()) {
            return ChartValueFactory.getCompBarChartValueAutoExpand(reportChart, collector, size, reportSessionId);
        }
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        if (size <= 0L) {
            return valueListMap;
        }
        String groupField = reportChart.getIRDataSet().getGroup();
        for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
            CategoryChartValue catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, 0, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(item.getKey());
                catValue.setCategory(item.getKey());
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(item.getKey(), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatStr);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, 0, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(0L, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getHoriBarChartValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        if (reportChart.getIRDataSet().isAutoExpand()) {
            return ChartValueFactory.getHoriBarChartValueAutoExpand(reportChart, collector, size, reportSessionId);
        }
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        if (size <= 0L) {
            return valueListMap;
        }
        String groupField = reportChart.getIRDataSet().getGroup();
        for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
            CategoryChartValue catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, 0, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(item.getKey());
                catValue.setCategory(item.getKey());
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(item.getKey(), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatStr);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, 0, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(0L, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getCompLineChartValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        if (reportChart.getIRDataSet().isAutoExpand()) {
            return ChartValueFactory.getCompBarChartValueAutoExpand(reportChart, collector, size, reportSessionId);
        }
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        if (size <= 0L) {
            return valueListMap;
        }
        String groupField = reportChart.getIRDataSet().getGroup();
        for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
            CategoryChartValue catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, 0, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(item.getSeries());
                catValue.setCategory(item.getKey());
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(item.getKey(), new IRColumn(item.getKeyFormatType(), ""));
                String formatSeri = IReportConfCheckUtil.formatObj(item.getSeries(), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatSeri);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, 0, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(0L, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getBarChartValueAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        String groupField = reportChart.getIRDataSet().getGroup();
        IRChartDataItem item = reportChart.getIRDataSet().getDataItemList().get(0);
        int row = 0;
        CategoryChartValue catValue = null;
        while ((long)row < size) {
            catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(String.valueOf(collector.getValue(row, item.getKey())));
                catValue.setCategory(String.valueOf(collector.getValue(row, item.getKey())));
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(collector.getValue(row, item.getKey()), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatStr);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
            ++row;
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getCompBarChartValueAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        String groupField = reportChart.getIRDataSet().getGroup();
        IRChartDataItem item = reportChart.getIRDataSet().getDataItemList().get(0);
        int row = 0;
        CategoryChartValue catValue = null;
        while ((long)row < size) {
            catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(String.valueOf(collector.getValue(row, item.getSeries())));
                catValue.setCategory(String.valueOf(collector.getValue(row, item.getKey())));
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(collector.getValue(row, item.getKey()), new IRColumn(item.getKeyFormatType(), ""));
                String formatSeri = IReportConfCheckUtil.formatObj(collector.getValue(row, item.getSeries()), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatSeri);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
            ++row;
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getHoriBarChartValueAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        String groupField = reportChart.getIRDataSet().getGroup();
        IRChartDataItem item = reportChart.getIRDataSet().getDataItemList().get(0);
        int row = 0;
        CategoryChartValue catValue = null;
        while ((long)row < size) {
            catValue = new CategoryChartValue();
            catValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            catValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                catValue.setSeries(String.valueOf(collector.getValue(row, item.getSeries())));
                catValue.setCategory(String.valueOf(collector.getValue(row, item.getKey())));
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(collector.getValue(row, item.getKey()), new IRColumn(item.getKeyFormatType(), ""));
                String formatSeri = IReportConfCheckUtil.formatObj(collector.getValue(row, item.getSeries()), new IRColumn(item.getKeyFormatType(), ""));
                catValue.setCategory(formatStr);
                catValue.setSeries(formatSeri);
            }
            catValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, catValue);
            ++row;
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getPieChartValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        if (reportChart.getIRDataSet().isAutoExpand()) {
            return ChartValueFactory.getPieChartValueAutoExpand(reportChart, collector, size, reportSessionId);
        }
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        if (size <= 0L) {
            return valueListMap;
        }
        String groupField = reportChart.getIRDataSet().getGroup();
        for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
            PieChartValue pieValue = new PieChartValue();
            pieValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                pieValue.setKey(String.valueOf(item.getKey()));
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(item.getKey(), new IRColumn(item.getKeyFormatType(), ""));
                pieValue.setKey(formatStr);
            }
            pieValue.setValue(ChartValueFactory.getDoubleValue(collector, 0, item.getValue()));
            pieValue.setUrlText(ChartValueFactory.createUrlText(collector, 0, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(0L, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, pieValue);
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getPieChartValueAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        String groupField = reportChart.getIRDataSet().getGroup();
        IRChartDataItem item = reportChart.getIRDataSet().getDataItemList().get(0);
        int row = 0;
        while ((long)row < size) {
            PieChartValue pieValue = new PieChartValue();
            pieValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
            if (IReportConfCheckUtil.isStringEmpty(item.getKeyFormatType())) {
                pieValue.setKey(String.valueOf(collector.getValue(row, item.getKey())));
            } else {
                String formatStr = IReportConfCheckUtil.formatObj(collector.getValue(row, item.getKey()), new IRColumn(item.getKeyFormatType(), ""));
                pieValue.setKey(formatStr);
            }
            pieValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
            pieValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
            }
            ChartValueFactory.putValueIntoMap(valueListMap, groupValue, pieValue);
            ++row;
        }
        return valueListMap;
    }

    private static double getDoubleValue(IDataSourceCollector collector, int row, String colName) {
        String str = String.valueOf(collector.getValue(row, colName));
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("getDoubleValue->colName:" + colName + " value can't trans to double."));
            return 0.0;
        }
    }

    private static Date getDateValue(IDataSourceCollector collector, int row, String colName) {
        Object obj = collector.getValue(row, colName);
        if (null == obj) {
            LOG.error((Object)("getDateValue->colName:" + colName + " value is null."));
            return new Date(0L);
        }
        try {
            return new Date(IReportConfCheckUtil.getLong(obj));
        }
        catch (Exception e) {
            LOG.error((Object)("getDateValue->colName:" + colName + " value can't trans to Date."));
            return new Date(0L);
        }
    }

    private static String createUrlText(IDataSourceCollector collector, int row, long reportSessionId, IRChartDataItem item) {
        String result = item.getDataDrillAction();
        result = !IReportConfCheckUtil.isStringEmpty(result) ? IReportUtil.formatUrl(result, row, collector, reportSessionId) : (!IReportConfCheckUtil.isStringEmpty(item.getUrlField()) ? String.valueOf(collector.getValue(row, item.getUrlField())) : null);
        return result;
    }

    private static Map<String, List<ChartValue>> getTimeSeriesValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        Map<Object, Object> valueListMap = new HashMap();
        try {
            valueListMap = reportChart.getIRDataSet().isAutoExpand() ? ChartValueFactory.getTimeSeriesValueAutoExpand(reportChart, collector, size, reportSessionId) : ChartValueFactory.getTimeSeriesValueNotAutoExpand(reportChart, collector, size, reportSessionId);
        }
        catch (NumberFormatException e) {
            valueListMap.clear();
            LOG.error((Object)("chart '" + reportChart.getId() + "' dataSource value column not number."));
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getTimeSeriesValueNotAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
            int row = 0;
            String groupField = reportChart.getIRDataSet().getGroup();
            while ((long)row < size) {
                TimeChartValue tValue = new TimeChartValue();
                tValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
                tValue.setSeries(item.getSeries());
                tValue.setTime(ChartValueFactory.getDateValue(collector, row, item.getKey()));
                tValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
                tValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
                String groupValue = "";
                if (groupField != null && !groupField.isEmpty()) {
                    groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
                }
                ChartValueFactory.putValueIntoMap(valueListMap, groupValue, tValue);
                ++row;
            }
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getTimeSeriesValueAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        try {
            IRChartDataItem item = reportChart.getIRDataSet().getDataItemList().get(0);
            String groupField = reportChart.getIRDataSet().getGroup();
            int row = 0;
            while ((long)row < size) {
                TimeChartValue tValue = new TimeChartValue();
                tValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
                tValue.setSeries(String.valueOf(collector.getValue(row, item.getSeries())));
                tValue.setTime(ChartValueFactory.getDateValue(collector, row, item.getKey()));
                tValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
                tValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
                String groupValue = "";
                if (groupField != null && !groupField.isEmpty()) {
                    groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
                }
                ChartValueFactory.putValueIntoMap(valueListMap, groupValue, tValue);
                ++row;
            }
        }
        catch (NumberFormatException e) {
            valueListMap.clear();
            LOG.error((Object)("chart '" + reportChart.getId() + "' dataSource value column not number."));
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getXYChartValue(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        if (reportChart.getIRDataSet().isAutoExpand()) {
            return ChartValueFactory.getXYChartValueAutoExpand(reportChart, collector, size, reportSessionId);
        }
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        try {
            String groupField = reportChart.getIRDataSet().getGroup();
            for (IRChartDataItem item : reportChart.getIRDataSet().getDataItemList()) {
                int row = 0;
                while ((long)row < size) {
                    XYChartValue xyValue = new XYChartValue();
                    xyValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
                    xyValue.setSeries(item.getSeries());
                    xyValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getKey()));
                    xyValue.setYValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
                    xyValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
                    String groupValue = "";
                    if (groupField != null && !groupField.isEmpty()) {
                        groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
                    }
                    ChartValueFactory.putValueIntoMap(valueListMap, groupValue, xyValue);
                    ++row;
                }
            }
        }
        catch (NumberFormatException e) {
            valueListMap.clear();
            LOG.error((Object)("chart '" + reportChart.getId() + "' dataSource value column not number."));
        }
        return valueListMap;
    }

    private static Map<String, List<ChartValue>> getXYChartValueAutoExpand(IRChart reportChart, IDataSourceCollector collector, long size, long reportSessionId) {
        HashMap<String, List<ChartValue>> valueListMap = new HashMap<String, List<ChartValue>>();
        try {
            IRChartDataItem item = reportChart.getIRDataSet().getDataItemList().get(0);
            String groupField = reportChart.getIRDataSet().getGroup();
            int row = 0;
            while ((long)row < size) {
                XYChartValue xyValue = new XYChartValue();
                xyValue.setKeyMaxLength(reportChart.getIRDataSet().getKeyMaxLength());
                xyValue.setSeries(String.valueOf(collector.getValue(row, item.getSeries())));
                xyValue.setValue(ChartValueFactory.getDoubleValue(collector, row, item.getKey()));
                xyValue.setYValue(ChartValueFactory.getDoubleValue(collector, row, item.getValue()));
                xyValue.setUrlText(ChartValueFactory.createUrlText(collector, row, reportSessionId, item));
                String groupValue = "";
                if (groupField != null && !groupField.isEmpty()) {
                    groupValue = IReportConfCheckUtil.getObjectStr(collector.getValue(row, groupField));
                }
                ChartValueFactory.putValueIntoMap(valueListMap, groupValue, xyValue);
                ++row;
            }
        }
        catch (NumberFormatException e) {
            valueListMap.clear();
            LOG.error((Object)("chart '" + reportChart.getId() + "' dataSource value column not number."));
        }
        return valueListMap;
    }

    private static void putValueIntoMap(Map<String, List<ChartValue>> valueListMap, String groupValue, ChartValue value) {
        if (valueListMap.containsKey(groupValue)) {
            valueListMap.get(groupValue).add(value);
        } else {
            ArrayList<ChartValue> chartValueList = new ArrayList<ChartValue>();
            chartValueList.add(value);
            valueListMap.put(groupValue, chartValueList);
        }
    }
}

