/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.security.ireport.util.EscapeUtil;
import com.security.ireport.util.chart.LegendUtil;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.util.StringUtils;

public abstract class IReportChartUtilities {
    public static String getImageMap(String name, ChartRenderingInfo info) {
        StringBuffer sb = new StringBuffer();
        sb.append("<map id=\"" + IReportChartUtilities.htmlEscape(name) + "\" name=\"" + IReportChartUtilities.htmlEscape(name) + "\">");
        sb.append(StringUtils.getLineSeparator());
        EntityCollection entities = info.getEntityCollection();
        if (entities != null) {
            int count = entities.getEntityCount();
            for (int i = count - 1; i >= 0; --i) {
                ChartEntity entity = entities.getEntity(i);
                String area = IReportChartUtilities.getImageMapAreaTag(entity);
                if (area.length() <= 0) continue;
                sb.append(area);
                sb.append(StringUtils.getLineSeparator());
            }
        }
        sb.append("</map>");
        return sb.toString();
    }

    private static String getImageMapAreaTag(ChartEntity chartEntity) {
        boolean hasToolTip;
        StringBuffer tag = new StringBuffer();
        boolean hasURL = chartEntity.getURLText() != null;
        boolean bl = hasToolTip = chartEntity.getToolTipText() != null;
        if (hasURL || hasToolTip) {
            tag.append("<area shape=\"" + chartEntity.getShapeType() + "\"" + " coords=\"" + chartEntity.getShapeCoords() + "\"");
            if (hasToolTip) {
                tag.append(IReportChartUtilities.generateToolTipFragment(chartEntity.getToolTipText()));
            }
            if (hasURL) {
                tag.append(IReportChartUtilities.generateURLFragment(chartEntity.getURLText()));
            } else {
                tag.append(" nohref=\"nohref\"");
            }
            if (!hasToolTip) {
                tag.append(" alt=\"\"");
            }
            tag.append("/>");
        }
        return tag.toString();
    }

    private static String generateToolTipFragment(String toolTipText) {
        return " title=\"" + EscapeUtil.escapeHtmlValue(toolTipText) + "\"";
    }

    private static String generateURLFragment(String urlText) {
        return " href=\"#\"onclick=\"window.open('" + LegendUtil.changeToWOS(IReportChartUtilities.reverseHtmlEscape(urlText)) + "')\"";
    }

    private static String htmlEscape(String input) {
        if (null == input) {
            throw new IllegalArgumentException("Null 'input' argument.");
        }
        StringBuffer result = new StringBuffer();
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            if (c == '\"') {
                result.append("&quot;");
                continue;
            }
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            if (c == '\'') {
                result.append("&#39;");
                continue;
            }
            if (c == '\\') {
                result.append("&#092;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String reverseHtmlEscape(String input) {
        if (null == input) {
            throw new IllegalArgumentException("Null 'input' argument.");
        }
        input = input.replaceAll("&amp;", "&");
        input = input.replaceAll("&quot;", "\"");
        input = input.replaceAll("&lt;", "<");
        input = input.replaceAll("&gt;", ">");
        input = input.replaceAll("&#39;", "'");
        input = input.replaceAll("&#092;", "\\");
        return input;
    }
}

