/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.security.ireport.engine.definition.chart.CategoryChartValue;
import com.security.ireport.engine.definition.chart.ChartValue;
import com.security.ireport.util.IReportConfCheckUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;

public class IReportStandardCategoryURLGenerator
implements CategoryURLGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2276668053074881909L;
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";
    private Map<String, String> urlMap = new HashMap<String, String>();

    public IReportStandardCategoryURLGenerator() {
    }

    public IReportStandardCategoryURLGenerator(String prefix) {
        if (null == prefix) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        this.prefix = prefix;
    }

    public IReportStandardCategoryURLGenerator(String prefix, String seriesParameterName, String categoryParameterName) {
        if (null == prefix) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        if (null == seriesParameterName) {
            throw new IllegalArgumentException("Null 'seriesParameterName' argument.");
        }
        if (null == categoryParameterName) {
            throw new IllegalArgumentException("Null 'categoryParameterName' argument.");
        }
        this.prefix = prefix;
        this.seriesParameterName = seriesParameterName;
        this.categoryParameterName = categoryParameterName;
    }

    public String generateURL(CategoryDataset dataset, int series, int category) {
        Comparable categoryKey = null;
        categoryKey = !dataset.getColumnKeys().isEmpty() && !IReportConfCheckUtil.isStringEmpty(String.valueOf(dataset.getColumnKey(0))) ? dataset.getColumnKey(category) : dataset.getRowKey(category);
        return this.urlMap.get(categoryKey.toString());
    }

    public void setChartValue(ChartValue[] values) {
        if (values != null && values.length > 1) {
            for (ChartValue item : values) {
                this.urlMap.put(((CategoryChartValue)item).getCategory(), item.getUrlText());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.categoryParameterName == null ? 0 : this.categoryParameterName.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.seriesParameterName == null ? 0 : this.seriesParameterName.hashCode());
        result = 31 * result + (this.urlMap == null ? 0 : this.urlMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IReportStandardCategoryURLGenerator other = (IReportStandardCategoryURLGenerator)obj;
        return !(this.urlMap == null ? other.urlMap != null : !this.urlMap.equals(other.urlMap));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

