/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ChartUtil;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.ReportConstants;
import com.security.ireport.engine.definition.IRAxis;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRColorMap;
import com.security.ireport.engine.definition.IRPlot;
import com.security.ireport.engine.definition.IRSeriesColor;
import com.security.ireport.engine.definition.chart.ChartValue;
import com.security.ireport.engine.definition.chart.TimeChartValue;
import com.security.ireport.engine.definition.chart.XYChartValue;
import com.security.ireport.engine.output.ChartEngineOutput;
import com.security.ireport.model.vo.ChartBuffer;
import com.security.ireport.model.vo.LegendColor;
import com.security.ireport.util.ExportConfigUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.ireport.util.chart.ChartDataSetFactory;
import com.security.ireport.util.chart.ChartParaInvocatorImpl;
import com.security.ireport.util.chart.IReportStandardCategoryURLGenerator;
import com.security.ireport.util.chart.IReportStandardPieURLGenerator;
import com.security.ireport.util.chart.IReportTimeURLGenerator;
import com.security.ireport.util.chart.IReportXYURLGenerator;
import com.security.ireport.util.chart.filter.ChartFilterUtil;
import com.security.ireport.util.chart.filter.IChartParaInvocator;
import com.security.ireport.util.chart.filter.MyDateAxis;
import com.security.ireport.util.chart.filter.MyPiePlot2D;
import com.security.ireport.util.chart.filter.MyPiePlot3D;
import com.security.ireport.util.chart.filter.PercentBarChartFilter;
import com.security.ireport.util.chart.filter.PercentTimeChartFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ShapeUtilities;

public abstract class JChartFactory {
    private static final double D_0_15 = 0.15;
    private static final double D_4_0 = 4.0;
    private static final double D_0_06 = 0.06;
    private static final double D_0_90 = 0.9;
    private static final double D_0_86 = 0.86;
    private static final double D_0_02 = 0.02;
    private static final double D_0_12 = 0.12;
    private static final double D_20_D = 20.0;
    private static final float D_4_0F = 4.0f;
    private static final double D_30_D = 30.0;
    private static final double D_0_08 = 0.08;
    private static final double D_0_04 = 0.04;
    private static final double D_0_03 = 0.03;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final double RANGE_AXIS_UPPER_MARGIN_MAX = 0.25;
    private static final double RANGE_AXIS_LOWER_MARGIN_MAX = 0.25;
    private static final Font PIE_LABEL_FONT = new Font("SansSerif", 1, 10);
    private static final double PIE_MAX_LABEL_WIDTH = 0.15;
    private static final double BAR_X_OFFSET = 20.0;
    private static final double BAR_Y_OFFSET = 10.0;
    private static final Color BAR_WALL_PAINT = new Color(221, 221, 221);
    private static final Color COLOR_BG = new Color(250, 250, 250);
    private static final double BAR_MAX_WIDTH = 0.06;
    private static final Color BAR_RANGG_GRID_LINE_PAINT = new Color(127, 127, 127);
    private static IChartParaInvocator filter = new ChartParaInvocatorImpl();

    public static ChartEngineOutput createChartOutput(IRChart reportChart, Map<String, ChartValue[]> valueMap) throws ProviderException {
        ChartEngineOutput chartOutput = new ChartEngineOutput();
        ArrayList<byte[]> content = new ArrayList<byte[]>();
        ArrayList<byte[]> exportContent = new ArrayList<byte[]>();
        ArrayList<List<LegendColor>> legendColorList = new ArrayList<List<LegendColor>>();
        for (Map.Entry<String, ChartValue[]> item : valueMap.entrySet()) {
            ChartValue[] values = item.getValue();
            if (null == values || values.length < 1) {
                throw new ProviderException("createChartOutput: The ChartValue is null or empty");
            }
            ChartBuffer temp = JChartFactory.createChartBuf(reportChart, values, item.getKey(), false, null, null, 0);
            if (null == temp) {
                throw new ProviderException("can't create chart, maybe it isn't supported chart.");
            }
            chartOutput.getRenderInfoList().add(temp.getInfo());
            byte[] image = null;
            try {
                image = EncoderUtil.encode((BufferedImage)temp.getBufferedImage(), (String)"png");
                content.add(image);
                if (!reportChart.isTableCell()) {
                    image = EncoderUtil.encode((BufferedImage)temp.getExportBufferedImage(), (String)"png");
                    exportContent.add(image);
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
            }
            legendColorList.add(new ArrayList<LegendColor>(reportChart.getPlot().getLegendColorList()));
        }
        chartOutput.setContent(content);
        chartOutput.setExportContent(exportContent);
        chartOutput.setLegendColorList(legendColorList);
        chartOutput.setContentType("image/png");
        chartOutput.setElementId(reportChart.getId());
        return chartOutput;
    }

    public static ChartEngineOutput createEmptyOutput(Locale locale, IRChart reportChart, String noDateKey, int noDateSize) throws ProviderException {
        ChartEngineOutput chartOutput = new ChartEngineOutput();
        ArrayList<byte[]> content = new ArrayList<byte[]>();
        ArrayList<byte[]> exportContent = new ArrayList<byte[]>();
        ChartValue[] values = new ChartValue[]{};
        IRChart cloneChart = null;
        try {
            cloneChart = reportChart.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e);
        }
        cloneChart.setChartType("PieChart");
        ChartBuffer temp = JChartFactory.createChartBuf(cloneChart, values, "", true, locale, noDateKey, noDateSize);
        if (null == temp) {
            throw new ProviderException("can't create chart, maybe it isn't supported chart.");
        }
        chartOutput.getRenderInfoList().add(temp.getInfo());
        byte[] image = null;
        try {
            image = EncoderUtil.encode((BufferedImage)temp.getBufferedImage(), (String)"png");
            content.add(image);
            if (!reportChart.isTableCell()) {
                image = EncoderUtil.encode((BufferedImage)temp.getExportBufferedImage(), (String)"png");
                exportContent.add(image);
            }
            if (null != temp.getEmptySmallBufferedImage()) {
                chartOutput.setExportSmallHeightContent(EncoderUtil.encode((BufferedImage)temp.getEmptySmallBufferedImage(), (String)"png"));
            }
            if (null != temp.getEmptySmallExcelBufferedImage()) {
                chartOutput.setExportSmallExcelHeightContent(EncoderUtil.encode((BufferedImage)temp.getEmptySmallExcelBufferedImage(), (String)"png"));
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
        }
        chartOutput.setContent(content);
        chartOutput.setExportContent(exportContent);
        chartOutput.setContentType("image/png");
        chartOutput.setElementId(reportChart.getId());
        return chartOutput;
    }

    public static ChartBuffer createChartBuf(IRChart reportChart, Dataset dataset) {
        ChartBuffer chartBuf = null;
        JFreeChart chart = JChartFactory.createChart(reportChart, dataset);
        if (chart != null) {
            chart.setBackgroundPaint((Paint)COLOR_BG);
            chartBuf = new ChartBuffer();
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            BufferedImage bufferedImage = chart.createBufferedImage(reportChart.getWidth(), reportChart.getHeight(), info);
            chartBuf.setBufferedImage(bufferedImage);
            chartBuf.setInfo(info);
            BufferedImage exportBufferedImage = chart.createBufferedImage(reportChart.getExportWidth(), reportChart.getExportHeight(), new ChartRenderingInfo((EntityCollection)new StandardEntityCollection()));
            chartBuf.setExportBufferedImage(exportBufferedImage);
        }
        return chartBuf;
    }

    public static ChartBuffer createChartBuf(IRChart reportChart, ChartValue[] values, String groupName, boolean isEmpty, Locale locale, String noDateKey, int noDateSize) {
        ChartBuffer chartBuf = null;
        IChartParaInvocator.ImageRange imageRange = filter.calculateImageRange(reportChart, values);
        JFreeChart chart = JChartFactory.createChart(reportChart, values);
        reportChart.setShowDataDrill(values.length);
        if (chart != null) {
            TextTitle subtitle = new TextTitle(reportChart.getSubTitle() + JChartFactory.transGroup(groupName), new Font("sans-serif", 1, 12));
            if (isEmpty) {
                chart.getPlot().setNoDataMessage(LocaleUtil.getLocaleText(locale, noDateKey));
                chart.getPlot().setNoDataMessageFont(new Font("sans-serif", 0, noDateSize));
            }
            chart.setTitle(reportChart.getTitle() + JChartFactory.transGroup(groupName));
            chart.addSubtitle((Title)subtitle);
            chartBuf = new ChartBuffer();
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            BufferedImage bufferedImage = null;
            bufferedImage = chart.createBufferedImage(imageRange.getWidth(), imageRange.getHeight(), info);
            chartBuf.setBufferedImage(bufferedImage);
            chartBuf.setInfo(info);
            if (!reportChart.isTableCell()) {
                BufferedImage exportBufferedImage = chart.createBufferedImage(imageRange.getExportWidth(), imageRange.getExportHeight(), new ChartRenderingInfo((EntityCollection)new StandardEntityCollection()));
                chartBuf.setExportBufferedImage(exportBufferedImage);
            }
            JChartFactory.setEmptySmallImage(isEmpty, reportChart, chart, imageRange, chartBuf);
        }
        return chartBuf;
    }

    private static void setEmptySmallImage(boolean isEmpty, IRChart reportChart, JFreeChart chart, IChartParaInvocator.ImageRange imageRange, ChartBuffer chartBuf) {
        int height = imageRange.getExportSmallHeight();
        if (-1 != ExportConfigUtil.getEmptySmallHeight()) {
            height = ExportConfigUtil.getEmptySmallHeight();
        }
        if (isEmpty && ExportConfigUtil.isEmptySmallHeight()) {
            BufferedImage emptySmallBufferedImage = chart.createBufferedImage(imageRange.getWidth(), height, chartBuf.getInfo());
            chartBuf.setEmptySmallBufferedImage(emptySmallBufferedImage);
        }
        if (!reportChart.isTableCell() && isEmpty && ExportConfigUtil.isEmptySmallHeight()) {
            BufferedImage emptySmallExcelBufferedImage = chart.createBufferedImage(imageRange.getExportWidth(), height, chartBuf.getInfo());
            chartBuf.setEmptySmallExcelBufferedImage(emptySmallExcelBufferedImage);
        }
    }

    private static String transGroup(String groupName) {
        if (IReportConfCheckUtil.isStringEmpty(groupName)) {
            return "";
        }
        return "(" + groupName + ")";
    }

    public static JFreeChart createChart(IRChart reportChart, Dataset dataset) {
        JFreeChart chart = null;
        chart = JChartFactory.createSimpleChart(reportChart, dataset);
        if (null != chart) {
            chart.setBackgroundPaint((Paint)COLOR_BG);
        }
        return chart;
    }

    public static JFreeChart createEmptyChart(IRChart reportChart) {
        ChartValue[] values = new ChartValue[]{};
        IRChart cloneChart = null;
        try {
            cloneChart = reportChart.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e);
        }
        cloneChart.setChartType("PieChart");
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = JChartFactory.createChart(cloneChart, values);
        if (chart != null) {
            TextTitle subtitle = new TextTitle(reportChart.getSubTitle(), new Font("sans-serif", 1, 12));
            chart.getPlot().setNoDataMessage(LocaleUtil.getLocaleText("ireport.nodata"));
            chart.getPlot().setNoDataMessageFont(new Font("sans-serif", 0, 15));
            chart.setTitle(reportChart.getTitle());
            chart.addSubtitle((Title)subtitle);
        }
        return chart;
    }

    public static JFreeChart createChart(IRChart reportChart, ChartValue[] values) {
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = null;
        chart = JChartFactory.createSimpleChart(reportChart, values);
        if (null == chart) {
            chart = JChartFactory.createUnUseChart(reportChart, values);
        }
        if (null != chart) {
            chart.setBackgroundPaint((Paint)COLOR_BG);
        }
        return chart;
    }

    private static JFreeChart createUnUseChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = null;
        switch (ReportConstants.getChartType(reportChart)) {
            case 9: {
                chart = JChartFactory.createDialChart(reportChart, values);
                break;
            }
            case 10: {
                chart = JChartFactory.createThermometerChart(reportChart, values);
                break;
            }
            case 13: {
                chart = JChartFactory.createXYBarChart(reportChart, values);
                break;
            }
            case 14: {
                chart = JChartFactory.createStackedXYBarChart(reportChart, values);
                break;
            }
            case 15: {
                chart = JChartFactory.createTimeBarChart(reportChart, values);
                break;
            }
            case 4: {
                chart = JChartFactory.createRingChart(reportChart, values);
                break;
            }
            case 5: {
                chart = JChartFactory.createAreaChart(reportChart, values);
                break;
            }
            case 8: {
                chart = JChartFactory.createStackedBarChart(reportChart, values);
                break;
            }
        }
        if (chart != null) {
            JChartFactory.handFont(chart.getPlot());
        }
        return chart;
    }

    private static JFreeChart createOtherSimpleChart(IRChart reportChart, Dataset dataset) {
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = null;
        switch (ReportConstants.getChartType(reportChart)) {
            case 6: {
                chart = JChartFactory.createXYAreaChart(reportChart, (XYDataset)dataset);
                break;
            }
            case 7: {
                chart = JChartFactory.createTimeAreaChart(reportChart, (XYDataset)dataset);
                break;
            }
            case 18: {
                chart = JChartFactory.createPercentTimeChart(reportChart, (TimeSeriesCollection)dataset);
                break;
            }
            case 23: {
                chart = JChartFactory.createCompLineChart(reportChart, (CategoryDataset)dataset);
                break;
            }
            case 24: {
                chart = JChartFactory.createCompBarChart(reportChart, (CategoryDataset)dataset);
                break;
            }
        }
        return chart;
    }

    private static JFreeChart createSimpleChart(IRChart reportChart, Dataset dataset) {
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = null;
        switch (ReportConstants.getChartType(reportChart)) {
            case 0: {
                chart = JChartFactory.create2DBarChart(reportChart, (CategoryDataset)dataset);
                break;
            }
            case 20: {
                chart = JChartFactory.createBarChart(reportChart, (CategoryDataset)dataset);
                break;
            }
            case 1: {
                chart = JChartFactory.create2DPieChart(reportChart, (PieDataset)dataset);
                break;
            }
            case 21: {
                chart = JChartFactory.createPieChart(reportChart, (PieDataset)dataset);
                break;
            }
            case 2: {
                chart = JChartFactory.createXYChart(reportChart, (XYDataset)dataset);
                break;
            }
            case 3: {
                chart = JChartFactory.createTimeChart(reportChart, (XYDataset)dataset);
                break;
            }
            default: {
                chart = JChartFactory.createOtherSimpleChart(reportChart, dataset);
            }
        }
        if (null != chart) {
            JChartFactory.handFont(chart.getPlot());
        }
        return chart;
    }

    private static JFreeChart createSimpleChart(IRChart reportChart, ChartValue[] values) {
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = null;
        switch (ReportConstants.getChartType(reportChart)) {
            case 0: {
                chart = JChartFactory.create2DBarChart(reportChart, values);
                break;
            }
            case 20: {
                chart = JChartFactory.createBarChart(reportChart, values);
                break;
            }
            case 1: {
                chart = JChartFactory.create2DPieChart(reportChart, values);
                break;
            }
            case 21: {
                chart = JChartFactory.createPieChart(reportChart, values);
                break;
            }
            case 2: {
                chart = JChartFactory.createXYChart(reportChart, values);
                break;
            }
            case 3: {
                chart = JChartFactory.createTimeChart(reportChart, values);
                break;
            }
            case 6: {
                chart = JChartFactory.createXYAreaChart(reportChart, values);
                break;
            }
            case 7: {
                chart = JChartFactory.createTimeAreaChart(reportChart, values);
                break;
            }
            default: {
                chart = JChartFactory.createOtherSimpleChart(reportChart, values);
            }
        }
        if (null != chart) {
            JChartFactory.handFont(chart.getPlot());
        }
        return chart;
    }

    private static JFreeChart createOtherSimpleChart(IRChart reportChart, ChartValue[] values) {
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = null;
        switch (ReportConstants.getChartType(reportChart)) {
            case 17: {
                chart = JChartFactory.createPercent2DBarChart(reportChart, values);
                break;
            }
            case 22: {
                chart = JChartFactory.createPercentBarChart(reportChart, values);
                break;
            }
            case 18: {
                chart = JChartFactory.createPercentTimeChart(reportChart, values);
                break;
            }
            case 16: {
                chart = JChartFactory.createStackedTimeAreaChart(reportChart, values);
                break;
            }
            case 23: {
                chart = JChartFactory.createCompLineChart(reportChart, values);
                break;
            }
            case 24: {
                chart = JChartFactory.createCompBarChart(reportChart, values);
                break;
            }
            case 30: {
                chart = JChartFactory.createHoriBarChart(reportChart, values);
                break;
            }
        }
        return chart;
    }

    private static JFreeChart createBarChart(IRChart reportChart, ChartValue[] values) {
        CategoryDataset dataset = ChartDataSetFactory.createBarCategoryDataset(reportChart, values);
        JFreeChart chart = JChartFactory.createBarChart(reportChart, dataset);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        BarRenderer3D render = (BarRenderer3D)plot.getRenderer();
        IReportStandardCategoryURLGenerator urlGenerator = new IReportStandardCategoryURLGenerator();
        urlGenerator.setChartValue(values);
        render.setItemURLGenerator((CategoryURLGenerator)urlGenerator);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        return chart;
    }

    private static JFreeChart create2DBarChart(IRChart reportChart, ChartValue[] values) {
        CategoryDataset dataset = ChartDataSetFactory.create2DBarCategoryDataset(reportChart, values);
        JFreeChart chart = JChartFactory.create2DBarChart(reportChart, dataset);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        BarRenderer render = (BarRenderer)plot.getRenderer();
        render.setShadowVisible(false);
        IReportStandardCategoryURLGenerator urlGenerator = new IReportStandardCategoryURLGenerator();
        urlGenerator.setChartValue(values);
        render.setItemURLGenerator((CategoryURLGenerator)urlGenerator);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        return chart;
    }

    private static void formatRangeAxis(ValueAxis axis, IRAxis rangeAxis) {
        if (!(axis instanceof NumberAxis)) {
            return;
        }
        NumberAxis numberAxis = (NumberAxis)axis;
        String formatType = rangeAxis.getFormatType();
        String formatValue = rangeAxis.getFormatValue();
        if (!IReportConfCheckUtil.isStringEmpty(formatType) && formatType.equalsIgnoreCase("NumberFormat")) {
            JChartFactory.formatNumber(numberAxis, formatValue);
        }
    }

    private static void setNumberAxisLowBound(ValueAxis axis, ChartValue[] values) {
        if (!(axis instanceof NumberAxis) || null == values || 0 == values.length) {
            return;
        }
        for (ChartValue value : values) {
            if (!(value instanceof TimeChartValue ? value.getValue() > 0.0 : value instanceof XYChartValue && ((XYChartValue)value).getYValue() > 0.0)) continue;
            return;
        }
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setLowerBound(0.0);
    }

    private static void setNumberAxisLowBound(ValueAxis axis, TimeSeriesCollection dataset) {
        if (!(axis instanceof NumberAxis) || null == dataset || 0 == dataset.getSeriesCount()) {
            return;
        }
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            TimeSeries t = dataset.getSeries(i);
            if (t.getItemCount() <= 0) continue;
            for (int j = 0; j < t.getItemCount(); ++j) {
                if (!(t.getDataItem(j).getValue().doubleValue() > 0.0)) continue;
                return;
            }
        }
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setLowerBound(0.0);
    }

    private static void formatNumber(NumberAxis numberAxis, String formatValue) {
        DecimalFormat formatter = null;
        try {
            formatter = !IReportConfCheckUtil.isStringEmpty(formatValue) ? new DecimalFormat(formatValue) : new DecimalFormat();
            numberAxis.setNumberFormatOverride((NumberFormat)formatter);
            if (formatValue != null && !formatValue.contains(".")) {
                numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("formatValue=" + formatValue), (Throwable)e);
        }
    }

    private static JFreeChart createBarChart(IRChart reportChart, CategoryDataset dataset) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        CategoryAxis3D categoryAxis = new CategoryAxis3D();
        NumberAxis3D valueAxis = new NumberAxis3D();
        BarRenderer3D renderer = new BarRenderer3D(20.0, 10.0);
        if (productName.equalsIgnoreCase("VSM V2")) {
            renderer.setBaseOutlinePaint((Paint)new Color(244, 244, 244));
        } else {
            renderer.setBaseOutlinePaint((Paint)Color.BLACK);
        }
        JChartFactory.setValueShowTop(reportChart, renderer);
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator(renderer);
        renderer.setWallPaint((Paint)BAR_WALL_PAINT);
        renderer.setDrawBarOutline(false);
        renderer.setMaximumBarWidth(0.06);
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        plot.setRangeGridlinePaint((Paint)BAR_RANGG_GRID_LINE_PAINT);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        JChartFactory.setSeriesChartSeriesColor(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart create2DBarChart(IRChart reportChart, CategoryDataset dataset) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        CategoryAxis categoryAxis = new CategoryAxis();
        NumberAxis valueAxis = new NumberAxis();
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        renderer.setErrorIndicatorStroke((Stroke)new BasicStroke(0.0f));
        renderer.setErrorIndicatorPaint((Paint)new Color(255, 255, 255));
        JChartFactory.setValueShowTop(reportChart, renderer);
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator((BarRenderer)renderer);
        if (productName.equalsIgnoreCase("VSM V2")) {
            renderer.setBaseOutlinePaint((Paint)COLOR_BG);
        } else {
            renderer.setBaseOutlinePaint((Paint)Color.BLACK);
        }
        renderer.setDrawBarOutline(false);
        renderer.setMaximumBarWidth(0.06);
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        plot.setRangeGridlinePaint((Paint)BAR_RANGG_GRID_LINE_PAINT);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)new Color(244, 244, 244));
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        JChartFactory.setSeriesChartSeriesColor(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart createPercentBarChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = JChartFactory.createBarChart(reportChart, values);
        PercentBarChartFilter.filter(reportChart, chart);
        return chart;
    }

    private static JFreeChart createPercent2DBarChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = JChartFactory.create2DBarChart(reportChart, values);
        PercentBarChartFilter.filter(reportChart, chart);
        return chart;
    }

    private static JFreeChart createPieChart(IRChart reportChart, ChartValue[] values) {
        PieDataset dataset = ChartDataSetFactory.createPieDataset(reportChart, values, reportChart.getTopN());
        JFreeChart chart = JChartFactory.createPieChart(reportChart, dataset);
        MyPiePlot3D plot = (MyPiePlot3D)chart.getPlot();
        IReportStandardPieURLGenerator urlGenerator = new IReportStandardPieURLGenerator();
        urlGenerator.setChartValue(values);
        plot.setURLGenerator(urlGenerator);
        return chart;
    }

    private static JFreeChart create2DPieChart(IRChart reportChart, ChartValue[] values) {
        PieDataset dataset = ChartDataSetFactory.createPieDataset(reportChart, values, reportChart.getTopN());
        JFreeChart chart = JChartFactory.create2DPieChart(reportChart, dataset);
        MyPiePlot2D plot = (MyPiePlot2D)chart.getPlot();
        IReportStandardPieURLGenerator urlGenerator = new IReportStandardPieURLGenerator();
        urlGenerator.setChartValue(values);
        plot.setURLGenerator(urlGenerator);
        return chart;
    }

    private static JFreeChart createPieChart(IRChart reportChart, PieDataset dataset) {
        MyPiePlot3D plot = new MyPiePlot3D(dataset, reportChart.getPlot().getSectionLabelMaxLen());
        int itemCount = dataset.getItemCount();
        boolean isShowLabel = itemCount < reportChart.getPlot().getShowWhenLessNum();
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator(plot, isShowLabel);
        plot.setCircular(true);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setMaximumLabelWidth(0.15);
        plot.setLabelFont(PIE_LABEL_FONT);
        plot.setStartAngle(0.0);
        plot.setLabelGap(0.03);
        plot.setLabelLinkMargin(0.04);
        plot.setLabelBackgroundPaint(new Color(255, 255, 192));
        plot.setBackgroundPaint(COLOR_BG);
        plot.setInteriorGap(0.08);
        JChartFactory.setPiePlotSeriesColor(reportChart.getPlot(), plot, dataset);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart create2DPieChart(IRChart reportChart, PieDataset dataset) {
        MyPiePlot2D plot = new MyPiePlot2D(dataset, reportChart.getPlot().getSectionLabelMaxLen());
        int itemCount = dataset.getItemCount();
        boolean isShowLabel = itemCount < reportChart.getPlot().getShowWhenLessNum();
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator(plot, isShowLabel);
        plot.setCircular(true);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setMaximumLabelWidth(0.15);
        plot.setLabelFont(PIE_LABEL_FONT);
        plot.setStartAngle(0.0);
        plot.setLabelGap(0.03);
        plot.setLabelLinkMargin(0.04);
        plot.setLabelBackgroundPaint(new Color(255, 255, 192));
        plot.setBackgroundPaint(COLOR_BG);
        plot.setInteriorGap(0.08);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        JChartFactory.setPiePlotSeriesColor(reportChart.getPlot(), plot, dataset);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createXYChart(IRChart reportChart, ChartValue[] values) {
        XYDataset dataset = ChartDataSetFactory.createXYDataset(values);
        JFreeChart chart = JChartFactory.createXYChart(reportChart, dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYItemRenderer renderer = plot.getRenderer();
        IReportXYURLGenerator urlGenerator = new IReportXYURLGenerator();
        urlGenerator.setChartValue(values);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    private static JFreeChart createXYChart(IRChart reportChart, XYDataset dataset) {
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)reportChart.getPlot().getLabelGenerator().createStandardXYToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        JChartFactory.setXYChartSeriesColor(reportChart.getPlot(), (XYItemRenderer)renderer, dataset);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)plot.getRenderer();
        xylineandshaperenderer.setShape((Shape)new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
        JChartFactory.setNumberAxisLowBound((ValueAxis)yAxis, reportChart.getRangeAxis());
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart createXYAreaChart(IRChart reportChart, ChartValue[] values) {
        XYDataset dataset = ChartDataSetFactory.createXYDataset(values);
        JFreeChart chart = JChartFactory.createXYAreaChart(reportChart, dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYItemRenderer renderer = plot.getRenderer();
        IReportXYURLGenerator urlGenerator = new IReportXYURLGenerator();
        urlGenerator.setChartValue(values);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    private static JFreeChart createXYAreaChart(IRChart reportChart, XYDataset dataset) {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis();
        XYAreaRenderer renderer = new XYAreaRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)reportChart.getPlot().getLabelGenerator().createStandardXYToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        JChartFactory.setXYChartSeriesColor(reportChart.getPlot(), (XYItemRenderer)renderer, dataset);
        JChartFactory.setNumberAxisLowBound((ValueAxis)yAxis, reportChart.getRangeAxis());
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart createTimeChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        XYDataset dataset = ChartDataSetFactory.createTimeDataset(values, reportChart);
        JFreeChart chart = JChartFactory.createTimeChart(reportChart, dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        XYItemRenderer renderer = plot.getRenderer();
        IReportTimeURLGenerator urlGenerator = new IReportTimeURLGenerator();
        urlGenerator.setChartValue(values);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        JChartFactory.filerTimeChart(reportChart, plot, values);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        if (reportChart.isTableCell()) {
            plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        }
        chart.setPadding(new RectangleInsets(2.0, 20.0, 2.0, 2.0));
        return chart;
    }

    private static long[] countMaxMinTime(ChartValue[] values) {
        if (null == values || 0 == values.length) {
            return new long[0];
        }
        long[] maxMinTime = new long[2];
        long startTime = 0L;
        long endTime = 0L;
        endTime = startTime = ((TimeChartValue)values[0]).getTime().getTime();
        for (int i = 1; i < values.length; ++i) {
            TimeChartValue value = (TimeChartValue)values[i];
            if (value.getTime().getTime() > endTime) {
                endTime = value.getTime().getTime();
            }
            if (value.getTime().getTime() >= startTime) continue;
            startTime = value.getTime().getTime();
        }
        maxMinTime[0] = startTime;
        maxMinTime[1] = endTime;
        return maxMinTime;
    }

    private static JFreeChart createPercentTimeChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = JChartFactory.createTimeChart(reportChart, values);
        PercentTimeChartFilter.filter(reportChart, chart);
        return chart;
    }

    public static JFreeChart createPercentTimeChart(IRChart reportChart, TimeSeriesCollection dataset) {
        try {
            JFreeChart chart = JChartFactory.createToPercentTimeChart(reportChart, (XYDataset)dataset);
            XYPlot plot = (XYPlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)COLOR_BG);
            JChartFactory.filerTimeChart(reportChart, plot, dataset);
            JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
            JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), dataset);
            PercentTimeChartFilter.filter(reportChart, chart);
            return chart;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return JChartFactory.createEmptyChart(reportChart);
        }
    }

    private static JFreeChart createToPercentTimeChart(IRChart reportChart, XYDataset dataset) {
        MyDateAxis timeAxis = new MyDateAxis();
        NumberAxis valueAxis = new NumberAxis();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)reportChart.getPlot().getLabelGenerator().createTimeSeriesToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        JChartFactory.setXYChartSeriesColor(reportChart.getPlot(), (XYItemRenderer)renderer, dataset);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)plot.getRenderer();
        double pointWidth = reportChart.getPointWidth();
        double pointHeight = reportChart.getPointHeight();
        xylineandshaperenderer.setShape((Shape)new Ellipse2D.Double(-1.0, -1.0, pointWidth, pointHeight));
        JChartFactory.setNumberAxisLowBound((ValueAxis)valueAxis, reportChart.getRangeAxis());
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart createTimeChart(IRChart reportChart, XYDataset dataset) {
        MyDateAxis timeAxis = new MyDateAxis();
        NumberAxis valueAxis = new NumberAxis();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        JChartFactory.setXYChartSeriesColor(reportChart.getPlot(), (XYItemRenderer)renderer, dataset);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)plot.getRenderer();
        double pointWidth = reportChart.getPointWidth();
        double pointHeight = reportChart.getPointHeight();
        xylineandshaperenderer.setShape((Shape)new Ellipse2D.Double(-1.0, -1.0, pointWidth, pointHeight));
        JChartFactory.filerTimeChart(reportChart, plot, (TimeSeriesCollection)dataset);
        JChartFactory.setNumberAxisLowBound((ValueAxis)valueAxis, reportChart.getRangeAxis());
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)reportChart.getPlot().getLabelGenerator().createTimeSeriesToolTipGenerator());
        JChartFactory.setValueShowTop(reportChart, renderer);
        renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)reportChart.getPlot().getLabelGenerator().createTimeSeriesItemLabelGenerator());
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart createCompLineChart(IRChart reportChart, CategoryDataset dataset) {
        JFreeChart chart = JChartFactory.createCompLineChart(reportChart, reportChart.getTitle(), "", "", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint((Paint)COLOR_BG);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)COLOR_BG);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        plot.setRangeGridlinePaint((Paint)BAR_RANGG_GRID_LINE_PAINT);
        plot.setDomainGridlinesVisible(true);
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 30.0));
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        CategoryAxis axis = plot.getDomainAxis();
        axis.setUpperMargin(0.0);
        axis.setLowerMargin(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setSeriesLinesVisible(2, false);
        renderer.setSeriesShape(2, ShapeUtilities.createDiamond((float)4.0f));
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setBaseFillPaint((Paint)COLOR_BG);
        JChartFactory.setValueShowTop(reportChart, renderer);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)reportChart.getPlot().getLabelGenerator().createCompLineItemLabelGenerator());
        JChartFactory.setLineAxis(plot, reportChart);
        NumberAxis valueAxis = new NumberAxis();
        JChartFactory.setNumberAxisLowBound((ValueAxis)valueAxis, reportChart.getRangeAxis());
        return chart;
    }

    private static JFreeChart createCompLineChart(IRChart reportChart, String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, false);
        JChartFactory.setSeriesChartSeriesColor(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)reportChart.getPlot().getLabelGenerator().createCompLineToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(title, new Font("sans-serif", 1, 18), (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createCompLineChart(IRChart reportChart, String title, String categoryAxisLabel, String valueAxisLabel, ChartValue[] values, PlotOrientation orientation, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryDataset dataset = ChartDataSetFactory.createLineChartDataset(values);
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, false);
        JChartFactory.setSeriesChartSeriesColor(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)reportChart.getPlot().getLabelGenerator().createCompLineToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(title, new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createCompLineChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = JChartFactory.createCompLineChart(reportChart, reportChart.getTitle(), "", "", values, PlotOrientation.VERTICAL, true, false);
        chart.setBackgroundPaint((Paint)COLOR_BG);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)COLOR_BG);
        plot.setDomainGridlinesVisible(true);
        if (reportChart.isTableCell()) {
            plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        } else {
            plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 30.0));
        }
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        CategoryAxis axis = plot.getDomainAxis();
        axis.setUpperMargin(0.0);
        axis.setLowerMargin(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setShapesVisible(true);
        double pointWidth = reportChart.getPointWidth();
        double pointHeight = reportChart.getPointHeight();
        renderer.setShape((Shape)new Ellipse2D.Double(-1.0, -1.0, pointWidth, pointHeight));
        JChartFactory.setValueShowTop(reportChart, renderer);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)reportChart.getPlot().getLabelGenerator().createCompLineItemLabelGenerator());
        JChartFactory.setLineAxis(plot, reportChart);
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    private static JFreeChart createCompBarChart(IRChart reportChart, CategoryDataset dataset) {
        JFreeChart chart = JChartFactory.createCompBarChart(reportChart, reportChart.getTitle(), "", "", dataset, PlotOrientation.VERTICAL, false, true, false);
        chart.setBackgroundPaint((Paint)COLOR_BG);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        plot.setRangeGridlinesVisible(true);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 20.0));
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        CategoryAxis axis = plot.getDomainAxis();
        axis.setCategoryMargin(0.12);
        axis.setUpperMargin(0.02);
        axis.setLowerMargin(0.02);
        BarRenderer renderer2 = (BarRenderer)plot.getRenderer();
        renderer2.setItemMargin(0.0);
        renderer2.setShadowVisible(false);
        renderer2.setMaximumBarWidth(0.06);
        JChartFactory.setValueShowTop(reportChart, renderer2);
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator(renderer2);
        JChartFactory.setLineAxis(plot, reportChart);
        NumberAxis valueAxis = new NumberAxis();
        JChartFactory.setNumberAxisLowBound((ValueAxis)valueAxis, reportChart.getRangeAxis());
        return chart;
    }

    private static JFreeChart createCompBarChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = JChartFactory.createCompBarChart(reportChart, reportChart.getTitle(), "", "", values, PlotOrientation.VERTICAL, false, true, false);
        chart.setBackgroundPaint((Paint)COLOR_BG);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        plot.setRangeGridlinePaint((Paint)BAR_RANGG_GRID_LINE_PAINT);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 20.0));
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        CategoryAxis axis = plot.getDomainAxis();
        double vleng = values.length;
        CategoryDataset dataset = plot.getDataset();
        if (null == dataset) {
            return chart;
        }
        if (dataset.getColumnCount() == 1 && dataset.getRowCount() == 2) {
            axis.setUpperMargin(0.86);
        } else if (0.9 - 0.06 * vleng > 0.0) {
            axis.setUpperMargin(0.9 - 0.06 * vleng);
        } else {
            axis.setUpperMargin(0.02);
        }
        axis.setCategoryMargin(0.12);
        axis.setLowerMargin(0.02);
        BarRenderer renderer2 = (BarRenderer)plot.getRenderer();
        renderer2.setItemMargin(0.0);
        renderer2.setShadowVisible(false);
        renderer2.setMaximumBarWidth(0.06);
        JChartFactory.setValueShowTop(reportChart, renderer2);
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator(renderer2);
        JChartFactory.setLineAxis(plot, reportChart);
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    public static JFreeChart createCompBarChart(IRChart reportChart, String title, String categoryAxisLabel, String valueAxisLabel, ChartValue[] values, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryDataset dataset = ChartDataSetFactory.createCompBarChartDataset(values);
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        renderer.setErrorIndicatorStroke((Stroke)new BasicStroke(0.0f));
        renderer.setErrorIndicatorPaint((Paint)new Color(255, 255, 255));
        JChartFactory.setSeriesChartSeriesColor(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setBasePositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setBaseNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setBasePositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setBaseNegativeItemLabelPosition(position2);
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(title, new Font("sans-serif", 1, 18), (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createCompBarChart(IRChart reportChart, String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        renderer.setErrorIndicatorStroke((Stroke)new BasicStroke(0.0f));
        renderer.setErrorIndicatorPaint((Paint)new Color(255, 255, 255));
        JChartFactory.setSeriesChartSeriesColor(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setBasePositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setBaseNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setBasePositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setBaseNegativeItemLabelPosition(position2);
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(title, new Font("sans-serif", 1, 18), (Plot)plot, legend);
        return chart;
    }

    private static void setNumberAxisLowBound(ValueAxis axis, IRAxis iRAxis) {
        if (!(axis instanceof NumberAxis) || !iRAxis.isFixRange()) {
            return;
        }
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setLowerBound(iRAxis.getLowerBound());
        numberAxis.setUpperBound(iRAxis.getUpperBound());
    }

    private static JFreeChart createTimeAreaChart(IRChart reportChart, ChartValue[] values) {
        XYDataset dataset = ChartDataSetFactory.createTimeDataset(values, reportChart);
        JFreeChart chart = JChartFactory.createTimeAreaChart(reportChart, dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYItemRenderer renderer = plot.getRenderer();
        IReportTimeURLGenerator urlGenerator = new IReportTimeURLGenerator();
        urlGenerator.setChartValue(values);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        JChartFactory.filerTimeChart(reportChart, plot, values);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    private static void filerTimeChart(IRChart reportChart, XYPlot plot, ChartValue[] values) {
        long startTime = 0L;
        long endTime = 0L;
        double labelAngle = 0.0;
        if (reportChart.isDomainAxisByParaDate() && reportChart.getStartTime() > 0L) {
            startTime = reportChart.getStartTime();
            endTime = reportChart.getEndTime();
        } else {
            if (null == values || 0 == values.length) {
                return;
            }
            long[] maxMinTime = JChartFactory.countMaxMinTime(values);
            if (maxMinTime.length > 1) {
                startTime = maxMinTime[0];
                endTime = maxMinTime[1];
            }
        }
        if (reportChart.getIntTimeLevel() == 4) {
            startTime -= startTime % 300000L;
            endTime = JChartFactory.dealEndTime(reportChart, startTime, endTime);
        }
        JChartFactory.handTimeChartLabel(reportChart, startTime, endTime, plot, reportChart.getIntTimeLevel(), labelAngle, reportChart.getDomainAxis());
    }

    private static long dealEndTime(IRChart reportChart, long startTime, long endTime) {
        long tempEndTime;
        long tickFiveMin = 0L;
        tickFiveMin = reportChart.getDomainAxis().getRegionNum() == 6 ? 1800000L : 300000L;
        if (endTime % tickFiveMin == 0L || endTime <= startTime + tickFiveMin) {
            return endTime;
        }
        for (tempEndTime = startTime; tempEndTime < endTime; tempEndTime += tickFiveMin) {
        }
        return tempEndTime;
    }

    private static void filerTimeChart(IRChart reportChart, XYPlot plot, TimeSeriesCollection dataset) {
        long startTime = 0L;
        long endTime = 0L;
        double labelAngle = 0.0;
        if (reportChart.isDomainAxisByParaDate() && reportChart.getStartTime() > 0L) {
            startTime = reportChart.getStartTime();
            endTime = reportChart.getEndTime();
        } else {
            if (null == dataset || 0 == dataset.getSeriesCount()) {
                return;
            }
            long[] maxMinTime = JChartFactory.countMaxMinTime(dataset);
            if (maxMinTime.length > 1) {
                startTime = maxMinTime[0];
                endTime = maxMinTime[1];
            }
        }
        if (reportChart.getIntTimeLevel() == 4) {
            startTime -= startTime % 300000L;
            endTime = JChartFactory.dealEndTime(reportChart, startTime, endTime);
        }
        JChartFactory.handTimeChartLabel(reportChart, startTime, endTime, plot, reportChart.getIntTimeLevel(), labelAngle, reportChart.getDomainAxis());
    }

    private static long[] countMaxMinTime(TimeSeriesCollection dataset) {
        if (null == dataset || 0 == dataset.getSeriesCount() || 0 == dataset.getSeries(0).getItemCount()) {
            return new long[0];
        }
        long[] maxMinTime = new long[2];
        long startTime = dataset.getSeries(0).getDataItem(0).getPeriod().getEnd().getTime();
        long endTime = 0L;
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            TimeSeries t = dataset.getSeries(i);
            for (int j = 0; j < t.getItemCount(); ++j) {
                if (t.getDataItem(j).getPeriod().getEnd().getTime() > endTime) {
                    endTime = t.getDataItem(j).getPeriod().getEnd().getTime();
                }
                if (t.getDataItem(j).getPeriod().getEnd().getTime() >= startTime) continue;
                startTime = t.getDataItem(j).getPeriod().getEnd().getTime();
            }
        }
        maxMinTime[0] = startTime;
        maxMinTime[1] = endTime;
        return maxMinTime;
    }

    private static JFreeChart createTimeAreaChart(IRChart reportChart, XYDataset dataset) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        MyDateAxis timeAxis = new MyDateAxis();
        NumberAxis valueAxis = new NumberAxis();
        XYAreaRenderer renderer = new XYAreaRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)reportChart.getPlot().getLabelGenerator().createTimeSeriesToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        JChartFactory.setXYChartSeriesColor(reportChart.getPlot(), (XYItemRenderer)renderer, dataset);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        JChartFactory.setNumberAxisLowBound((ValueAxis)valueAxis, reportChart.getRangeAxis());
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static JFreeChart createStackedTimeAreaChart(IRChart reportChart, ChartValue[] values) {
        TimeTableXYDataset dataset = ChartDataSetFactory.createTimeTableXYDataset(values, reportChart);
        JFreeChart chart = JChartFactory.createStackedTimeAreaChart(reportChart, (XYDataset)dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYItemRenderer renderer = plot.getRenderer();
        IReportTimeURLGenerator urlGenerator = new IReportTimeURLGenerator();
        urlGenerator.setChartValue(values);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        JChartFactory.filerTimeChart(reportChart, plot, values);
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    private static JFreeChart createStackedTimeAreaChart(IRChart reportChart, XYDataset dataset) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        MyDateAxis timeAxis = new MyDateAxis();
        NumberAxis valueAxis = new NumberAxis();
        StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)reportChart.getPlot().getLabelGenerator().createTimeSeriesToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        JChartFactory.setXYChartSeriesColor(reportChart.getPlot(), (XYItemRenderer)renderer, dataset);
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        JChartFactory.setNumberAxisLowBound((ValueAxis)valueAxis, reportChart.getRangeAxis());
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        JChartFactory.setAxis(plot, reportChart);
        return chart;
    }

    private static void setXYChartSeriesColor(IRPlot plot, XYItemRenderer render, XYDataset dataset) {
        LegendColor temp;
        Color color;
        Paint paint;
        List<IRSeriesColor> secPaintList = plot.getSectionPaintList();
        plot.getLegendColorList().clear();
        if (0 == dataset.getSeriesCount()) {
            return;
        }
        if (!secPaintList.isEmpty() && JChartFactory.isSeriesColorValid(secPaintList)) {
            int n = dataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int index = i % secPaintList.size();
                paint = ChartUtil.getPaint(secPaintList.get(index).getColor());
                color = (Color)paint;
                render.setSeriesPaint(i, paint);
                temp = new LegendColor(dataset.getSeriesKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        } else {
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
            int n = dataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                paint = drawingSupplier.getNextPaint();
                color = (Color)paint;
                render.setSeriesPaint(i, paint);
                temp = new LegendColor(dataset.getSeriesKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        }
        List<IRColorMap> colorMapList = plot.getColorMapList();
        for (IRColorMap item : colorMapList) {
            int index = dataset.indexOf((Comparable)((Object)item.getKey()));
            if (index < 0) continue;
            render.setSeriesPaint(index, ChartUtil.getPaint(item.getColor()));
            plot.getLegendColorList().get(index).setColor((Color)ChartUtil.getPaint(item.getColor()));
        }
    }

    private static void setPiePlotSeriesColor(IRPlot plot, MyPiePlot3D chartPlot, PieDataset dataset) {
        LegendColor temp;
        Color color;
        Paint paint;
        List<IRSeriesColor> secPaintList = plot.getSectionPaintList();
        plot.getLegendColorList().clear();
        if (0 == dataset.getItemCount()) {
            return;
        }
        if (!secPaintList.isEmpty() && JChartFactory.isSeriesColorValid(secPaintList)) {
            int n = dataset.getItemCount();
            for (int i = 0; i < n; ++i) {
                int index = i % secPaintList.size();
                paint = ChartUtil.getPaint(secPaintList.get(index).getColor());
                color = (Color)paint;
                chartPlot.setSectionPaint(i, paint);
                temp = new LegendColor(dataset.getKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        } else {
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
            int n = dataset.getItemCount();
            for (int i = 0; i < n; ++i) {
                paint = drawingSupplier.getNextPaint();
                color = (Color)paint;
                chartPlot.setSectionPaint(i, paint);
                temp = new LegendColor(dataset.getKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        }
        List<IRColorMap> colorMapList = plot.getColorMapList();
        for (IRColorMap item : colorMapList) {
            int index = dataset.getIndex((Comparable)((Object)item.getKey()));
            if (index < 0) continue;
            chartPlot.setSectionPaint(index, ChartUtil.getPaint(item.getColor()));
            plot.getLegendColorList().get(index).setColor((Color)ChartUtil.getPaint(item.getColor()));
        }
    }

    private static void setPiePlotSeriesColor(IRPlot plot, MyPiePlot2D chartPlot, PieDataset dataset) {
        LegendColor temp;
        Color color;
        Paint paint;
        List<IRSeriesColor> secPaintList = plot.getSectionPaintList();
        plot.getLegendColorList().clear();
        if (0 == dataset.getItemCount()) {
            return;
        }
        if (!secPaintList.isEmpty() && JChartFactory.isSeriesColorValid(secPaintList)) {
            int n = dataset.getItemCount();
            for (int i = 0; i < n; ++i) {
                int index = i % secPaintList.size();
                paint = ChartUtil.getPaint(secPaintList.get(index).getColor());
                color = (Color)paint;
                chartPlot.setSectionPaint(i, paint);
                temp = new LegendColor(dataset.getKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        } else {
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
            int n = dataset.getItemCount();
            for (int i = 0; i < n; ++i) {
                paint = drawingSupplier.getNextPaint();
                color = (Color)paint;
                chartPlot.setSectionPaint(i, paint);
                temp = new LegendColor(dataset.getKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        }
        List<IRColorMap> colorMapList = plot.getColorMapList();
        for (IRColorMap item : colorMapList) {
            int index = dataset.getIndex((Comparable)((Object)item.getKey()));
            if (index < 0) continue;
            chartPlot.setSectionPaint(index, ChartUtil.getPaint(item.getColor()));
            plot.getLegendColorList().get(index).setColor((Color)ChartUtil.getPaint(item.getColor()));
        }
    }

    private static void setSeriesChartSeriesColor(IRPlot plot, AbstractRenderer render, CategoryDataset dataset) {
        LegendColor temp;
        Color color;
        Paint paint;
        List<IRSeriesColor> secPaintList = plot.getSectionPaintList();
        plot.getLegendColorList().clear();
        if (0 == dataset.getColumnCount()) {
            return;
        }
        if (!secPaintList.isEmpty() && JChartFactory.isSeriesColorValid(secPaintList)) {
            int n = dataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                int index = i % secPaintList.size();
                paint = ChartUtil.getPaint(secPaintList.get(index).getColor());
                color = (Color)paint;
                render.setSeriesPaint(i, paint);
                temp = new LegendColor(dataset.getRowKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        } else {
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
            int n = dataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                paint = drawingSupplier.getNextPaint();
                color = (Color)paint;
                render.setSeriesPaint(i, paint);
                temp = new LegendColor(dataset.getRowKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        }
        List<IRColorMap> colorMapList = plot.getColorMapList();
        for (IRColorMap item : colorMapList) {
            int index = dataset.getRowIndex((Comparable)((Object)item.getKey()));
            if (index < 0) continue;
            Paint paint2 = ChartUtil.getPaint(item.getColor());
            Color color2 = (Color)paint2;
            render.setSeriesPaint(index, paint2);
            plot.getLegendColorList().get(index).setColor(color2);
        }
    }

    private static boolean isSeriesColorValid(List<IRSeriesColor> secPaintList) {
        boolean isSeriesColorValid = true;
        if (secPaintList != null && !secPaintList.isEmpty()) {
            for (IRSeriesColor item : secPaintList) {
                if (null != item) continue;
                isSeriesColorValid = false;
                break;
            }
        }
        return isSeriesColorValid;
    }

    private static void setAxis(CategoryPlot plot, IRChart reportChart) {
        plot.getRangeAxis().setLabel(reportChart.getRangeAxis().getLabel());
        plot.getDomainAxis().setLabel(reportChart.getDomainAxis().getLabel());
        plot.getRangeAxis().setVisible(reportChart.getRangeAxis().isVisible());
        plot.getDomainAxis().setVisible(reportChart.getDomainAxis().isVisible());
        JChartFactory.setRangeAxisMargin(plot);
        JChartFactory.handLabelDisplay(plot, reportChart);
    }

    private static void setLineAxis(CategoryPlot plot, IRChart reportChart) {
        plot.getRangeAxis().setLabel(reportChart.getRangeAxis().getLabel());
        plot.getDomainAxis().setLabel(reportChart.getDomainAxis().getLabel());
        plot.getRangeAxis().setVisible(reportChart.getRangeAxis().isVisible());
        plot.getDomainAxis().setVisible(reportChart.getDomainAxis().isVisible());
        JChartFactory.setRangeAxisMargin(plot);
        JChartFactory.handLabelDisplay(plot, reportChart);
    }

    private static void setAxis(XYPlot plot, IRChart reportChart) {
        plot.getRangeAxis().setLabel(reportChart.getRangeAxis().getLabel());
        plot.getDomainAxis().setLabel(reportChart.getDomainAxis().getLabel());
        plot.getRangeAxis().setVisible(reportChart.getRangeAxis().isVisible());
        plot.getDomainAxis().setVisible(reportChart.getDomainAxis().isVisible());
        JChartFactory.handLabelDisplay(plot, reportChart);
        JChartFactory.setRangeAxisMargin(plot);
    }

    private static JFreeChart createAreaChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        CategoryDataset dataset = ChartDataSetFactory.createCategoryDataset(values);
        CategoryAxis3D categoryAxis = new CategoryAxis3D();
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis3D valueAxis = new NumberAxis3D();
        AreaRenderer renderer = new AreaRenderer();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createStackedBarChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        CategoryDataset dataset = ChartDataSetFactory.createCategoryDataset(values);
        CategoryAxis3D categoryAxis = new CategoryAxis3D();
        NumberAxis3D valueAxis = new NumberAxis3D();
        StackedBarRenderer3D renderer = new StackedBarRenderer3D();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(ReportConstants.transPlotOrientation(reportChart.getPlot().getOrientation()));
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createStackedXYBarChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        XYDataset dataset = ChartDataSetFactory.createXYDataset(values);
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        StackedXYBarRenderer renderer = new StackedXYBarRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        return new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
    }

    private static JFreeChart createDialChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        DefaultValueDataset dataset = ChartDataSetFactory.createDefaultValueDataset(values);
        MeterPlot plot = new MeterPlot((ValueDataset)dataset);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createThermometerChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        DefaultValueDataset dataset = ChartDataSetFactory.createDefaultValueDataset(values);
        ThermometerPlot plot = new ThermometerPlot((ValueDataset)dataset);
        plot.setThermometerPaint((Paint)Color.lightGray);
        plot.setUnits(1);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createXYBarChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        XYDataset dataset = ChartDataSetFactory.createXYDataset(values);
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createRingChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        PieDataset dataset = ChartDataSetFactory.createPieDataset(reportChart, values);
        RingPlot plot = new RingPlot(dataset);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static JFreeChart createTimeBarChart(IRChart reportChart, ChartValue[] values) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        JFreeChart chart = null;
        XYDataset dataset = ChartDataSetFactory.createTimeDataset(values, reportChart);
        DateAxis timeAxis = new DateAxis();
        NumberAxis valueAxis = new NumberAxis();
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)StandardXYToolTipGenerator.getTimeSeriesInstance());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        chart = new JFreeChart(reportChart.getTitle(), new Font("sans-serif", 1, 18), (Plot)plot, false);
        return chart;
    }

    private static void handFont(Object plot) {
        if (null != plot) {
            if (plot instanceof CategoryPlot) {
                CategoryPlot plot1 = (CategoryPlot)plot;
                plot1.getDomainAxis().setTickLabelFont(new Font("SansSerif", 1, 10));
                plot1.getRangeAxis().setTickLabelFont(new Font("SansSerif", 1, 10));
                if (Locale.CHINA.equals(ProductFaceUtil.getInstance().getUserLocale())) {
                    plot1.getDomainAxis().setLabelFont(new Font("\u9ed1\u4f53", 1, 12));
                    plot1.getRangeAxis().setLabelFont(new Font("\u9ed1\u4f53", 1, 12));
                } else {
                    plot1.getDomainAxis().setLabelFont(new Font("SansSerif", 1, 12));
                    plot1.getRangeAxis().setLabelFont(new Font("SansSerif", 1, 12));
                }
            } else if (plot instanceof XYPlot) {
                XYPlot plot2 = (XYPlot)plot;
                plot2.getDomainAxis().setTickLabelFont(new Font("SansSerif", 1, 10));
                plot2.getRangeAxis().setTickLabelFont(new Font("SansSerif", 1, 10));
                if (Locale.CHINA.equals(ProductFaceUtil.getInstance().getUserLocale())) {
                    plot2.getDomainAxis().setLabelFont(new Font("\u9ed1\u4f53", 1, 12));
                    plot2.getRangeAxis().setLabelFont(new Font("\u9ed1\u4f53", 1, 12));
                } else {
                    plot2.getDomainAxis().setLabelFont(new Font("SansSerif", 1, 12));
                    plot2.getRangeAxis().setLabelFont(new Font("SansSerif", 1, 12));
                }
            }
        }
    }

    private static void handLabelDisplay(CategoryPlot plot, IRChart reportChart) {
        if ("declining".equalsIgnoreCase(reportChart.getDisplay())) {
            plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        } else {
            plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        }
    }

    private static void handLabelDisplay(XYPlot plot, IRChart reportChart) {
        if ("declining".equalsIgnoreCase(reportChart.getDisplay())) {
            plot.getDomainAxis().setVerticalTickLabels(true);
        } else {
            plot.getDomainAxis().setVerticalTickLabels(false);
        }
    }

    private static void handTimeChartLabel(IRChart reportChart, long startTime, long endTime, XYPlot plot, int dateUnit, double labelAngle, IRAxis domainAxis) {
        labelAngle = "standard".equalsIgnoreCase(reportChart.getDisplay()) ? 0.0 : -0.7853981633974483;
        ChartFilterUtil.filterTimeChart(startTime, endTime, plot, dateUnit, labelAngle, domainAxis, reportChart.getDomainAxis().getRegionNum(), reportChart.getDomainAxis().isRightEndShow());
    }

    private static void setValueShowTop(IRChart reportChart, Object renderer) {
        if (reportChart.isValueShowTop() && null != renderer) {
            if (renderer instanceof AbstractCategoryItemRenderer) {
                ((AbstractCategoryItemRenderer)renderer).setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                ((AbstractCategoryItemRenderer)renderer).setBaseItemLabelsVisible(true);
            } else if (renderer instanceof AbstractXYItemRenderer) {
                ((AbstractXYItemRenderer)renderer).setBaseItemLabelGenerator((XYItemLabelGenerator)new StandardXYItemLabelGenerator());
                ((AbstractXYItemRenderer)renderer).setBaseItemLabelsVisible(true);
            }
        }
    }

    private static void setRangeAxisMargin(Object plot) {
        if (plot instanceof CategoryPlot) {
            ((CategoryPlot)plot).getRangeAxis().setUpperMargin(0.25);
            ((CategoryPlot)plot).getRangeAxis().setLowerMargin(0.25);
        } else if (plot instanceof XYPlot) {
            ((XYPlot)plot).getRangeAxis().setUpperMargin(0.25);
            ((XYPlot)plot).getRangeAxis().setLowerMargin(0.25);
        }
    }

    private static JFreeChart createHoriBarChart(IRChart reportChart, ChartValue[] values) {
        JFreeChart chart = JChartFactory.createHoriBarChart(reportChart, reportChart.getTitle(), "", "", values, false, true, false);
        chart.setBackgroundPaint((Paint)COLOR_BG);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        plot.setRangeGridlinePaint((Paint)BAR_RANGG_GRID_LINE_PAINT);
        if (productName.equalsIgnoreCase("VSM V2")) {
            plot.setBackgroundPaint((Paint)COLOR_BG);
        } else {
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        }
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 20.0));
        plot.setForegroundAlpha(reportChart.getPlot().getForegroundAlpha());
        JChartFactory.formatRangeAxis(plot.getRangeAxis(), reportChart.getRangeAxis());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setShadowVisible(false);
        renderer.setMaximumBarWidth(0.06);
        JChartFactory.setValueShowTop(reportChart, renderer);
        reportChart.getPlot().getLabelGenerator().setToolTipAndLabelGenerator(renderer);
        CategoryAxis categoryAxis = plot.getDomainAxis();
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabel(reportChart.getRangeAxis().getLabel());
        categoryAxis.setLabel(reportChart.getDomainAxis().getLabel());
        valueAxis.setVisible(reportChart.getRangeAxis().isVisible());
        categoryAxis.setVisible(reportChart.getDomainAxis().isVisible());
        double vleng = values.length;
        if (0.9 - 0.08 * vleng > 0.0) {
            categoryAxis.setLowerMargin(0.9 - 0.08 * vleng);
        } else {
            categoryAxis.setLowerMargin(0.02);
        }
        categoryAxis.setCategoryMargin(0.15);
        categoryAxis.setUpperMargin(0.02);
        JChartFactory.setNumberAxisLowBound(plot.getRangeAxis(), values);
        return chart;
    }

    private static JFreeChart createHoriBarChart(IRChart reportChart, String title, String categoryAxisLabel, String valueAxisLabel, ChartValue[] values, boolean legend, boolean tooltips, boolean urls) {
        CategoryDataset dataset = ChartDataSetFactory.createHoriBarChartDataset(values);
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        StatisticalBarRenderer renderer = new StatisticalBarRenderer(){
            private static final long serialVersionUID = -1333512317894926338L;

            public Paint getItemPaint(int row, int column) {
                return this.lookupSeriesPaint(column);
            }
        };
        renderer.setErrorIndicatorStroke((Stroke)new BasicStroke(0.0f));
        renderer.setErrorIndicatorPaint((Paint)new Color(255, 255, 255));
        JChartFactory.setSeriesChartSeriesColorByColumn(reportChart.getPlot(), (AbstractRenderer)renderer, dataset);
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.HORIZONTAL);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        ItemLabelPosition position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
        renderer.setBasePositiveItemLabelPosition(position1);
        ItemLabelPosition position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
        renderer.setBaseNegativeItemLabelPosition(position2);
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        LOG.info((Object)("---------->" + Thread.currentThread().getContextClassLoader().getClass().getName()));
        JFreeChart chart = new JFreeChart(title, new Font("sans-serif", 1, 18), (Plot)plot, legend);
        return chart;
    }

    private static void setSeriesChartSeriesColorByColumn(IRPlot plot, AbstractRenderer render, CategoryDataset dataset) {
        LegendColor temp;
        Color color;
        Paint paint;
        List<IRSeriesColor> secPaintList = plot.getSectionPaintList();
        plot.getLegendColorList().clear();
        if (0 == dataset.getColumnCount()) {
            return;
        }
        if (!secPaintList.isEmpty() && JChartFactory.isSeriesColorValid(secPaintList)) {
            int n = dataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int index = i % secPaintList.size();
                paint = ChartUtil.getPaint(secPaintList.get(index).getColor());
                color = (Color)paint;
                render.setSeriesPaint(i, paint);
                temp = new LegendColor(dataset.getColumnKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        } else {
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
            int n = dataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                paint = drawingSupplier.getNextPaint();
                color = (Color)paint;
                render.setSeriesPaint(i, paint);
                temp = new LegendColor(dataset.getColumnKey(i).toString(), color);
                if (!plot.getLegendColorList().contains(temp)) {
                    plot.getLegendColorList().add(temp);
                    continue;
                }
                LOG.error((Object)(temp + " is repeat"));
            }
        }
        List<IRColorMap> colorMapList = plot.getColorMapList();
        for (IRColorMap item : colorMapList) {
            int index = dataset.getColumnIndex((Comparable)((Object)item.getKey()));
            if (index < 0) continue;
            Paint paint2 = ChartUtil.getPaint(item.getColor());
            Color color2 = (Color)paint2;
            render.setSeriesPaint(index, paint2);
            plot.getLegendColorList().get(index).setColor(color2);
        }
    }
}

