/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart.filter;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.definition.IRAxis;
import com.security.ireport.util.DateUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.chart.filter.MyDateAxis;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleInsets;

public abstract class ChartFilterUtil {
    private static final long D_1000_L = 1000L;
    private static final double D_15D = 15.0;
    private static final double D_70D = 70.0;
    private static final double D_0D = 0.0;
    private static final double D_5D = 5.0;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static void filterTimeChart(long startTime, long endTime, XYPlot plot, int dateUnit, double labelAngle, IRAxis domainAxis, int regionNum, boolean rightEndShow) {
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        long tempEndTime = endTime;
        plot.setAxisOffset(new RectangleInsets(5.0, 0.0, 0.0, 70.0));
        axis.setLabelInsets(new RectangleInsets(15.0, 0.0, 0.0, 0.0));
        axis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        int unitTmpForTick = 0;
        long startTmp = startTime / 1000L;
        long endTmp = endTime / 1000L;
        long timeRange = endTmp - startTmp;
        switch (dateUnit) {
            case 4: {
                int minTick = 60 * regionNum;
                unitTmpForTick = ChartFilterUtil.calTickUnit(timeRange, minTick, regionNum);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(4, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
                endTime = ChartFilterUtil.calRightEndtime(startTime, endTime, timeRange, minTick, regionNum, rightEndShow);
                LOG.info((Object)endTime);
                break;
            }
            case 3: {
                int minTick = 3600 * regionNum;
                unitTmpForTick = ChartFilterUtil.calTickUnit(timeRange, minTick, regionNum);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(3, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MM-dd HH:00"));
                endTime = ChartFilterUtil.calRightEndtime(startTime, endTime, timeRange, minTick, regionNum, rightEndShow);
                LOG.info((Object)endTime);
                break;
            }
            case 2: {
                int minTick = 86400 * regionNum;
                unitTmpForTick = ChartFilterUtil.calTickUnit(timeRange, minTick, regionNum);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(2, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MM-dd"));
                endTime = ChartFilterUtil.calRightEndtime(startTime, endTime, timeRange, minTick, regionNum, rightEndShow);
                LOG.info((Object)endTime);
                break;
            }
            case 1: {
                int minTick = 2678400 * regionNum;
                unitTmpForTick = ChartFilterUtil.calTickUnit(timeRange, minTick, regionNum);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(1, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM"));
                endTime = ChartFilterUtil.calRightEndtime(startTime, endTime, timeRange, minTick, regionNum, rightEndShow);
                LOG.info((Object)endTime);
                break;
            }
            default: {
                int minTick = 60 * regionNum;
                unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(4, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
                if (0L == timeRange % (long)minTick || timeRange < (long)minTick) {
                    endTime += 60000L;
                }
                LOG.info((Object)endTime);
            }
        }
        ChartFilterUtil.procDateFormat(domainAxis, axis);
        endTime = tempEndTime;
        axis.setMaximumDate(new Date(endTime));
        axis.setMinimumDate(new Date(startTime));
        ((MyDateAxis)axis).setMinVisible(new Date(startTime));
        ((MyDateAxis)axis).setMaxVisible(new Date(endTime));
        ChartFilterUtil.handleDstTime(dateUnit);
    }

    private static void procDateFormat(IRAxis domainAxis, DateAxis axis) {
        if (domainAxis.getFormatType().equals("dateFormat")) {
            if (domainAxis.getFormatValue().equals("")) {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
            } else {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat(domainAxis.getFormatValue()));
            }
        }
    }

    public static int calTickUnit(long timeRange, int minTick, int regionNum) {
        long remainder;
        long unit = minTick / regionNum;
        int unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
        if ((long)unitTmpForTick < (remainder = timeRange % (long)minTick / unit)) {
            ++unitTmpForTick;
        }
        return unitTmpForTick;
    }

    public static long calRightEndtime(long startTime, long endTime, long timeRange, int minTick, int regionNum, boolean rightEndShow) {
        long unit = minTick / regionNum;
        int unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
        long remainder = timeRange % (long)minTick / unit;
        if (remainder != 0L) {
            if ((long)unitTmpForTick > remainder) {
                if (rightEndShow) {
                    endTime = startTime + (long)(unitTmpForTick * (regionNum + 1)) * unit * 1000L + 60000L;
                }
            } else if ((long)unitTmpForTick < remainder) {
                if (timeRange / unit % (long)(++unitTmpForTick) != 0L && rightEndShow) {
                    endTime = startTime + 1000L * (long)unitTmpForTick * (long)regionNum * unit + 60000L;
                } else if (timeRange / unit % (long)unitTmpForTick == 0L) {
                    endTime = startTime + (long)(unitTmpForTick * (regionNum - 1)) * unit * 1000L + 60000L;
                }
            } else if ((long)unitTmpForTick == remainder) {
                endTime = startTime + (long)(unitTmpForTick * (regionNum + 1)) * unit * 1000L + 60000L;
            }
        } else if (timeRange % (long)minTick == 0L || timeRange < (long)minTick) {
            endTime += 60000L;
        }
        return endTime;
    }

    public static void filterTimeChart(long startTime, long endTime, XYPlot plot, int dateUnit, double labelAngle, IRAxis domainAxis) {
        int minTick;
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        plot.setAxisOffset(new RectangleInsets(5.0, 0.0, 0.0, 70.0));
        axis.setLabelInsets(new RectangleInsets(15.0, 0.0, 0.0, 0.0));
        axis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        int unitTmpForTick = 0;
        long startTmp = startTime / 1000L;
        long endTmp = endTime / 1000L;
        long timeRange = endTmp - startTmp;
        int regionNum = 5;
        switch (dateUnit) {
            case 4: {
                minTick = 60 * regionNum;
                unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(4, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
                break;
            }
            case 3: {
                minTick = 3600 * regionNum;
                unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(3, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MM-dd HH:00"));
                break;
            }
            case 2: {
                minTick = 86400 * regionNum;
                unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(2, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MM-dd"));
                break;
            }
            case 1: {
                minTick = 15552000;
                unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(1, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM"));
                break;
            }
            default: {
                minTick = 21600;
                unitTmpForTick = (int)Math.floor((double)timeRange / (double)minTick);
                if (0 == unitTmpForTick) {
                    unitTmpForTick = 1;
                }
                axis.setTickUnit(new DateTickUnit(3, unitTmpForTick));
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
            }
        }
        ChartFilterUtil.procDateFormat(domainAxis, axis);
        if (0L == timeRange % (long)minTick || timeRange < (long)minTick) {
            endTime += 60000L;
        }
        axis.setMaximumDate(new Date(endTime));
        axis.setMinimumDate(new Date(startTime));
        ((MyDateAxis)axis).setMinVisible(new Date(startTime));
        ((MyDateAxis)axis).setMaxVisible(new Date(endTime));
        ChartFilterUtil.handleDstTime(dateUnit);
    }

    private static void handleDstTime(int dateUnit) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        if (!"VSM V2".equals(productName)) {
            ChartFilterUtil.needDstTime(dateUnit);
        }
    }

    private static void needDstTime(int dateUnit) {
        LOG.info((Object)"none used needDstTime");
        if (dateUnit != 2 && dateUnit != 1) {
            Long startTime = DateUtil.getLastDSTTimeInMillisRange().get("start");
            Long endTime = DateUtil.getLastDSTTimeInMillisRange().get("end");
            LOG.info((Object)startTime);
            LOG.info((Object)endTime);
        }
    }
}

