/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart.filter;

import com.security.ireport.util.chart.LegendUtil;
import com.security.ireport.util.chart.filter.MyPieLabelDistributor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.plot.PieLabelRecord;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.PieDataset;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;

public class MyPiePlot3D
extends PiePlot3D {
    private static final double D_0_9 = 0.9;
    private static final double D_2_0 = 2.0;
    private static final long serialVersionUID = 8858796512623514512L;
    private int sectionLabelMaxLen = 8;

    public MyPiePlot3D() {
    }

    public MyPiePlot3D(PieDataset pieDataset, int sectionLabelMaxLen) {
        super(pieDataset);
        this.sectionLabelMaxLen = sectionLabelMaxLen;
    }

    protected void drawLeftLabels(KeyedValues leftKeys, Graphics2D g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        int i;
        MyPieLabelDistributor distributor1 = new MyPieLabelDistributor(leftKeys.getItemCount());
        double lGap = plotArea.getWidth() * this.getLabelGap();
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        for (i = 0; i < leftKeys.getItemCount(); ++i) {
            String label = this.getLabelGenerator().generateSectionLabel(this.getDataset(), leftKeys.getKey(i));
            if (label == null) continue;
            label = this.getHandleLabel(label);
            TextBlock block = TextUtilities.createTextBlock((String)label, (Font)this.getLabelFont(), (Paint)this.getLabelPaint(), (float)250.0f, (TextMeasurer)new G2TextMeasurer(g2));
            TextBox labelBox = new TextBox(block);
            labelBox.setBackgroundPaint(this.getLabelBackgroundPaint());
            labelBox.setOutlinePaint(this.getLabelOutlinePaint());
            labelBox.setOutlineStroke(this.getLabelOutlineStroke());
            labelBox.setShadowPaint(this.getLabelShadowPaint());
            double theta = Math.toRadians(leftKeys.getValue(i).doubleValue());
            double baseY = state.getPieCenterY() - Math.sin(theta) * verticalLinkRadius;
            double hh = labelBox.getHeight(g2);
            distributor1.addPieLabelRecord(new PieLabelRecord(leftKeys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * -Math.cos(theta), 0.9 + this.getExplodePercent(this.getDataset().getIndex(leftKeys.getKey(i)))));
        }
        distributor1.distributeLabels(plotArea.getMinY(), plotArea.getHeight());
        for (i = 0; i < distributor1.getItemCount(); ++i) {
            this.drawLeftLabel(g2, state, distributor1.getPieLabelRecord(i));
        }
    }

    protected void drawRightLabels(KeyedValues keys, Graphics2D g2, Rectangle2D plotArea, Rectangle2D linkArea, float maxLabelWidth, PiePlotState state) {
        int i;
        MyPieLabelDistributor distributor2 = new MyPieLabelDistributor(keys.getItemCount());
        double lGap = plotArea.getWidth() * this.getLabelGap();
        double verticalLinkRadius = state.getLinkArea().getHeight() / 2.0;
        for (i = 0; i < keys.getItemCount(); ++i) {
            String label = this.getLabelGenerator().generateSectionLabel(this.getDataset(), keys.getKey(i));
            if (label == null) continue;
            label = this.getHandleLabel(label);
            TextBlock block = TextUtilities.createTextBlock((String)label, (Font)this.getLabelFont(), (Paint)this.getLabelPaint(), (float)250.0f, (TextMeasurer)new G2TextMeasurer(g2));
            TextBox labelBox = new TextBox(block);
            labelBox.setBackgroundPaint(this.getLabelBackgroundPaint());
            labelBox.setOutlinePaint(this.getLabelOutlinePaint());
            labelBox.setOutlineStroke(this.getLabelOutlineStroke());
            labelBox.setShadowPaint(this.getLabelShadowPaint());
            double theta = Math.toRadians(keys.getValue(i).doubleValue());
            double baseY = state.getPieCenterY() - Math.sin(theta) * verticalLinkRadius;
            double hh = labelBox.getHeight(g2);
            distributor2.addPieLabelRecord(new PieLabelRecord(keys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * Math.cos(theta), 0.9 + this.getExplodePercent(this.getDataset().getIndex(keys.getKey(i)))));
        }
        distributor2.distributeLabels(plotArea.getMinY(), plotArea.getHeight());
        for (i = 0; i < distributor2.getItemCount(); ++i) {
            this.drawRightLabel(g2, state, distributor2.getPieLabelRecord(i));
        }
    }

    private String getHandleLabel(String targetLabel) {
        String result = targetLabel;
        String temStr = null;
        int index = targetLabel.indexOf(":");
        if (index > -1) {
            temStr = targetLabel.substring(0, index);
            temStr = LegendUtil.getByteLengthStr(temStr, this.sectionLabelMaxLen);
            result = temStr + targetLabel.substring(index);
        }
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

