/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart.filter;

import com.security.ireport.engine.definition.IRChart;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.data.Range;
import org.jfree.ui.TextAnchor;

public abstract class PercentBarChartFilter {
    private static final double D_10_0 = 10.0;
    private static final double D_0_2 = 0.2;
    private static final double D_0_1 = 0.1;
    private static final double PERCENT_TICK_UNIT = 0.2;
    private static final double PERCENT_MAX_RANGE = 1.19;
    private static final double PERCENT_MIN_RANGE = 0.0;

    public static void filter(IRChart chartDefine, JFreeChart chart) {
        BarRenderer3D render = (BarRenderer3D)chart.getCategoryPlot().getRenderer();
        NumberAxis number = (NumberAxis)chart.getCategoryPlot().getRangeAxis();
        PercentBarChartFilter.setPercentBarRender(render);
        PercentBarChartFilter.setPercentRangeAxis(number);
        number.setNumberFormatOverride(NumberFormat.getPercentInstance());
    }

    private static void setPercentBarRender(BarRenderer3D render) {
        render.setItemMargin(0.1);
        render.setBaseOutlinePaint((Paint)Color.BLACK);
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMaximumIntegerDigits(3);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(1);
        StandardCategoryItemLabelGenerator sxig = new StandardCategoryItemLabelGenerator("{2}", numberFormat);
        render.setItemLabelGenerator((CategoryItemLabelGenerator)sxig);
        render.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_LEFT, TextAnchor.BOTTOM_LEFT, -0.5235987755982988), false);
        render.setItemLabelFont(new Font("SansSerif", 0, 9));
        render.setMaximumBarWidth(0.2);
        render.setItemLabelAnchorOffset(10.0);
        render.setItemLabelsVisible(true);
    }

    private static void setPercentRangeAxis(NumberAxis axis) {
        axis.setTickUnit(new NumberTickUnit(0.2));
        axis.setRange(new Range(0.0, 1.19), false, true);
    }
}

