/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.validator;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.validator.AbstractValidator;
import com.security.ireport.validator.ReportValidators;
import com.security.ireport.validator.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public final class ReportValidatorFactory {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ReportValidatorFactory instance = null;
    private static final String VALIDATOR_CONFIG_NAME = "ireport-validators.xml";
    private ReportValidators validators = new ReportValidators();

    private ReportValidatorFactory() {
    }

    public static ReportValidatorFactory getInstance() {
        if (null == instance) {
            instance = new ReportValidatorFactory();
        }
        return instance;
    }

    protected Digester initDigester() {
        Digester digester = new Digester();
        digester.setClassLoader(Thread.currentThread().getContextClassLoader());
        digester.addObjectCreate("validators", "com.security.ireport.validator.ReportValidators", "type");
        digester.addObjectCreate("validators/validator", "com.security.ireport.validator.Validator", "type");
        digester.addSetProperties("validators/validator");
        digester.addSetNext("validators/validator", "addValidator");
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValidators() {
        LOGGER.info((Object)"Begin load validate file");
        InputStream input = null;
        Digester digester = this.initDigester();
        try {
            input = ReportValidatorFactory.class.getClassLoader().getResourceAsStream(VALIDATOR_CONFIG_NAME);
            this.validators = (ReportValidators)digester.parse(input);
            LOGGER.info((Object)"successful load validate file");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Digester parse IO error", (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"Digester parse file error", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
    }

    public boolean validate(String reportId, String conditionStr) {
        Map<String, JsonValueObj> reportCond = null;
        try {
            reportCond = JSONUtil.transformKeyValueObjMap(conditionStr);
        }
        catch (ParaException e1) {
            LOGGER.error((Object)"transformKeyValueObjMap error", (Throwable)e1);
            return false;
        }
        this.loadValidators();
        Validator findValidator = this.validators.findValidator(reportId);
        if (null == findValidator) {
            return false;
        }
        String validateClass = findValidator.getValidator();
        if (null == validateClass || validateClass.isEmpty()) {
            return false;
        }
        try {
            Class<?> chartClass = Class.forName(validateClass);
            Constructor<?> con = chartClass.getConstructor(new Class[0]);
            AbstractValidator newInstance = (AbstractValidator)con.newInstance(new Object[0]);
            return newInstance.validate(reportCond);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)e);
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e);
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e);
        }
        return true;
    }
}

