/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.cfg.ConditionConfigParser;
import com.security.logserver.module.condition.cfg.ConditionParser;
import com.security.logserver.module.condition.common.AjaxDataSource;
import com.security.logserver.module.condition.common.AjaxDataSourceMgr;
import com.security.logserver.module.condition.util.DataSourceProcesser;
import com.security.logserver.module.condition.util.ElogConditionException;
import com.security.logserver.module.condition.util.Pair;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;

public final class ConditionMgr {
    public static final String CONDITION_GROUP = "elogConditionGroup";
    public static final String CONDITION_GROUP_INFO = "elogConditionGroupInfo";
    public static final String STYLE_TEMPLATES = "elogConditionStyleTemplates";
    public static final String CURRENT_STYLE_TEMPLATE_NAME = "elogConditionCurrentStyleTemplateName";
    public static final String LANGUAGE = "language";
    public static final String RESOURCE_KEY = "label_resource_key";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int DEFAULT_COLUMN = 4;
    private static ConditionMgr cdtConfigMgr = null;
    private String useLanguage = Locale.getDefault().getLanguage();
    private String resourceBaseName = "iReportCbb";
    private ApplicationContext applicationContext = null;
    private Map<Locale, List<ResourceBundle>> resMap = null;

    private ConditionMgr() {
    }

    public static synchronized ConditionMgr getInstance() {
        if (cdtConfigMgr == null) {
            cdtConfigMgr = new ConditionMgr();
        }
        return cdtConfigMgr;
    }

    public List<Map<String, Object>> getConditionGroupById(String id, String reportId) {
        List infoList = null;
        try {
            infoList = (List)ConditionParser.getInstance().parse().getConditionGroupMap().get(id);
            if (null != infoList && !infoList.isEmpty()) {
                this.controlLanguage(infoList);
                this.buildSubGroup(infoList, reportId);
            }
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("getConditionGroupById() error:" + id), (Throwable)e);
        }
        return infoList;
    }

    public void controlLanguage(List<Map<String, Object>> infoList) {
        for (Map<String, Object> map : infoList) {
            this.controlLanguageSplit(map);
        }
    }

    private void i18nDefaultValue(Map<String, Object> map2) {
        String typeName = "defaultValue";
        if (!map2.containsKey(typeName)) {
            return;
        }
        String val = String.valueOf(map2.get(typeName));
        if ("null".equals(val)) {
            return;
        }
        String resourceKey = IReportConfCheckUtil.getObjectStr(map2.get("label_resource_key_" + typeName));
        if (StringUtils.isBlank(resourceKey)) {
            resourceKey = IReportConfCheckUtil.getObjectStr(map2.get(typeName));
        }
        String[] aryDefault = resourceKey.split(",");
        StringBuffer defaultVals = new StringBuffer();
        String i18Str = null;
        for (String dval : aryDefault) {
            i18Str = this.i18nElement(dval);
            if (null == i18Str) {
                defaultVals.append(dval);
            } else {
                defaultVals.append(i18Str);
            }
            defaultVals.append(',');
        }
        String defaultVal = defaultVals.toString();
        if (defaultVals.lastIndexOf(",") == defaultVals.length() - 1) {
            defaultVal = defaultVals.substring(0, defaultVals.length() - 1);
        }
        if (StringUtils.isNotBlank(defaultVal)) {
            map2.put("label_resource_key_" + typeName, resourceKey);
            map2.put(typeName, defaultVal);
        }
    }

    private void controlLanguageSplit(Map<String, Object> map) {
        List l = (List)map.get("subConditions");
        if (null != map.get("label")) {
            this.convertLanguage(map, "label");
        }
        if (null != l) {
            for (Map map2 : l) {
                Map gridMap;
                String dateRangeCheckDataInfo;
                this.convertLanguage(map2, "dialogTitle");
                this.convertLanguage(map2, "title");
                this.convertLanguage(map2, "initValue");
                this.convertLanguage(map2, "desc");
                this.convertLanguage(map2, "regexText");
                this.convertLanguage(map2, "blankValidateText");
                this.i18nDefaultValue(map2);
                this.convertLanguage(map2, "label");
                this.convertLanguage(map2, "subLabel");
                this.convertLanguage(map2, "textName");
                this.convertLanguage(map2, "blankOption");
                this.convertLanguage(map2, "maxNumText");
                String winTreeCheckLevelInfo = IReportConfCheckUtil.getObjectStr(map2.get("checkLevelInfo"));
                if (!winTreeCheckLevelInfo.isEmpty()) {
                    this.convertLanguage(map2, "checkLevelInfo");
                }
                if (!(dateRangeCheckDataInfo = IReportConfCheckUtil.getObjectStr(map2.get("checkDataInfo"))).isEmpty()) {
                    this.convertLanguage(map2, "checkDataInfo");
                }
                if (null == (gridMap = (Map)map2.get("grid")) || null == gridMap.get("title")) continue;
                this.convertLanguage(gridMap, "title");
            }
        }
    }

    public void convertLanguage(Map<String, Object> map2, String typeName) {
        String nLan;
        String resourceKey = IReportConfCheckUtil.getObjectStr(map2.get("label_resource_key_" + typeName));
        if (StringUtils.isBlank(resourceKey)) {
            resourceKey = IReportConfCheckUtil.getObjectStr(map2.get(typeName));
        }
        if (StringUtils.isNotBlank(nLan = this.i18nElement(resourceKey))) {
            map2.put("label_resource_key_" + typeName, resourceKey);
            map2.put(typeName, nLan);
        }
    }

    private void buildSubGroup(List<Map<String, Object>> infoList, String reportId) {
        DataSourceProcesser.getInstance(this.applicationContext);
        for (Map<String, Object> subGroupsMap : infoList) {
            List cdtInfoList = (List)subGroupsMap.get("subConditions");
            if (null == cdtInfoList || cdtInfoList.isEmpty()) continue;
            this.buildGroup(cdtInfoList, infoList, reportId);
        }
    }

    private void buildGroup(List<Map<String, Object>> cdtinfoList, List<Map<String, Object>> infoList, String reportId) {
        DataSourceProcesser processer = DataSourceProcesser.getInstance(this.applicationContext);
        for (Map<String, Object> infoMap : cdtinfoList) {
            AjaxDataSource ds;
            if (this.needGetData(infoMap, ds = (AjaxDataSource)infoMap.get("ajaxDataSource"))) {
                try {
                    infoMap.put("data", processer.getDataSource(infoList, infoMap, this.useLanguage, reportId));
                }
                catch (ElogConditionException e) {
                    LOGGER.error((Object)("reflectInvoke() error: " + e));
                }
                this.buildDefaultValue(infoMap);
            }
            this.buildChooseObj(infoMap);
        }
    }

    private void buildDefaultValue(Map<String, Object> infoMap) {
        String type = infoMap.get("type").toString();
        if (null != infoMap.get("data") && ("radioGroup".equals(type) || "checkboxGroup".equals(type) || "select".equals(type) && null == infoMap.get("blankOption"))) {
            List list = (List)infoMap.get("data");
            if (!list.isEmpty()) {
                String defaultValue = ((Pair)list.get(0)).getKey().toString();
                infoMap.put("defaultValue", defaultValue);
            } else {
                infoMap.put("defaultValue", "");
            }
        }
    }

    private void buildChooseObj(Map<String, Object> infoMap) {
        String type = infoMap.get("type").toString();
        if (type.equals("radioGroup") || type.equals("checkboxGroup")) {
            int num = 0;
            if (null != infoMap.get("columns")) {
                try {
                    num = Integer.parseInt(infoMap.get("columns").toString());
                }
                catch (NumberFormatException e) {
                    num = 4;
                    LOGGER.error((Object)"buildChooseObj(),error.");
                }
                if (num <= 0) {
                    num = 4;
                }
            } else {
                num = 4;
            }
            infoMap.put("columns", num);
        }
    }

    private boolean needGetData(Map<String, Object> infoMap, AjaxDataSource ds) {
        String type = infoMap.get("type").toString();
        return (type.equals("radioGroup") || type.equals("checkboxGroup") || type.equals("select") || type.equals("combobox")) && null != ds;
    }

    public Map<String, String> getConditionGroupInfoById(String groupId) {
        return ConditionParser.getInstance().getConditionGroupInfoMap().get(groupId);
    }

    public Map<String, Object> getSubmitValue(String conditionId, HttpServletRequest request) {
        HashMap<String, Object> submitValueMap = new HashMap<String, Object>();
        List<Map<String, Object>> lm = this.getConditionGroupById(conditionId, null);
        if (lm != null) {
            for (Map<String, Object> m : lm) {
                String key = IReportConfCheckUtil.getObjectStr(m.get("key"));
                String name = IReportConfCheckUtil.getObjectStr(m.get("name"));
                String value = request.getParameter(name);
                submitValueMap.put(key, value);
            }
        }
        return submitValueMap;
    }

    public Map<String, Object> getConditionInfo(String groupId, String subGroupId, String conditionId) {
        if (StringUtils.isBlank(conditionId) || StringUtils.isBlank(subGroupId) || StringUtils.isBlank(groupId)) {
            return null;
        }
        List<Map<String, Object>> conditionGroup = this.getConditionGroupById(groupId, null);
        if (null == conditionGroup) {
            return null;
        }
        Iterator<Map<String, Object>> iterator = conditionGroup.iterator();
        if (iterator.hasNext()) {
            Map<String, Object> subGroupInfo = iterator.next();
            return this.getConditionInfoFromSubGroup(subGroupInfo, subGroupId, conditionId);
        }
        return null;
    }

    private Map<String, Object> getConditionInfoFromSubGroup(Map<String, Object> subGroupInfo, String subGroupId, String conditionId) {
        if (subGroupInfo.get("id").equals(subGroupId)) {
            List cdtInfoList = (List)subGroupInfo.get("subConditions");
            if (null == cdtInfoList) {
                return null;
            }
            for (Map cdtInfo : cdtInfoList) {
                if (!conditionId.equals(cdtInfo.get("id"))) continue;
                return cdtInfo;
            }
        }
        return null;
    }

    public void setConditionInfoToRequest(String id, HttpServletRequest request, ApplicationContext appContext, String reportId) {
        this.setApplicationContext(appContext);
        String styleTemplateName = request.getParameter("styleTemplateName");
        List<Map<String, Object>> conditionGroupList = null;
        if (!StringUtils.isBlank(styleTemplateName)) {
            request.setAttribute(CURRENT_STYLE_TEMPLATE_NAME, (Object)styleTemplateName);
        } else {
            request.setAttribute(CURRENT_STYLE_TEMPLATE_NAME, (Object)this.getDefaultStyleTemplate());
        }
        Locale local = ProductFaceUtil.getInstance().getUserLocale();
        if (null != local) {
            this.setUseLanguage(local.getLanguage());
            LOGGER.info((Object)("iReportCbb User Locale:" + local.getLanguage()));
        } else {
            Locale l = this.useLanguage.equals("en") ? Locale.ENGLISH : Locale.SIMPLIFIED_CHINESE;
            ActionContext.getContext().setLocale(l);
            LOGGER.error((Object)("iReportCbb User Locale Error,Return Default User Locale:" + l.getLanguage()));
        }
        conditionGroupList = this.getConditionGroupById(id, reportId);
        request.setAttribute(CONDITION_GROUP, conditionGroupList);
        request.setAttribute(STYLE_TEMPLATES, this.getStyleTemplates());
        request.setAttribute(CONDITION_GROUP_INFO, this.getConditionGroupInfoById(id));
        if (null != conditionGroupList) {
            for (Map<String, Object> map : conditionGroupList) {
                List cdtInfoList = (List)map.get("help");
                if (null == cdtInfoList) continue;
                this.setHelpContent(request, cdtInfoList);
            }
        }
        request.setAttribute(LANGUAGE, (Object)this.useLanguage);
    }

    private void setHelpContent(HttpServletRequest request, List<Map<String, Object>> cdtInfoList) {
        for (Map<String, Object> map2 : cdtInfoList) {
            if (null != map2.get("title")) {
                request.setAttribute("help_title", this.i18nElement(String.valueOf(map2.get("title"))) != null ? this.i18nElement(String.valueOf(map2.get("title"))) : map2.get("title"));
            }
            if (null == map2.get("content")) continue;
            request.setAttribute("help_content", this.i18nElement(String.valueOf(map2.get("content"))) != null ? this.i18nElement(String.valueOf(map2.get("content"))) : map2.get("content"));
        }
    }

    public String getDefaultStyleTemplate() {
        try {
            return ConditionConfigParser.getInstance().getDefaultStyleTemplate();
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("getDefaultStyleTemplate():" + e));
            return StringUtils.getEmpty();
        }
    }

    public String getStyleTemplatePath(String tplName) {
        try {
            return ConditionConfigParser.getInstance().getStyleTemplatePath(tplName);
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("getStyleTemplatePath():" + e));
            return StringUtils.getEmpty();
        }
    }

    public Map<String, String> getStyleTemplates() {
        try {
            return ConditionConfigParser.getInstance().getStyleTemplatesMap();
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("getStyleTemplates():" + e));
            return null;
        }
    }

    public AjaxDataSource getAjaxDataSource(String groupId, String subGroupId, String conditionId) {
        return AjaxDataSourceMgr.getInstance().get(groupId, subGroupId, conditionId);
    }

    public void setAjaxDataSource(String groupId, String subGroupId, String conditionId, AjaxDataSource dataSource) {
        AjaxDataSourceMgr.getInstance().set(groupId, subGroupId, conditionId, dataSource);
    }

    public String i18nElement(String key) {
        if (StringUtils.isBlank(key)) {
            return key;
        }
        this.initResBundle(this.resourceBaseName);
        List<ResourceBundle> bundleList = null;
        if ("en".equals(this.useLanguage)) {
            bundleList = this.resMap.get(Locale.ENGLISH);
        } else if ("zh".equals(this.useLanguage)) {
            bundleList = this.resMap.get(Locale.SIMPLIFIED_CHINESE);
        }
        if (bundleList == null || bundleList.isEmpty()) {
            LOGGER.error((Object)"bundleList is empty.");
            return key;
        }
        for (ResourceBundle item : bundleList) {
            if (!item.containsKey(key)) continue;
            return item.getString(key);
        }
        return key;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getUseLanguage() {
        return this.useLanguage;
    }

    public void setUseLanguage(String useLanguage) {
        this.useLanguage = useLanguage;
    }

    public void setResourceBaseName(String resourceBaseName) {
        this.resourceBaseName = resourceBaseName;
    }

    private void initResBundle(String resourceBaseNameNew) {
        if (this.resMap != null) {
            return;
        }
        this.resMap = new HashMap<Locale, List<ResourceBundle>>();
        if (IReportConfCheckUtil.isStringEmpty(resourceBaseNameNew)) {
            return;
        }
        String[] resArr = resourceBaseNameNew.split(",");
        ArrayList<ResourceBundle> enBundle = new ArrayList<ResourceBundle>();
        ArrayList<ResourceBundle> zhBundle = new ArrayList<ResourceBundle>();
        for (String resNm : resArr) {
            try {
                enBundle.add(ResourceBundle.getBundle(resNm, Locale.ENGLISH));
                zhBundle.add(ResourceBundle.getBundle(resNm, Locale.SIMPLIFIED_CHINESE));
            }
            catch (Exception e) {
                LOGGER.error((Object)("ResourceBundle.getBundle->" + resNm + " is failed"), (Throwable)e);
            }
        }
        this.resMap.put(Locale.ENGLISH, enBundle);
        this.resMap.put(Locale.SIMPLIFIED_CHINESE, zhBundle);
    }
}

