/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.logserver.module.condition.ConditionMgr;
import com.security.logserver.module.condition.util.ElogConditionException;
import com.security.logserver.module.condition.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class ConditionConfigParser {
    private static String configPath = "ireport-condition-config.xml";
    private static final String PATH_LEGO = "ireport-condition-config-lego.xml";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ConditionConfigParser parser = null;
    private boolean debug = false;
    private List<String> resource = new ArrayList<String>();
    private String defineFile = "";
    private Map<String, String> styleTemplatesMap = new HashMap<String, String>();
    private String defaultStyleTemplate = "";
    private boolean parsed = false;

    private ConditionConfigParser() {
    }

    public ConditionConfigParser parse() throws ElogConditionException {
        if (this.parsed && !this.debug) {
            return this;
        }
        LOGGER.info((Object)("ireport-condition-config parse:" + configPath));
        this.resource = new ArrayList<String>();
        InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(configPath);
        try {
            Document doc = new SAXReader().read(ins);
            Element root = doc.getRootElement();
            String debugNew = root.element("debug").getTextTrim();
            this.debug = Boolean.valueOf(debugNew);
            String language = root.element("language").getTextTrim();
            String lanRes = root.element("languageResource").getTextTrim();
            if (!this.parsed) {
                ConditionMgr.getInstance().setUseLanguage(language);
                ConditionMgr.getInstance().setResourceBaseName(lanRes);
            }
            Element el = root.element("resource");
            Iterator eit = el.elementIterator("file");
            Element element = null;
            String fileType = "";
            String path = "";
            while (eit.hasNext()) {
                element = (Element)eit.next();
                fileType = element.attributeValue("type");
                path = element.getTextTrim();
                this.resource.add(PathUtil.getRealPathByType(fileType, path));
            }
            el = root.element("define-file");
            if (el != null) {
                this.defineFile = el.getTextTrim();
            }
        }
        catch (DocumentException e) {
            LOGGER.error((Object)("parse " + configPath + " error!"));
            throw new ElogConditionException(4000, "Parser 'elog-condition-config.xml' error.", e);
        }
        finally {
            this.parsed = true;
            try {
                ins.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)("FileInputStream close error:" + configPath));
            }
        }
        return this;
    }

    public String getStyleTemplatePath(String tplName) {
        return this.styleTemplatesMap.get(tplName);
    }

    public static synchronized ConditionConfigParser getInstance() throws ElogConditionException {
        if (null == parser) {
            parser = new ConditionConfigParser();
            configPath = PATH_LEGO;
            parser.parse();
        }
        return parser;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<String> getResource() {
        return this.resource;
    }

    public String getDefineFile() {
        return this.defineFile;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public Map<String, String> getStyleTemplatesMap() {
        return this.styleTemplatesMap;
    }

    public String getDefaultStyleTemplate() {
        return this.defaultStyleTemplate;
    }

    public void setDefaultStyleTemplate(String defaultStyleTemplate) {
        this.defaultStyleTemplate = defaultStyleTemplate;
    }
}

