/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.logserver.module.condition.cfg.ConditionConfigParser;
import com.security.logserver.module.condition.util.ElogConditionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class ConditionDefineParser {
    private static String condDefinePath = "com/security/logserver/module/condition/cfg/condition-define.xml";
    private static final String PATH_SIG = "com/security/logserver/module/condition/cfg/condition-define.xml";
    private static final String PATH_LEGO = "com/security/logserver/module/condition/cfg/condition-define-lego.xml";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ConditionDefineParser parser = null;
    private Map<String, Map<String, Object>> defineInfoMap = null;
    private boolean parsed = false;

    private ConditionDefineParser() {
    }

    public ConditionDefineParser parse() throws ElogConditionException {
        if (this.parsed && !ConditionConfigParser.getInstance().isDebug()) {
            return this;
        }
        LOGGER.info((Object)"condition-define.xml parse()");
        this.defineInfoMap = new HashMap<String, Map<String, Object>>();
        InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(condDefinePath);
        try {
            Document doc = new SAXReader().read(ins);
            Element root = doc.getRootElement();
            Iterator eit = root.elementIterator("condition");
            while (eit.hasNext()) {
                Element el = (Element)eit.next();
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("type", el.attributeValue("type"));
                m.put("url", el.getTextTrim());
                m.put("parser", el.attributeValue("parser"));
                this.defineInfoMap.put(el.attributeValue("type"), m);
            }
        }
        catch (DocumentException e) {
            LOGGER.error((Object)"parse condDefinePath error!");
            throw new ElogConditionException(4000, "Parser " + condDefinePath + ", error.", e);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"FileInputStream close error");
            }
        }
        this.parsed = true;
        return this;
    }

    public static synchronized ConditionDefineParser getInstance() {
        if (null == parser) {
            parser = new ConditionDefineParser();
            condDefinePath = PATH_LEGO;
        }
        return parser;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public Map<String, Map<String, Object>> getDefineInfoMap() throws ElogConditionException {
        if (ConditionConfigParser.getInstance().isDebug()) {
            this.parse();
        }
        return this.defineInfoMap;
    }
}

