/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.logserver.module.condition.cfg.ConditionDefineParser;
import com.security.logserver.module.condition.util.ElogConditionException;
import java.util.Map;

public final class ConditionProcesser {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ConditionProcesser ca = null;

    private ConditionProcesser() {
    }

    public void process(Map<String, Object> cdtInfo) {
        try {
            Map<String, Object> cdtDefine = ConditionDefineParser.getInstance().parse().getDefineInfoMap().get(cdtInfo.get("type"));
            String url = "";
            if (cdtDefine != null) {
                url = IReportConfCheckUtil.getObjectStr(cdtDefine.get("url"));
            }
            cdtInfo.put("url", url);
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("process(), error:" + e));
            cdtInfo.put("url", "");
        }
    }

    public static synchronized ConditionProcesser getInstance() {
        if (null == ca) {
            ca = new ConditionProcesser();
        }
        return ca;
    }
}

