/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg.parser;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.logserver.module.condition.cfg.parser.BasicParser;
import com.security.logserver.module.condition.cfg.parser.IParser;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.util.HashMap;
import java.util.Map;

public final class PareserFactory {
    public static final String DEFAULE_PARSE = "com.security.logserver.module.condition.cfg.parser.BasicParser";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static PareserFactory factory = null;
    private Map<String, IParser> parserMap = new HashMap<String, IParser>();

    private PareserFactory() {
    }

    public IParser getParser(String parserClassPath) {
        if (StringUtils.isBlank(parserClassPath)) {
            return this.parserMap.get(DEFAULE_PARSE);
        }
        IParser parser = this.parserMap.get(parserClassPath);
        if (parser != null) {
            return parser;
        }
        try {
            parser = (IParser)Class.forName(parserClassPath).newInstance();
            this.parserMap.put(parserClassPath, parser);
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)("getParser(),error:" + e));
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("getParser(),error:" + e));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("getParser(),error:" + e));
        }
        if (parser != null) {
            return parser;
        }
        return this.parserMap.get(DEFAULE_PARSE);
    }

    public static synchronized PareserFactory getInstance() {
        if (null == factory) {
            factory = new PareserFactory();
            PareserFactory.factory.parserMap.put(DEFAULE_PARSE, new BasicParser());
        }
        return factory;
    }
}

