/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg.parser;

import com.security.logserver.module.condition.cfg.parser.BasicParser;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class WinGridParser
extends BasicParser {
    @Override
    public Map<String, Object> parse(Element el) {
        HashMap<String, Object> cdtInfoMap = new HashMap<String, Object>();
        cdtInfoMap.put("type", el.getName());
        cdtInfoMap.put("id", el.attributeValue("id"));
        if (StringUtils.isNotBlank(el.attributeValue("triggerID"))) {
            cdtInfoMap.put("triggerID", el.attributeValue("triggerID"));
        }
        Iterator it = el.elementIterator();
        while (it.hasNext()) {
            Element temp = (Element)it.next();
            if ("ajaxDataSource".equals(temp.getName())) {
                cdtInfoMap.put("ajaxDataSource", this.parseAjaxDataSource(temp));
                continue;
            }
            if ("grid".equals(temp.getName())) {
                cdtInfoMap.put("grid", this.parseGrid(temp));
                continue;
            }
            cdtInfoMap.put(temp.getName(), temp.getTextTrim());
        }
        return cdtInfoMap;
    }

    private Map<String, Object> parseGrid(Element el) {
        HashMap<String, Object> gridInfo = new HashMap<String, Object>();
        Iterator it = el.elementIterator();
        while (it.hasNext()) {
            Element temp = (Element)it.next();
            if ("columnModels".equals(temp.getName())) {
                Iterator cit = temp.elementIterator("cm");
                List<Map<String, String>> cms = this.parseCM(cit);
                gridInfo.put("columnModels", cms);
                continue;
            }
            gridInfo.put(temp.getName(), temp.getTextTrim());
        }
        return gridInfo;
    }

    private List<Map<String, String>> parseCM(Iterator cit) {
        ArrayList<Map<String, String>> cms = new ArrayList<Map<String, String>>();
        while (cit.hasNext()) {
            Element c = (Element)cit.next();
            Iterator attrIt = c.attributeIterator();
            HashMap<String, String> cm = new HashMap<String, String>();
            while (attrIt.hasNext()) {
                Attribute attr = (Attribute)attrIt.next();
                cm.put(attr.getName(), attr.getText());
            }
            cms.add(cm);
        }
        return cms;
    }
}

