/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.HotSwapClassLoader;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.common.AjaxDataSource;
import com.security.logserver.module.condition.load.IApplicationContextAware;
import com.security.logserver.module.condition.load.paramparse.IInvokerParamParser;
import com.security.logserver.module.condition.load.paramparse.ParamsParserConfiParser;
import com.security.logserver.module.condition.util.ElogConditionException;
import com.security.logserver.module.condition.util.FileMapping;
import com.security.logserver.module.condition.util.Pair;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public final class DataSourceProcesser {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static DataSourceProcesser processer = null;
    private ApplicationContext applicationContext = null;

    private DataSourceProcesser() {
    }

    public static synchronized DataSourceProcesser getInstance(ApplicationContext applicationContext) {
        if (null == processer) {
            processer = new DataSourceProcesser();
            processer.setApplicationContext(applicationContext);
        }
        return processer;
    }

    public synchronized Object getDataSource(List<Map<String, Object>> cdtInfoList, Map<String, Object> infoMap, String language, String reportId) throws ElogConditionException {
        AjaxDataSource ds = (AjaxDataSource)infoMap.get("ajaxDataSource");
        if (null != ds) {
            if (!StringUtils.isBlank(ds.getFilePath())) {
                return this.fileTypeProcess(ds, language);
            }
            if (!StringUtils.isBlank(ds.getBeanName()) || !StringUtils.isBlank(ds.getClassName())) {
                return this.reflectInvoke(cdtInfoList, infoMap, ds, reportId);
            }
        }
        return null;
    }

    private Object fileTypeProcess(AjaxDataSource dataSource, String language) {
        StringBuilder sb = new StringBuilder(language);
        sb.append(dataSource.getFilePath());
        List<Pair<String, String>> list = FileMapping.getInstance().getMappingList(sb.toString());
        return list;
    }

    private Object getExecuteObject(AjaxDataSource dataSource, String reportId) throws ElogConditionException {
        Object executeObj = null;
        if (!StringUtils.isBlank(dataSource.getBeanName())) {
            executeObj = this.applicationContext.getBean(dataSource.getBeanName());
        } else {
            String className = "";
            className = !StringUtils.isBlank(dataSource.getInterfaceClass()) ? dataSource.getInterfaceClass() : dataSource.getClassName();
            executeObj = this.getJaveExecuteObject(className, dataSource, reportId);
        }
        return executeObj;
    }

    private Object getJaveExecuteObject(String className, AjaxDataSource dataSource, String reportId) throws ElogConditionException {
        Object executeObj = null;
        try {
            int index = className.lastIndexOf(".");
            String subClassName = className.substring(index + 1);
            String filePathName = IReportUtil.getPluginPath() + reportId + "/" + subClassName + ".class";
            Class<?> cls = HotSwapClassLoader.getInstance().load(className, filePathName);
            executeObj = cls.newInstance();
            Class[] interfaces = executeObj.getClass().getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                executeObj = this.setApplicationContext2Obj(interfaces, executeObj);
            }
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
            throw new ElogConditionException(6000, " create execute object " + dataSource.getClassName() + " fail.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
            throw new ElogConditionException(6000, " create execute object " + dataSource.getClassName() + " fail.", e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
            throw new ElogConditionException(6000, " create execute object " + dataSource.getClassName() + " fail.", e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error to get class loader. ", (Throwable)e);
        }
        return executeObj;
    }

    private Object setApplicationContext2Obj(Class[] interfaces, Object executeObj) {
        for (Class ifNew : interfaces) {
            if (!ifNew.getName().endsWith("IApplicationContextAware")) continue;
            ((IApplicationContextAware)executeObj).setApplicationContext(this.applicationContext);
        }
        return executeObj;
    }

    private Object[] getInvokParams(List<Map<String, Object>> cdtInfoList, Map<String, Object> infoMap, AjaxDataSource dataSource) throws ElogConditionException {
        String[] paramTypes = dataSource.getParamTypes();
        if (null == paramTypes || 0 == paramTypes.length) {
            return new Object[0];
        }
        List<Object> arguments = null;
        arguments = this.buildParams(cdtInfoList, infoMap);
        if (null == arguments || arguments.size() != paramTypes.length) {
            throw new ElogConditionException(2000, "invoker params count not match", null);
        }
        Object[] invokParams = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Object argument;
            String type = paramTypes[i];
            IInvokerParamParser parser = ParamsParserConfiParser.getInstance().parse().getArgumentsParserMap().get(type);
            invokParams[i] = argument = parser.parse(arguments.get(i));
        }
        return invokParams;
    }

    private List<Object> buildParams(List<Map<String, Object>> cdtInfoList, Map<String, Object> infoMap) {
        if (null != infoMap.get("loadParamsSource")) {
            String[] paramSourceIds;
            ArrayList<Object> paramList = new ArrayList<Object>();
            for (String id : paramSourceIds = infoMap.get("loadParamsSource").toString().split(",")) {
                Map<String, Object> tmpMap = this.getInfoMapById(cdtInfoList, id);
                if (null != tmpMap && null != tmpMap.get("defaultValue")) {
                    paramList.add(tmpMap.get("defaultValue"));
                    continue;
                }
                paramList.add(StringUtils.getEmpty());
            }
            return paramList;
        }
        return null;
    }

    private Map<String, Object> getInfoMapById(List<Map<String, Object>> cdtInfoList, String id) {
        for (Map<String, Object> subGroupsMap : cdtInfoList) {
            List infoList = (List)subGroupsMap.get("subConditions");
            for (Map infoMap : infoList) {
                if (!id.equals(infoMap.get("id"))) continue;
                return infoMap;
            }
        }
        return null;
    }

    private Object reflectInvoke(List<Map<String, Object>> cdtInfoList, Map<String, Object> infoMap, AjaxDataSource dataSource, String reportId) throws ElogConditionException {
        Object[] invokParams = null;
        Object executeObj = null;
        Method executeMethod = null;
        if (null == dataSource.getExecuteObj()) {
            executeObj = this.getExecuteObject(dataSource, reportId);
            dataSource.setExecuteObj(executeObj);
        } else {
            executeObj = dataSource.getExecuteObj();
        }
        invokParams = this.getInvokParams(cdtInfoList, infoMap, dataSource);
        executeMethod = this.getExecuteMethod(dataSource.getExecuteObj(), dataSource.getMethodName());
        if (null == executeMethod) {
            LOGGER.error((Object)"reflectInvoke() error: method not found!");
            ElogConditionException ex = new ElogConditionException(5000, dataSource.getMethodName() + " method not found.", null);
            throw ex;
        }
        Object resultObj = this.executeMethod(dataSource, executeObj, executeMethod, invokParams);
        return resultObj;
    }

    private Object executeMethod(AjaxDataSource dataSource, Object executeObj, Method executeMethod, Object[] invokParams) throws ElogConditionException {
        Object resultObj = null;
        try {
            resultObj = 0 == invokParams.length ? executeMethod.invoke(executeObj, new Object[0]) : executeMethod.invoke(executeObj, invokParams);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("execute method fail:" + e.getMessage()));
            throw new ElogConditionException(5001, LocaleUtil.replaceParamValue(LocaleUtil.getProperty("condtion.ajaxdatasource.error", ProductFaceUtil.getInstance().getUserLocale()), dataSource.getMethodName()), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("execute method fail:" + e.getMessage()));
            throw new ElogConditionException(5001, LocaleUtil.replaceParamValue(LocaleUtil.getProperty("condtion.ajaxdatasource.error", ProductFaceUtil.getInstance().getUserLocale()), dataSource.getMethodName()), e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)("execute method fail:" + e.getMessage()));
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                if (ProductFaceUtil.getInstance().isBusinessException((Exception)targetException)) {
                    ProductFaceUtil.getInstance().throwProductException(e.getTargetException().getMessage(), "INFO", e.getTargetException());
                }
                throw new ElogConditionException(5001, LocaleUtil.replaceParamValue(LocaleUtil.getProperty("condtion.ajaxdatasource.error", ProductFaceUtil.getInstance().getUserLocale()), dataSource.getMethodName()), e);
            }
            LOGGER.error((Object)"reflectInvoke() error: method not found!");
        }
        return resultObj;
    }

    private Method getExecuteMethod(Object obj, String methodName) {
        Method[] methodArr = obj.getClass().getMethods();
        Method method = null;
        for (int i = 0; i < methodArr.length; ++i) {
            if (!methodArr[i].getName().equals(methodName)) continue;
            method = methodArr[i];
            return method;
        }
        return null;
    }

    private void setApplicationContext(ApplicationContext applicationContext) {
        if (null == this.applicationContext) {
            this.applicationContext = applicationContext;
        }
    }
}

