/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.logserver.module.condition.cfg.ConditionConfigParser;
import com.security.logserver.module.condition.util.ElogConditionException;
import com.security.logserver.module.condition.util.Pair;
import com.security.logserver.module.condition.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class FileMapping {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean LINUX = Normalizer.normalize(OS_NAME, Normalizer.Form.NFKC).startsWith("Linux");
    static final int LOCAL_LENGTH = 6;
    static final String FILE_SUFFIX = ".xml";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static Map<String, List<Pair<String, String>>> fileDataCache;
    private static final String ROOT_PATH_PLUGIN = "/iReport/iReportBiz/reportPlugins/";
    private static final String ROOT_PATH_CLASS = "/stub/xml/";
    private static FileMapping mapping;
    private final Object lock = new Object();

    private FileMapping() {
    }

    public static synchronized FileMapping getInstance() {
        if (null == mapping) {
            mapping = new FileMapping();
            fileDataCache = new HashMap<String, List<Pair<String, String>>>();
        }
        return mapping;
    }

    private InputStream getInputStream(String filePath) throws FileNotFoundException {
        return new FileInputStream(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getMappingProperties(String filePath) {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sbClass = new StringBuilder(ROOT_PATH_CLASS);
            sbClass.append(filePath);
            String classPath = PathUtil.class.getResource("/").getPath();
            classPath = classPath.replaceAll("%20", " ");
            String realPath = null;
            realPath = LINUX ? classPath.substring(0, classPath.indexOf("/WEB-INF/")) : classPath.substring(1, classPath.indexOf("/WEB-INF/"));
            StringBuilder sbPlugin = new StringBuilder(realPath + ROOT_PATH_PLUGIN);
            sbPlugin.append(this.convertFilePath(filePath));
            Properties pro = new Properties();
            InputStream inputStream = this.getClass().getResourceAsStream(sbClass.toString());
            try {
                if (null != inputStream) {
                    pro.loadFromXML(inputStream);
                    Properties properties = pro;
                    return properties;
                }
                pro.loadFromXML(this.getInputStream(sbPlugin.toString()));
            }
            catch (InvalidPropertiesFormatException e) {
                LOGGER.error((Object)("FileMapping.getMappingProperties():" + e));
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"FileMapping.getMappingProperties() File not found");
            }
            catch (IOException e) {
                LOGGER.error((Object)("FileMapping.getMappingProperties():" + e));
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"inputStream not close", (Throwable)e);
                }
            }
            return pro;
        }
    }

    private String convertFilePath(String filePath) {
        StringBuffer sb = new StringBuffer();
        String local = "en";
        int offset = filePath.indexOf("/");
        if (-1 == offset) {
            offset = filePath.indexOf("\\");
        }
        if (offset != -1 && offset < 6) {
            local = filePath.substring(0, offset);
            filePath = filePath.substring(++offset);
        }
        if ((offset = filePath.indexOf(FILE_SUFFIX)) != -1) {
            filePath = filePath.substring(0, offset);
        }
        sb.append(filePath);
        sb.append('_');
        sb.append(local);
        sb.append(FILE_SUFFIX);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> getMappingList(String filePath) {
        Class<FileMapping> clazz = FileMapping.class;
        synchronized (FileMapping.class) {
            try {
                if (!ConditionConfigParser.getInstance().isDebug() && fileDataCache.containsKey(filePath)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return fileDataCache.get(filePath);
                }
            }
            catch (ElogConditionException e) {
                this.getElogLog().error((Object)("getMappingList():" + e));
            }
            Properties pro = this.getMappingProperties(filePath);
            ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
            for (Map.Entry<Object, Object> entry : pro.entrySet()) {
                list.add(new Pair<String, String>(IReportConfCheckUtil.getObjectStr(entry.getKey()), IReportConfCheckUtil.getObjectStr(entry.getValue())));
            }
            Collections.sort(list);
            fileDataCache.put(filePath, list);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return list;
        }
    }

    private Logger getElogLog() {
        return Logger.getLogger((String)"elog");
    }
}

