/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.util;

import java.net.URLDecoder;
import org.apache.log4j.Logger;

public final class PathUtil {
    public static final String SRC_PATH_TYPE = "src";
    public static final String WEB_PATH_TYPE = "web";
    private static final String ELOG = "elog";
    private static Logger elogLogger = null;

    private PathUtil() {
    }

    public static synchronized Logger getElogLog() {
        if (null == elogLogger) {
            elogLogger = Logger.getLogger((String)ELOG);
        }
        return elogLogger;
    }

    public static String getRealPathByType(String pathType, String path) {
        String realPath = "";
        realPath = WEB_PATH_TYPE.equalsIgnoreCase(pathType) ? PathUtil.getRealPath() + path : PathUtil.class.getResource("/").getPath() + path;
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            PathUtil.getElogLog().error((Object)e.getMessage());
        }
        return realPath;
    }

    public static String getRealPath() {
        String realPath = "";
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        String classPath = PathUtil.class.getResource("/").getPath();
        realPath = windows ? classPath.substring(1, classPath.indexOf("/WEB-INF/")) : classPath.substring(0, classPath.indexOf("/WEB-INF/"));
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            PathUtil.getElogLog().error((Object)e.getMessage());
        }
        return realPath;
    }
}

