/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.model.OutboundDivertTactics;
import com.hs.atic.bis.util.BisDivertUtil;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.OutboundDivertTacticsQueryBean;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsForm;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsService;
import com.hs.atic.sdk.bis.service.ISysQueryDetail;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.SysQueryFactory;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.util.RadioBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OutboundDivertTacticsAction
extends BaseAction {
    private static final long serialVersionUID = -4274073939254636520L;
    private static final int MAX_OUTBOUND = 2000;
    String divertDetail;
    List<AticDevice> firewallList;
    private ISysOptLog sysLogService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private String nfaId;
    private List<OutboundDivertTacticsForm> outboundDivertTacticsFormList;
    private IOutboundDivertTacticsService outboundDivertTacticsService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private IZoneService zoneService;
    private String sortField;
    private String sortType;
    private AticDeviceServiceImpl aticDeviceService;
    private AticDevice firewall;
    private OutboundDivertTacticsForm outboundDivertTacticsForm;
    private Long[] ids;
    private String[] names;
    private List<ZoneInfoForm> zoneFormList;
    private ZoneInfoForm zoneInfoForm;
    private OutboundDivertTacticsQueryBean queryBean;
    private String allQueryDisplay;
    private List<LangPair> modeCombData;
    private List<LangPair> statusCombData;
    private String source;
    private String showTaskType;
    private String selDev;
    private List<ZoneInfoForm> queryZoneFormList;
    private List<RadioBean> radioGroupList;
    private Long zoneId;
    private String ip;
    private Integer mask;
    private Integer maskBit;
    private Integer gridId;
    private Integer initRadioId;
    private StringBuffer submitToken = new StringBuffer();
    private String showDivertType;
    private String zoneName;
    private List<LangPair> strListDeviceSearchComb;
    private String defDeviceName;
    private String defDeviceId;
    private String creatStart;
    private String neId;
    private Long dashBoardZoneId;
    private Long dashBoardDeviceId;
    private String dashBoardDivertIp;
    private String sourcePortTableId;
    private String portTableId;
    private String[] sourcePortList;
    private String[] desPortList;
    private List<LangPair> outboundActionList;
    private String outboundActionLabel;
    private String outboundActionValue;
    private List<LangPair> outBoundProtocalList;
    private String combProtocolLabel;
    private String comProtoclValue;
    private String sourceIp;

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    private void initOutboundActionList(boolean isAdd) {
        this.outboundActionList = new ArrayList<LangPair>();
        this.outboundActionList.add(new LangPair("1", this.getText("atic.bis.divert.outbound.action.block")));
        this.outboundActionList.add(new LangPair("2", this.getText("atic.bis.divert.outbound.action.limit")));
        this.outboundActionList.add(new LangPair("3", this.getText("atic.bis.divert.outbound.action.redirect")));
    }

    public List<LangPair> getOutboundActionList() {
        return this.outboundActionList;
    }

    public void setOutboundActionList(List<LangPair> outboundActionList) {
        this.outboundActionList = outboundActionList;
    }

    public void addOutboundDivertTactics() {
        int i;
        List<OutboundDivertTactics> list = this.outboundDivertTacticsService.queryAll();
        if (list.size() >= 2000) {
            this.responseResult("size");
            return;
        }
        if (null != this.showDivertType && "policy".equals(this.showDivertType)) {
            if (IPUtil.isIpv4((String)this.outboundDivertTacticsForm.getSourceIp())) {
                this.outboundDivertTacticsForm.setSourceIp(this.outboundDivertTacticsForm.getSourceIp() + "/32");
            } else {
                this.outboundDivertTacticsForm.setSourceIp(this.outboundDivertTacticsForm.getSourceIp() + "/128");
            }
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.outboundDivertTacticsForm.setOperator(currentUser.getUserName());
        this.outboundDivertTacticsForm.setClientIp(currentUser.getIpAdr());
        StringBuffer sourcePorts = new StringBuffer();
        StringBuffer desPorts = new StringBuffer();
        for (i = 0; i < this.sourcePortList.length; ++i) {
            if (i != 0) {
                sourcePorts.append(",");
            }
            sourcePorts.append(this.sourcePortList[i]);
        }
        for (i = 0; i < this.desPortList.length; ++i) {
            if (i != 0) {
                desPorts.append(",");
            }
            desPorts.append(this.desPortList[i]);
        }
        this.outboundDivertTacticsForm.setSourcePort(sourcePorts.toString());
        this.outboundDivertTacticsForm.setDesPort(desPorts.toString());
        this.outboundDivertTacticsForm.setDivertMode(Integer.valueOf(2));
        if (null == this.outboundDivertTacticsForm.getProtocol()) {
            this.outboundDivertTacticsForm.setProtocol(Integer.valueOf(0));
        }
        if (null == this.outboundDivertTacticsForm.getAction()) {
            this.outboundDivertTacticsForm.setAction(Integer.valueOf(1));
        }
        if (this.isRepeat()) {
            this.responseResult("repeat");
            return;
        }
        this.outboundDivertTacticsService.createDivertTactics(this.outboundDivertTacticsForm);
        this.logger.info((Object)("deploy and save outbound divert tactics : ip = " + this.outboundDivertTacticsForm.getSourceIp() + " successfully."));
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.title.outbound.add");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(currentUser.getIpAdr());
        sysLog.setOperator(currentUser.getUserName());
        sysLog.setDetail("atic.bis.divert.tactics.log.result.success");
        sysLog.setResult(1);
        sysLog.setTarget(this.outboundDivertTacticsForm.getSourceIp());
        this.sysLogService.writeOptLog(sysLog);
        this.responseResult("success");
    }

    private boolean isRepeat() {
        List<OutboundDivertTacticsForm> oubboundDivertFormLst;
        if (null != this.outboundDivertTacticsService && null != this.outboundDivertTacticsForm.getSourceIp() && null != (oubboundDivertFormLst = this.outboundDivertTacticsService.queryBySourceIp(this.outboundDivertTacticsForm.getSourceIp())) && !oubboundDivertFormLst.isEmpty()) {
            for (OutboundDivertTacticsForm outboundForm : oubboundDivertFormLst) {
                if (null == outboundForm) continue;
                if (null == outboundForm.getProtocol()) {
                    outboundForm.setProtocol(Integer.valueOf(0));
                }
                if (null == this.outboundDivertTacticsForm.getProtocol()) {
                    this.outboundDivertTacticsForm.setProtocol(Integer.valueOf(0));
                }
                if (null == outboundForm.getDesIp()) {
                    outboundForm.setDesIp("");
                }
                if (null == this.outboundDivertTacticsForm.getDesIp()) {
                    this.outboundDivertTacticsForm.setDesIp("");
                }
                if (null == outboundForm.getAction()) {
                    outboundForm.setAction(Integer.valueOf(0));
                }
                if (null == this.outboundDivertTacticsForm.getAction()) {
                    this.outboundDivertTacticsForm.setAction(Integer.valueOf(0));
                }
                if (null == outboundForm.getSourcePort()) {
                    outboundForm.setSourcePort("");
                }
                if (null == this.outboundDivertTacticsForm.getSourcePort()) {
                    this.outboundDivertTacticsForm.setSourcePort("");
                }
                if (null == outboundForm.getDesPort()) {
                    outboundForm.setDesPort("");
                }
                if (null == this.outboundDivertTacticsForm.getDesPort()) {
                    this.outboundDivertTacticsForm.setDesPort("");
                }
                if (!outboundForm.getProtocol().equals(this.outboundDivertTacticsForm.getProtocol()) || !outboundForm.getDesIp().equals(this.outboundDivertTacticsForm.getDesIp()) || !outboundForm.getAction().equals(this.outboundDivertTacticsForm.getAction()) || !this.isPortEqual(outboundForm.getSourcePort(), this.outboundDivertTacticsForm.getSourcePort()) || !this.isPortEqual(outboundForm.getDesPort(), this.outboundDivertTacticsForm.getDesPort())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPortEqual(String sqlPort, String webPort) {
        String[] webPortArray;
        if ("".equals(sqlPort) && !"".equals(webPort) || !"".equals(sqlPort) && "".equals(webPort)) {
            return false;
        }
        if ("".equals(sqlPort) && "".equals(webPort)) {
            return true;
        }
        String[] sqlPortArray = sqlPort.split(",");
        if (sqlPortArray.length != (webPortArray = webPort.split(",")).length) {
            return false;
        }
        boolean issourcePortequal = true;
        for (int i = 0; i < sqlPortArray.length; ++i) {
            boolean isequal = false;
            for (int m = 0; m < sqlPortArray.length; ++m) {
                if (!sqlPortArray[i].equals(webPortArray[m])) continue;
                isequal = true;
            }
            if (isequal) continue;
            issourcePortequal = false;
            break;
        }
        return issourcePortequal;
    }

    public void writeSysLog() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.title.outbound.add");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(currentUser.getIpAdr());
        sysLog.setOperator(currentUser.getUserName());
        sysLog.setResult(0);
        sysLog.setTarget("com.hs.vsm.secservice.ddos.policy.action.outbound.trafficDivert.title ");
        sysLog.setTargetLocal(Boolean.valueOf(true));
        sysLog.setDetail("com.hs.vsm.secservice.ddos.policy.outbound.divert.max.num");
        this.sysLogService.writeOptLog(sysLog);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public Map<String, String> createQueryMap() {
        ZoneInfoForm zoneInfo;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.sortField && null != this.sortType) {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        } else {
            queryMap.put("sortName", "createTime");
            queryMap.put("sortType", "desc");
        }
        if (null != this.queryBean) {
            String sIp;
            queryMap.put("deviceId", null == this.queryBean.getDeviceId() ? null : this.queryBean.getDeviceId().toString());
            queryMap.put("zoneId", String.valueOf(this.queryBean.getZoneId()));
            zoneInfo = this.zoneService.getById(this.queryBean.getZoneId());
            if (null != zoneInfo) {
                this.queryBean.setZoneDesc(zoneInfo.getZoneDesc());
            }
            String string = sIp = null == this.queryBean.getSourceIp() ? null : this.queryBean.getSourceIp();
            if (!AticUtil.isNull((String)sIp)) {
                queryMap.put("sourceIp", sIp);
            }
            queryMap.put("startTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getStartTime())));
            queryMap.put("endTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getEndTime())));
            queryMap.put("divertMode", this.queryBean.getDivertMode());
            queryMap.put("divertStatus", this.queryBean.getDivertStatus());
            queryMap.put("detail", this.queryBean.getDetail());
        } else {
            this.processDashBoardDivert(queryMap);
            if (null != this.zoneId) {
                if (null == this.queryBean) {
                    this.queryBean = new OutboundDivertTacticsQueryBean();
                }
                this.queryBean.setZoneId(this.zoneId);
                queryMap.put("zoneId", String.valueOf(this.queryBean.getZoneId()));
                zoneInfo = this.zoneService.getById(this.queryBean.getZoneId());
                if (null != zoneInfo) {
                    this.queryBean.setZoneDesc(zoneInfo.getZoneDesc());
                }
            }
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private void processDashBoardDivert(Map<String, String> queryMap) {
        if (null != this.dashBoardZoneId) {
            if (null == this.queryBean) {
                this.queryBean = new OutboundDivertTacticsQueryBean();
            }
            this.queryBean.setZoneId(this.dashBoardZoneId);
            queryMap.put("zoneId", String.valueOf(this.queryBean.getZoneId()));
            ZoneInfoForm zoneInfo = this.zoneService.getById(this.queryBean.getZoneId());
            if (null != zoneInfo) {
                this.queryBean.setZoneDesc(zoneInfo.getZoneDesc());
            }
        }
        if (null != this.dashBoardDeviceId) {
            if (null == this.queryBean) {
                this.queryBean = new OutboundDivertTacticsQueryBean();
            }
            this.queryBean.setDeviceId(this.dashBoardDeviceId);
            queryMap.put("deviceId", String.valueOf(this.dashBoardDeviceId));
        }
        if (null != this.dashBoardDivertIp) {
            if (null == this.queryBean) {
                this.queryBean = new OutboundDivertTacticsQueryBean();
            }
            this.queryBean.setSourceIp(this.dashBoardDivertIp);
            queryMap.put("sourceIp", this.dashBoardDivertIp);
        }
    }

    public void deleteOutboundDivertTactics() {
        this.validateIdsAndNames();
        List<BatchOperation> batchOpList = this.batchOperate();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.batchOperationResult = this.outboundDivertTacticsService.deleteDivertTactics(batchOpList, false, currentUser.getUserName(), currentUser.getIpAdr());
        this.logger.info((Object)("delete outbound divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
        this.getOperateLog().normal("atic.bis.divert.tactics.operate.type.outbound.delete", "lego.dic.module.AticBis", null, false, "atic.bis.divert.tactics.log.result.success", null);
        this.bathResult(this.batchOperationResult);
    }

    private List<BatchOperation> batchOperate() {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            bo.setTargetName(this.filterTargetName(this.names[i]));
            batchOpList.add(bo);
            this.logger.info((Object)("batch operate targetName = " + this.getcleanedMessage(bo.getTargetName())));
        }
        return batchOpList;
    }

    public void deleteAllOutboundDivertTactics() {
        Long[] divertIds = new Long[]{0L};
        Set<Long> devIds = this.outboundDivertTacticsService.getDevIdsByDivertIds(divertIds);
        if (null == devIds) {
            this.bathResult(new BatchOperationResult());
        }
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != devIds) {
            ArrayList<Long> deviceList = new ArrayList<Long>(devIds);
            BisUtil.checkUserSecurity(deviceList);
            for (Long devId : devIds) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(devId.longValue());
                batchOpList.add(bo);
                this.logger.info((Object)("batch operate device id = " + bo.getTargetId()));
            }
        }
        this.batchOperationResult = this.outboundDivertTacticsService.deleteAllDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
        this.logger.info((Object)("delete all outbound divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
        this.getOperateLog().normal("atic.bis.divert.tactics.operate.type.outbound.delete.all", "lego.dic.module.AticBis", null, false, "atic.bis.divert.tactics.log.result.success", null);
        this.bathResult(this.batchOperationResult);
    }

    private String filterTargetName(String targetName) {
        if (null == targetName) {
            return "";
        }
        return targetName;
    }

    public String getAllQueryDisplay() {
        return this.allQueryDisplay;
    }

    public void getBitByMask() {
        this.responseResult(this.mask.toString());
    }

    public String getCreatStart() {
        return this.creatStart;
    }

    public String getDefDeviceId() {
        return this.defDeviceId;
    }

    public String getDefDeviceName() {
        return this.defDeviceName;
    }

    public AticDevice getFirewall() {
        return this.firewall;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public Integer getGridId() {
        return this.gridId;
    }

    public Integer getInitRadioId() {
        return this.initRadioId;
    }

    public String getIp() {
        return this.ip;
    }

    public void getIpByZoneId() {
        this.zoneInfoForm = this.zoneService.getById(this.zoneId);
        if (null == this.zoneInfoForm) {
            this.logger.warn((Object)("view zone. zone : " + this.zoneId + "has not been existed."));
            throw new LegoCheckedException(570609L);
        }
        List zifList = this.zoneInfoForm.getZoneIpFormList();
        StringBuffer json = new StringBuffer("{data : [");
        if (null != zifList) {
            for (ZoneIpForm zoneIpForm : zifList) {
                json.append('{').append("ip : \"").append(zoneIpForm.getZoneIp()).append('\"').append(',').append("mask : \"").append(zoneIpForm.getMask()).append('\"').append("},");
            }
        } else {
            this.logger.error((Object)"convertToJson: parameter zoneInfoFormList is null");
        }
        json.append("]}");
        this.logger.info((Object)("zone ip json : " + json));
        this.responseResult(json.toString());
    }

    public void isIpExistedInPolicy() {
        this.zoneInfoForm = this.zoneService.getById(this.zoneId);
        List zoneInfoFormList = this.zoneInfoForm.getZoneIpFormList();
        for (int i = 0; i < zoneInfoFormList.size(); ++i) {
            if ((!IPUtil.isIpv4((String)this.sourceIp) || !IPUtil.isIpv4((String)((ZoneIpForm)zoneInfoFormList.get(i)).getStartIp())) && (!IPUtil.isIpv6((String)this.sourceIp) || !IPUtil.isIpv6((String)((ZoneIpForm)zoneInfoFormList.get(i)).getStartIp())) || IPUtil.compareTo((String)((ZoneIpForm)zoneInfoFormList.get(i)).getStartIp(), (String)this.sourceIp) > 0 || IPUtil.compareTo((String)((ZoneIpForm)zoneInfoFormList.get(i)).getEndIp(), (String)this.sourceIp) < 0) continue;
            this.responseResult("success");
        }
        this.responseResult(this.getText("atic.bis.divert.source.ip.range.error"));
    }

    public Integer getMask() {
        return this.mask;
    }

    public Integer getMaskBit() {
        return this.maskBit;
    }

    public List<LangPair> getModeCombData() {
        return this.modeCombData;
    }

    public String getNeId() {
        return this.neId;
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    public List<ZoneInfoForm> getQueryZoneFormList() {
        return this.queryZoneFormList;
    }

    public List<RadioBean> getRadioGroupList() {
        return this.radioGroupList;
    }

    public String getSelDev() {
        return this.selDev;
    }

    public String getShowDivertType() {
        return this.showDivertType;
    }

    public String getShowTaskType() {
        return this.showTaskType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public String getSource() {
        return this.source;
    }

    public List<LangPair> getStatusCombData() {
        return this.statusCombData;
    }

    public List<LangPair> getStrListDeviceSearchComb() {
        return this.strListDeviceSearchComb;
    }

    public String getSubmitToken() {
        return this.submitToken.toString();
    }

    public String getZoneByDevId() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.selDev = this.selDev.split(",")[0];
        this.source = this.source.split(",")[0];
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        if ("0".equals(this.selDev)) {
            Paging page = this.zoneService.getPageDeployZoneInfo(queryMap, this.getStart(), this.getPageSize());
            this.queryZoneFormList = page.getData();
            this.setTotal(page.getCount());
            this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
            this.getSession().setAttribute("start", (Object)this.getStart());
            this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
            this.getSession().setAttribute("sortField", (Object)this.sortField);
            this.getSession().setAttribute("sortType", (Object)this.sortType);
        } else {
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.selDev));
            BisUtil.checkUserSecurity(deviceList);
            queryMap.put("deviceId", AticUtil.stringFilter((String)this.selDev));
            Paging page = this.zoneService.getPageDeployZoneInfo(queryMap, this.getStart(), this.getPageSize());
            this.queryZoneFormList = page.getData();
            this.setTotal(page.getCount());
            this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
            this.getSession().setAttribute("start", (Object)this.getStart());
            this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
            this.getSession().setAttribute("sortField", (Object)this.sortField);
            this.getSession().setAttribute("sortType", (Object)this.sortType);
        }
        return "list";
    }

    public boolean validateSelDev() {
        if (AticUtil.isNullForVpn((String)this.selDev)) {
            return true;
        }
        String testSelDev = this.selDev.split(",")[0];
        try {
            if (Long.parseLong(testSelDev) >= 0L) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    public List<ZoneInfoForm> getZoneFormList() {
        return this.zoneFormList;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public ZoneInfoForm getZoneInfoForm() {
        return this.zoneInfoForm;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    private void initDevicesComb(boolean isQuery) {
        boolean isHaveDivert = this.inputFirewallList();
        if (!isQuery && !isHaveDivert) {
            throw new LegoCheckedException(571218L);
        }
        this.strListDeviceSearchComb = new ArrayList<LangPair>();
        if (null != this.firewallList && !this.firewallList.isEmpty()) {
            for (int i = 0; i < this.firewallList.size(); ++i) {
                AticDevice fireWall = this.firewallList.get(i);
                if (null == fireWall) continue;
                if (i == 0) {
                    this.defDeviceId = String.valueOf(fireWall.getMoId());
                    this.defDeviceName = fireWall.getName();
                }
                LangPair ld = new LangPair(String.valueOf(fireWall.getMoId()), fireWall.getName());
                this.strListDeviceSearchComb.add(ld);
            }
        }
        this.allQueryDisplay = this.getText("atic.public.query.all");
    }

    private boolean inputFirewallList() {
        AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByFlowspec(Boolean.valueOf(true));
        if (null == aticDeviceNfa) {
            return false;
        }
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(aticDeviceNfa.getMoId());
        if (null == this.firewallList) {
            this.firewallList = new ArrayList<AticDevice>();
        }
        this.firewallList.add(aticDevice);
        return true;
    }

    private void initQueryBean() {
        if (null != this.queryBean) {
            AticDevice fireWall;
            if (!AticUtil.isNull((String)this.queryBean.getDivertMode())) {
                Map<Integer, String> divertModeMap = BisDivertUtil.getDivertModeMap();
                this.queryBean.setDivertModeName(divertModeMap.get(Integer.valueOf(this.queryBean.getDivertMode())));
            }
            if (!AticUtil.isNull((String)this.queryBean.getDivertStatus())) {
                Map<Integer, String> divertStateMap = BisDivertUtil.getDivertStateMap();
                this.queryBean.setDivertStatusName(divertStateMap.get(Integer.valueOf(this.queryBean.getDivertStatus())));
            }
            if (null != this.queryBean.getDeviceId() && null != (fireWall = this.aticDeviceService.getDeviceByMoid(this.queryBean.getDeviceId().longValue()))) {
                this.queryBean.setDeviceName(fireWall.getName());
            }
        }
    }

    public void isDevOnLine() {
        this.responseResult("success");
    }

    public String listOutboundDivertTactics() {
        Paging page = this.outboundDivertTacticsService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.outboundDivertTacticsFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.initDevicesComb(true);
        this.modeCombData = BisDivertUtil.getDivertModeCombData();
        this.statusCombData = BisDivertUtil.getDivertStatusCombData();
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (null != this.queryBean && null != this.queryBean.getZoneId() && 0L != this.queryBean.getZoneId()) {
            moIDList.add(ZoneBisUtil.getMoidByZoneid((Long)this.queryBean.getZoneId()));
        }
        if (null != this.queryBean && null != this.queryBean.getDeviceId() && 0L != this.queryBean.getDeviceId()) {
            moIDList.add(this.queryBean.getDeviceId());
        }
        BisUtil.checkUserSecurity(moIDList);
        this.initQueryBean();
        this.logger.info((Object)("query outbound divert tactics list, size = " + this.outboundDivertTacticsFormList.size()));
        this.allQueryDisplay = this.getText("atic.public.query.all");
        if (null != this.showDivertType && "policy".equals(this.showDivertType)) {
            return "listforpolicy";
        }
        return "list";
    }

    public String queryAllZone() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.selDev = this.selDev.split(",")[0];
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        if (Integer.parseInt(this.selDev) > 0) {
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.selDev));
            BisUtil.checkUserSecurity(deviceList);
        }
        queryMap.put("deviceId", AticUtil.stringFilter((String)this.selDev));
        Paging page = this.zoneService.getConnectZoneInfo(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        return "list";
    }

    public String queryConnectZoneByDevId() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        if (AticUtil.isNull((String)this.selDev)) {
            return "list";
        }
        this.selDev = this.selDev.split(",")[0];
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        if (null == this.selDev || this.selDev.isEmpty()) {
            return "list";
        }
        if (Integer.parseInt(this.selDev) > 0) {
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.selDev));
            BisUtil.checkUserSecurity(deviceList);
        }
        queryMap.put("deviceId", AticUtil.stringFilter((String)this.selDev));
        Paging page = this.zoneService.getConnectZoneInfo(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        return "list";
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public void setCreatStart(String creatStart) {
        this.creatStart = creatStart;
    }

    public void setDefDeviceId(String defDeviceId) {
        this.defDeviceId = defDeviceId;
    }

    public void setDefDeviceName(String defDeviceName) {
        this.defDeviceName = defDeviceName;
    }

    public List<OutboundDivertTacticsForm> getOutboundDivertTacticsFormList() {
        return this.outboundDivertTacticsFormList;
    }

    public void setOutboundDivertTacticsFormList(List<OutboundDivertTacticsForm> outboundDivertTacticsFormList) {
        this.outboundDivertTacticsFormList = outboundDivertTacticsFormList;
    }

    public void setFirewall(AticDevice firewall) {
        this.firewall = firewall;
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public void setGridId(Integer gridId) {
        this.gridId = gridId;
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public void setInitRadioId(Integer initRadioId) {
        this.initRadioId = initRadioId;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setMask(Integer mask) {
        this.mask = mask;
    }

    public void setMaskBit(Integer maskBit) {
        this.maskBit = maskBit;
    }

    public void setModeCombData(List<LangPair> modeCombData) {
        this.modeCombData = modeCombData;
    }

    public void setNames(String[] names) {
        this.names = null != names ? (String[])names.clone() : null;
    }

    public void setNeId(String neId) {
        this.neId = neId;
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public OutboundDivertTacticsQueryBean getQueryBean() {
        return this.queryBean;
    }

    public void setQueryBean(OutboundDivertTacticsQueryBean queryBean) {
        this.queryBean = queryBean;
    }

    public void setQueryZoneFormList(List<ZoneInfoForm> queryZoneFormList) {
        this.queryZoneFormList = queryZoneFormList;
    }

    public void setRadioGroupList(List<RadioBean> radioGroupList) {
        this.radioGroupList = radioGroupList;
    }

    public void setSelDev(String selDev) {
        this.selDev = selDev;
    }

    public void setShowDivertType(String showDivertType) {
        this.showDivertType = showDivertType;
    }

    public void setShowTaskType(String showTaskType) {
        this.showTaskType = showTaskType;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setStatusCombData(List<LangPair> statusCombData) {
        this.statusCombData = statusCombData;
    }

    public void setStrListDeviceSearchComb(List<LangPair> strListDeviceSearchComb) {
        this.strListDeviceSearchComb = strListDeviceSearchComb;
    }

    public void setSubmitToken(String submitToken) {
        this.submitToken = new StringBuffer(submitToken);
    }

    public void setZoneFormList(List<ZoneInfoForm> zoneFormList) {
        this.zoneFormList = zoneFormList;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public void setZoneInfoForm(ZoneInfoForm zoneInfoForm) {
        this.zoneInfoForm = zoneInfoForm;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String showAddOutboundDivertTactics() {
        this.logger.info((Object)"prepare to add outbound divert tactics");
        this.initDevicesComb(false);
        this.initOutboundActionList(true);
        this.setCombProtocolLabel(this.getText("atic.analysis.common.protocol.all"));
        this.setOutboundActionLabel(this.getText("atic.bis.divert.outbound.action.block"));
        this.initProtoclList();
        if (null != this.showDivertType && "policy".equals(this.showDivertType)) {
            return "addforpolicy";
        }
        return "add";
    }

    private void initProtoclList() {
        this.outBoundProtocalList = new ArrayList<LangPair>();
        this.outBoundProtocalList.add(new LangPair("0", this.getText("atic.analysis.common.protocol.all")));
        this.outBoundProtocalList.add(new LangPair("6", this.getText("atic.analysis.common.protocol.tcp")));
        this.outBoundProtocalList.add(new LangPair("17", this.getText("atic.analysis.common.protocol.udp")));
        this.outBoundProtocalList.add(new LangPair("1", this.getText("atic.analysis.common.protocol.icmp")));
    }

    public List<LangPair> getOutBoundProtocalList() {
        return this.outBoundProtocalList;
    }

    public void setOutBoundProtocalList(List<LangPair> outBoundProtocalList) {
        this.outBoundProtocalList = outBoundProtocalList;
    }

    public String showDivertPanel() {
        if (null != this.showDivertType && "policy".equals(this.showDivertType)) {
            return "listforpolicy";
        }
        return "list";
    }

    public String showSplitIp() {
        this.logger.info((Object)"prepare to show split ip");
        if (null != this.showDivertType && "policy".equals(this.showDivertType)) {
            return "addforpolicy";
        }
        return "add";
    }

    public void splitIpByMask() {
        List splitIpList = new ArrayList();
        Integer splitMask = null;
        if (null != this.ip && null != this.mask && null != this.maskBit) {
            if (this.ip.contains("/")) {
                this.ip = this.ip.split("/")[0];
            }
            this.logger.info((Object)("prepare to split ip .ipAddress = " + this.ip + " ,mask = " + this.mask + " , maskBit = " + this.maskBit));
            Integer maskLength = this.mask;
            if (this.maskBit > maskLength + 8 || this.maskBit <= maskLength) {
                this.responseResult("failure");
                return;
            }
            splitMask = this.maskBit;
            splitIpList = IPUtil.spiltNetworkSegmentByMask((String)(this.ip + "/" + this.mask), (int)this.maskBit);
        } else {
            this.logger.error((Object)"ip or mask or maskDigit is null");
        }
        this.logger.info((Object)("get Subnet mask = " + splitMask + " by Mask Length = " + this.maskBit));
        StringBuffer json = new StringBuffer("{data : [");
        if (null != splitIpList) {
            for (String splitIpTemp : splitIpList) {
                String splitIp = splitIpTemp;
                if (splitIp.contains("/")) {
                    splitIp = splitIp.split("/")[0];
                }
                json.append('{').append("ip : \"").append(splitIp).append('\"').append(',').append("mask : \"").append(splitMask).append('\"').append("},");
            }
        } else {
            this.logger.error((Object)"convertToJson: parameter splitIpList is null");
        }
        json.append("]}");
        this.logger.info((Object)("split ip json : " + json));
        this.responseResult(json.toString());
    }

    public void startOutboundDivertTactics() {
        this.validateIdsAndNames();
        List<BatchOperation> batchOpList = this.batchOperate();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.batchOperationResult = this.outboundDivertTacticsService.startDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
        this.logger.info((Object)("start outbound divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
        this.getOperateLog().normal("atic.bis.divert.tactics.operate.type.outbound.start", "lego.dic.module.AticBis", null, false, "atic.bis.divert.tactics.log.result.success", null);
        this.bathResult(this.batchOperationResult);
    }

    private void checkUltraVires(Long id) {
    }

    private void checkSecurity(Long nfaID) {
    }

    public void stopOutboundDivertTactics() {
        this.validateIdsAndNames();
        List<BatchOperation> batchOpList = this.batchOperate();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.batchOperationResult = this.outboundDivertTacticsService.stopDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
        this.logger.info((Object)("stop divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
        this.getOperateLog().normal("atic.bis.divert.tactics.operate.type.outbound.stop", "lego.dic.module.AticBis", null, false, "atic.bis.divert.tactics.log.result.success", null);
        this.bathResult(this.batchOperationResult);
    }

    private boolean validateContain(List<ZoneIpForm> zoneIps, String startIp, String endIp) {
        if (zoneIps == null) {
            return false;
        }
        for (ZoneIpForm ipForm : zoneIps) {
            String[] rangeIps = IPUtil.getSubnetRange((String)ipForm.getZoneIp(), (int)ipForm.getMask());
            String startIpExist = rangeIps[0];
            String endIpExist = rangeIps[1];
            if (IPUtil4Atic.convert2CompleteIp((String)startIp).compareTo(IPUtil4Atic.convert2CompleteIp((String)startIpExist)) < 0 || IPUtil4Atic.convert2CompleteIp((String)endIp).compareTo(IPUtil4Atic.convert2CompleteIp((String)endIpExist)) > 0) continue;
            return true;
        }
        return false;
    }

    private void validateIdsAndNames() {
        for (Long id : this.ids) {
            this.checkUltraVires(id);
        }
    }

    public void validateIp() {
        if (null != this.zoneId && !AticUtil.isNull((String)this.ip) && this.mask != null) {
            Boolean isDefaultZone = this.zoneService.isDefaultZone(this.zoneId.longValue());
            String[] rangeIps = IPUtil.getSubnetRange((String)this.ip, (int)this.mask);
            String startIp = rangeIps[0];
            String endIp = rangeIps[1];
            if (!isDefaultZone.booleanValue()) {
                List zIpList = this.zoneService.findIpByZoneId(this.zoneId);
                if (this.validateContain(zIpList, startIp, endIp)) {
                    this.responseResult("success");
                } else {
                    this.responseResult("notzone");
                }
            } else {
                this.responseResult("success");
            }
        }
    }

    public String viewDivertDetail() {
        this.checkSecurity(Long.valueOf(this.nfaId));
        ISysQueryDetail sysQuery = (ISysQueryDetail)SysQueryFactory.getInstance().getThirdServiceByName("ISysQueryDetail");
        if (sysQuery != null) {
            this.divertDetail = sysQuery.queryNfaDetailById(Long.parseLong(this.nfaId));
        } else {
            LOG.error("service SysQueryDetail is null", new String[0]);
        }
        return "success";
    }

    public String getNfaId() {
        return this.nfaId;
    }

    public void setNfaId(String nfaId) {
        this.nfaId = nfaId;
    }

    public String getDivertDetail() {
        return this.divertDetail;
    }

    public void setDivertDetail(String divertDetail) {
        this.divertDetail = divertDetail;
    }

    public Long getDashBoardZoneId() {
        return this.dashBoardZoneId;
    }

    public void setDashBoardZoneId(Long dashBoardZoneId) {
        this.dashBoardZoneId = dashBoardZoneId;
    }

    public Long getDashBoardDeviceId() {
        return this.dashBoardDeviceId;
    }

    public void setDashBoardDeviceId(Long dashBoardDeviceId) {
        this.dashBoardDeviceId = dashBoardDeviceId;
    }

    public String getDashBoardDivertIp() {
        return this.dashBoardDivertIp;
    }

    public void setDashBoardDivertIp(String dashBoardDivertIp) {
        this.dashBoardDivertIp = dashBoardDivertIp;
    }

    public boolean validateZoneId() {
        if (null == this.zoneId) {
            return true;
        }
        return this.zoneId >= 0L;
    }

    public boolean validateIds() {
        if (null == this.ids) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateQueryBeanZoneId() {
        if (null != this.queryBean) {
            if (null == this.queryBean.getZoneId()) {
                return true;
            }
            if (this.queryBean.getZoneId() < 0L) {
                return false;
            }
        }
        return true;
    }

    public boolean validateQueryBeanDeviceId() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getDeviceId()) {
            return true;
        }
        return this.queryBean.getDeviceId() >= 0L;
    }

    public boolean validateQueryBeanDivertIp() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getSourceIp()) || IPUtil.isIpv4((String)this.queryBean.getSourceIp()) || IPUtil.isIpv6((String)this.queryBean.getSourceIp());
    }

    public boolean validateQueryBeanStartTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getStartTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getStartTime());
    }

    public boolean validateQueryBeanEndTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getEndTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getEndTime());
    }

    public boolean validateQueryBeanDeviceName() {
        if (null == this.queryBean) {
            return true;
        }
        if (AticUtil.isNullForVpn((String)this.queryBean.getDeviceName())) {
            return true;
        }
        if (this.queryBean.getDeviceName().length() > 32) {
            return false;
        }
        if (this.queryBean.getDeviceName().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return this.queryBean.getDeviceName().matches(nameRegex);
    }

    public boolean validateQueryBeanZoneDesc() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getZoneDesc() || "".equals(this.queryBean.getZoneDesc().trim())) {
            return true;
        }
        if (this.queryBean.getZoneDesc().length() > 64) {
            return false;
        }
        if (this.queryBean.getZoneDesc().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
        return this.queryBean.getZoneDesc().matches(nameRegex);
    }

    public boolean validateQueryBeanDetail() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getDetail() || "".equals(this.queryBean.getDetail().trim())) {
            return true;
        }
        if (this.queryBean.getDetail().length() > 64) {
            return false;
        }
        if (this.queryBean.getDetail().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!\\s*null$)(?![\\s\\S]*[\\s]+null$)(?!\\s*null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\\u4e00-\\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-]*$";
        return this.queryBean.getDetail().matches(nameRegex);
    }

    public boolean validataZoneName() {
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            String nameRegex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
            if (!this.zoneInfoForm.getZoneName().matches(nameRegex) || this.zoneInfoForm.getZoneName().length() > 32) {
                return false;
            }
        }
        return true;
    }

    public boolean validateSplitIpByMask() {
        if (AticUtil.isNull((String)this.ip) || null == this.mask) {
            return false;
        }
        if (AticUtil.validateIpv4((String)this.ip) && this.mask > 0 && this.mask <= 32) {
            return true;
        }
        return IPUtil.isIpv6((String)this.ip) && this.mask > 0 && this.mask <= 128;
    }

    public boolean validateNames() {
        if (null != this.names) {
            for (int i = 0; i < this.names.length; ++i) {
                String nameRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|\\-|_|!|@|#|$|*|&|:|,|%|;|.|+|}|{|(|)]*$";
                if (null == this.names[i] || this.names[i].matches(nameRegex)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean validateOnLineNames() {
        if (null != this.names) {
            for (int i = 0; i < this.names.length; ++i) {
                String nameRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|\\-|_|!|@|#|$|*|&|:|,|%|;|.|+|}|{|(|)]*$";
                if (null == this.names[i] || this.names[i].matches(nameRegex)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateHomePageDivertTactics(String idStr) {
        String dashBoardId = this.fetchRequest().getParameter(idStr);
        if (!AticUtil.isNullForVpn((String)dashBoardId)) {
            try {
                if (Long.parseLong(dashBoardId) < 0L) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateDashBoardDivertIp() {
        return AticUtil.isNullForVpn((String)this.dashBoardDivertIp) || AticUtil.validateIpv4((String)this.dashBoardDivertIp) || IPUtil.isIpv6((String)this.dashBoardDivertIp);
    }

    public boolean checkIpAndMask() {
        if (AticUtil.isNull((String)this.ip) || null == this.mask) {
            return false;
        }
        try {
            IPUtil.getSubnetRange((String)this.ip, (int)this.mask);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (LegoCheckedException e) {
            return false;
        }
        return true;
    }

    public OutboundDivertTacticsForm getOutboundDivertTacticsForm() {
        return this.outboundDivertTacticsForm;
    }

    public void setOutboundDivertTacticsForm(OutboundDivertTacticsForm outboundDivertTacticsForm) {
        this.outboundDivertTacticsForm = outboundDivertTacticsForm;
    }

    public String getCombProtocolLabel() {
        return this.combProtocolLabel;
    }

    public void setCombProtocolLabel(String combProtocolLabel) {
        this.combProtocolLabel = combProtocolLabel;
    }

    public String getComProtoclValue() {
        return this.comProtoclValue;
    }

    public void setComProtoclValue(String comProtoclValue) {
        this.comProtoclValue = comProtoclValue;
    }

    public String getOutboundActionLabel() {
        return this.outboundActionLabel;
    }

    public void setOutboundActionLabel(String outboundActionLabel) {
        this.outboundActionLabel = outboundActionLabel;
    }

    public String getOutboundActionValue() {
        return this.outboundActionValue;
    }

    public void setOutboundActionValue(String outboundActionValue) {
        this.outboundActionValue = outboundActionValue;
    }

    public void setSourcePortList(String[] sourcePortList) {
        this.sourcePortList = null != sourcePortList ? (String[])sourcePortList.clone() : null;
    }

    public void setDesPortList(String[] desPortList) {
        this.desPortList = null != desPortList ? (String[])desPortList.clone() : null;
    }

    public String getSourcePortTableId() {
        return this.sourcePortTableId;
    }

    public void setSourcePortTableId(String sourcePortTableId) {
        this.sourcePortTableId = sourcePortTableId;
    }

    public String getPortTableId() {
        return this.portTableId;
    }

    public void setPortTableId(String portTableId) {
        this.portTableId = portTableId;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public void setOutboundDivertTacticsService(IOutboundDivertTacticsService outboundDivertTacticsService) {
        this.outboundDivertTacticsService = outboundDivertTacticsService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void setAticDeviceService(AticDeviceServiceImpl aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

