/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.model.OutboundDivertTacticsLog;
import com.hs.atic.bis.util.BisDivertUtil;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.OutboundDivertTacticsQueryBean;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsLogService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class OutboundDivertTacticsLogAction
extends BaseAction {
    private static final long serialVersionUID = -703739437386447818L;
    private String divertLogRemark;
    private String logId;
    private List<OutboundDivertTacticsLogForm> outboundDivertTacticsLogFormList;
    private IOutboundDivertTacticsLogService outboundDivertTacticsLogService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private AticDeviceServiceImpl aticDeviceService;
    private IZoneService zoneService;
    private List<AticDevice> firewallList;
    private String sortField;
    private String sortType;
    private OutboundDivertTacticsQueryBean queryBean;
    private AticDevice firewall;
    private Integer exportStart;
    private Integer exportEnd;
    private String allQueryDisplay;
    private List<LangPair> modeCombData;
    private List<LangPair> logLevelCombData;
    private ZoneInfoForm zoneInfoForm;
    private List<ZoneInfoForm> queryZoneFormList;
    private String downFileName;
    private String idStr;
    private String isQuery = "false";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);

    public String listOutboundDivertTacticsLog() {
        String sourceIp;
        if (!(null == this.queryBean || null == this.queryBean.getSourceIp() || this.queryBean.getSourceIp().isEmpty() || IPUtil.isIpv4((String)(sourceIp = this.queryBean.getSourceIp().split("/")[0])) || IPUtil.isIpv6((String)sourceIp))) {
            this.logger.error((Object)"queryBean sourceIp format is error!");
            return null;
        }
        Paging page = this.outboundDivertTacticsLogService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.outboundDivertTacticsLogFormList = page.getData();
        this.processRemark(this.outboundDivertTacticsLogFormList);
        this.initDevicesComb();
        this.modeCombData = BisDivertUtil.getDivertModeCombData();
        this.logLevelCombData = BisDivertUtil.getDivertLogCombData();
        if (null != this.queryBean) {
            ArrayList<Long> moIDList = new ArrayList<Long>();
            if (null != this.queryBean.getZoneId() && 0L != this.queryBean.getZoneId()) {
                moIDList.add(ZoneBisUtil.getMoidByZoneid((Long)this.queryBean.getZoneId()));
            }
            if (null != this.queryBean.getDeviceId() && 0L != this.queryBean.getDeviceId()) {
                moIDList.add(this.queryBean.getDeviceId());
            }
            BisUtil.checkUserSecurity(moIDList);
            this.isQuery = "true";
        } else {
            this.isQuery = "false";
        }
        this.setZoneNameAndDeviceNameForLog(this.outboundDivertTacticsLogFormList);
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("queryBean", (Object)this.queryBean);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        this.logger.info((Object)("query outbound divert tactics log. size = " + this.outboundDivertTacticsLogFormList.size()));
        this.allQueryDisplay = this.getText("atic.public.query.all");
        return "list";
    }

    public void setOutboundDivertTacticsLogService(IOutboundDivertTacticsLogService outboundDivertTacticsLogService) {
        this.outboundDivertTacticsLogService = outboundDivertTacticsLogService;
    }

    private void processRemark(List<OutboundDivertTacticsLogForm> outboundDivertTacticsLogFormLists) {
        for (OutboundDivertTacticsLogForm outboundDivertTacticsLogForm : outboundDivertTacticsLogFormLists) {
            String remark = outboundDivertTacticsLogForm.getRemark();
            if (AticUtil.isNull((String)remark)) continue;
            if (remark.contains(".") && !remark.contains(":") && !remark.contains(" ")) {
                outboundDivertTacticsLogForm.setRemark(this.getText("atic.bis.divert.tactics.log.remark." + remark));
                continue;
            }
            if (!remark.matches("[0-9]+")) continue;
            outboundDivertTacticsLogForm.setRemark(this.getText("lego.err." + remark));
        }
    }

    public String showExportDivertTacticsLog() {
        this.logger.info((Object)"prepare to export outbound divert tactics log");
        this.queryBean = (OutboundDivertTacticsQueryBean)this.getSession().getAttribute("queryBean");
        this.setTotal((Integer)this.getSession().getAttribute("total"));
        this.sortField = (String)this.getSession().getAttribute("sortField");
        this.sortType = (String)this.getSession().getAttribute("sortType");
        return "export";
    }

    public void exportOutboundDivertTacticsLog() {
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        if (!this.createFile(downloadPath)) {
            return;
        }
        Long dateTime = System.currentTimeMillis();
        String fileNameTmp = "outbounddivertLog_" + dateTime + ".xls";
        downloadPath = downloadPath + File.separator + fileNameTmp;
        if (this.idStr != null) {
            String tempStr = this.idStr;
            if (!"".equals(tempStr)) {
                tempStr = tempStr.substring(0, tempStr.length() - 1);
                this.outboundDivertTacticsLogFormList = this.outboundDivertTacticsLogService.getOutboundLogsByDivertTacticsLogIdS(tempStr);
            }
            this.getOperateLog().info("atic.bis.divert.tactics.log.outbound.export.select", "lego.dic.module.AticBis", "atic.bis.divert.tactics.log.outbound.list", true, "atic.bis.divert.tactics.log.outbound.export.select", null);
        } else {
            this.outboundDivertTacticsLogFormList = this.outboundDivertTacticsLogService.queryByPage(this.createQueryMap(), 0, 65535).getData();
            this.getOperateLog().info("atic.bis.divert.tactics.log.outbound.export.all", "lego.dic.module.AticBis", "atic.bis.divert.tactics.log.outbound.list", true, "atic.bis.divert.tactics.log.outbound.export.all", null);
        }
        if (null == this.outboundDivertTacticsLogFormList) {
            this.logger.error((Object)"exportDivertTacticsLog(), outboundDivertTacticsLogFormList is null!");
            return;
        }
        ArrayList<Long> moIDList = new ArrayList<Long>();
        for (OutboundDivertTacticsLogForm form : this.outboundDivertTacticsLogFormList) {
            moIDList.add(form.getDeviceId());
        }
        BisUtil.checkUserSecurity(moIDList);
        this.setZoneNameAndDeviceNameForLog(this.outboundDivertTacticsLogFormList);
        this.processRemark(this.outboundDivertTacticsLogFormList);
        this.exportOutboundDivertTacticsLog0(BisDivertUtil.generateOutboundDivertExportTitles(), this.outboundDivertTacticsLogFormList, downloadPath);
        this.logger.info((Object)"export outbound divert tactics log successfully.");
        String[] args = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        args = 1 == version ? downloadPath.split("/") : downloadPath.split("\\\\");
        this.responseResult(args[args.length - 1]);
    }

    public String getZoneForDivertLog() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneService.queryByPage(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        return "list";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOutboundDivertTacticsLog0(String[] titles, List<OutboundDivertTacticsLogForm> outboundDivertTacticsLogFormLists, String downloadPath) {
        this.logger.info((Object)"begin to export OutboundDivertTacticsLog");
        WritableWorkbook workBook = null;
        FileOutputStream writeFileOut = null;
        try {
            writeFileOut = new FileOutputStream(downloadPath);
            workBook = Workbook.createWorkbook((OutputStream)writeFileOut);
            WritableSheet sheet = workBook.createSheet("ouboundDivertLog", 0);
            for (int i = 0; i < titles.length; ++i) {
                sheet.addCell((WritableCell)new Label(i, 0, titles[i]));
            }
            int rowNum = 1;
            Map<Integer, String> actionMap = BisDivertUtil.getDiveretLogActionMap();
            Map<Integer, String> operTypeMap = BisDivertUtil.getDiveretLogOperTypeMap();
            Map<Integer, String> resultsMap = BisDivertUtil.getDiveretLogResultsMap();
            Map<Integer, String> modeMap = BisDivertUtil.getDivertModeMap();
            Map<Integer, String> levelMap = BisDivertUtil.getLogLevelMap();
            for (OutboundDivertTacticsLogForm outboundDivertTacticsLogForm : outboundDivertTacticsLogFormLists) {
                sheet.addCell((WritableCell)new Label(0, rowNum, outboundDivertTacticsLogForm.getDeviceName()));
                sheet.addCell((WritableCell)new Label(1, rowNum, outboundDivertTacticsLogForm.getZoneDesc()));
                sheet.addCell((WritableCell)new Label(2, rowNum, outboundDivertTacticsLogForm.getSourceIp()));
                sheet.addCell((WritableCell)new Label(3, rowNum, String.valueOf(outboundDivertTacticsLogForm.getSourcePort())));
                sheet.addCell((WritableCell)new Label(4, rowNum, String.valueOf(outboundDivertTacticsLogForm.getDesIp())));
                sheet.addCell((WritableCell)new Label(5, rowNum, String.valueOf(outboundDivertTacticsLogForm.getDesPort())));
                sheet.addCell((WritableCell)new Label(6, rowNum, String.valueOf(outboundDivertTacticsLogForm.getProtocol())));
                sheet.addCell((WritableCell)new Label(7, rowNum, actionMap.get(outboundDivertTacticsLogForm.getAction())));
                sheet.addCell((WritableCell)new Label(8, rowNum, String.valueOf(outboundDivertTacticsLogForm.getThreshold())));
                sheet.addCell((WritableCell)new Label(9, rowNum, String.valueOf(outboundDivertTacticsLogForm.getNextHop())));
                sheet.addCell((WritableCell)new Label(10, rowNum, outboundDivertTacticsLogForm.getLogTimeStr()));
                sheet.addCell((WritableCell)new Label(11, rowNum, outboundDivertTacticsLogForm.getOperator()));
                sheet.addCell((WritableCell)new Label(12, rowNum, outboundDivertTacticsLogForm.getClientIp()));
                sheet.addCell((WritableCell)new Label(13, rowNum, operTypeMap.get(outboundDivertTacticsLogForm.getOperType())));
                sheet.addCell((WritableCell)new Label(14, rowNum, resultsMap.get(outboundDivertTacticsLogForm.getResult())));
                sheet.addCell((WritableCell)new Label(15, rowNum, modeMap.get(outboundDivertTacticsLogForm.getDivertMode())));
                sheet.addCell((WritableCell)new Label(16, rowNum, levelMap.get(outboundDivertTacticsLogForm.getLevel())));
                sheet.addCell((WritableCell)new Label(17, rowNum, outboundDivertTacticsLogForm.getRemark()));
                ++rowNum;
            }
            workBook.write();
            writeFileOut.flush();
        }
        catch (WriteException e) {
            this.logger.error((Object)"exportOutboundDivertLog WriteException ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"exportOutboundDivertLog IOException ", (Throwable)e);
        }
        finally {
            if (null != workBook) {
                try {
                    workBook.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"close workBook Exception", (Throwable)e);
                }
                workBook = null;
            }
            if (null != writeFileOut) {
                try {
                    writeFileOut.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"close writeFileOut Exception", (Throwable)e);
                }
                writeFileOut = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadNameFile() {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        String onlyFileName = this.downFileName;
        this.downFileName = exportFolderPath + File.separator + this.downFileName;
        try {
            if (!AticUtil.checkFileName((String)onlyFileName, (String)"xls")) {
                AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                return;
            }
            if (!AticUtil.checkFilePath((String)exportFolderPath, (String)this.downFileName)) {
                AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                return;
            }
            this.downloadFile(this.getResponse());
        }
        catch (Exception e) {
            AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
        }
        finally {
            AticUtil.deleteTempFile((String)this.downFileName);
        }
    }

    private void downloadFile(HttpServletResponse response) {
        String downloadFileName = "";
        try {
            downloadFileName = new String(this.getDownFileName().getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)"downloadFile", (Throwable)e);
            return;
        }
        response.setContentType("application/x-download");
        response.addHeader("Content-Disposition", "attachment;filename=divertLog.xls");
        response.setCharacterEncoding("windows-1251");
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            this.closeInputStream(fileInput);
            this.closeInputStream(bis);
            this.closeOutputStream(bos);
        }
        catch (IOException e) {
            try {
                this.logger.error((Object)"downloadFile", (Throwable)e);
                throw new LegoSecurityException(206L);
            }
            catch (Throwable throwable) {
                this.closeInputStream(fileInput);
                this.closeInputStream(bis);
                this.closeOutputStream(bos);
                throw throwable;
            }
        }
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"downloadFile", (Throwable)e);
            }
            finally {
                input = null;
            }
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"downloadFile", (Throwable)e);
            }
            finally {
                output = null;
            }
        }
    }

    private boolean createFile(String downloadPath) {
        File file = new File(downloadPath);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    private Map<String, String> createQueryMap() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.sortField && null != this.sortType) {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        } else {
            queryMap.put("sortName", "logTime");
            queryMap.put("sortType", "desc");
        }
        if (null != this.queryBean) {
            String sourceIp;
            queryMap.put("deviceId", null == this.queryBean.getDeviceId() ? null : this.queryBean.getDeviceId().toString());
            String string = sourceIp = this.queryBean.getSourceIp() == null ? null : this.queryBean.getSourceIp();
            if (!AticUtil.isNull((String)sourceIp)) {
                queryMap.put("sourceIp", sourceIp);
            }
            queryMap.put("startTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getStartTime())));
            queryMap.put("endTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getEndTime())));
            queryMap.put("divertMode", this.queryBean.getDivertMode());
            queryMap.put("level", this.queryBean.getLevel());
            queryMap.put("zoneId", null == this.queryBean.getZoneId() ? null : this.queryBean.getZoneId().toString());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private void setZoneNameAndDeviceNameForLog(List<OutboundDivertTacticsLogForm> outboundDivertTacticsLogFormLists) {
        HashMap<Long, String> firewallMap = new HashMap<Long, String>();
        HashMap<Long, String> zoneMap = new HashMap<Long, String>();
        for (OutboundDivertTacticsLogForm outbounddivertTacticsLogForm : outboundDivertTacticsLogFormLists) {
            if (null == outbounddivertTacticsLogForm.getDeviceId() || null == outbounddivertTacticsLogForm.getZoneId()) continue;
            if (firewallMap.containsKey(outbounddivertTacticsLogForm.getDeviceId())) {
                outbounddivertTacticsLogForm.setDeviceName((String)firewallMap.get(outbounddivertTacticsLogForm.getDeviceId()));
            } else {
                AticDevice fireWall = this.aticDeviceService.getDeviceByMoid(outbounddivertTacticsLogForm.getDeviceId().longValue());
                if (null != fireWall) {
                    outbounddivertTacticsLogForm.setDeviceName(fireWall.getName());
                    firewallMap.put(outbounddivertTacticsLogForm.getDeviceId(), fireWall.getName());
                }
            }
            if (zoneMap.containsKey(outbounddivertTacticsLogForm.getZoneId())) {
                outbounddivertTacticsLogForm.setZoneDesc((String)zoneMap.get(outbounddivertTacticsLogForm.getZoneId()));
                continue;
            }
            ZoneInfoForm zoneInfoForms = this.zoneService.getZoneNOIpById(outbounddivertTacticsLogForm.getZoneId());
            if (null == zoneInfoForms) continue;
            outbounddivertTacticsLogForm.setZoneDesc("".equals(zoneInfoForms.getZoneDesc()) ? null : zoneInfoForms.getZoneDesc());
            zoneMap.put(outbounddivertTacticsLogForm.getZoneId(), zoneInfoForms.getZoneDesc());
        }
    }

    private void initDevicesComb() {
        AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByFlowspec(Boolean.valueOf(true));
        if (null == this.firewallList) {
            this.firewallList = new ArrayList<AticDevice>();
        }
        if (null == aticDeviceNfa || aticDeviceNfa.getFlowspec() == null) {
            return;
        }
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(aticDeviceNfa.getMoId());
        this.firewallList.add(aticDevice);
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public void setAticDeviceService(AticDeviceServiceImpl aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") && null == this.queryBean ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    public void setTotal(int total) {
        super.setTotal(total);
        this.getSession().setAttribute("total", (Object)total);
    }

    public String viewDivertLogRemark() {
        this.checkUltraVires(Long.valueOf(this.logId));
        List<OutboundDivertTacticsLogForm> forms = this.outboundDivertTacticsLogService.getOutboundLogsByDivertTacticsLogIdS(this.logId);
        if (null != forms && !forms.isEmpty()) {
            this.divertLogRemark = forms.get(0).getRemark();
            if (this.divertLogRemark.matches("[0-9]+")) {
                this.divertLogRemark = this.getText("lego.err." + forms.get(0).getRemark());
            } else if (this.divertLogRemark.contains(".") && !this.divertLogRemark.contains(":") && !this.divertLogRemark.contains(" ")) {
                this.divertLogRemark = this.getText("atic.bis.divert.tactics.log.remark." + forms.get(0).getRemark());
            }
        }
        return "success";
    }

    private void checkUltraVires(Long id) {
        OutboundDivertTacticsLog outboundDivertTacticsLog = this.outboundDivertTacticsLogService.getLogDetail(id);
        if (null == outboundDivertTacticsLog) {
            throw new LegoCheckedException(570506L);
        }
        Long deviceId = outboundDivertTacticsLog.getDeviceId();
        Long zoneId = outboundDivertTacticsLog.getZoneId();
        Long moId = ZoneBisUtil.getMoidByZoneid((Long)zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(deviceId);
        BisUtil.checkUserSecurity(deviceList);
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public List<OutboundDivertTacticsLogForm> getOutboundDivertTacticsLogFormList() {
        return this.outboundDivertTacticsLogFormList;
    }

    public void setOutboundDivertTacticsLogFormList(List<OutboundDivertTacticsLogForm> outboundDivertTacticsLogFormList) {
        this.outboundDivertTacticsLogFormList = outboundDivertTacticsLogFormList;
    }

    public OutboundDivertTacticsQueryBean getQueryBean() {
        return this.queryBean;
    }

    public void setQueryBean(OutboundDivertTacticsQueryBean queryBean) {
        this.queryBean = queryBean;
    }

    public AticDevice getFirewall() {
        return this.firewall;
    }

    public void setFirewall(AticDevice firewall) {
        this.firewall = firewall;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void setExportStart(Integer exportStart) {
        this.exportStart = exportStart;
    }

    public void setExportEnd(Integer exportEnd) {
        this.exportEnd = exportEnd;
    }

    public String getAllQueryDisplay() {
        return this.allQueryDisplay;
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public List<LangPair> getModeCombData() {
        return this.modeCombData;
    }

    public List<LangPair> getLogLevelCombData() {
        return this.logLevelCombData;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public String getIsQuery() {
        return this.isQuery;
    }

    public void setIsQuery(String isQuery) {
        this.isQuery = isQuery;
    }

    public Integer getExportStart() {
        return this.exportStart;
    }

    public Integer getExportEnd() {
        return this.exportEnd;
    }

    public ZoneInfoForm getZoneInfoForm() {
        return this.zoneInfoForm;
    }

    public void setZoneInfoForm(ZoneInfoForm zoneInfoForm) {
        this.zoneInfoForm = zoneInfoForm;
    }

    public List<ZoneInfoForm> getQueryZoneFormList() {
        return this.queryZoneFormList;
    }

    public void setQueryZoneFormList(List<ZoneInfoForm> queryZoneFormList) {
        this.queryZoneFormList = queryZoneFormList;
    }

    public String getDivertLogRemark() {
        return this.divertLogRemark;
    }

    public void setDivertLogRemark(String divertLogRemark) {
        this.divertLogRemark = divertLogRemark;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public boolean validateIdStr() {
        if (null == this.idStr) {
            return true;
        }
        String[] ids = this.idStr.split(",");
        long idTemp = 0L;
        for (int i = 0; i < ids.length; ++i) {
            try {
                idTemp = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (idTemp > 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateQueryBeanDeviceId() {
        if (null != this.queryBean) {
            if (null == this.queryBean.getDeviceId()) {
                return true;
            }
            if (this.queryBean.getDeviceId() < 0L) {
                return false;
            }
        }
        return true;
    }

    public boolean validateQueryBeanZoneId() {
        if (null != this.queryBean) {
            if (null == this.queryBean.getZoneId()) {
                return true;
            }
            if (this.queryBean.getZoneId() < 0L) {
                return false;
            }
        }
        return true;
    }

    public boolean validateQueryBeanDivertIp() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getSourceIp()) || IPUtil.isIpv4((String)this.queryBean.getSourceIp()) || IPUtil.isIpv6((String)this.queryBean.getSourceIp());
    }

    public boolean validateQueryBeanStartTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getStartTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getStartTime());
    }

    public boolean validateQueryBeanEndTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getEndTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getEndTime());
    }

    public boolean validateQueryBeanZoneDesc() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getZoneDesc() || "".equals(this.queryBean.getZoneDesc().trim())) {
            return true;
        }
        if (this.queryBean.getZoneDesc().length() > 32) {
            return false;
        }
        if (this.queryBean.getZoneDesc().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
        return this.queryBean.getZoneDesc().matches(nameRegex);
    }

    public boolean validateQueryBeanDeviceName() {
        if (null == this.queryBean) {
            return true;
        }
        if (AticUtil.isNullForVpn((String)this.queryBean.getDeviceName())) {
            return true;
        }
        if (this.queryBean.getDeviceName().length() > 32) {
            return false;
        }
        if (this.queryBean.getDeviceName().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return this.queryBean.getDeviceName().matches(nameRegex);
    }
}

