/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.OutboundDivertTactics;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.util.IPUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class OutboundDivertTacticsDao
extends CommonDaoImpl {
    public OutboundDivertTactics get(Long id) {
        String hql = "from OutboundDivertTactics where id = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (OutboundDivertTactics)result.get(0);
    }

    public OutboundDivertTactics getByDeviceId(Long deviceId) {
        String hql = "from OutboundDivertTactics where deviceId = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (OutboundDivertTactics)result.get(0);
    }

    public List<OutboundDivertTactics> getBySourceIp(String sourceIp) {
        String hql = "from OutboundDivertTactics where sourceIp = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, sourceIp);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void remove(Long id) {
        String hql = "delete from OutboundDivertTactics where id = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteAll() {
        String hql = "delete from OutboundDivertTactics";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }

    public List<Long> getDistinctDevIds() {
        String hql = "select distinct deviceId from OutboundDivertTactics";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<Long>();
        }
        return result;
    }

    public List<OutboundDivertTactics> getDivertListByZoneId(Long zoneId) {
        if (zoneId == null) {
            return new ArrayList<OutboundDivertTactics>();
        }
        String hql = "from OutboundDivertTactics where zoneId=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<OutboundDivertTactics>();
    }

    public OutboundDivertTactics getDivertTacticsByZoneIp(Long deviceId, String zoneIp) {
        if (AticUtil.isNull((String)zoneIp) || null == deviceId) {
            return null;
        }
        String hql = "from OutboundDivertTactics where deviceId=? and sourceIp=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        if (IPUtil.isIpv4((String)zoneIp)) {
            param.put(1, zoneIp + "/32");
        } else {
            param.put(1, zoneIp + "/128");
        }
        List result = this.findByHql(hql, param);
        if (null != result && !result.isEmpty()) {
            return (OutboundDivertTactics)result.get(0);
        }
        return null;
    }

    public List<OutboundDivertTactics> queryAll() {
        String hql = "from OutboundDivertTactics";
        List result = this.findByHql(hql);
        if (null == result) {
            return new ArrayList<OutboundDivertTactics>();
        }
        return result;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String divertStatus;
        String divertMode;
        String endTime;
        String startTime;
        String sourceIp;
        String zoneId;
        String deviceId;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from OutboundDivertTactics where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String userId = conditionMap.get("currentUserId");
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        if (!AticUtil.isNull((String)userId) && !AticUtil.isNull((String)isAdmin) && "false".equalsIgnoreCase(isAdmin)) {
            long uid = Long.parseLong(userId);
            String authSql = CheckChildrenMoUtil.getInstanse().getHql(uid);
            hql = hql + " and deviceId in (" + authSql + ")";
        }
        if (!AticUtil.isNull((String)(deviceId = conditionMap.get("deviceId"))) && !"0".equals(deviceId)) {
            hql = hql + " and deviceId = ? ";
            queryMap.put(index++, deviceId.trim());
        }
        if (!AticUtil.isNull((String)(zoneId = conditionMap.get("zoneId")))) {
            hql = hql + " and zoneId = ? ";
            queryMap.put(index++, zoneId.trim());
        }
        if (!AticUtil.isNull((String)(sourceIp = conditionMap.get("sourceIp")))) {
            hql = hql + " and sourceIp = ? ";
            queryMap.put(index++, sourceIp);
        }
        if (!AticUtil.isNull((String)(startTime = conditionMap.get("startTime"))) && !"0".equals(startTime)) {
            hql = hql + " and createTime >= ? ";
            queryMap.put(index++, startTime.trim());
        }
        if (!AticUtil.isNull((String)(endTime = conditionMap.get("endTime"))) && !"0".equals(endTime)) {
            hql = hql + " and createTime <= ? ";
            queryMap.put(index++, endTime.trim());
        }
        if (!AticUtil.isNull((String)(divertMode = conditionMap.get("divertMode")))) {
            hql = hql + " and divertMode = ? ";
            queryMap.put(index++, divertMode.trim());
        }
        if (!AticUtil.isNull((String)(divertStatus = conditionMap.get("divertStatus")))) {
            hql = hql + " and divertStatus = ? ";
            queryMap.put(index++, divertStatus.trim());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public OutboundDivertTactics getDivertTacticsByZoneId(Long zoneId) {
        String hql = "from OutboundDivertTactics where zoneId=?";
        List result = this.findByHql(hql, new Object[]{zoneId});
        if (null != result && !result.isEmpty()) {
            return (OutboundDivertTactics)result.get(0);
        }
        return null;
    }
}

