/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.scheduler;

import com.hs.atic.bis.dao.ConfigBlackholeApiDao;
import com.hs.atic.bis.model.ConfigBlackholeApi;
import com.hs.atic.rmi.IpStateData;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.service.IDivertBlackholeService;
import com.hs.atic.util.AticDiversionUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.BlackholeAlarmHandler;
import com.hs.atic.util.BlackholeDataBuffer;
import com.hs.atic.util.BlackholeWhiteThread;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.model.DefendGroup;
import com.huawei.atic.sdk.bis.service.dao.DefendGroupDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class BlackholeScheduler
extends Thread {
    private static final int RETRY_TIMES = 3;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private String nextHopValue = "NULL 0";
    private boolean start = false;
    private BlackholeAlarmHandler blackholeAlarmHandler;
    private IDivertBlackholeService blackholeService;
    private IAticDeviceService aticDeviceService;
    private ConfigBlackholeApiDao configBlackholeApiDao;
    private DefendGroupDao defendGroupDao;
    private IZoneDeviceService zoneDeviceService;
    private BlackholeWhiteThread blackholeWhiteThread;
    private ISysOptLog sysOptLogService;
    private int blackHoleIpMask = 32;
    private int blackHoleIpv6Mask = 128;

    @Override
    public void run() {
        this.initBlackHoleIpMask();
        while (this.start) {
            try {
                this.checkAndNotify();
            }
            catch (Exception e1) {
                this.logger.error((Object)e1);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"sleep get error.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBlackHoleIpMask() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = AticUtil.class.getResourceAsStream("/datetable.properties");
            properties.load(inputStream);
            this.blackHoleIpMask = Integer.parseInt(properties.getProperty("BlackHoleIPMask"));
            this.blackHoleIpv6Mask = Integer.parseInt(properties.getProperty("BlackHoleIPV6Mask"));
        }
        catch (IOException e) {
            this.logger.error((Object)("load blackHoleIpMask error, " + e));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("load blackHoleIpMask error, " + e));
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)("static mode is error " + e));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkAndNotify() {
        List<IpStateData> list = BlackholeDataBuffer.getInstance().getIpStateData();
        if (!list.isEmpty()) {
            this.logger.info((Object)("BlackholeDataBuffer.getInstance().getIpStateData(), size=" + list.size()));
        }
        List<ConfigBlackholeApi> blackholeApiList = null;
        list = this.dealWithMask(list);
        for (IpStateData data : list) {
            String vpnName;
            ZoneDeviceForm zoneDeviceForm;
            DivertBlackholeForm divertBlackholeForm;
            Object device;
            List<Object> deviceList;
            Object maskStr;
            this.logger.info((Object)("Blackhole IpStateData = " + data));
            String zoneIp = data.getZoneIp();
            ArrayList<DivertBlackholeForm> listForms = new ArrayList<DivertBlackholeForm>();
            if (data.getPolicy() == 6) {
                int mask = IPUtil.isIpv4((String)zoneIp) ? this.blackHoleIpMask : this.blackHoleIpv6Mask;
                maskStr = String.valueOf(mask);
                deviceList = new ArrayList();
                if (data.isFromCleanDevice()) {
                    device = this.aticDeviceService.getDeviceByIp(data.getDeviceIp());
                    if (device != null) {
                        deviceList.add(device);
                    }
                } else {
                    deviceList = this.getCleanDevices(data.getDeviceIp());
                }
                if (deviceList.isEmpty()) {
                    this.logger.error((Object)("dynamic blackhole cannot find clean device, deviceIp=" + data.getDeviceIp()));
                } else {
                    for (AticDevice aticDevice : deviceList) {
                        if (0 != aticDevice.getDdosType() || aticDevice.getDeviceModel().contains("AntiDDoS16")) continue;
                        divertBlackholeForm = new DivertBlackholeForm();
                        divertBlackholeForm.setMode(1);
                        divertBlackholeForm.setBlackholeMode(2);
                        divertBlackholeForm.setServiceProvider("--");
                        divertBlackholeForm.setDeviceIP(aticDevice.getIpAddress());
                        divertBlackholeForm.setDeviceId(aticDevice.getMoId());
                        divertBlackholeForm.setDeviceName(aticDevice.getName());
                        divertBlackholeForm.setBlackIP(zoneIp);
                        divertBlackholeForm.setBlackMask((String)maskStr);
                        divertBlackholeForm.setZoneId(data.getZoneId());
                        zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(Long.valueOf(data.getZoneId()), Long.valueOf(aticDevice.getMoId()));
                        vpnName = "--";
                        if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                            vpnName = zoneDeviceForm.getVpnName();
                        }
                        divertBlackholeForm.setVpn(vpnName);
                        listForms.add(divertBlackholeForm);
                    }
                }
            } else if (data.getPolicy() == 3) {
                int mask = IPUtil.isIpv4((String)zoneIp) ? this.blackHoleIpMask : this.blackHoleIpv6Mask;
                maskStr = String.valueOf(mask);
                deviceList = new ArrayList();
                if (data.isFromCleanDevice()) {
                    device = this.aticDeviceService.getDeviceByIp(data.getDeviceIp());
                    if (device != null) {
                        deviceList.add(device);
                    }
                } else {
                    deviceList = this.getCleanDevices(data.getDeviceIp());
                }
                if (deviceList.isEmpty()) {
                    this.logger.error((Object)("dynamic blackhole cannot find clean device, deviceIp=" + data.getDeviceIp()));
                } else {
                    for (AticDevice aticDevice : deviceList) {
                        divertBlackholeForm = new DivertBlackholeForm();
                        divertBlackholeForm.setMode(1);
                        divertBlackholeForm.setBlackholeMode(0);
                        divertBlackholeForm.setServiceProvider("--");
                        divertBlackholeForm.setDeviceIP(aticDevice.getIpAddress());
                        divertBlackholeForm.setDeviceId(aticDevice.getMoId());
                        divertBlackholeForm.setDeviceName(aticDevice.getName());
                        divertBlackholeForm.setBlackIP(zoneIp);
                        divertBlackholeForm.setBlackMask((String)maskStr);
                        divertBlackholeForm.setNexthopIP(this.nextHopValue);
                        divertBlackholeForm.setZoneId(data.getZoneId());
                        zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(Long.valueOf(data.getZoneId()), Long.valueOf(aticDevice.getMoId()));
                        vpnName = "--";
                        if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                            vpnName = zoneDeviceForm.getVpnName();
                        }
                        divertBlackholeForm.setVpn(vpnName);
                        listForms.add(divertBlackholeForm);
                    }
                }
            } else {
                String mask;
                String string = mask = IPUtil.isIpv4((String)zoneIp) ? "32" : "128";
                if (blackholeApiList == null) {
                    blackholeApiList = this.configBlackholeApiDao.getAllEnable();
                }
                if (blackholeApiList.isEmpty()) {
                    this.logger.warn((Object)"Can not find any enabled API and break.");
                    break;
                }
                this.logger.info((Object)("Enabled API size=" + blackholeApiList.size()));
                for (ConfigBlackholeApi api : blackholeApiList) {
                    DivertBlackholeForm divertBlackholeForm2 = new DivertBlackholeForm();
                    divertBlackholeForm2.setMode(1);
                    divertBlackholeForm2.setBlackholeMode(1);
                    divertBlackholeForm2.setServiceProvider(api.getServiceProvider());
                    divertBlackholeForm2.setDeviceIP("--");
                    divertBlackholeForm2.setDeviceId(null);
                    divertBlackholeForm2.setDeviceName("--");
                    divertBlackholeForm2.setBlackIP(zoneIp);
                    divertBlackholeForm2.setBlackMask(mask);
                    divertBlackholeForm2.setZoneId(data.getZoneId());
                    listForms.add(divertBlackholeForm2);
                }
            }
            for (DivertBlackholeForm form : listForms) {
                this.logger.info((Object)AticUtil.getcleanedMessage((String)("divertBlackholeForm info: blackIp=" + form.getBlackIP() + ", blackMask=" + form.getBlackMask() + ", deviceIp=" + form.getDeviceIP() + ", nextHopIp=" + form.getNexthopIP() + ", serviceProvider=" + form.getServiceProvider())));
                if (this.isExistBWhiteTime(form)) {
                    this.logger.info((Object)("this blackhole is in blackholeWhiteTime, blackHoleIp is :" + form.getBlackIP()));
                    continue;
                }
                DivertBlackholeForm blackholeFormInDB = null;
                try {
                    if (2 == form.getBlackholeMode()) {
                        form.setEnableTime(System.currentTimeMillis());
                    }
                    if (null == (blackholeFormInDB = this.blackholeService.createDivertBlackhole(form)).getDeviceId()) {
                        blackholeFormInDB.setDeviceIP("--");
                        blackholeFormInDB.setDeviceId(null);
                        blackholeFormInDB.setDeviceName("--");
                    } else {
                        try {
                            Long deviceId = blackholeFormInDB.getDeviceId();
                            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                            blackholeFormInDB.setDeviceName(aticDevice.getName());
                            blackholeFormInDB.setDeviceIP(aticDevice.getIpAddress());
                        }
                        catch (Exception e) {
                            this.logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    this.logger.info((Object)"alarm contain blackhole, start to send blackhole ip");
                    this.addOperaLog(0L, blackholeFormInDB, "create");
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("createDivertBlackhole error, BlackholeMode=" + form.getBlackholeMode() + ", blackIp=" + form.getBlackIP() + ", deviceName=" + form.getDeviceName() + ", serviceProvider=" + form.getServiceProvider()));
                    if (571810L != e.getErrorCode()) {
                        this.addOperaLog(e.getErrorCode(), form, "create");
                    }
                }
                catch (Exception e1) {
                    this.logger.error((Object)e1);
                }
                if (blackholeFormInDB == null) continue;
                boolean canDeploy = true;
                boolean bl = false;
                while (canDeploy) {
                    void var11_21;
                    this.logger.info((Object)("DeployTimes = " + (int)(++var11_21)));
                    canDeploy = false;
                    try {
                        blackholeFormInDB.setFlowTrigger(true);
                        blackholeFormInDB = this.blackholeService.startDivertBlackhole(blackholeFormInDB);
                        this.addOperaLog(0L, blackholeFormInDB, "start");
                        this.sendBlackholeAlarm(blackholeFormInDB, true);
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)("startDivertBlackhole error, blackIp=" + form.getBlackIP() + ", deviceName=" + form.getDeviceName() + ", serviceProvider=" + form.getServiceProvider()));
                        this.addOperaLog(e.getErrorCode(), blackholeFormInDB, "start");
                        if (var11_21 >= 3) {
                            this.sendBlackholeAlarm(blackholeFormInDB, false);
                            continue;
                        }
                        canDeploy = true;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error((Object)("Failed to deploy and need retry, Failed times = " + (int)var11_21));
                        }
                        this.logger.info((Object)("Failed to deploy and need retry, Failed times = " + (int)var11_21));
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                        this.addOperaLog(1L, blackholeFormInDB, "start");
                        if (var11_21 >= 3) {
                            this.sendBlackholeAlarm(blackholeFormInDB, false);
                            continue;
                        }
                        canDeploy = true;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error((Object)("Failed to deploy and need retry, Failed times = " + (int)var11_21));
                        }
                        this.logger.info((Object)("Failed to deploy and need retry, Failed times = " + (int)var11_21));
                    }
                }
            }
        }
    }

    private boolean isExistBWhiteTime(DivertBlackholeForm divertBlackholeForm) {
        if ((0 == divertBlackholeForm.getBlackholeMode() || 2 == divertBlackholeForm.getBlackholeMode()) && (divertBlackholeForm.getBlackMask().equals("32") || divertBlackholeForm.getBlackMask().equals("128"))) {
            return this.blackholeWhiteThread.isExistWhiteTimeList(divertBlackholeForm.getBlackIP());
        }
        return false;
    }

    private List<IpStateData> dealWithMask(List<IpStateData> list) {
        if (32 != this.blackHoleIpMask || 128 != this.blackHoleIpv6Mask) {
            String[] ipRange = null;
            for (int i = list.size(); i > 0; --i) {
                IpStateData blackHole = list.get(i - 1);
                if (blackHole.getPolicy() != 3) continue;
                String zoneIp = blackHole.getZoneIp();
                try {
                    ipRange = IPUtil.isIpv4((String)zoneIp) ? IPUtil.getSubnetRange((String)zoneIp, (int)this.blackHoleIpMask) : IPUtil.getSubnetRange((String)zoneIp, (int)this.blackHoleIpv6Mask);
                    blackHole.setZoneIp(ipRange[0]);
                }
                catch (Exception e) {
                    this.logger.error((Object)("catch Exception :" + e));
                    continue;
                }
                boolean isHave = false;
                for (int j = 0; j < i - 1; ++j) {
                    IpStateData tempJ = list.get(j);
                    if (tempJ.getPolicy() != 3) continue;
                    try {
                        if (!IPUtil.isInIpRange((String[])ipRange, (String)tempJ.getZoneIp())) continue;
                        isHave = true;
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("IPUtil.isInIpRange catch Exception : " + e));
                    }
                }
                if (!isHave) continue;
                list.remove(i - 1);
            }
        }
        return list;
    }

    private List<AticDevice> getCleanDevices(String deviceIp) {
        List<Object> deviceList = new ArrayList<AticDevice>();
        AticDevice deviceSrc = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == deviceSrc) {
            this.logger.info((Object)("can not find this detect device. deivceIp=" + deviceIp));
            return deviceList;
        }
        boolean isInclude = false;
        List defendGroupList = this.defendGroupDao.getAll();
        for (DefendGroup defendGroup : defendGroupList) {
            if (!defendGroup.getFirewallIds().contains(deviceSrc.getMoId())) continue;
            isInclude = true;
            for (Long deviceId : defendGroup.getFirewallIds()) {
                AticDevice deviceTemp = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                if (0 != deviceTemp.getDdosType() && 2 != deviceTemp.getDdosType()) continue;
                deviceList.add(deviceTemp);
            }
        }
        if (!isInclude) {
            this.logger.info((Object)("device " + deviceIp + " belong to default defend group."));
            List cleanDevices = this.aticDeviceService.getCleanDevice();
            block2: for (int i = cleanDevices.size() - 1; i >= 0; --i) {
                AticDevice cleanDevice = (AticDevice)cleanDevices.get(i);
                for (DefendGroup defendGroup : defendGroupList) {
                    if (!defendGroup.getFirewallIds().contains(cleanDevice.getMoId())) continue;
                    cleanDevices.remove(i);
                    continue block2;
                }
            }
            deviceList = cleanDevices;
        }
        this.logger.info((Object)("the last clean firewallList is " + AticUtil.getcleanedMessage((String)deviceList.toString())));
        return deviceList;
    }

    private void sendBlackholeAlarm(DivertBlackholeForm blackholeForm, boolean isSuccess) {
        if (isSuccess) {
            String zoneName = AticDiversionUtil.getZoneInfoByIpMask(blackholeForm.getBlackIP(), Integer.parseInt(blackholeForm.getBlackMask()));
            if (2 == blackholeForm.getBlackholeMode()) {
                this.blackholeAlarmHandler.blackholeAlarmBoardReport(blackholeForm.getDeviceName(), blackholeForm.getBlackIP() + '/' + blackholeForm.getBlackMask(), blackholeForm.getDeviceIP(), blackholeForm.getDeviceId());
            } else if (1 == blackholeForm.getBlackholeMode()) {
                this.blackholeAlarmHandler.blackholeAPIAlarmBoardReport(blackholeForm.getDeviceName(), blackholeForm.getBlackIP() + '/' + blackholeForm.getBlackMask(), blackholeForm.getDeviceIP(), blackholeForm.getDeviceId());
            } else {
                this.blackholeAlarmHandler.blackholeAlarmReport(zoneName, blackholeForm.getDeviceName(), blackholeForm.getBlackIP() + '/' + blackholeForm.getBlackMask(), blackholeForm.getVpn(), blackholeForm.getDeviceIP(), blackholeForm.getDeviceId());
            }
        } else {
            String zoneName = AticDiversionUtil.getZoneInfoByIpMask(blackholeForm.getBlackIP(), Integer.parseInt(blackholeForm.getBlackMask()));
            if (2 == blackholeForm.getBlackholeMode()) {
                this.blackholeAlarmHandler.blackholeAlarmBoardReportFailed(blackholeForm.getDeviceName(), blackholeForm.getBlackIP() + '/' + blackholeForm.getBlackMask(), blackholeForm.getDeviceIP(), blackholeForm.getDeviceId());
            } else if (1 == blackholeForm.getBlackholeMode()) {
                this.blackholeAlarmHandler.blackholeAPIAlarmBoardReportFailed(blackholeForm.getDeviceName(), blackholeForm.getBlackIP() + '/' + blackholeForm.getBlackMask(), blackholeForm.getDeviceIP(), blackholeForm.getDeviceId());
            } else {
                this.blackholeAlarmHandler.blackholeAlarmReportFailed(zoneName, blackholeForm.getDeviceName(), blackholeForm.getBlackIP() + '/' + blackholeForm.getBlackMask(), blackholeForm.getVpn(), blackholeForm.getDeviceIP(), blackholeForm.getDeviceId());
            }
        }
    }

    private void addOperaLog(long errorcode, DivertBlackholeForm returnForm, String operation) {
        String[] paraDetail;
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        if ("create".equals(operation) && "--".equals(returnForm.getDeviceIP())) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.create.api");
        }
        if ("create".equals(operation) && !"--".equals(returnForm.getDeviceIP())) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.create");
        }
        if ("create".equals(operation) && 2 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.board.create");
        }
        if ("start".equals(operation) && "--".equals(returnForm.getDeviceIP())) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.enable.api");
        }
        if ("start".equals(operation) && !"--".equals(returnForm.getDeviceIP())) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.enable");
        }
        if ("start".equals(operation) && 2 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.board.enable");
        }
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        if (errorcode == 0L) {
            sysOptLogLego.setResult(1);
            if (1 == returnForm.getBlackholeMode()) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.dynamic.api.success");
                String isp = "atic.bis.blackhole.api.sp.ctcc";
                if ("CTCC".equals(returnForm.getServiceProvider())) {
                    isp = "atic.bis.blackhole.api.sp.ctcc";
                }
                String[] paraDetail2 = new String[]{returnForm.getBlackIP(), returnForm.getBlackMask(), isp, returnForm.getVpn()};
                sysOptLogLego.setDetailPara(paraDetail2);
            } else {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.dynamic.success");
                paraDetail = new String[]{returnForm.getBlackIP(), returnForm.getBlackMask(), returnForm.getDeviceIP(), returnForm.getVpn()};
                sysOptLogLego.setDetailPara(paraDetail);
            }
        } else {
            sysOptLogLego.setResult(0);
            if (errorcode == 571801L || errorcode == 571804L || errorcode == 571810L || errorcode == 571818L || errorcode == 571813L) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail." + errorcode);
            } else if (571817L == errorcode) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail." + errorcode);
            } else if (514L == errorcode || 517L == errorcode) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail.517");
            } else {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail.other");
            }
            paraDetail = new String[]{returnForm.getBlackIP(), returnForm.getBlackMask(), returnForm.getDeviceIP(), returnForm.getVpn()};
            sysOptLogLego.setDetailPara(paraDetail);
        }
        sysOptLogLego.setTarget(returnForm.getBlackIP());
        sysOptLogLego.setTargetLocal(Boolean.valueOf(false));
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != this.sysOptLogService) {
            this.sysOptLogService.writeOptLog(sysOptLogLego);
        }
    }

    public DefendGroupDao getDefendGroupDao() {
        return this.defendGroupDao;
    }

    public void setDefendGroupDao(DefendGroupDao defendGroupDao) {
        this.defendGroupDao = defendGroupDao;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean isStart) {
        this.start = isStart;
    }

    public IDivertBlackholeService getBlackholeService() {
        return this.blackholeService;
    }

    public void setBlackholeService(IDivertBlackholeService blackholeService) {
        this.blackholeService = blackholeService;
    }

    public BlackholeAlarmHandler getBlackholeAlarmHandler() {
        return this.blackholeAlarmHandler;
    }

    public void setBlackholeAlarmHandler(BlackholeAlarmHandler blackholeAlarmHandler) {
        this.blackholeAlarmHandler = blackholeAlarmHandler;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ConfigBlackholeApiDao getConfigBlackholeApiDao() {
        return this.configBlackholeApiDao;
    }

    public void setConfigBlackholeApiDao(ConfigBlackholeApiDao configBlackholeApiDao) {
        this.configBlackholeApiDao = configBlackholeApiDao;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setSysOptLogService(ISysOptLog sysOptLogService) {
        this.sysOptLogService = sysOptLogService;
    }

    public BlackholeWhiteThread getBlackholeWhiteThread() {
        return this.blackholeWhiteThread;
    }

    public void setBlackholeWhiteThread(BlackholeWhiteThread blackholeWhiteThread) {
        this.blackholeWhiteThread = blackholeWhiteThread;
    }
}

