/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.scheduler;

import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.service.IBlackholeNpService;
import com.hs.atic.util.IpStateDataBuffer;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.List;

public class BlackholeTransformThread
extends Thread {
    private static final long SLEEP_TIME = 10L;
    private boolean start = false;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private IBlackholeNpService blackholeNpService;

    @Override
    public void run() {
        this.logger.info((Object)"blackhole np alarm thread start");
        while (this.start) {
            try {
                IpStateDataBuffer ipStateDataBuffer = IpStateDataBuffer.getInstance();
                List<BlackholeNpForm> blackholeNpFormList = ipStateDataBuffer.getBlackholeNpFormList();
                for (BlackholeNpForm blackholeNp : blackholeNpFormList) {
                    this.blackholeNpService.startDivertBlackholeNp(blackholeNp);
                    this.logger.info((Object)("BlackholeTransformThread BlackholeNpForm [npIp=" + blackholeNp.getNpIp() + ", timeLong=" + blackholeNp.getTimeLong() + ", blackholeThreshold=" + blackholeNp.getBlackholeThreshold() + ", deviceIp=" + blackholeNp.getDeviceIp() + "]"));
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)("Blackhole np thread.sleep error." + e1));
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("blackhole np alarm data error." + e));
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)("Blackhole np thread.sleep error." + e1));
                }
            }
        }
    }

    public IBlackholeNpService getBlackholeNpService() {
        return this.blackholeNpService;
    }

    public void setBlackholeNpService(IBlackholeNpService blackholeNpService) {
        this.blackholeNpService = blackholeNpService;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

