/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.scheduler;

import com.hs.atic.bis.dao.DivertTacticsDao;
import com.hs.atic.bis.dao.DivertTacticsLogDao;
import com.hs.atic.bis.dao.FaultSeverityRuleDao;
import com.hs.atic.bis.dao.OutboundDivertTacticsDao;
import com.hs.atic.bis.dao.OutboundDivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.bis.model.DivertTask;
import com.hs.atic.bis.model.OutboundDivertTactics;
import com.hs.atic.bis.service.DeviceAtom;
import com.hs.atic.bis.util.BisDivertUtil;
import com.hs.atic.rmi.IpStateData;
import com.hs.atic.sdk.bis.form.CloudCleanForm;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.service.IDateTableFileService;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.atic.util.DivertByRestThread;
import com.hs.atic.util.DivertData;
import com.hs.atic.util.DivertOutboundThread;
import com.hs.atic.util.DivertOutboundThreadPool;
import com.hs.atic.util.DivertRetryDataMangement;
import com.hs.atic.util.DivertThread;
import com.hs.atic.util.DivertThreadPool;
import com.hs.atic.util.IpStateDataBuffer;
import com.hs.atic.util.OutboundDivertData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.diversion.third.service.ICloudCleanForDiversionService;
import com.huawei.atic.sdk.bis.model.DefendGroup;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.sdk.bis.service.dao.DefendGroupDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.ddos.restful.util.DdosRestThreadPool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IpStateScheduler
extends Thread {
    public static final int DIVERT_TASK_DISABLED = 0;
    public static final int DIVERT_TASK_ENABLED = 1;
    public static final int MASK_24 = 24;
    public static final int MASK_32 = 32;
    public static final int MASK_128 = 128;
    private static final int RETRAY_DIVERT_NUM = 2;
    private static final int BATCH_DIVERT_SIZE = 40;
    private static final long SYNC_DEVICE_TIME = 1000L;
    private static long lastSynDbTime = System.currentTimeMillis();
    private static boolean cancelDivertByDetect = false;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private int linkageDivertIpMask = 24;
    private int userDefineDivertIpMask = 32;
    private int userDefineDivertIpv6Mask = 128;
    private boolean isOpenKIO = false;
    private boolean isLinkageWhenCloudClean = false;
    private IAticDeviceService aticDeviceService;
    private IZoneMgrNorthSerice zoneMgrNorthSerice;
    private DivertTacticsDao divertTacticsDao;
    private OutboundDivertTacticsDao outboundDivertTacticsDao;
    private IZoneService zoneService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private DefendGroupDao defendGroupDao;
    private DivertTacticsLogDao divertTacticsLogDao;
    private OutboundDivertTacticsLogDao outboundDivertTacticsLogDao;
    private IDivertTacticsService divertTacticsService;
    private IDefendGroupService defendGroupService;
    private IDateTableFileService dateTableFileService;
    private IOutboundDivertTacticsService outboundDivertTacticsService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private FaultSeverityRuleDao faultSeverityRuleDao;
    private Map<String, Set<DeviceAtom>> abnormalIpStateMap = new HashMap<String, Set<DeviceAtom>>();
    private Map<String, Set<DeviceAtom>> abnormalIpOutboundStateMap = new HashMap<String, Set<DeviceAtom>>();
    private Map<String, Map<Integer, List<DivertTask>>> deviceDivertTaskMap = new HashMap<String, Map<Integer, List<DivertTask>>>();
    private Map<String, List<DivertTask>> deviceOutboundDivertTaskMap = new HashMap<String, List<DivertTask>>();
    private List<AticDevice> groupDevices = new ArrayList<AticDevice>();
    private Map<String, AticDevice> allDeviceMap = new HashMap<String, AticDevice>();
    private boolean start = false;

    @Override
    public void run() {
        this.initDivertIpMask();
        while (this.start) {
            try {
                List<IpStateData> ipStateDataList = IpStateDataBuffer.getInstance().getIpStateData();
                if (!ipStateDataList.isEmpty() || !this.checkDeviceDivertTaskMapEmpty()) {
                    this.logger.info((Object)("start to divert, ipStateDataList.size=" + ipStateDataList.size()));
                    this.synThreadPoolDevice();
                    this.checkIpBufferToDiverTaskMap(ipStateDataList);
                    this.checkAndPutToDivertThread();
                    this.checkAndPutToOutboundDivertThread();
                }
                this.checkRetryDataToDivertThread();
            }
            catch (Exception e) {
                this.logger.error((Object)"IpStateScheduler running error.", (Throwable)e);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"sleep get error.", (Throwable)e);
            }
        }
    }

    private boolean checkDeviceDivertTaskMapEmpty() {
        for (Map.Entry<String, Map<Integer, List<DivertTask>>> devMapEntry : this.deviceDivertTaskMap.entrySet()) {
            Map<Integer, List<DivertTask>> actionMap = devMapEntry.getValue();
            if (null == actionMap || actionMap.isEmpty()) continue;
            for (Map.Entry<Integer, List<DivertTask>> actionEntry : actionMap.entrySet()) {
                List<DivertTask> taskList = actionEntry.getValue();
                if (taskList == null || taskList.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private void checkRetryDataToDivertThread() {
        Map<String, Map<Integer, List<DivertData>>> tempDevMap = DivertRetryDataMangement.getRetryDivertData();
        if (null == tempDevMap || tempDevMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<Integer, List<DivertData>>> devActionEntry : tempDevMap.entrySet()) {
            String deviceIp = devActionEntry.getKey();
            Map<Integer, List<DivertData>> devActionMap = devActionEntry.getValue();
            if (devActionMap.isEmpty()) continue;
            for (Map.Entry<Integer, List<DivertData>> entry : devActionMap.entrySet()) {
                List<DivertData> divertDataList = entry.getValue();
                if (null == divertDataList || divertDataList.isEmpty()) continue;
                int action = entry.getKey();
                AticDevice device = this.allDeviceMap.get(deviceIp);
                if (null != device) {
                    this.dealRetryDivertToThread(device, divertDataList, action);
                }
                divertDataList.clear();
            }
        }
    }

    private void dealRetryDivertToThread(AticDevice device, List<DivertData> divertDataList, int action) {
        block2: {
            int size;
            boolean submitResult;
            String deviceIp;
            block1: {
                deviceIp = device.getIpAddress();
                submitResult = false;
                size = divertDataList.size();
                if (size > 40) break block1;
                submitResult = this.submitDivertThreadToPool(device, action, divertDataList);
                if (submitResult) break block2;
                this.logger.info((Object)("submit retry divert thread error, " + divertDataList.size() + " diverts save to DivertRetryDataMangement next process of " + deviceIp + " action " + action));
                DivertRetryDataMangement.addRetryDivertDataList(deviceIp, divertDataList, action);
                break block2;
            }
            int index = 0;
            index = 0 == size % 40 ? size / 40 : size / 40 + 1;
            for (int i = 0; i < index; ++i) {
                int endIndex = i == index - 1 ? size : (i + 1) * 40;
                submitResult = this.submitDivertThreadToPool(device, action, divertDataList.subList(i * 40, endIndex));
                if (submitResult) continue;
                this.logger.info((Object)("submit retry divert thread error, " + divertDataList.size() + " diverts save to DivertRetryDataMangement next process of " + deviceIp + " action " + action));
                DivertRetryDataMangement.addRetryDivertDataList(deviceIp, divertDataList.subList(i * 40, size), action);
                break;
            }
        }
    }

    private void initDivertIpMask() {
        this.userDefineDivertIpMask = this.dateTableFileService.getDivertIpMask();
        this.userDefineDivertIpv6Mask = this.dateTableFileService.getDivertIpv6Mask();
        this.linkageDivertIpMask = this.dateTableFileService.getLinkageDivertIpMask();
        boolean cancelDivertByDetectValue = this.dateTableFileService.isCancelDivertByDetect();
        this.setCancelDivertByDetectValue(cancelDivertByDetectValue);
        this.isOpenKIO = this.dateTableFileService.isOpenKIO();
        this.isLinkageWhenCloudClean = this.dateTableFileService.isLinkageWhenCloudClean();
    }

    private void checkAndPutToOutboundDivertThread() {
        for (Map.Entry<String, List<DivertTask>> entry : this.deviceOutboundDivertTaskMap.entrySet()) {
            List<DivertTask> divertTaskList = entry.getValue();
            if (null == divertTaskList || divertTaskList.isEmpty()) continue;
            divertTaskList = this.dealwithMask(divertTaskList);
            AticDevice device = DivertOutboundThreadPool.get(entry.getKey()).getDevice();
            this.dealOutboundDivertTaskToThread(device, divertTaskList);
            divertTaskList.clear();
        }
    }

    private void checkAndPutToDivertThread() {
        Iterator<Map.Entry<String, Map<Integer, List<DivertTask>>>> iterator = this.deviceDivertTaskMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<Integer, List<DivertTask>>> devEntry = iterator.next();
            String deviceIp = devEntry.getKey();
            Map<Integer, List<DivertTask>> devActionMap = devEntry.getValue();
            if (devActionMap == null || devActionMap.isEmpty()) continue;
            AticDevice device = this.allDeviceMap.get(deviceIp);
            if (null == device) {
                this.logger.error((Object)("remove device divert task for device is removed, deviceIp=" + deviceIp));
                iterator.remove();
                continue;
            }
            Iterator<Map.Entry<Integer, List<DivertTask>>> it = devActionMap.entrySet().iterator();
            while (it.hasNext()) {
                boolean submitResult;
                Map.Entry<Integer, List<DivertTask>> entry = it.next();
                List<DivertTask> divertTaskList = entry.getValue();
                if (null == divertTaskList || divertTaskList.isEmpty()) continue;
                int action = entry.getKey();
                if (1 == action) {
                    divertTaskList = this.dealwithMask(divertTaskList);
                }
                if (!(submitResult = this.dealDivertTaskToThread(device, divertTaskList, action))) continue;
                it.remove();
            }
        }
    }

    private List<DivertTask> dealwithMask(List<DivertTask> divertTaskList) {
        for (int i = divertTaskList.size(); i > 0; --i) {
            DivertTask divert = divertTaskList.get(i - 1);
            String zoneIp = divert.getZoneIp();
            String[] ipRange = null;
            try {
                ipRange = IPUtil.isIpv4((String)zoneIp) ? (divert.getPolicy() == 2 && this.isOpenKIO ? IPUtil.getSubnetRange((String)zoneIp, (int)this.linkageDivertIpMask) : IPUtil.getSubnetRange((String)zoneIp, (int)this.userDefineDivertIpMask)) : IPUtil.getSubnetRange((String)zoneIp, (int)this.userDefineDivertIpv6Mask);
                divert.setZoneIp(ipRange[0]);
            }
            catch (Exception e) {
                this.logger.error((Object)("catch Exception :" + e));
                continue;
            }
            boolean isHave = false;
            for (int j = 0; j < i - 1; ++j) {
                DivertTask divertJ = divertTaskList.get(j);
                if (divertJ.getPolicy() == 9) continue;
                try {
                    if (!IPUtil.isInIpRange((String[])ipRange, (String)divertJ.getZoneIp())) continue;
                    isHave = true;
                    break;
                }
                catch (Exception e) {
                    this.logger.error((Object)("IPUtil.isInIpRange catch Exception : " + e));
                }
            }
            if (!isHave) continue;
            divertTaskList.remove(i - 1);
        }
        return divertTaskList;
    }

    private boolean dealDivertTaskToThread(AticDevice device, List<DivertTask> divertTaskList, Integer action) {
        ArrayList<DivertData> divertDataList = new ArrayList<DivertData>();
        int index = 1;
        int size = divertTaskList.size();
        boolean submitResult = true;
        for (int i = 0; i < size; ++i) {
            DivertTask divert = divertTaskList.get(i);
            DivertTactics divertTactics = this.composeDevDivert(device.getMoId(), divert);
            if (!this.isOpenKIO) {
                this.logger.info((Object)"isOpenKIO is false .");
            }
            if (2 == divert.getPolicy() && this.isOpenKIO) {
                this.logger.info((Object)"isOpenKIO is true .");
                this.deleteGroupDeviceDivert(divertTactics);
            }
            DivertData divertData = new DivertData(divertTactics, divert.getPolicy(), 2);
            divertDataList.add(divertData);
            if (0 == index % 40 || size == index) {
                submitResult = this.submitDivertThreadToPool(device, action, divertDataList);
                divertDataList.clear();
                if (!submitResult) break;
            }
            ++index;
        }
        if (!submitResult) {
            int endIndex = (index - 1) / 40 * 40;
            divertTaskList.subList(0, endIndex).clear();
            this.logger.info((Object)("submit thread error, " + divertTaskList.size() + " diverts save to next process of " + device.getIpAddress() + " action " + action));
        } else {
            divertTaskList.clear();
        }
        return submitResult;
    }

    private boolean submitDivertThreadToPool(AticDevice device, Integer action, List<DivertData> divertDataList) {
        boolean result = false;
        String deviceIp = device.getIpAddress();
        if (device.getRestfulEnable() != null && device.getRestfulEnable().booleanValue()) {
            DivertByRestThread restDivertThread = new DivertByRestThread(device, this.divertTacticsLogDao, this.divertTacticsDao, this.divertTacticsService, action);
            restDivertThread.addDivertData(divertDataList);
            result = DdosRestThreadPool.addThreadToPool((String)deviceIp, (Runnable)restDivertThread);
            if (result) {
                this.logger.info((Object)("submit a restful divert thread to threadPoolExecutor, name=" + restDivertThread.getName() + ", divert data size=" + divertDataList.size()));
            }
        } else {
            DivertThread divertThread = new DivertThread(device, this.divertTacticsLogDao, this.divertTacticsDao, this.divertTacticsService, this.zoneMgrNorthSerice, action);
            divertThread.addDivertData(divertDataList);
            result = DivertThreadPool.addThreadToPool(deviceIp, divertThread);
            if (result) {
                this.logger.info((Object)("submit a telnet divert thread to threadPoolExecutor, name=" + divertThread.getName() + ", divert data size=" + divertDataList.size()));
            }
        }
        return result;
    }

    private void dealOutboundDivertTaskToThread(AticDevice device, List<DivertTask> divertTaskList) {
        ArrayList<OutboundDivertData> divertDataList = new ArrayList<OutboundDivertData>();
        for (DivertTask divert : divertTaskList) {
            OutboundDivertTactics divertTactics = this.composeDevOutboundDivert(device.getMoId(), divert);
            OutboundDivertData divertData = new OutboundDivertData(divertTactics, divert.getPolicy(), 2);
            divertDataList.add(divertData);
        }
        DivertOutboundThreadPool.get(device.getIpAddress()).addDivertData(divertDataList);
    }

    private void synThreadPoolDevice() {
        long currTime = System.currentTimeMillis();
        if (currTime - lastSynDbTime > 1000L) {
            this.synAllDevices();
            this.synOutboundThreadPoolWithDB();
            lastSynDbTime = currTime;
        }
    }

    private void synAllDevices() {
        try {
            this.allDeviceMap.clear();
            List allDeviceList = this.aticDeviceService.getAllDevice();
            if (null != allDeviceList) {
                for (AticDevice device : allDeviceList) {
                    this.allDeviceMap.put(device.getIpAddress(), device);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("synAllDevices error. " + e.getMessage()));
        }
    }

    private void synOutboundThreadPoolWithDB() {
        try {
            Set<String> divertDeviceIpSet = DivertOutboundThreadPool.getAllDivertDeviceIp();
            for (String deviceIp : divertDeviceIpSet) {
                if (this.allDeviceMap.containsKey(deviceIp)) continue;
                DivertOutboundThreadPool.remove(deviceIp);
                this.logger.info((Object)("remove " + deviceIp + " from DivertOutboundThreadPool."));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("synOutboundThreadPoolWithDB error. " + e));
        }
    }

    private void checkIpBufferToDiverTaskMap(List<IpStateData> ipStateDataList) {
        List defendGroupList = this.defendGroupDao.getAll();
        for (IpStateData data : ipStateDataList) {
            this.logger.info((Object)("IpStateData = " + data));
            if (data.getZoneId() < 1L) {
                this.logger.warn((Object)("zoneId is invalid. zoneId=" + data.getZoneId()));
                continue;
            }
            switch (data.getPolicy()) {
                case 1: {
                    this.processDivert(data, defendGroupList);
                    break;
                }
                case 5: {
                    this.processOutboundDivert(data);
                    break;
                }
                case 2: {
                    this.processDivertLinkage(data);
                    break;
                }
                case 9: {
                    this.processStopDivert(data);
                    break;
                }
                case 98: {
                    this.processOutboundStopDivert(data);
                    break;
                }
            }
        }
        ipStateDataList.clear();
    }

    private void processDivert(IpStateData data, List<DefendGroup> defendGroupList) {
        String deviceIp = data.getDeviceIp();
        String zoneIp = data.getZoneIp();
        long zoneId = data.getZoneId();
        try {
            if (!cancelDivertByDetect || !data.isFromCleanDevice()) {
                DeviceAtom deviceAtom;
                Set<DeviceAtom> deviceSet = this.abnormalIpStateMap.get(zoneIp + "," + zoneId);
                if (null == deviceSet) {
                    this.logger.info((Object)("the zoneIp " + zoneIp + "'s abnormalIpSet is null, create one."));
                    deviceSet = new HashSet<DeviceAtom>();
                    this.abnormalIpStateMap.put(zoneIp + "," + zoneId, deviceSet);
                }
                if (deviceSet.add(deviceAtom = new DeviceAtom(deviceIp, data.isFromCleanDevice()))) {
                    this.logger.info((Object)("add to " + zoneIp + "'s abnormalIpSet: " + deviceAtom));
                }
            }
            if (!data.isFromCleanDevice()) {
                List<AticDevice> deviceList = this.getCleanDevices(deviceIp, defendGroupList);
                this.prepareStartForDivertThreads(data, deviceList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void processOutboundDivert(IpStateData data) {
        String deviceIp = data.getDeviceIp();
        String zoneIp = data.getZoneIp();
        long zoneId = data.getZoneId();
        try {
            if (!cancelDivertByDetect || !data.isFromCleanDevice()) {
                DeviceAtom deviceAtom;
                Set<DeviceAtom> deviceSet = this.abnormalIpOutboundStateMap.get(zoneIp + "," + zoneId);
                if (null == deviceSet) {
                    this.logger.info((Object)("the zoneIp " + zoneIp + "'s abnormalIpSet is null, create one."));
                    deviceSet = new HashSet<DeviceAtom>();
                    this.abnormalIpOutboundStateMap.put(zoneIp + "," + zoneId, deviceSet);
                }
                if (deviceSet.add(deviceAtom = new DeviceAtom(deviceIp, data.isFromCleanDevice()))) {
                    this.logger.info((Object)("add to " + zoneIp + "'s abnormalIpSet: " + deviceAtom));
                }
            }
            if (!data.isFromCleanDevice()) {
                ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
                AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByFlowspec(Boolean.valueOf(true));
                if (null != aticDeviceNfa) {
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(aticDeviceNfa.getMoId());
                    deviceList.add(aticDevice);
                }
                this.prepareStartForOutboundDivertThreads(data, deviceList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void processStopDivert(IpStateData data) {
        String deviceIp = data.getDeviceIp();
        String zoneIp = data.getZoneIp();
        long zoneId = data.getZoneId();
        Set<DeviceAtom> deviceSet = this.abnormalIpStateMap.get(zoneIp + "," + zoneId);
        if (null != deviceSet) {
            if (!cancelDivertByDetect || !data.isFromCleanDevice()) {
                DeviceAtom deviceAtom = new DeviceAtom(deviceIp, data.isFromCleanDevice());
                if (!data.isAlarm()) {
                    deviceSet.remove(deviceAtom);
                }
            }
            this.resetZoneIpForMask(data);
            if (deviceSet.isEmpty()) {
                this.logger.info((Object)("ZoneIp is normal, zoneIp=" + zoneIp + ", ZoneId is " + zoneId));
                this.abnormalIpStateMap.remove(zoneIp + "," + zoneId);
                boolean canStop = this.checkCanStopForMask(data, this.abnormalIpStateMap.keySet());
                if (canStop) {
                    List<String> deviceList = this.getAllDivertDeviceIp();
                    this.prepareStopForDivertThreads(data, deviceList);
                } else {
                    this.logger.info((Object)("Cannot stop divert, some ip is still abnormal for mask, zoneIp=" + zoneIp + " zoneId=" + zoneId));
                }
            } else if (data.isAlarm()) {
                List<String> deviceList = this.getAllDivertDeviceIp();
                this.prepareStopForDivertThreads(data, deviceList);
                this.logger.warn((Object)("Force stop divert, zoneIp=" + zoneIp));
            } else {
                this.logger.info((Object)("Cannot stop divert, some device is still abnormal, zoneIp=" + zoneIp + ", deviceSet=" + deviceSet));
            }
        }
    }

    private void processOutboundStopDivert(IpStateData data) {
        String deviceIp = data.getDeviceIp();
        String zoneIp = data.getZoneIp();
        long zoneId = data.getZoneId();
        Set<DeviceAtom> deviceSet = this.abnormalIpOutboundStateMap.get(zoneIp + "," + zoneId);
        if (null != deviceSet) {
            if (!cancelDivertByDetect || !data.isFromCleanDevice()) {
                DeviceAtom deviceAtom = new DeviceAtom(deviceIp, data.isFromCleanDevice());
                if (!data.isAlarm()) {
                    deviceSet.remove(deviceAtom);
                }
            }
            this.resetZoneIpForMask(data);
            if (deviceSet.isEmpty()) {
                this.logger.info((Object)("ZoneIp is normal, zoneIp=" + zoneIp + ", ZoneId is " + zoneId));
                this.abnormalIpOutboundStateMap.remove(zoneIp + "," + zoneId);
                boolean canStop = this.checkCanStopForMask(data, this.abnormalIpOutboundStateMap.keySet());
                if (canStop) {
                    ArrayList<String> deviceList = new ArrayList<String>(DivertOutboundThreadPool.getAllDivertDeviceIp());
                    this.prepareStopForOutboundDivertThreads(data, deviceList);
                } else {
                    this.logger.info((Object)("Cannot stop divert, some ip is still abnormal for mask, zoneIp=" + zoneIp + " zoneId=" + zoneId));
                }
            } else {
                this.logger.info((Object)("Cannot stop divert, some device is still abnormal, zoneIp=" + zoneIp + ", deviceSet=" + deviceSet));
            }
        }
    }

    private void processDivertLinkage(IpStateData data) {
        String deviceIp = data.getDeviceIp();
        String zoneIp = data.getZoneIp();
        long zoneId = data.getZoneId();
        try {
            if (!cancelDivertByDetect || !data.isFromCleanDevice()) {
                DeviceAtom deviceAtom;
                Set<DeviceAtom> deviceSet = this.abnormalIpStateMap.get(zoneIp + "," + zoneId);
                if (null == deviceSet) {
                    this.logger.info((Object)("the zoneIp " + zoneIp + "'s abnormalIpSet is null, create one."));
                    deviceSet = new HashSet<DeviceAtom>();
                    this.abnormalIpStateMap.put(data.getZoneIp() + "," + zoneId, deviceSet);
                }
                if (deviceSet.add(deviceAtom = new DeviceAtom(deviceIp, data.isFromCleanDevice()))) {
                    this.logger.info((Object)("add to " + zoneIp + "'s abnormalIpSet: " + deviceAtom));
                }
            }
            if (!this.isLinkageWhenCloudClean) {
                ICloudCleanForDiversionService cloudCleanDiversion = this.getCloudCleanService();
                if (cloudCleanDiversion == null) {
                    this.logger.error((Object)"cloudCleanDiversion is null");
                    return;
                }
                List<CloudCleanForm> cloudCleanFormList = cloudCleanDiversion.findAll();
                if (this.isCloudCleanTaskExist(cloudCleanFormList, zoneIp)) {
                    return;
                }
            }
            ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
            AticDevice aticDevice = this.allDeviceMap.get(deviceIp);
            List linkageDeviceList = this.defendGroupService.getLinkageCleanDevices(aticDevice);
            this.logger.info((Object)("processDivertLinkage, linkageDeviceList.size = " + linkageDeviceList.size()));
            List groupDeviceList = this.defendGroupService.getGroupCleanDevices(aticDevice);
            this.logger.info((Object)("processDivertLinkage, groupDeviceList.size = " + groupDeviceList.size()));
            this.groupDevices = groupDeviceList;
            if (linkageDeviceList.isEmpty()) {
                this.logger.warn((Object)("Cannot find linkage device. deviceIp=" + deviceIp + ", zoneId=" + zoneId + ", zoneIp=" + zoneIp));
                return;
            }
            deviceList.addAll(linkageDeviceList);
            if (!groupDeviceList.isEmpty() && this.isOpenKIO) {
                deviceList.addAll(groupDeviceList);
            }
            this.prepareStartForDivertThreads(data, deviceList);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e);
        }
    }

    private void resetZoneIpForMask(IpStateData ipStateData) {
        if (this.userDefineDivertIpMask != 32 || this.userDefineDivertIpv6Mask != 128) {
            int mask = IPUtil.isIpv4((String)ipStateData.getZoneIp()) ? this.userDefineDivertIpMask : this.userDefineDivertIpv6Mask;
            String[] ipRange = IPUtil.getSubnetRange((String)ipStateData.getZoneIp(), (int)mask);
            ipStateData.setZoneIp(ipRange[0]);
        }
    }

    private boolean checkCanStopForMask(IpStateData ipStateData, Set<String> zoneIpIdSet) {
        int mask = IPUtil.isIpv4((String)ipStateData.getZoneIp()) ? this.userDefineDivertIpMask : this.userDefineDivertIpv6Mask;
        String[] ipRange = IPUtil.getSubnetRange((String)ipStateData.getZoneIp(), (int)mask);
        for (String keyZoneIpId : zoneIpIdSet) {
            String keyZoneIp = keyZoneIpId.split(",")[0];
            try {
                if (!IPUtil.isInIpRange((String[])ipRange, (String)keyZoneIp)) continue;
                return false;
            }
            catch (Exception e) {
                this.logger.error((Object)("IPUtil.isInIpRange catch Exception :" + e));
            }
        }
        return true;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void prepareStartForDivertThreads(IpStateData ipStateData, List<AticDevice> deviceList) {
        String zoneIp = ipStateData.getZoneIp();
        long zoneId = ipStateData.getZoneId();
        for (AticDevice device : deviceList) {
            ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm = this.zoneDeviceDeployStatusService.getByZoneIdAndDeviceId(Long.valueOf(zoneId), Long.valueOf(device.getMoId()));
            if (null == zoneDeviceDeployStatusForm) {
                this.logger.info((Object)("Ip not belong to custom zone, zoneId=" + zoneId + ", zoneIp=" + zoneIp + ", deviceIp=" + this.getcleanedMessage(device.getIpAddress()) + ", policy=" + ipStateData.getPolicy() + ", deviceId=" + device.getMoId()));
                long defaultZoneId = this.zoneService.getDeployDefaultZoneByDeviceId(Long.valueOf(device.getMoId()));
                if (0L == defaultZoneId) {
                    this.logger.info((Object)("drop start data for not belong to any zone, zoneId=" + zoneId + ", zoneIp=" + zoneIp + ", deviceIp=" + this.getcleanedMessage(device.getIpAddress()) + ", policy=" + ipStateData.getPolicy()));
                    continue;
                }
                ipStateData.setZoneId(defaultZoneId);
                if (ipStateData.getNfaId() > 0L) {
                    FaultSeverityRuleForm ruleFrom = this.faultSeverityRuleDao.listRuleByZoneId(Long.valueOf(defaultZoneId), Integer.valueOf(ipStateData.getDirection()));
                    if (ruleFrom == null) {
                        ruleFrom = this.faultSeverityRuleDao.listRuleByZoneId(Long.valueOf(0L), Integer.valueOf(1));
                    }
                    int policy = ruleFrom.getMajorRule().getDiversionAction();
                    ipStateData.setPolicy(policy);
                }
            }
            this.storeDivertIntoMap(device.getIpAddress(), ipStateData, 1);
            this.logger.info((Object)("write start data to thread, zoneId=" + ipStateData.getZoneId() + ", zoneIp=" + zoneIp + ", deviceIp=" + this.getcleanedMessage(device.getIpAddress()) + ", policy=" + ipStateData.getPolicy()));
            ipStateData.setZoneId(zoneId);
        }
    }

    private void prepareStartForOutboundDivertThreads(IpStateData ipStateData, List<AticDevice> deviceList) {
        String zoneIp = ipStateData.getZoneIp();
        long zoneId = ipStateData.getZoneId();
        for (AticDevice device : deviceList) {
            DivertOutboundThread divertOutboundThread = DivertOutboundThreadPool.get(device.getIpAddress());
            if (null == divertOutboundThread && null != this.aticDeviceService.getDeviceByMoid(device.getMoId())) {
                divertOutboundThread = new DivertOutboundThread(device, this.outboundDivertTacticsLogDao, this.outboundDivertTacticsDao, this.outboundDivertTacticsService, this.zonePolicyApplyService);
                divertOutboundThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                divertOutboundThread.start();
                DivertOutboundThreadPool.put(device.getIpAddress(), divertOutboundThread);
                this.logger.info((Object)("Create and start outbound divert thread, deviceIp=" + this.getcleanedMessage(device.getIpAddress())));
            }
            if (null != divertOutboundThread) {
                divertOutboundThread.setDevice(device);
                this.storeOutboundDivertIntoMap(device.getIpAddress(), ipStateData);
                this.logger.info((Object)("write start data to outbound thread, zoneId=" + ipStateData.getZoneId() + ", zoneIp=" + zoneIp + ", deviceIp=" + this.getcleanedMessage(device.getIpAddress()) + ", policy=" + ipStateData.getPolicy()));
            }
            ipStateData.setZoneId(zoneId);
        }
    }

    private void prepareStopForDivertThreads(IpStateData ipStateData, List<String> deviceIpList) {
        for (String deviceIp : deviceIpList) {
            this.storeDivertIntoMap(deviceIp, ipStateData, 9);
            this.logger.info((Object)("write stop data to thread, zoneId=" + ipStateData.getZoneId() + ", zoneIp=" + ipStateData.getZoneIp() + ", deviceIp=" + deviceIp + ", policy=" + ipStateData.getPolicy()));
        }
    }

    private void prepareStopForOutboundDivertThreads(IpStateData ipStateData, List<String> deviceIpList) {
        for (String deviceIp : deviceIpList) {
            this.storeOutboundDivertIntoMap(deviceIp, ipStateData);
            this.logger.info((Object)("write stop data to thread, zoneId=" + ipStateData.getZoneId() + ", zoneIp=" + ipStateData.getZoneIp() + ", deviceIp=" + deviceIp + ", policy=" + ipStateData.getPolicy()));
        }
    }

    private void storeDivertIntoMap(String deviceIp, IpStateData ipStateData, int action) {
        DivertTask divert = new DivertTask();
        divert.setZoneId(ipStateData.getZoneId());
        divert.setZoneIp(ipStateData.getZoneIp());
        divert.setPolicy(ipStateData.getPolicy());
        divert.setNfaId(ipStateData.getNfaId());
        List<DivertTask> divertTaskList = null;
        Map<Integer, List<DivertTask>> deviceActionMap = this.deviceDivertTaskMap.get(deviceIp);
        if (null == deviceActionMap) {
            deviceActionMap = new HashMap<Integer, List<DivertTask>>();
            divertTaskList = new ArrayList<DivertTask>();
            divertTaskList.add(divert);
            deviceActionMap.put(action, divertTaskList);
            this.deviceDivertTaskMap.put(deviceIp, deviceActionMap);
        } else {
            divertTaskList = deviceActionMap.get(action);
            if (null == divertTaskList) {
                divertTaskList = new ArrayList<DivertTask>();
                deviceActionMap.put(action, divertTaskList);
            }
            divertTaskList.add(divert);
        }
    }

    private void storeOutboundDivertIntoMap(String deviceIp, IpStateData ipStateData) {
        DivertTask divert = new DivertTask();
        divert.setZoneId(ipStateData.getZoneId());
        divert.setZoneIp(ipStateData.getZoneIp());
        divert.setPolicy(ipStateData.getPolicy());
        divert.setNfaId(ipStateData.getNfaId());
        if (this.deviceOutboundDivertTaskMap.containsKey(deviceIp)) {
            this.deviceOutboundDivertTaskMap.get(deviceIp).add(divert);
        } else {
            ArrayList<DivertTask> divertTaskList = new ArrayList<DivertTask>();
            divertTaskList.add(divert);
            this.deviceOutboundDivertTaskMap.put(deviceIp, divertTaskList);
        }
    }

    private DivertTactics composeDevDivert(long deviceId, DivertTask divert) {
        String[] ipRange = null;
        String zoneIp = divert.getZoneIp();
        DivertTactics divertTactics = new DivertTactics();
        divertTactics.setDeviceId(deviceId);
        divertTactics.setId(divert.getId());
        divertTactics.setDivertStatus(divert.getDivertStatus());
        divertTactics.setZoneId(divert.getZoneId());
        divertTactics.setCreateTime(Calendar.getInstance().getTimeInMillis() / 1000L);
        divertTactics.setDivertIp(zoneIp);
        if (IPUtil.isIpv4((String)divert.getZoneIp())) {
            if (2 == divert.getPolicy()) {
                ipRange = IPUtil.getSubnetRange((String)zoneIp, (int)this.linkageDivertIpMask);
                divertTactics.setMask(this.linkageDivertIpMask);
            } else {
                ipRange = IPUtil.getSubnetRange((String)zoneIp, (int)this.userDefineDivertIpMask);
                divertTactics.setMask(this.userDefineDivertIpMask);
            }
        } else {
            ipRange = IPUtil.getSubnetRange((String)zoneIp, (int)this.userDefineDivertIpv6Mask);
            divertTactics.setMask(this.userDefineDivertIpv6Mask);
        }
        divertTactics.setStartIp(ipRange[0]);
        divertTactics.setEndIp(ipRange[1]);
        divertTactics.setNfaId(divert.getNfaId());
        ZonePolicyApplyForm zonePolicyApplyForm = this.zoneMgrNorthSerice.getDivertMode(divert.getZoneId());
        if (null != zonePolicyApplyForm) {
            divertTactics.setDivertMode(zonePolicyApplyForm.getDivertMode());
        } else {
            divertTactics.setDivertMode(0);
        }
        return divertTactics;
    }

    private OutboundDivertTactics composeDevOutboundDivert(long deviceId, DivertTask divert) {
        OutboundDivertTactics outboundDivertTactics = new OutboundDivertTactics();
        outboundDivertTactics.setDeviceId(deviceId);
        outboundDivertTactics.setId(divert.getId());
        outboundDivertTactics.setDivertStatus(divert.getDivertStatus());
        outboundDivertTactics.setZoneId(divert.getZoneId());
        outboundDivertTactics.setCreateTime(Calendar.getInstance().getTimeInMillis() / 1000L);
        outboundDivertTactics.setSourceIp(divert.getZoneIp());
        outboundDivertTactics.setDivertMode(0);
        return outboundDivertTactics;
    }

    private List<AticDevice> getCleanDevices(String deviceIp, List<DefendGroup> defendGroupList) {
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        AticDevice device = this.allDeviceMap.get(deviceIp);
        if (null == device) {
            this.logger.info((Object)("cant find this detect device. deivce ip = " + deviceIp));
            return deviceList;
        }
        DefendGroup devDefendGroup = null;
        for (DefendGroup defendGroup : defendGroupList) {
            if (!defendGroup.getFirewallIds().contains(device.getMoId())) continue;
            devDefendGroup = defendGroup;
            break;
        }
        if (devDefendGroup != null) {
            this.logger.info((Object)("the detect device " + deviceIp + " if it is belong one  group"));
            block1: for (Long l : devDefendGroup.getFirewallIds()) {
                for (Map.Entry<String, AticDevice> entry : this.allDeviceMap.entrySet()) {
                    AticDevice deviceTemp = entry.getValue();
                    if (deviceTemp.getMoId() != l.longValue() || 0 != deviceTemp.getDdosType() && 2 != deviceTemp.getDdosType()) continue;
                    deviceList.add(deviceTemp);
                    continue block1;
                }
            }
        } else {
            this.logger.info((Object)("the detect device " + deviceIp + " if it is belong default group"));
            for (Map.Entry entry : this.allDeviceMap.entrySet()) {
                boolean isInGroup = false;
                AticDevice tempDevice = (AticDevice)entry.getValue();
                if (0 != tempDevice.getDdosType() && 2 != tempDevice.getDdosType()) continue;
                long tempMoId = tempDevice.getMoId();
                for (DefendGroup defendGroup : defendGroupList) {
                    if (!defendGroup.getFirewallIds().contains(tempMoId)) continue;
                    isInGroup = true;
                    break;
                }
                if (isInGroup) continue;
                deviceList.add(tempDevice);
            }
        }
        StringBuffer buffer = new StringBuffer();
        for (AticDevice dev : deviceList) {
            buffer.append(dev.getIpAddress()).append("  ");
        }
        this.logger.info((Object)("the last clean deviceList is " + buffer.toString()));
        return deviceList;
    }

    private List<String> getDeviceIpList(List<AticDevice> deviceList) {
        ArrayList<String> deviceIpList = new ArrayList<String>();
        if (null == deviceList || deviceList.isEmpty()) {
            return deviceIpList;
        }
        for (AticDevice device : deviceList) {
            deviceIpList.add(device.getIpAddress());
        }
        return deviceIpList;
    }

    private void deleteGroupDeviceDivert(DivertTactics divertTactics) {
        List<DivertTactics> divert32MaskInDBs;
        long deviceId = divertTactics.getDeviceId();
        String zoneIp = divertTactics.getDivertIp();
        AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId);
        String deviceIp = device.getIpAddress();
        List<String> deviceIps = this.getDeviceIpList(this.groupDevices);
        this.logger.warn((Object)("deleteGroupDeviceDivert, groupDevices.size = " + this.groupDevices.size()));
        if (!deviceIps.contains(deviceIp)) {
            this.logger.warn((Object)("deleteGroupDeviceDivert, deviceIp=" + deviceIp + " is not in groupDevices"));
            return;
        }
        this.logger.info((Object)("deleteGroupDeviceDivert, deviceIp=" + deviceIp + ", zoneIp=" + zoneIp));
        List<DivertTactics> divertInDBs = this.divertTacticsDao.getConflictDivert(divertTactics);
        if (!divertInDBs.isEmpty() && !(divert32MaskInDBs = this.divertTacticsDao.getConflictDivert(divertTactics, 32)).isEmpty() && divertInDBs.size() == divert32MaskInDBs.size()) {
            this.logger.info((Object)("deleteGroupDeviceDivert, all divertTactics is 32 mask in same segment " + zoneIp + "/" + divertTactics.getMask()));
            this.logger.info((Object)"deleteGroupDeviceDivert, begin to delete....");
            for (DivertTactics divertTacticsTemp : divert32MaskInDBs) {
                DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
                AticUtil.copyProperties((Object)divertTacticsTemp, (Object)dtDivertTacticsForm);
                this.divertTacticsService.stopAndDelDivert(dtDivertTacticsForm);
                this.logger.info((Object)("delete DB divert , deviceIp=" + deviceIp + ", zoneIp=" + divertTacticsTemp.getDivertIp() + ",  divertMode =" + divertTacticsTemp.getDivertMode() + ", divertStatus=" + divertTacticsTemp.getDivertStatus()));
            }
            this.logger.info((Object)"deleteGroupDeviceDivert, end to delete....");
        }
    }

    private boolean isCloudCleanTaskExist(List<CloudCleanForm> ccFormList, String zoneIp) {
        this.logger.info((Object)("cloud clean task size : " + ccFormList.size() + ", zoneIp : " + zoneIp));
        for (CloudCleanForm cloudCleanForm : ccFormList) {
            try {
                if (!"enable".equals(cloudCleanForm.getStatus()) || null == cloudCleanForm.getIpMask() || cloudCleanForm.getIpMask().isEmpty() || !IPUtil4Atic.isInIpRange((String[])IPUtil.getSubnetRange((String)cloudCleanForm.getIpMask().split("/")[0], (int)Integer.parseInt(cloudCleanForm.getIpMask().split("/")[1])), (String)zoneIp)) continue;
                this.logger.info((Object)("IP exists in the already started cloud clean task.  ip :" + zoneIp + ", cloud clean task :" + cloudCleanForm.getIpMask()));
                return true;
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"isCloudCleanTaskExist exception:", (Throwable)e);
            }
        }
        this.logger.info((Object)("zoneIp :" + zoneIp + "is not in started cloud clean task."));
        return false;
    }

    private List<String> getAllDivertDeviceIp() {
        return new ArrayList<String>(this.deviceDivertTaskMap.keySet());
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean isStart) {
        this.start = isStart;
    }

    public void setCancelDivertByDetectValue(boolean cancelDivertByDetectValue) {
        IpStateScheduler.setCancelDivertByDetect(cancelDivertByDetect);
    }

    public static void setCancelDivertByDetect(boolean isCancelDivertByDetect) {
        cancelDivertByDetect = isCancelDivertByDetect;
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public DivertTacticsLogDao getDivertTacticsLogDao() {
        return this.divertTacticsLogDao;
    }

    public void setDivertTacticsLogDao(DivertTacticsLogDao divertTacticsLogDao) {
        this.divertTacticsLogDao = divertTacticsLogDao;
    }

    public DivertTacticsDao getDivertTacticsDao() {
        return this.divertTacticsDao;
    }

    public void setDivertTacticsDao(DivertTacticsDao divertTacticsDao) {
        this.divertTacticsDao = divertTacticsDao;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IZoneMgrNorthSerice getZoneMgrNorthSerice() {
        return this.zoneMgrNorthSerice;
    }

    public void setZoneMgrNorthSerice(IZoneMgrNorthSerice zoneMgrNorthSerice) {
        this.zoneMgrNorthSerice = zoneMgrNorthSerice;
    }

    public DefendGroupDao getDefendGroupDao() {
        return this.defendGroupDao;
    }

    public void setDefendGroupDao(DefendGroupDao defendGroupDao) {
        this.defendGroupDao = defendGroupDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneDeviceDeployStatusService getZoneDeviceDeployStatusService() {
        return this.zoneDeviceDeployStatusService;
    }

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }

    public FaultSeverityRuleDao getFaultSeverityRuleDao() {
        return this.faultSeverityRuleDao;
    }

    public void setFaultSeverityRuleDao(FaultSeverityRuleDao faultSeverityRuleDao) {
        this.faultSeverityRuleDao = faultSeverityRuleDao;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public OutboundDivertTacticsDao getOutboundDivertTacticsDao() {
        return this.outboundDivertTacticsDao;
    }

    public void setOutboundDivertTacticsDao(OutboundDivertTacticsDao outboundDivertTacticsDao) {
        this.outboundDivertTacticsDao = outboundDivertTacticsDao;
    }

    public OutboundDivertTacticsLogDao getOutboundDivertTacticsLogDao() {
        return this.outboundDivertTacticsLogDao;
    }

    public void setOutboundDivertTacticsLogDao(OutboundDivertTacticsLogDao outboundDivertTacticsLogDao) {
        this.outboundDivertTacticsLogDao = outboundDivertTacticsLogDao;
    }

    public IOutboundDivertTacticsService getOutboundDivertTacticsService() {
        return this.outboundDivertTacticsService;
    }

    public void setOutboundDivertTacticsService(IOutboundDivertTacticsService outboundDivertTacticsService) {
        this.outboundDivertTacticsService = outboundDivertTacticsService;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public IDefendGroupService getDefendGroupService() {
        return this.defendGroupService;
    }

    public void setDefendGroupService(IDefendGroupService defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    public IDateTableFileService getDateTableFileService() {
        return this.dateTableFileService;
    }

    public void setDateTableFileService(IDateTableFileService dateTableFileService) {
        this.dateTableFileService = dateTableFileService;
    }

    private ICloudCleanForDiversionService getCloudCleanService() {
        ICloudCleanForDiversionService cloudCleanService = BisDivertUtil.getCloudCleanForDiversionService();
        return cloudCleanService;
    }
}

