/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.BlackholeNpFailDao;
import com.hs.atic.bis.dao.DivertTacticsDao;
import com.hs.atic.bis.dao.FaultSeverityRuleDao;
import com.hs.atic.bis.model.ConfigBlackholeNPFail;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.sdk.bis.service.IBlackholeNpService;
import com.hs.atic.sdk.bis.service.IDivertBlackholeService;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.BlackholeAlarmHandler;
import com.hs.atic.zone.dao.ZoneListIpDao;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.collector.service.dao.BlackholeNpDao;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.ConfigBlackholeNp;
import com.huawei.atic.sdk.bis.model.DefendGroup;
import com.huawei.atic.sdk.bis.service.dao.DefendGroupDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.dao.DataAccessException;

public class BlackholeNpServiceImpl
implements IBlackholeNpService {
    public static final long GAP_TIME_ONE_MINUTE_IN_MILLISECOND_LOONG = 60000L;
    private static final String DEPLOY_DIVESION_USERNAME = "system";
    private static final String DEPLOY_DIVESION_TERMINAL_IP = "127.0.0.1";
    private static final int GAP_TIME_ONE_DAY_MILLISECOND = 86400000;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private Set<ConfigBlackholeNPFail> configBlackholeNpFails = new HashSet<ConfigBlackholeNPFail>();
    private IDivertBlackholeService divertBlackholeService;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private ZoneDeviceDao zoneDeviceDao;
    private CollectorDao collectorDao;
    private BlackholeNpDao blackholeNpDao;
    private DefendGroupDao defendGroupDao;
    private IAticDeviceService aticDeviceService;
    private IZoneService zoneService;
    private IDivertTacticsService divertTacticsService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private DivertTacticsDao divertTacticsDao;
    private FaultSeverityRuleDao faultSeverityRuleDao;
    private ZoneListIpDao zoneListIpDao;
    private BlackholeNpFailDao blackholeNpFailDao;
    private BlackholeAlarmHandler blackholeAlarmHandler;

    public BlackholeNpServiceImpl() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date time = calendar.getTime();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (BlackholeNpServiceImpl.this.collectorDao != null && BlackholeNpServiceImpl.this.blackholeNpDao != null && BlackholeNpServiceImpl.this.collectorRMIProxy != null) {
                    BlackholeNpServiceImpl.this.synchronizationBalckholeNP();
                }
            }
        }, time, 86400000L);
    }

    @Override
    public void batchSaveNP(List<BlackholeNpForm> blackholeNpForms) {
        block12: {
            this.logger.info((Object)("batch save or update blackhole NP blackholeNpForms =" + blackholeNpForms.toString()));
            if (blackholeNpForms.isEmpty()) {
                throw new LegoCheckedException(571212L);
            }
            try {
                this.logger.info((Object)"Restful:BlackholeNpForms saves begin.");
                String[] arrIps = this.collectorDao.getAllCollectorIP();
                NotifyFaultSeverityRuleService client = null;
                boolean isAddSucces = false;
                for (int i = 0; i < arrIps.length; ++i) {
                    client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(arrIps[i]);
                    if (null == client) {
                        this.logger.warn((Object)("Get NotifyFaultSeverityRuleService interface failed, collector ip is " + arrIps[i]));
                        continue;
                    }
                    this.logger.info((Object)("BlackholeNpForms collect " + i + " saves begin."));
                    try {
                        if (!client.bathSaveOrUpate(blackholeNpForms)) continue;
                        isAddSucces = true;
                        continue;
                    }
                    catch (RemoteException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.logger.info((Object)"BlackholeNpForms atic saves begin.");
                if (isAddSucces) {
                    ConfigBlackholeNp configBlackholeNp = null;
                    for (BlackholeNpForm blackholeNpForm : blackholeNpForms) {
                        if (this.blackholeNpDao.isExist(blackholeNpForm.getNpIp())) {
                            configBlackholeNp = this.blackholeNpDao.getBlackholeNpByIp(blackholeNpForm.getNpIp());
                        } else {
                            configBlackholeNp = new ConfigBlackholeNp();
                            configBlackholeNp.setNpIp(blackholeNpForm.getNpIp());
                        }
                        configBlackholeNp.setBlackholeThreshold(blackholeNpForm.getBlackholeThreshold());
                        configBlackholeNp.setTimeLong(blackholeNpForm.getTimeLong());
                        this.blackholeNpDao.saveOrUpdate((Object)configBlackholeNp);
                    }
                    break block12;
                }
                throw new LegoCheckedException(570002L);
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LegoCheckedException(571804L, (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LegoCheckedException(571805L, (Throwable)e);
            }
        }
    }

    @Override
    public BlackholeNpForm getBlackholeNPFormByIp(String ip) {
        try {
            BlackholeNpForm blackholeNpForm = new BlackholeNpForm();
            if (this.blackholeNpDao.isExist(ip)) {
                ConfigBlackholeNp configBlackholeNp = this.blackholeNpDao.getBlackholeNpByIp(ip);
                blackholeNpForm.setId(configBlackholeNp.getId());
                blackholeNpForm.setNpIp(configBlackholeNp.getNpIp());
                blackholeNpForm.setBlackholeThreshold(configBlackholeNp.getBlackholeThreshold());
                blackholeNpForm.setTimeLong(configBlackholeNp.getTimeLong());
            }
            return blackholeNpForm;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
    }

    @Override
    public List<BlackholeNpForm> queryBlackholeNPFormByIps(List<String> ips) {
        ArrayList<BlackholeNpForm> blackholeNpForms = new ArrayList<BlackholeNpForm>();
        for (String ip : ips) {
            BlackholeNpForm blackholeNpForm = this.getBlackholeNPFormByIp(ip);
            blackholeNpForms.add(blackholeNpForm);
        }
        return blackholeNpForms;
    }

    @Override
    public void deleteBlackholeNpByIp(String ip) {
        this.logger.info((Object)("delete blackhole NP by ip =" + ip));
        try {
            if (this.blackholeNpDao.isExist(ip)) {
                this.blackholeNpDao.remove(ip);
            }
            String[] arrIps = this.collectorDao.getAllCollectorIP();
            NotifyFaultSeverityRuleService client = null;
            for (int i = 0; i < arrIps.length; ++i) {
                ConfigBlackholeNPFail configBlackholeNpFail = new ConfigBlackholeNPFail();
                configBlackholeNpFail.setNpIp(ip);
                String collectorIp = arrIps[i];
                try {
                    client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(collectorIp);
                    if (null != client && client.deleteBlackholeNP(ip)) {
                        collectorIp = null;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (null == collectorIp) continue;
                configBlackholeNpFail.setCollectorIp(collectorIp);
                this.configBlackholeNpFails.add(configBlackholeNpFail);
            }
            if (this.configBlackholeNpFails.size() > 0) {
                this.blackholeNpFailDao.saveAll(this.configBlackholeNpFails);
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
    }

    @Override
    public void deleteCollectorFailedBlackholeNP() {
        try {
            Map<String, List<ConfigBlackholeNPFail>> blackholeNpFailMap = this.queryAllCollectorBlackholeNpFail();
            NotifyFaultSeverityRuleService client = null;
            for (Map.Entry<String, List<ConfigBlackholeNPFail>> entry : blackholeNpFailMap.entrySet()) {
                String collectorIp = entry.getKey();
                List<ConfigBlackholeNPFail> configBlackholeNPFails = entry.getValue();
                List<String> npIps = this.queryZoneIps(configBlackholeNPFails);
                if (this.collectorDao.isIpExists(null, collectorIp)) {
                    client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(collectorIp);
                    if (null == client) {
                        this.logger.warn((Object)("Get NotifyFaultSeverityRuleService interface failed, collector ip is " + collectorIp));
                        continue;
                    }
                    try {
                        if (!client.deleteCollectorFailedBlackholeNP(npIps)) continue;
                        this.blackholeNpFailDao.deleteAll(configBlackholeNPFails);
                    }
                    catch (RemoteException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                this.blackholeNpFailDao.deleteAll(configBlackholeNPFails);
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
    }

    private List<String> queryZoneIps(List<ConfigBlackholeNPFail> configBlackholeNPFails) {
        ArrayList<String> zoneIps = new ArrayList<String>();
        for (ConfigBlackholeNPFail configBlackholeNPFail : configBlackholeNPFails) {
            zoneIps.add(configBlackholeNPFail.getNpIp());
        }
        return zoneIps;
    }

    private Map<String, List<ConfigBlackholeNPFail>> queryAllCollectorBlackholeNpFail() {
        HashMap<String, List<ConfigBlackholeNPFail>> map = new HashMap<String, List<ConfigBlackholeNPFail>>();
        List<ConfigBlackholeNPFail> configBlackholeNpFailList = this.blackholeNpFailDao.queryAllFailBlackholeNp();
        ArrayList<ConfigBlackholeNPFail> blackholeNpFails = null;
        for (ConfigBlackholeNPFail temp : configBlackholeNpFailList) {
            String collectorIp = temp.getCollectorIp();
            if (map.containsKey(collectorIp)) {
                ((List)map.get(collectorIp)).add(temp);
                continue;
            }
            blackholeNpFails = new ArrayList<ConfigBlackholeNPFail>();
            blackholeNpFails.add(temp);
            map.put(collectorIp, blackholeNpFails);
        }
        return map;
    }

    @Override
    public List<DivertBlackholeForm> blackholeNpByEnableStatus() {
        Map divertBlackholeNpMap = this.blackholeNpDao.blackholeNpByEnableStatus();
        ArrayList<DivertBlackholeForm> divertBlackholeNPFormList = new ArrayList<DivertBlackholeForm>();
        if (divertBlackholeNpMap.isEmpty()) {
            return divertBlackholeNPFormList;
        }
        List<DivertBlackholeForm> divertBlackholeNpFormList = this.divertBlackholeService.getEnableDiversionList();
        for (DivertBlackholeForm divertBlackholeForm : divertBlackholeNpFormList) {
            Long time;
            ConfigBlackholeNp configBlackholeNp = (ConfigBlackholeNp)divertBlackholeNpMap.get(divertBlackholeForm.getBlackIPAndMask());
            if (configBlackholeNp == null || (time = Long.valueOf(System.currentTimeMillis() - (long)configBlackholeNp.getTimeLong().intValue() * 60000L)) <= divertBlackholeForm.getEnableTime()) continue;
            divertBlackholeForm.setBlackholeThreshold(configBlackholeNp.getBlackholeThreshold());
            divertBlackholeForm.setBlackholeTime(configBlackholeNp.getTimeLong());
            divertBlackholeNPFormList.add(divertBlackholeForm);
            this.logger.info((Object)("blackholeNpByEnableStatus query DivertBlackholeNPForm, divertBlackholeForm deviceIp=" + divertBlackholeForm.getDeviceIP() + ", NpIp=" + divertBlackholeForm.getBlackIPAndMask()));
        }
        return divertBlackholeNPFormList;
    }

    @Override
    public void startDivertBlackholeNp(BlackholeNpForm blackholeNpForm) {
        this.logger.info((Object)("startDivertBlackholeNp BlackholeNpForm deviceIp=" + blackholeNpForm.getDeviceIp() + ", npIp=" + blackholeNpForm.getNpIp()));
        String[] ipAndMark = blackholeNpForm.getNpIp().split("/");
        String npIp = ipAndMark[0];
        try {
            Long zoneId;
            ZoneListIpInfo zoneListIpInfo = this.zoneListIpDao.getByIpAndMask(npIp, ipAndMark[1]);
            if (zoneListIpInfo == null) {
                this.logger.info((Object)("startDivertBlackholeNp can not find custom zone. zoneIp=" + npIp + "; mark=" + ipAndMark[1]));
                AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(blackholeNpForm.getDeviceIp());
                if (null == aticDevice) {
                    this.logger.info((Object)("startDivertBlackholeNp can not find this device. deivceIp=" + blackholeNpForm.getDeviceIp()));
                    return;
                }
                zoneId = this.zoneService.getDeployDefaultZoneByDeviceId(Long.valueOf(aticDevice.getMoId()));
                if (zoneId == 0L) {
                    this.logger.info((Object)("startDivertBlackholeNp can not find default zone. deivceIp=" + blackholeNpForm.getDeviceIp() + "; deivceId=" + aticDevice.getMoId()));
                    return;
                }
            } else {
                zoneId = zoneListIpInfo.getZoneId();
            }
            List deviceIdList = this.zoneDeviceDao.getDeviceIdsByZoneId(zoneId);
            String deviceIp = blackholeNpForm.getDeviceIp();
            AticDevice device = this.checkNEByDeviceIp(deviceIp);
            blackholeNpForm.setZoneId(zoneId);
            this.logger.info((Object)("ddos type equal 0 deploy NP black hole device zoneIp=" + blackholeNpForm.getNpIp() + "; deviceId:" + device.getMoId()));
            if (deviceIdList.contains(device.getMoId()) && device.getDdosType() == 0) {
                this.startBlackholeNp(blackholeNpForm, device);
            } else if (deviceIdList.contains(device.getMoId()) && device.getDdosType() == 1) {
                List<AticDevice> deviceList = this.getCleanDevices(blackholeNpForm.getDeviceIp());
                for (AticDevice aticDevice : deviceList) {
                    this.logger.info((Object)("deploy divesion zoneIp=" + blackholeNpForm.getNpIp() + "; aticDevice Device IP:" + aticDevice.getIpAddress()));
                    boolean isDeployDivesion = this.deployDivesion(blackholeNpForm.getNpIp(), aticDevice, DEPLOY_DIVESION_USERNAME, DEPLOY_DIVESION_TERMINAL_IP);
                    if (!isDeployDivesion) continue;
                    this.startBlackholeNp(blackholeNpForm, aticDevice);
                }
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
    }

    public void startBlackholeNp(BlackholeNpForm blackholeNpForm, AticDevice device) {
        this.logger.info((Object)("startDivertBlackholeNp BlackholeNpForm deviceIp=" + blackholeNpForm.getDeviceIp() + ", npIp=" + blackholeNpForm.getNpIp()));
        String[] ipAndMark = blackholeNpForm.getNpIp().split("/");
        String npIp = ipAndMark[0];
        String mark = ipAndMark[1];
        DivertBlackholeForm divertBlackholeForm = new DivertBlackholeForm();
        divertBlackholeForm.setBlackholeMode(2);
        divertBlackholeForm.setBlackIP(npIp);
        divertBlackholeForm.setBlackMask(mark);
        divertBlackholeForm.setEnableStatus(0);
        divertBlackholeForm.setDetail("1");
        divertBlackholeForm.setMode(1);
        divertBlackholeForm.setEnableTime(System.currentTimeMillis());
        divertBlackholeForm.setDeviceId(device.getMoId());
        divertBlackholeForm.setDeviceName(device.getName());
        divertBlackholeForm.setDeviceIP(device.getIpAddress());
        divertBlackholeForm.setNexthopIP("NULL 0");
        divertBlackholeForm.setServiceProvider("--");
        divertBlackholeForm.setVpn("--");
        divertBlackholeForm.setBlackholeType(1);
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        conditionMap.put("blackIP", divertBlackholeForm.getBlackIP());
        conditionMap.put("deviceId", String.valueOf(divertBlackholeForm.getDeviceId()));
        conditionMap.put("blackMask", String.valueOf(divertBlackholeForm.getBlackMask()));
        conditionMap.put("blackholeMode", String.valueOf(divertBlackholeForm.getBlackholeMode()));
        Paging page = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
        List divertBlackholes = page.getData();
        Map divertBlackholeNpMap = this.blackholeNpDao.blackholeNpByEnableStatus();
        ConfigBlackholeNp configBlackholeNp = (ConfigBlackholeNp)divertBlackholeNpMap.get(blackholeNpForm.getNpIp());
        this.logger.info((Object)("startDivertBlackholeNp divertBlackholeForm BlackIP=" + divertBlackholeForm.getBlackIP() + ", deviceId=" + divertBlackholeForm.getDeviceId() + ", blackMask=" + divertBlackholeForm.getBlackMask() + ", blackholeMode=" + divertBlackholeForm.getBlackholeMode() + ", DeviceIP=" + divertBlackholeForm.getDeviceIP()));
        try {
            if (null != divertBlackholes && !divertBlackholes.isEmpty()) {
                if (null != ((DivertBlackholeForm)divertBlackholes.get(0)).getEnableStatus() && 0 == ((DivertBlackholeForm)divertBlackholes.get(0)).getEnableStatus()) {
                    DivertBlackholeForm divertBlackhole = (DivertBlackholeForm)divertBlackholes.get(0);
                    divertBlackhole.setZoneId(blackholeNpForm.getZoneId());
                    divertBlackhole.setFlowTrigger(true);
                    divertBlackhole.setBlackholeTime(blackholeNpForm.getTimeLong());
                    this.divertBlackholeService.startDivertBlackhole(divertBlackhole);
                    this.blackholeAlarmHandler.blackholeNpAlarmBoardReport(divertBlackholeForm, configBlackholeNp);
                }
            } else {
                divertBlackholeForm.setZoneId(blackholeNpForm.getZoneId());
                divertBlackholeForm.setFlowTrigger(true);
                divertBlackholeForm.setBlackholeTime(blackholeNpForm.getTimeLong());
                this.divertBlackholeService.createAndDeployDivertBlackhole(divertBlackholeForm);
                this.blackholeAlarmHandler.blackholeNpAlarmBoardReport(divertBlackholeForm, configBlackholeNp);
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("create and start DivertBlackhole NP error, BlackholeMode=" + divertBlackholeForm.getBlackholeMode() + ", blackIp=" + divertBlackholeForm.getBlackIP() + ", deviceName=" + divertBlackholeForm.getDeviceName() + ", deviceIP=" + divertBlackholeForm.getDeviceIP()));
            throw e;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
        finally {
            conditionMap.put("blackholeType", String.valueOf(divertBlackholeForm.getBlackholeType()));
            Paging startDivertBlackholeFormPage = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
            List divertBlackholeList = startDivertBlackholeFormPage.getData();
            if (null != divertBlackholeList && !divertBlackholeList.isEmpty() && 0 == ((DivertBlackholeForm)divertBlackholeList.get(0)).getEnableStatus()) {
                this.divertBlackholeService.removeBlackholeNpOfDeployFail((DivertBlackholeForm)divertBlackholeList.get(0));
            }
        }
    }

    private boolean deployDivesion(String zoneIp, AticDevice device, String userName, String terminalIp) {
        ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm;
        String[] zoneIpDetails = zoneIp.split("/");
        DivertTacticsForm divertTacticsForm = new DivertTacticsForm();
        divertTacticsForm.setDivertIp(zoneIpDetails[0]);
        divertTacticsForm.setMask(Integer.valueOf(Integer.parseInt(zoneIpDetails[1])));
        divertTacticsForm.setDivertIpAndMask(zoneIp);
        divertTacticsForm.setCreateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        String[] rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
        divertTacticsForm.setStartIp(rangeIps[0]);
        divertTacticsForm.setEndIp(rangeIps[1]);
        divertTacticsForm.setDivertMode(Integer.valueOf(0));
        long zoneId = 0L;
        Long id = this.zoneService.getZoneIdByIpAndMask(zoneIpDetails[0], Integer.parseInt(zoneIpDetails[1]));
        if (null != id) {
            zoneId = id;
        } else {
            divertTacticsForm.setZoneId(null);
            this.logger.error((Object)"getZoneIdByIpAndMask(),zoneId is null!");
        }
        if (1L != zoneId) {
            divertTacticsForm.setZoneId(Long.valueOf(zoneId));
        }
        divertTacticsForm.setDeviceId(Long.valueOf(device.getMoId()));
        divertTacticsForm.setDeviceName(device.getName());
        if (null != divertTacticsForm.getZoneId() && null == (zoneDeviceDeployStatusForm = this.zoneDeviceDeployStatusService.getByZoneIdAndDeviceId(Long.valueOf(zoneId), Long.valueOf(device.getMoId())))) {
            divertTacticsForm.setZoneId(null);
        }
        if (null == divertTacticsForm.getZoneId()) {
            zoneId = this.zoneService.getDeployDefaultZoneByDeviceId(Long.valueOf(device.getMoId()));
            if (0L != zoneId) {
                divertTacticsForm.setZoneId(Long.valueOf(zoneId));
            } else {
                return false;
            }
        }
        this.logger.info((Object)("deploy divesion divertTacticsForm  startIp:" + divertTacticsForm.getDeviceId() + " startIp:" + divertTacticsForm.getStartIp() + " zoneId:" + divertTacticsForm.getZoneId()));
        divertTacticsForm.setOperator(userName);
        divertTacticsForm.setClientIp(terminalIp + "(auth)");
        DivertTactics divertTactics2 = this.divertTacticsDao.getDivertTacticsByZoneIp(divertTacticsForm.getDeviceId(), divertTacticsForm.getStartIp());
        if (divertTactics2 != null && divertTactics2.getDivertStatus() == 1) {
            return true;
        }
        try {
            this.divertTacticsService.deployAndSaveDivertTactics(divertTacticsForm, 1, true);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private List<AticDevice> getCleanDevices(String deviceIp) {
        List<Object> deviceList = new ArrayList<AticDevice>();
        AticDevice deviceSrc = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == deviceSrc) {
            this.logger.info((Object)("can not find this detect device. deivceIp=" + deviceIp));
            return deviceList;
        }
        boolean isInclude = false;
        List defendGroupList = this.defendGroupDao.getAll();
        for (DefendGroup defendGroup : defendGroupList) {
            if (!defendGroup.getFirewallIds().contains(deviceSrc.getMoId())) continue;
            isInclude = true;
            for (Long deviceId : defendGroup.getFirewallIds()) {
                AticDevice deviceTemp = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                if (0 != deviceTemp.getDdosType()) continue;
                deviceList.add(deviceTemp);
            }
        }
        if (!isInclude) {
            void var7_9;
            this.logger.info((Object)("device " + deviceIp + " belong to default defend group."));
            List cleanDevices = this.aticDeviceService.getCleanDevice();
            int n = cleanDevices.size() - 1;
            while (var7_9 >= 0) {
                AticDevice cleanDevice = (AticDevice)cleanDevices.get((int)var7_9);
                for (DefendGroup defendGroup : defendGroupList) {
                    if (!defendGroup.getFirewallIds().contains(cleanDevice.getMoId())) continue;
                    cleanDevices.remove((int)var7_9);
                    break;
                }
                --var7_9;
            }
            deviceList = cleanDevices;
        }
        for (AticDevice aticDevice : deviceList) {
            this.logger.info((Object)("the last clean firewallList is model=" + aticDevice.getDeviceModel() + ",ddosType=" + aticDevice.getDdosType() + ",Ip=" + aticDevice.getIpAddress() + ",version=" + aticDevice.getVersion()));
        }
        return deviceList;
    }

    private AticDevice checkNEByDeviceIp(String deviceIp) {
        if (null == deviceIp) {
            return new AticDevice();
        }
        AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == device) {
            return new AticDevice();
        }
        return device;
    }

    @Override
    public boolean isBlackholeThresholdTransfinite(DivertBlackholeForm divertBlackholeForm) {
        this.logger.info((Object)"Restful:blackholeNPDivert delete begin.");
        String zoneIp = divertBlackholeForm.getBlackIP();
        String deviceIp = divertBlackholeForm.getDeviceIP();
        int plugThreshold = 0;
        try {
            FaultSeverityRule faultSeverityRule;
            FaultSeverityRuleForm faultSeverityRuleForm;
            ZoneListIpInfo zoneIpInfoList;
            ConfigBlackholeNp configBlackholeNp;
            String zoneIpAndMask = zoneIp + "/" + divertBlackholeForm.getBlackMask();
            if (this.blackholeNpDao.isExist(zoneIpAndMask) && (configBlackholeNp = this.blackholeNpDao.getBlackholeNpByIp(zoneIpAndMask)).getBlackholeThreshold() > 0) {
                plugThreshold = configBlackholeNp.getBlackholeThreshold() * 1024;
            }
            if (null != (zoneIpInfoList = this.zoneListIpDao.getByIpAndMask(zoneIp, divertBlackholeForm.getBlackMask())) && null != zoneIpInfoList.getZoneId() && null != (faultSeverityRuleForm = this.faultSeverityRuleDao.listRuleByZoneId(zoneIpInfoList.getZoneId(), Integer.valueOf(1))) && null != faultSeverityRuleForm.getCriticalRule() && null != (faultSeverityRule = faultSeverityRuleForm.getCriticalRule()) && faultSeverityRule.getInTrafficMbps() > 0 && (plugThreshold == 0 || plugThreshold >= faultSeverityRule.getInTrafficMbps())) {
                plugThreshold = faultSeverityRule.getInTrafficMbps();
            }
            if (plugThreshold == 0) {
                this.logger.warn((Object)"query blackholeThreshold by zoneip is null");
                return false;
            }
            String[] arrIps = this.collectorDao.getAllCollectorIP();
            NotifyFaultSeverityRuleService client = null;
            for (int i = 0; i < arrIps.length; ++i) {
                client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(arrIps[i]);
                if (null == client) {
                    this.logger.warn((Object)("Get NotifyFaultSeverityRuleService interface failed, collector ip is " + arrIps[i]));
                    continue;
                }
                try {
                    if (!client.isBlackholeThresholdTransfinite(deviceIp, zoneIp, Integer.valueOf(plugThreshold))) continue;
                    return true;
                }
                catch (RemoteException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (DataAccessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
        return false;
    }

    @Override
    public void synchronizationBalckholeNP() {
        List blackholeForms = this.blackholeNpDao.queryAllBlackholeNP();
        String[] arrIps = this.collectorDao.getAllCollectorIP();
        NotifyFaultSeverityRuleService client = null;
        for (int i = 0; i < arrIps.length; ++i) {
            client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(arrIps[i]);
            if (client == null) continue;
            try {
                client.saveAllConfigBlackholeNpData(blackholeForms);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public BlackholeNpDao getBlackholeNpDao() {
        return this.blackholeNpDao;
    }

    public void setBlackholeNpDao(BlackholeNpDao blackholeNpDao) {
        this.blackholeNpDao = blackholeNpDao;
    }

    public IDivertBlackholeService getDivertBlackholeService() {
        return this.divertBlackholeService;
    }

    public void setDivertBlackholeService(IDivertBlackholeService divertBlackholeService) {
        this.divertBlackholeService = divertBlackholeService;
    }

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public DefendGroupDao getDefendGroupDao() {
        return this.defendGroupDao;
    }

    public void setDefendGroupDao(DefendGroupDao defendGroupDao) {
        this.defendGroupDao = defendGroupDao;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public IZoneDeviceDeployStatusService getZoneDeviceDeployStatusService() {
        return this.zoneDeviceDeployStatusService;
    }

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }

    public DivertTacticsDao getDivertTacticsDao() {
        return this.divertTacticsDao;
    }

    public void setDivertTacticsDao(DivertTacticsDao divertTacticsDao) {
        this.divertTacticsDao = divertTacticsDao;
    }

    public FaultSeverityRuleDao getFaultSeverityRuleDao() {
        return this.faultSeverityRuleDao;
    }

    public void setFaultSeverityRuleDao(FaultSeverityRuleDao faultSeverityRuleDao) {
        this.faultSeverityRuleDao = faultSeverityRuleDao;
    }

    public ZoneListIpDao getZoneListIpDao() {
        return this.zoneListIpDao;
    }

    public void setZoneListIpDao(ZoneListIpDao zoneListIpDao) {
        this.zoneListIpDao = zoneListIpDao;
    }

    public BlackholeNpFailDao getBlackholeNpFailDao() {
        return this.blackholeNpFailDao;
    }

    public void setBlackholeNpFailDao(BlackholeNpFailDao blackholeNpFailDao) {
        this.blackholeNpFailDao = blackholeNpFailDao;
    }

    public Set<ConfigBlackholeNPFail> getConfigBlackholeNpFails() {
        return this.configBlackholeNpFails;
    }

    public void setConfigBlackholeNpFails(Set<ConfigBlackholeNPFail> configBlackholeNpFails) {
        this.configBlackholeNpFails = configBlackholeNpFails;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public BlackholeAlarmHandler getBlackholeAlarmHandler() {
        return this.blackholeAlarmHandler;
    }

    public void setBlackholeAlarmHandler(BlackholeAlarmHandler blackholeAlarmHandler) {
        this.blackholeAlarmHandler = blackholeAlarmHandler;
    }
}

