/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.ConfigBlackholeApiDao;
import com.hs.atic.bis.dao.ConfigBlackholeDao;
import com.hs.atic.bis.model.ConfigBlackholeApi;
import com.hs.atic.sdk.bis.form.ConfigBlackholeApiForm;
import com.hs.atic.sdk.bis.service.IConfigBlackholeService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CloudCleanUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.service.ICollectorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigBlackholeServiceImpl
implements IConfigBlackholeService {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private ConfigBlackholeDao configBlackholeDao;
    private ICollectorService collectorService;
    private ConfigBlackholeApiDao configBlackholeApiDao;
    private IDataProtectService dataProtectService;

    @Override
    public ConfigBlackholeApiForm getBlackHoleApiConfig() {
        List<ConfigBlackholeApi> list = this.configBlackholeApiDao.getAll();
        if (!list.isEmpty()) {
            ConfigBlackholeApi configBlackhole = list.get(0);
            ConfigBlackholeApiForm form = new ConfigBlackholeApiForm();
            AticUtil.copyProperties((Object)configBlackhole, (Object)form);
            return form;
        }
        this.logger.error((Object)"there no init blackhole api config data exists & return the default values.");
        return new ConfigBlackholeApiForm();
    }

    @Override
    public void saveApi(ConfigBlackholeApiForm form) {
        ConfigBlackholeApi configBlackholeApi = this.configBlackholeApiDao.getApiConfigBySp(form.getServiceProvider());
        if (null == configBlackholeApi.getId()) {
            ConfigBlackholeApi configApi = new ConfigBlackholeApi();
            AticUtil.copyProperties((Object)form, (Object)configApi);
            try {
                this.configBlackholeApiDao.save(configApi);
                AticUtil.setTimeout((int)configApi.getUnblockTime());
            }
            catch (Exception e) {
                this.logger.error((Object)"saveApiConfig error", (Throwable)e);
            }
        } else {
            configBlackholeApi.setUserName(form.getUserName());
            if (null != form.getPassword()) {
                configBlackholeApi.setPassword(form.getPassword());
            }
            configBlackholeApi.setServiceProvider(form.getServiceProvider());
            configBlackholeApi.setEnableStatus(form.getEnableStatus());
            configBlackholeApi.setDefendScope(form.getDefendScope());
            configBlackholeApi.setUrl(form.getUrl());
            configBlackholeApi.setUnblockTime(form.getUnblockTime());
            try {
                this.configBlackholeApiDao.update(configBlackholeApi);
                AticUtil.setTimeout((int)configBlackholeApi.getUnblockTime());
            }
            catch (Exception e) {
                this.logger.error((Object)"updateApiConfig error", (Throwable)e);
            }
        }
    }

    @Override
    public ConfigBlackholeApiForm getConfigApi(String sp) {
        ConfigBlackholeApi configBlackholeApi = this.configBlackholeApiDao.getApiConfigBySp(sp);
        ConfigBlackholeApiForm configBlackholeApiForm = new ConfigBlackholeApiForm();
        AticUtil.copyProperties((Object)configBlackholeApi, (Object)configBlackholeApiForm);
        return configBlackholeApiForm;
    }

    @Override
    public List<ConfigBlackholeApiForm> getServiceProvider() {
        ArrayList<ConfigBlackholeApiForm> formList = new ArrayList<ConfigBlackholeApiForm>();
        List<ConfigBlackholeApi> list = this.configBlackholeApiDao.getAllEnable();
        for (ConfigBlackholeApi configBlackholeApi : list) {
            ConfigBlackholeApiForm blackholeApiForm = new ConfigBlackholeApiForm();
            AticUtil.copyProperties((Object)configBlackholeApi, (Object)blackholeApiForm);
            formList.add(blackholeApiForm);
        }
        return formList;
    }

    @Override
    public Map<String, String> testBlackHoleApiConfig(String serviceProvider, String url, StringBuffer userName, StringBuffer password) {
        Map<String, String> map = null;
        StringBuffer pwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)password.toString());
        if ("CTCC".equals(serviceProvider)) {
            map = CloudCleanUtil.getInstance().getAccountInfo4CTCC(url, userName, pwd);
        }
        return map;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ConfigBlackholeDao getConfigBlackholeDao() {
        return this.configBlackholeDao;
    }

    public void setConfigBlackholeDao(ConfigBlackholeDao configBlackholeDao) {
        this.configBlackholeDao = configBlackholeDao;
    }

    public ConfigBlackholeApiDao getConfigBlackholeApiDao() {
        return this.configBlackholeApiDao;
    }

    public void setConfigBlackholeApiDao(ConfigBlackholeApiDao configBlackholeApiDao) {
        this.configBlackholeApiDao = configBlackholeApiDao;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

