/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.DivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsLogService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDeviceForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DivertTacticsLogServiceImpl
implements IDivertTacticsLogService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private DivertTacticsLogDao divertTacticsLogDao;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.divertTacticsLogDao.queryByPage(queryMap, start, pageSize);
        ArrayList<DivertTacticsLogForm> divertLogFormList = new ArrayList<DivertTacticsLogForm>();
        for (DivertTacticsLog divertTacticsLog : page.getData()) {
            divertLogFormList.add((DivertTacticsLogForm)AticUtil.copyProperties((Object)divertTacticsLog, (Object)new DivertTacticsLogForm()));
        }
        page.setData(divertLogFormList);
        this.logger.info((Object)("query divert tactics log list. size = " + divertLogFormList.size()));
        return page;
    }

    @Override
    public void respondMsgDelDevice(List<AticDeviceForm> deviceList) {
        for (AticDeviceForm device : deviceList) {
            this.logger.info((Object)("delete divert tactics  log while deleting firewall id = " + device.getMoId()));
            this.divertTacticsLogDao.deleteByDeviceId(device.getMoId());
        }
    }

    @Override
    public int deleteLog(Long endTime) {
        return this.divertTacticsLogDao.betchDelete(endTime);
    }

    public DivertTacticsLogDao getDivertTacticsLogDao() {
        return this.divertTacticsLogDao;
    }

    public void setDivertTacticsLogDao(DivertTacticsLogDao divertTacticsLogDao) {
        this.divertTacticsLogDao = divertTacticsLogDao;
    }

    @Override
    public List<DivertTacticsLogForm> getLogsByDivertTacticsLogIdS(String logIds) {
        ArrayList<DivertTacticsLogForm> divertLogFormList = new ArrayList<DivertTacticsLogForm>();
        if (null == logIds || logIds.equals("")) {
            return null;
        }
        String[] logs = logIds.split(",");
        for (int i = 0; i < logs.length; ++i) {
            try {
                Long id = Long.valueOf(logs[i]);
                DivertTacticsLogForm divertTacticsLogForm = this.getById(id);
                if (null == divertTacticsLogForm) continue;
                divertLogFormList.add(divertTacticsLogForm);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Numberformat exception id = " + logs[i]), (Throwable)e);
            }
        }
        return divertLogFormList;
    }

    private DivertTacticsLogForm getById(Long id) {
        if (null == id) {
            this.logger.error((Object)"divert tactics log by id. Id is null");
            return null;
        }
        DivertTacticsLog divertTacticsLog = this.divertTacticsLogDao.get(id);
        if (null == divertTacticsLog) {
            this.logger.warn((Object)"divert tactics log by id, result is null");
            return null;
        }
        DivertTacticsLogForm divertTacticsLogForm = (DivertTacticsLogForm)AticUtil.copyProperties((Object)divertTacticsLog, (Object)new DivertTacticsLogForm());
        this.logger.info((Object)("get divertTacticsLogForm info by id successfuly. Id is : " + id));
        return divertTacticsLogForm;
    }

    @Override
    public DivertTacticsLog getLogDetail(Long logId) {
        DivertTacticsLog divertTacticsLog = this.divertTacticsLogDao.get(logId);
        if (null == divertTacticsLog) {
            this.logger.warn((Object)"divert tactics log by id, result is null");
            return null;
        }
        return divertTacticsLog;
    }
}

