/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.DivertTacticsDao;
import com.hs.atic.bis.dao.DivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.bis.service.ISysQueryDetail;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticDiversionUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.DeviceProxy;
import com.hs.atic.util.DeviceProxyFactory;
import com.hs.atic.util.DivertAlarmHandler;
import com.hs.atic.util.DivertData;
import com.hs.atic.util.DivertDeployResult;
import com.hs.atic.util.DivertRetryDataMangement;
import com.hs.atic.util.SysQueryFactory;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IVpnDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.comm.south.ssh.Ssh2Connector;
import com.huawei.atic.comm.south.telnet.TelnetConnector;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.device.model.StartEndIp;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.ddos.restful.model.RequestURLForm;
import com.huawei.atic.secservice.ddos.restful.model.RestErrorInfo;
import com.huawei.atic.secservice.ddos.restful.service.IRestfulDdosService;
import com.huawei.atic.secservice.ddos.restful.util.RestDdosUtil;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DivertTacticsServiceImpl
implements IDivertTacticsService {
    private static final int BATCH_OPERATION_SUCCESS = 0;
    private static final long RESPONSE_TIME_OUT = 15L;
    private static final int NE_OFF_LINE = -1;
    private static Lock lock = new ReentrantLock();
    private DivertAlarmHandler divertAlarmHandler;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private DivertTacticsDao divertTacticsDao;
    private DivertTacticsLogDao divertTacticsLogDao;
    private IAticDeviceService aticDeviceService;
    private IVpnDeviceService vpnDeviceService;
    private IZoneService zoneService;
    private IZoneDeviceService zoneDeviceService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IRestfulDdosService restfulDdosService;
    private Ssh2Connector sconn;
    private TelnetConnector tconn;

    @Override
    public BatchOperationResult batchAddDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        ArrayList<DivertTactics> divertTacticsList = new ArrayList<DivertTactics>();
        for (BatchOperation bo : boList) {
            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)bo.getExtTargetId();
            divertTacticsForm.setOperator(operator);
            divertTacticsForm.setClientIp(clientIp);
            DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
            divertTacticsList.add(divertTactics);
        }
        if (divertTacticsList.isEmpty()) {
            this.logger.error((Object)"divertTacticsList is null");
            throw new LegoCheckedException(570503L);
        }
        DivertTactics divert = (DivertTactics)divertTacticsList.get(0);
        if (null == this.aticDeviceService.getDeviceByMoid(divert.getDeviceId().longValue())) {
            this.logger.error((Object)("start divert tactics : " + divert.getDeviceName() + ", " + divert.getDivertIp() + " failed, no device exists!"));
            throw new LegoCheckedException(571205L);
        }
        BatchOperationResult result = null;
        try {
            result = this.exeDivertListCmd(boList, divertTacticsList);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)"@execTelnet,EXE CLI ERROR:", (Throwable)e1);
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
        finally {
            if (null != this.sconn) {
                this.logger.info((Object)"@execTelnet,EXE CLI close Telnet connected");
                this.sconn.close();
                this.sconn = null;
            }
            if (null != this.tconn) {
                this.logger.info((Object)"@execTelnet,EXE CLI close Telnet connected");
                this.tconn.close();
                this.tconn = null;
            }
        }
        this.logger.info((Object)("start divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public BatchOperationResult batchCreateDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)bo.getExtTargetId();
            if (null == divertTacticsForm) {
                this.logger.error((Object)"divertTacticsForm is null");
                continue;
            }
            divertTacticsForm.setOperator(operator);
            divertTacticsForm.setClientIp(clientIp);
            DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
            DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
            if (this.isExist(divertTacticsForm)) {
                this.logger.error((Object)"the divert tactics has been existed!");
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 3, 0, Integer.toString(571204));
                divertTactics.setDivertStatus(0);
                bo.setErrorCode(571204L);
                ++fail;
                continue;
            }
            if (null == this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue())) {
                this.logger.error((Object)("start divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed, no device exists!"));
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
                divertTactics.setDivertStatus(0);
                bo.setErrorCode(571205L);
                ++fail;
                continue;
            }
            divertTactics.setDivertStatus(0);
            this.saveDivertTactics((DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()));
            DivertTacticsLogForm divertTacticsLogForms = this.getTacticsLog(divertTactics);
            this.fillDivertLog(divertTacticsLogForms, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 4, 1, "");
            this.logger.info((Object)("save divertTactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp()));
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("start divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public void cascadeDivertByZoneDel(List<BatchOperation> zoneDelResult) {
        for (BatchOperation bo : zoneDelResult) {
            if (bo.getErrorCode() != 0L) continue;
            List<DivertTactics> divertTacticList = this.divertTacticsDao.getDivertListByZoneId(bo.getTargetId());
            if (divertTacticList.isEmpty()) {
                this.logger.info((Object)("no divert tactics existed while deleting zone : " + this.getcleanedMessage(bo.getTargetName())));
                return;
            }
            this.stopAndDelDivertList(divertTacticList);
        }
    }

    private Integer cmdResult(String cmdResult) {
        if (cmdResult.contains("Error: Invalid IP address")) {
            return 571208;
        }
        if (cmdResult.contains("Error: The number of IP addresses of traffic diversion reaches limit already")) {
            return 571209;
        }
        if (cmdResult.contains("Error: Please specify IP address of next hop first")) {
            return 571210;
        }
        if (cmdResult.contains("Error: Traffic IP addresses conflict")) {
            return 571211;
        }
        if (cmdResult.contains("Error: The IP address does not exist")) {
            return 1;
        }
        if (cmdResult.contains("Error: This traffic diversion policy does not exist")) {
            return 571212;
        }
        if (cmdResult.contains("Route-Distinguisher has not been set to this VPN-Instance")) {
            return 571214;
        }
        if (cmdResult.contains("The specified VPN-Instance does not exist")) {
            return 571215;
        }
        if (cmdResult.contains("The static route of this policy is the same as an existing one")) {
            return 571216;
        }
        if (cmdResult.contains("Info: The system is busy in collecting the current configuration. Please wait...")) {
            return 571217;
        }
        if (cmdResult.contains("The system is busy in saving or comparing the current configuration. Please wait...")) {
            return 571217;
        }
        if (cmdResult.contains("Error:")) {
            return 570503;
        }
        return 1;
    }

    private int cmdStatusCode(int statusCode, String errorMsg) {
        if (400 == statusCode) {
            return 571221;
        }
        if (403 == statusCode) {
            return 571223;
        }
        if (401 == statusCode) {
            return 571222;
        }
        if (414 == statusCode) {
            return 571224;
        }
        if (408 == statusCode) {
            if (!StringUtils.isEmpty((String)errorMsg)) {
                if ("Connection timed out".contains(errorMsg.trim())) {
                    return 571226;
                }
                if ("Read timed out".contains(errorMsg.trim())) {
                    return 571227;
                }
            }
            return 571226;
        }
        return 571225;
    }

    private Integer cmdResultOfDispaly(String cmdResultOfDispaly) {
        if (cmdResultOfDispaly.contains("Summary Count : 1")) {
            return 1;
        }
        return 571992;
    }

    public void createDivertTactics(DivertTacticsForm divertTacticsForm) {
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
        AticDevice firewall = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
        if (null == firewall) {
            this.logger.error((Object)("start divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed, no device exists!"));
            divertTacticsLogForm.setOperator(divertTacticsForm.getOperator());
            divertTacticsLogForm.setClientIp(divertTacticsForm.getClientIp());
            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
            divertTactics.setDivertStatus(0);
            throw new LegoCheckedException(571205L);
        }
        divertTactics.setDeviceName(firewall.getName());
        this.logger.info((Object)("save divert tactics device name : " + divertTactics.getDeviceName()));
        if (this.zoneService.getById(divertTactics.getZoneId()).getZoneType() == 1) {
            if (this.vpnDeviceService.isVpnExcluded(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128))) {
                this.logger.info((Object)("IP is in exclude list. zoneIp=" + divertTactics.getDivertIp()));
            } else if (!this.vpnDeviceService.isVpnIncluded(divertTactics.getDeviceId(), divertTactics.getZoneId())) {
                this.logger.info((Object)("IP is not in include list. zoneIp=" + divertTactics.getDivertIp()));
            } else {
                String vpnName = this.vpnDeviceService.getIncludedVpn(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128));
                divertTactics.setVpnName(vpnName);
            }
        }
        divertTactics.setDivertStatus(0);
        DivertTacticsForm dTForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
        if (this.isExist(dTForm)) {
            this.logger.error((Object)"the divert tactics has been existed!");
            throw new LegoCheckedException(571204L);
        }
        this.saveDivertTactics(dTForm);
        DivertTacticsLogForm divertTacticsLogForms = this.getTacticsLog(divertTactics);
        divertTacticsLogForms.setOperator(divertTacticsForm.getOperator());
        divertTacticsLogForms.setClientIp(divertTacticsForm.getClientIp());
        divertTacticsLogForms.setVpnName(dTForm.getVpnName());
        this.fillDivertLog(divertTacticsLogForms, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 4, 1, "");
        this.logger.info((Object)("save divertTactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp()));
    }

    public BatchOperationResult deleteDivertTactics(List<BatchOperation> boList, boolean isRestful, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            DivertTactics divertTactics = null;
            DivertTacticsLogForm divertTacticsLogForm = null;
            try {
                divertTactics = this.divertTacticsDao.get(bo.getTargetId());
                if (null == divertTactics) {
                    this.logger.error((Object)("delete divert tactics :" + this.getcleanedMessage(bo.getTargetName()) + " failed,  this divert has not been existed."));
                    bo.setErrorCode(571201L);
                    ++fail;
                    continue;
                }
                divertTactics.setOperator(operator);
                divertTactics.setClientIp(clientIp);
                divertTacticsLogForm = this.getTacticsLog(divertTactics);
                int statuts = this.aticDeviceService.getStatusByMoid(divertTactics.getDeviceId().longValue());
                if (statuts == -1) {
                    if (isRestful) {
                        ++fail;
                        continue;
                    }
                    DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                    this.removeDivertTactics(divertTacticsForm);
                    continue;
                }
                Long errorCode = null;
                if (divertTactics.getDivertStatus() != null && divertTactics.getDivertStatus() == 1) {
                    try {
                        this.stopSigleDivertTactics((DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()), false, 0);
                    }
                    catch (LegoCheckedException e) {
                        errorCode = e.getErrorCode();
                        if (571212 == errorCode.intValue()) {
                            this.logger.info((Object)"isStopDivert = true");
                        } else {
                            this.logger.info((Object)"isStopDivert = false");
                        }
                        ++fail;
                        bo.setErrorCode(errorCode.longValue());
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("stop divert : " + divertTactics.getDeviceName() + " : " + divertTactics.getDivertIp() + " error when deleting divert whose status is on."));
                        ++fail;
                        continue;
                    }
                }
                DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                this.tellToStopAlarm(divertTacticsForm);
                this.removeDivertTactics(divertTacticsForm);
                this.logger.info((Object)("delete divert tactics :" + this.getcleanedMessage(bo.getTargetName()) + " sucessfully."));
            }
            catch (Exception e) {
                this.logger.error((Object)("delete divert tactics :" + this.getcleanedMessage(bo.getTargetName()) + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE, 3, 0, "del.exception");
                ++fail;
                bo.setErrorCode(570507L);
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("delete divert result, success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult deleteAllDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        try {
            for (BatchOperation bo : boList) {
                DivertTacticsLogForm divertTacticsLogForm = new DivertTacticsLogForm();
                divertTacticsLogForm.setDeviceId(bo.getTargetId());
                divertTacticsLogForm.setLogTime(System.currentTimeMillis() / 1000L);
                divertTacticsLogForm.setDivertIp("--");
                divertTacticsLogForm.setZoneId(0L);
                divertTacticsLogForm.setOperator(operator);
                divertTacticsLogForm.setClientIp(clientIp);
                AticDevice device = this.aticDeviceService.getDeviceByMoid(bo.getTargetId());
                if (null == device) {
                    ++fail;
                    bo.setErrorCode(570503L);
                    this.logger.error((Object)("device not exist while delete all divert tasks. device id: " + bo.getTargetId()));
                    continue;
                }
                bo.setTargetName(device.getName());
                divertTacticsLogForm.setDeviceName(device.getName());
                int statuts = this.aticDeviceService.getStatusByMoid(bo.getTargetId());
                if (statuts == -1) {
                    ++fail;
                    bo.setErrorCode(570503L);
                    this.logger.error((Object)("device offline while delete all divert tasks. device name: " + device.getName()));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 0, String.valueOf(570503));
                    continue;
                }
                ArrayList<String> cmds = new ArrayList<String>();
                cmds.add("system-view");
                cmds.add("undo firewall ddos traffic-diversion ip all");
                cmds.add("y");
                cmds.add("undo firewall ddos traffic-diversion ipv6 all");
                cmds.add("y");
                List<String> vpnNames = this.divertTacticsDao.getVpnNameByDevId(bo.getTargetId());
                if (!vpnNames.isEmpty()) {
                    for (String vpnName : vpnNames) {
                        cmds.add("undo firewall ddos traffic-diversion vpn-instance " + vpnName + " ip all");
                        cmds.add("y");
                        cmds.add("undo firewall ddos traffic-diversion vpn6-instance " + vpnName + " ipv6 all");
                        cmds.add("y");
                    }
                }
                try {
                    this.aticDeviceService.execNoResultCmd(cmds, bo.getTargetId());
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 1, "");
                }
                catch (LegoCheckedException e) {
                    bo.setErrorCode(e.getErrorCode());
                    ++fail;
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 0, String.valueOf(e.getErrorCode()));
                    this.logger.error((Object)"deploy undo all divert task command failed.", (Throwable)e);
                }
            }
        }
        finally {
            this.divertTacticsDao.deleteAll();
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("delete divert result, success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public void deleteStaticDivertByPolicy(Long zoneId, Long firewallId) {
        if (null == zoneId || null == firewallId) {
            this.logger.error((Object)"delete static divert tactics error, zoneId or firewallId is null");
            return;
        }
        List<DivertTactics> divertList = this.divertTacticsDao.getStaticDivertByZoneIdAndFirewallId(zoneId, firewallId);
        for (DivertTactics divert : divertList) {
            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divert, (Object)new DivertTacticsForm());
            this.removeDivertTactics(divertTacticsForm);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deployAndSaveDivertTactics(DivertTacticsForm divertTacticsForm, int replayNum, boolean createAlarm) {
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        AticDevice device = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
        if (null == device) {
            this.logger.error((Object)("start divert tactics failed, no device exists, deviceId=" + divertTactics.getDeviceId() + ", deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
            this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
            divertTactics.setDivertStatus(0);
            throw new LegoCheckedException(571205L);
        }
        divertTactics.setDeviceName(device.getName());
        if (null != this.zoneDeviceService) {
            Long zoneId = divertTactics.getZoneId();
            Long deviceId = divertTactics.getDeviceId();
            String vpnName = "";
            if (null != zoneId && null != deviceId) {
                ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
                if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                    vpnName = zoneDeviceForm.getVpnName();
                }
                divertTactics.setVpnName(vpnName);
            }
        }
        DeviceProxy proxy = null;
        String command = AticDiversionUtil.getDivertCommand(divertTactics, "DEPLOY");
        DivertTacticsLogForm saveLogForm = this.getTacticsLog(divertTactics);
        String cmdResult = "";
        String cmdResultOfDisplay = "";
        try {
            proxy = DeviceProxyFactory.createDeviceProxy(divertTactics.getDeviceId(), this.aticDeviceService);
            this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
            if (command == null || "".equals(command)) {
                this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                divertTactics.setDivertStatus(0);
                return;
            }
            cmdResult = proxy.executeCommand(command);
            this.logger.info((Object)("deploy cmdResult is " + cmdResult));
            Integer errorCode = this.cmdResult(cmdResult);
            this.logger.info((Object)("deploy command result errorCode is " + errorCode));
            if (errorCode == 1) {
                DivertTacticsForm dTForm;
                if (device.getVersion().contains("V100R001") || device.getVersion().contains("V500R001C00")) {
                    DivertTacticsForm dTForm2;
                    String commandOfDisplay = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAY");
                    if (IPUtil.isIpv4((String)divertTactics.getDivertIp()) && 32 == divertTactics.getMask() || IPUtil.isIpv6((String)divertTactics.getDivertIp()) && 128 == divertTactics.getMask()) {
                        DivertTacticsForm dTForm3;
                        int firstLineBeginIndex;
                        cmdResultOfDisplay = proxy.executeCommand(commandOfDisplay);
                        if (CommonUtil.isNull((String)commandOfDisplay)) {
                            this.logger.info((Object)("the divert commandOfDisplay is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + ", deviceName=" + divertTactics.getDeviceName()));
                        }
                        if (-1 != (firstLineBeginIndex = cmdResultOfDisplay.indexOf("\n"))) {
                            cmdResultOfDisplay = commandOfDisplay + cmdResultOfDisplay.substring(firstLineBeginIndex + 1, cmdResultOfDisplay.length());
                        }
                        this.logger.info((Object)("deploy cmdResultOfDisplay is " + this.getcleanedMessage(cmdResultOfDisplay)));
                        Integer errorCodeOfDispaly = this.cmdResultOfDispaly(cmdResultOfDisplay);
                        if (1 != errorCodeOfDispaly) {
                            divertTactics.setDivertStatus(0);
                            this.logger.error((Object)("start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                            throw new LegoCheckedException((long)errorCodeOfDispaly.intValue());
                        }
                        this.logger.info((Object)("start divert tactics success, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp() + ", divertTactics=" + divertTactics));
                        this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultOfDisplay);
                        divertTactics.setDivertStatus(1);
                        if (createAlarm) {
                            this.logger.info((Object)("deployAndSaveDivertTactics alarm " + this.getcleanedMessage(divertTactics.toString())));
                            this.divertAlarmHandler.divertAlarmStart(divertTactics, device.getIpAddress());
                        }
                        if (!this.isExist(dTForm3 = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()))) return;
                        DivertTactics divertTactics2 = this.divertTacticsDao.getDivertTacticsByZoneIp(dTForm3.getDeviceId(), dTForm3.getStartIp());
                        if (null == divertTactics2) return;
                        divertTactics2.setDivertStatus(1);
                        this.divertTacticsDao.update(divertTactics2);
                        return;
                    }
                    this.logger.info((Object)("start divert tactics success, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp() + ", divertTactics=" + divertTactics));
                    this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, "");
                    divertTactics.setDivertStatus(1);
                    if (createAlarm) {
                        this.logger.info((Object)("deployAndSaveDivertTactics alarm " + this.getcleanedMessage(divertTactics.toString())));
                        this.divertAlarmHandler.divertAlarmStart(divertTactics, device.getIpAddress());
                    }
                    if (!this.isExist(dTForm2 = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()))) return;
                    DivertTactics divertTactics2 = this.divertTacticsDao.getDivertTacticsByZoneIp(dTForm2.getDeviceId(), dTForm2.getStartIp());
                    if (null == divertTactics2) return;
                    divertTactics2.setDivertStatus(1);
                    this.divertTacticsDao.update(divertTactics2);
                    return;
                }
                String commandOfC20 = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAYOFC20");
                if (commandOfC20 == null || "".equals(commandOfC20)) {
                    this.logger.info((Object)("the divert commandOfC20 is null or empty, this task no need be display. deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                    return;
                }
                cmdResultOfDisplay = proxy.executeCommand(commandOfC20);
                Integer errorCodeOfDisplayOfC20 = this.cmdResultOfDispaly(cmdResultOfDisplay);
                int firstLineBeginIndex = cmdResultOfDisplay.indexOf("\n");
                if (-1 != firstLineBeginIndex) {
                    cmdResultOfDisplay = commandOfC20 + cmdResultOfDisplay.substring(firstLineBeginIndex + 1, cmdResultOfDisplay.length());
                }
                if (1 != errorCodeOfDisplayOfC20) {
                    divertTactics.setDivertStatus(0);
                    this.logger.error((Object)("start divert tactics failed\uff0c deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                    throw new LegoCheckedException((long)errorCodeOfDisplayOfC20.intValue());
                }
                this.logger.info((Object)("start divert tactics success, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp() + ", divertTactics=" + divertTactics));
                this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultOfDisplay);
                divertTactics.setDivertStatus(1);
                if (createAlarm) {
                    this.logger.info((Object)("deployAndSaveDivertTactics alarm " + this.getcleanedMessage(divertTactics.toString())));
                    this.divertAlarmHandler.divertAlarmStart(divertTactics, device.getIpAddress());
                }
                if (!this.isExist(dTForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()))) return;
                DivertTactics divertTactics2 = this.divertTacticsDao.getDivertTacticsByZoneIp(dTForm.getDeviceId(), dTForm.getStartIp());
                if (null == divertTactics2) return;
                divertTactics2.setDivertStatus(1);
                this.divertTacticsDao.update(divertTactics2);
                return;
            }
            divertTactics.setDivertStatus(0);
            this.logger.error((Object)("start divert tactics failed\uff0c deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
            throw new LegoCheckedException((long)errorCode.intValue());
        }
        catch (LegoCheckedException e) {
            divertTactics.setDivertStatus(0);
            this.logger.error((Object)("start divert tactics failed\uff0c deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()), (Throwable)e);
            if (571992L == e.getErrorCode()) {
                this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultOfDisplay);
            } else if (570503L == e.getErrorCode()) {
                this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResult);
            } else {
                this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(e.getErrorCode()));
            }
            if (0 == replayNum && createAlarm) {
                this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + this.getcleanedMessage(device.getIpAddress())));
                this.divertAlarmHandler.divertAlarmStartFailed(divertTactics, device.getIpAddress());
            }
            if (571217L == e.getErrorCode()) {
                try {
                    int sleepTime = AticDiversionUtil.getRetryDivertSleepTime();
                    this.logger.info((Object)("telnet auto dirver system busying, need sleep and sleepTime is " + sleepTime));
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)"telnet auto dirver system busying error");
                }
            }
            this.replayDivert(divertTactics, device, 1, replayNum);
            throw e;
        }
        catch (Exception e) {
            divertTactics.setDivertStatus(0);
            this.logger.error((Object)("start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()), (Throwable)e);
            this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "firewall.exception");
            if (0 == replayNum && createAlarm) {
                this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + this.getcleanedMessage(device.getIpAddress())));
                this.divertAlarmHandler.divertAlarmStartFailed(divertTactics, device.getIpAddress());
            }
            this.replayDivert(divertTactics, device, 1, replayNum);
            throw new LegoCheckedException(570507L, (Throwable)e);
        }
        finally {
            DivertTacticsForm dTForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
            if (!this.isExist(dTForm)) {
                this.saveDivertTactics(dTForm);
                this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 4, 1, "");
                this.logger.info((Object)("save divertTactics, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
            }
            if (proxy != null) {
                proxy.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployAndSaveDivertTacticsByRestful(List<DivertTacticsForm> divertTacticsFormList, int replayNum, boolean createAlarm) {
        HashMap divertTacticsMap = new HashMap();
        HashMap<Long, AticDevice> deviceMap = new HashMap<Long, AticDevice>();
        HashMap<Long, Boolean> deviceExistMap = new HashMap<Long, Boolean>();
        long startTime = System.currentTimeMillis();
        for (DivertTacticsForm divertTacticsForm : divertTacticsFormList) {
            String vpnName;
            DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
            Long deviceId = divertTactics.getDeviceId();
            if (null == deviceExistMap.get(deviceId)) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
                if (null == device) {
                    deviceExistMap.put(deviceId, false);
                    this.logger.error((Object)("start divert tactics failed, no device exists, deviceId=" + divertTactics.getDeviceId() + ", deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                    this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, "no.device");
                    divertTactics.setDivertStatus(0);
                    this.createDivertTacticsAndLog(divertTactics);
                    continue;
                }
                deviceExistMap.put(deviceId, true);
                deviceMap.put(deviceId, device);
                divertTactics.setDeviceName(device.getName());
            } else {
                if (!((Boolean)deviceExistMap.get(deviceId)).booleanValue()) {
                    this.logger.error((Object)("start divert tactics failed, no device exists, deviceId=" + divertTactics.getDeviceId() + ", deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                    this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, "no.device");
                    divertTactics.setDivertStatus(0);
                    this.createDivertTacticsAndLog(divertTactics);
                    continue;
                }
                divertTactics.setDeviceName(((AticDevice)deviceMap.get(deviceId)).getName());
            }
            if (null != this.zoneDeviceService) {
                Long zoneId = divertTactics.getZoneId();
                String vpnName2 = "";
                if (null != zoneId && null != deviceId) {
                    ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
                    if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                        vpnName2 = zoneDeviceForm.getVpnName();
                    }
                    divertTactics.setVpnName(vpnName2);
                }
            }
            if (null == (vpnName = AticDiversionUtil.calcDivertVPN(divertTactics))) {
                this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                divertTactics.setDivertStatus(0);
                this.createDivertTacticsAndLog(divertTactics);
                continue;
            }
            if (null == divertTacticsMap.get(deviceId)) {
                divertTacticsMap.put(deviceId, new ArrayList());
            }
            ((List)divertTacticsMap.get(deviceId)).add(divertTactics);
        }
        long endTime = System.currentTimeMillis();
        this.logger.info((Object)("deployAndSaveDivertTacticsByRestful, init data use time=" + (endTime - startTime)));
        long deployStartTime = endTime;
        for (Map.Entry entry : divertTacticsMap.entrySet()) {
            Long deviceId = (Long)entry.getKey();
            List<DivertTactics> divertTacticsList = (ArrayList<DivertTactics>)entry.getValue();
            AticDevice device = (AticDevice)deviceMap.get(deviceId);
            RequestURLForm requestURLForm = RestDdosUtil.getRequestURLForm((AticDevice)device);
            boolean canDeploy = true;
            int deployTimes = 0;
            while (canDeploy) {
                String msg;
                startTime = System.currentTimeMillis();
                DeviceProxy proxy = null;
                ArrayList<DivertTactics> needRetryDivertTacticsList = new ArrayList<DivertTactics>();
                canDeploy = false;
                this.logger.info((Object)("start DeployTimes = " + ++deployTimes + ", deviceId is " + deviceId + ", the diverts size is " + divertTacticsList.size()));
                String body = this.translateDivert(divertTacticsList, true);
                try {
                    List<DivertTactics> divertTacticsOKList;
                    DivertDeployResult divertDeployResult;
                    Result result = this.restfulDdosService.restDdosAddDivertTactics((Object)body, requestURLForm);
                    this.logger.info((Object)("deployAndSaveDivertTacticsByRestful, restDdosAddDivertTactics() use time=" + (System.currentTimeMillis() - startTime)));
                    startTime = System.currentTimeMillis();
                    int errorCode = result.getStatusCode();
                    this.logger.info((Object)("deploy result is " + result.toString()));
                    if (errorCode == 201) {
                        long errorCode4Proxy = 571225L;
                        for (DivertTactics divertTactics : divertTacticsList) {
                            long startTelnetTime = System.currentTimeMillis();
                            DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
                            String commandOfC20 = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAYOFC20");
                            if (commandOfC20 == null || "".equals(commandOfC20)) {
                                this.logger.error((Object)("the divert commandOfC20 is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + " device:" + divertTactics.getDeviceId()));
                                continue;
                            }
                            try {
                                if (null == proxy) {
                                    proxy = DeviceProxyFactory.createDeviceProxy(deviceId, this.aticDeviceService);
                                }
                                String cmdResultDisplayOfC20 = proxy.executeCommand(commandOfC20);
                                Integer errorCodeOfDisplayOfC20 = this.cmdResultOfDispaly(cmdResultDisplayOfC20);
                                int firstLineBeginIndex = cmdResultDisplayOfC20.indexOf("\n");
                                if (-1 != firstLineBeginIndex) {
                                    cmdResultDisplayOfC20 = commandOfC20 + cmdResultDisplayOfC20.substring(firstLineBeginIndex + 1, cmdResultDisplayOfC20.length());
                                }
                                this.logger.info((Object)("deployAndSaveDivertTacticsByRestful, proxy.executeCommand() use time=" + (System.currentTimeMillis() - startTelnetTime)));
                                String msg2 = "deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp();
                                if (1 == errorCodeOfDisplayOfC20) {
                                    this.logger.info((Object)("start divert tactics : " + msg2 + " successfully."));
                                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 4, 1, cmdResultDisplayOfC20);
                                    divertTactics.setDivertStatus(1);
                                    if (createAlarm) {
                                        this.logger.info((Object)("deployAndSaveDivertTacticsByRestful create alarm " + msg2));
                                        this.divertAlarmHandler.divertAlarmStart(divertTactics, device.getIpAddress());
                                    }
                                    this.saveDivertTacticsOnConc(divertTactics);
                                    continue;
                                }
                                divertTactics.setDivertStatus(0);
                                this.logger.error((Object)("start divert tactics : " + msg2 + " failed."));
                                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, cmdResultDisplayOfC20);
                                needRetryDivertTacticsList.add(divertTactics);
                                errorCode4Proxy = errorCodeOfDisplayOfC20.intValue();
                            }
                            catch (LegoCheckedException e) {
                                divertTactics.setDivertStatus(0);
                                this.logger.error((Object)("start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp() + ", LegoCheckedException=" + (Object)((Object)e)));
                                needRetryDivertTacticsList.add(divertTactics);
                                errorCode4Proxy = e.getErrorCode();
                            }
                            catch (Exception e) {
                                divertTactics.setDivertStatus(0);
                                this.logger.error((Object)("start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp() + ", Exception=" + e));
                                this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, "firewall.exception");
                                needRetryDivertTacticsList.add(divertTactics);
                            }
                        }
                        this.logger.info((Object)("deployAndSaveDivertTacticsByRestful, proxy.executeCommand() and save total use time=" + (System.currentTimeMillis() - startTime)));
                        startTime = System.currentTimeMillis();
                        if (needRetryDivertTacticsList.isEmpty()) continue;
                        divertTacticsList = needRetryDivertTacticsList;
                        throw new LegoCheckedException(errorCode4Proxy);
                    }
                    RestErrorInfo errorInfo = RestDdosUtil.translateResult((Result)result);
                    this.logger.error((Object)("start divert tactics failed, errorCode=" + errorCode + ", errorMessage=" + errorInfo.getErrorMessage() + ", errorPath=" + errorInfo.getErrorPath()));
                    if (StringUtils.isEmpty((String)errorInfo.getErrorPath()) || !errorInfo.getErrorPath().contains("ip-address")) {
                        throw new LegoCheckedException((long)this.cmdStatusCode(errorCode, errorInfo.getErrorMessage()));
                    }
                    if (AticDiversionUtil.isNumberLimitMax(errorCode, errorInfo)) {
                        divertDeployResult = this.getFailDivertTacticsList(errorInfo, divertTacticsList);
                        divertTacticsOKList = divertDeployResult.getDivertTacticsOKList();
                        this.createDivertTacticsAndLog(divertTacticsOKList, device, createAlarm);
                        divertDeployResult.addDivertTactics2UnExecListOnFirst(divertDeployResult.getDivertTacticsFail());
                        divertTacticsList = divertDeployResult.getDivertTacticsUnExecList();
                        throw new LegoCheckedException(571209L);
                    }
                    if (AticDiversionUtil.isDeviceBusying(errorCode, errorInfo)) {
                        divertDeployResult = this.getFailDivertTacticsList(errorInfo, divertTacticsList);
                        divertTacticsOKList = divertDeployResult.getDivertTacticsOKList();
                        this.createDivertTacticsAndLog(divertTacticsOKList, device, createAlarm);
                        divertDeployResult.addDivertTactics2UnExecListOnFirst(divertDeployResult.getDivertTacticsFail());
                        divertTacticsList = divertDeployResult.getDivertTacticsUnExecList();
                        throw new LegoCheckedException(571217L);
                    }
                    divertDeployResult = this.getFailDivertTacticsList(errorInfo, divertTacticsList);
                    divertTacticsOKList = divertDeployResult.getDivertTacticsOKList();
                    this.createDivertTacticsAndLog(divertTacticsOKList, device, createAlarm);
                    DivertTactics divertTacticsFail = divertDeployResult.getDivertTacticsFail();
                    divertTacticsFail.setDivertStatus(0);
                    String msg3 = "deviceName=" + divertTacticsFail.getDeviceName() + ", zoneIp=" + divertTacticsFail.getDivertIp();
                    this.logger.error((Object)("start divert tactics failed, " + msg3));
                    this.fillDivertLog(this.getTacticsLog(divertTacticsFail), AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, String.valueOf(this.cmdResult(errorInfo.getErrorMessage())));
                    if (createAlarm) {
                        this.logger.info((Object)("deployAndSaveDivertTacticsByRestful create alarm : " + this.getcleanedMessage(msg3)));
                        this.divertAlarmHandler.divertAlarmStartFailed(divertTacticsFail, device.getIpAddress());
                    }
                    this.saveDivertTacticsOnConc(divertTacticsFail);
                    divertTacticsList = divertDeployResult.getDivertTacticsUnExecList();
                    throw new LegoCheckedException((long)this.cmdResult(errorInfo.getErrorMessage()).intValue());
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"start divert tactics happened exception.", (Throwable)e);
                    for (DivertTactics divertTactics : divertTacticsList) {
                        divertTactics.setDivertStatus(0);
                        msg = "deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp();
                        this.logger.error((Object)("start divert tactics failed, " + msg));
                        this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, String.valueOf(e.getErrorCode()));
                        if (0 != replayNum || !createAlarm) continue;
                        this.logger.error((Object)("enter the divertAlarmStartFailed create alarm :" + msg));
                        this.divertAlarmHandler.divertAlarmStartFailed(divertTactics, device.getIpAddress());
                    }
                    if (replayNum > 0 && 571209L != e.getErrorCode()) {
                        canDeploy = true;
                        --replayNum;
                    }
                    if (!canDeploy || 571217L != e.getErrorCode()) continue;
                    int sleepTime = AticDiversionUtil.getRetryDivertSleepTime();
                    this.logger.error((Object)("because device system busying, need sleep and sleepTime is " + sleepTime));
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        this.logger.error((Object)"sleep happened error.", (Throwable)e1);
                    }
                }
                catch (DocumentException e) {
                    this.logger.error((Object)"start divert tactics happened exception.", (Throwable)e);
                    for (DivertTactics divertTactics : divertTacticsList) {
                        divertTactics.setDivertStatus(0);
                        msg = "deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp();
                        this.logger.error((Object)("start divert tactics failed, " + msg));
                        this.fillDivertLog(this.getTacticsLog(divertTactics), AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 3, 0, "firewall.exception");
                        if (0 != replayNum || !createAlarm) continue;
                        this.logger.error((Object)("enter the divertAlarmStartFailed create alarm :" + msg));
                        this.divertAlarmHandler.divertAlarmStartFailed(divertTactics, device.getIpAddress());
                    }
                    if (replayNum <= 0) continue;
                    canDeploy = true;
                    --replayNum;
                }
                finally {
                    if (null == proxy) continue;
                    proxy.close();
                }
            }
            for (DivertTactics divertTactics : divertTacticsList) {
                this.createDivertTacticsAndLog(divertTactics);
            }
        }
        this.logger.info((Object)("deployAndSaveDivertTacticsByRestful, deploy total use time=" + (System.currentTimeMillis() - deployStartTime)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDivertTacticsOnConc(DivertTactics divertTactics) {
        boolean isCreate = false;
        if (null == divertTactics) {
            this.logger.error((Object)"can't save null divertTactics");
            return;
        }
        divertTactics.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp()));
        divertTactics.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp()));
        DivertTactics divertDB = this.divertTacticsDao.getDivertWithSamePolicy(divertTactics);
        if (null != divertDB) {
            divertDB.setDivertStatus(divertTactics.getDivertStatus());
            this.divertTacticsDao.update(divertDB);
        } else {
            try {
                lock.lock();
                divertDB = this.divertTacticsDao.getDivertWithSamePolicy(divertTactics);
                if (null != divertDB) {
                    divertDB.setDivertStatus(divertTactics.getDivertStatus());
                    this.divertTacticsDao.update(divertDB);
                } else {
                    this.divertTacticsDao.saveOrUpdate(divertTactics);
                    isCreate = true;
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (isCreate) {
            DivertTacticsLogForm saveLogForm = this.getTacticsLog(divertTactics);
            this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE_REST, 4, 1, "");
            this.logger.info((Object)("save divertTactics, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
        }
    }

    private void createDivertTacticsAndLog(DivertTactics divertTactics) {
        this.saveDivertTacticsOnConc(divertTactics);
    }

    private void createDivertTacticsAndLog(List<DivertTactics> divertTacticsList, AticDevice device, boolean createAlarm) {
        if (null != divertTacticsList) {
            for (DivertTactics divertTactics : divertTacticsList) {
                DivertTacticsLogForm saveLogForm = this.getTacticsLog(divertTactics);
                this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, 4, 1, "");
                divertTactics.setDivertStatus(1);
                String msg = "deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp();
                if (createAlarm) {
                    this.logger.info((Object)("create alarm " + msg));
                    this.divertAlarmHandler.divertAlarmStart(divertTactics, device.getIpAddress());
                }
                this.saveDivertTacticsOnConc(divertTactics);
            }
        }
    }

    private void stopDivertTacticsAndLog(List<DivertTactics> divertTacticsList, AticDevice device) {
        if (null != divertTacticsList) {
            for (DivertTactics divertTactics : divertTacticsList) {
                this.logger.info((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " successfully."));
                DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 4, 1, "");
                divertTactics.setDivertStatus(0);
                this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
                DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                this.removeDivertTacticsByRestful(divertTacticsForm);
                this.logger.info((Object)("remove the divert,  deviceId=" + divertTactics.getDeviceId() + ", divertIp=" + divertTactics.getDivertIp() + ", mask=" + divertTactics.getMask()));
            }
        }
    }

    private DivertDeployResult getFailDivertTacticsList(RestErrorInfo errorInfo, List<DivertTactics> divertTacticsList) {
        String ip = AticDiversionUtil.parseIpFromErrorPath(errorInfo.getErrorPath());
        this.logger.info((Object)("the divert fail, divertIp = " + ip));
        DivertDeployResult divertDeployResult = new DivertDeployResult();
        int size = divertTacticsList.size();
        for (int i = 0; i < size; ++i) {
            DivertTactics divertTactics = divertTacticsList.get(i);
            if (ip.equals(divertTactics.getDivertIp())) {
                divertDeployResult.setDivertTacticsFail(divertTactics);
                List<DivertTactics> list = divertTacticsList.subList(i + 1, size);
                if (list.isEmpty()) break;
                divertDeployResult.addDivertTactics2UnExecList(list);
                break;
            }
            divertDeployResult.addDivertTactics2OKList(divertTactics);
        }
        return divertDeployResult;
    }

    private String translateDivert(List<DivertTactics> divertTacticsList, boolean isDeploy) {
        String xmlDivert = "";
        Document document = DocumentHelper.createDocument();
        if (null != divertTacticsList && !divertTacticsList.isEmpty()) {
            Element root = document.addElement("traffic-diversion");
            for (DivertTactics divertTactics : divertTacticsList) {
                Element ipType = null;
                ipType = IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? root.addElement("ipv4") : root.addElement("ipv6");
                if (!isDeploy) {
                    Element deleteEle = ipType.addElement("delete");
                    deleteEle.setText("true");
                }
                Element vpnName = ipType.addElement("vpn-instance");
                if (!StringUtils.isEmpty((String)divertTactics.getVpnName())) {
                    vpnName.setText(divertTactics.getVpnName());
                }
                Element divertIp = ipType.addElement("ip-address");
                divertIp.setText(DivertTacticsServiceImpl.dealNull(divertTactics.getDivertIp()));
                Element mask = ipType.addElement("ip-mask");
                mask.setText(DivertTacticsServiceImpl.dealNull(divertTactics.getMask()));
            }
            xmlDivert = document.asXML();
        }
        return xmlDivert;
    }

    private static String dealNull(Object str) {
        return null != str ? str.toString() : "";
    }

    private BatchOperationResult exeDivertListCmd(List<BatchOperation> boList, List<DivertTactics> divertTacticsList) {
        BatchOperationResult result = new BatchOperationResult();
        HashMap<Long, DeviceProxy> proxyMap = new HashMap<Long, DeviceProxy>();
        DeviceProxy proxy = null;
        int fail = 0;
        List<String> cmdList = AticDiversionUtil.getDivertCommandAsList(divertTacticsList, "DEPLOY");
        String strRetVal = null;
        if (!cmdList.isEmpty()) {
            this.logger.info((Object)("cmd List size:" + cmdList.size() + "; diveretTactics List size:" + divertTacticsList.size() + "; boList size:" + boList.size()));
            for (int i = 0; i < cmdList.size(); ++i) {
                DivertTactics divertTactics = divertTacticsList.get(i);
                DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
                BatchOperation bo = boList.get(i);
                if (this.divertTacticsDao.isExist(divertTactics)) {
                    this.logger.error((Object)"the divert tactics has been existed!");
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, Integer.toString(571204));
                    divertTactics.setDivertStatus(0);
                    bo.setErrorCode(571204L);
                    ++fail;
                    continue;
                }
                proxy = (DeviceProxy)proxyMap.get(divertTactics.getDeviceId());
                if (proxy == null) {
                    proxy = DeviceProxyFactory.createDeviceProxy(divertTactics.getDeviceId(), this.aticDeviceService);
                    proxyMap.put(divertTactics.getDeviceId(), proxy);
                }
                try {
                    if (null == this.tconn && null == this.sconn) {
                        this.getConnector(divertTactics.getDeviceId());
                    }
                    if (null != this.tconn) {
                        strRetVal = this.tconn.executeCommand(cmdList.get(i));
                    } else if (null != this.sconn) {
                        strRetVal = this.sconn.executeCommand(cmdList.get(i));
                    }
                    this.logger.info((Object)("@execTelnet,Command[" + this.getcleanedMessage(cmdList.get(i)) + "],Result:" + this.getcleanedMessage(strRetVal)));
                    if (strRetVal == null) {
                        this.logger.error((Object)"strRetVal is null");
                        return new BatchOperationResult();
                    }
                    Integer errorCode = this.cmdResult(strRetVal);
                    this.logger.info((Object)("deploy command result errorCode is " + errorCode));
                    if (errorCode == 1) {
                        AticDevice device = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
                        if (device.getVersion().contains("V100R001") || device.getVersion().contains("V500R001C00")) {
                            if (IPUtil.isIpv4((String)divertTactics.getDivertIp()) && 32 == divertTactics.getMask() || IPUtil.isIpv6((String)divertTactics.getDivertIp()) && 128 == divertTactics.getMask()) {
                                Integer errorCodeOfDispaly;
                                String commandOfDisplay = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAY");
                                if (commandOfDisplay == null || "".equals(commandOfDisplay)) {
                                    this.logger.error((Object)("the divert commandOfDisplay is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + " device:" + divertTactics.getDeviceId()));
                                    continue;
                                }
                                String cmdResultOfDisplay = proxy.executeCommand(commandOfDisplay);
                                int firstLineBeginIndex = cmdResultOfDisplay.indexOf("\n");
                                if (-1 != firstLineBeginIndex) {
                                    cmdResultOfDisplay = commandOfDisplay + cmdResultOfDisplay.substring(firstLineBeginIndex + 1, cmdResultOfDisplay.length());
                                }
                                if (1 == (errorCodeOfDispaly = this.cmdResultOfDispaly(cmdResultOfDisplay))) {
                                    this.logger.info((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultOfDisplay);
                                    divertTactics.setDivertStatus(1);
                                    this.divertTacticsDao.saveOrUpdate(divertTactics);
                                    continue;
                                }
                                this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultOfDisplay);
                                bo.setErrorCode((long)errorCodeOfDispaly.intValue());
                                ++fail;
                                continue;
                            }
                            this.logger.info((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, "");
                            divertTactics.setDivertStatus(1);
                            this.divertTacticsDao.saveOrUpdate(divertTactics);
                            continue;
                        }
                        String commandOfC20 = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAYOFC20");
                        if (commandOfC20 == null || "".equals(commandOfC20)) {
                            this.logger.error((Object)("the divert commandOfC20 is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + " device:" + divertTactics.getDeviceId()));
                            continue;
                        }
                        String cmdResultDisplayOfC20 = proxy.executeCommand(commandOfC20);
                        Integer errorCodeOfDisplayOfC20 = this.cmdResultOfDispaly(cmdResultDisplayOfC20);
                        int firstLineBeginIndex = cmdResultDisplayOfC20.indexOf("\n");
                        if (-1 != firstLineBeginIndex) {
                            cmdResultDisplayOfC20 = commandOfC20 + cmdResultDisplayOfC20.substring(firstLineBeginIndex + 1, cmdResultDisplayOfC20.length());
                        }
                        if (1 == errorCodeOfDisplayOfC20) {
                            this.logger.info((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultDisplayOfC20);
                            divertTactics.setDivertStatus(1);
                            divertTactics.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp()));
                            divertTactics.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp()));
                            this.divertTacticsDao.saveOrUpdate(divertTactics);
                            continue;
                        }
                        this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultDisplayOfC20);
                        bo.setErrorCode((long)errorCodeOfDisplayOfC20.intValue());
                        ++fail;
                        continue;
                    }
                    divertTactics.setDivertStatus(0);
                    this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                    if (570503 == errorCode) {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, strRetVal);
                    } else {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(errorCode));
                    }
                    bo.setErrorCode((long)errorCode.intValue());
                    ++fail;
                    continue;
                }
                catch (LegoCheckedException e) {
                    divertTactics.setDivertStatus(0);
                    this.logger.error((Object)("start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()), (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(e.getErrorCode()));
                    ++fail;
                    bo.setErrorCode(e.getErrorCode());
                    continue;
                }
                catch (Exception e) {
                    divertTactics.setDivertStatus(0);
                    this.logger.error((Object)("start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()), (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "firewall.exception");
                    ++fail;
                    bo.setErrorCode(570507L);
                }
            }
        } else {
            return result;
        }
        Collection proxies = proxyMap.values();
        for (DeviceProxy deviceProxy : proxies) {
            deviceProxy.close();
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    @Override
    public void fillDivertLog(DivertTacticsLogForm divertTacticsLogForm, int operType, int logLevel, int result, String remark) {
        if (null == divertTacticsLogForm) {
            return;
        }
        divertTacticsLogForm.setOperType(operType);
        divertTacticsLogForm.setLevel(logLevel);
        divertTacticsLogForm.setRemark(remark);
        divertTacticsLogForm.setResult(result);
        DivertTacticsLog divertTacticsLog = (DivertTacticsLog)AticUtil.copyProperties((Object)divertTacticsLogForm, (Object)new DivertTacticsLog());
        divertTacticsLog.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTacticsLog.getStartIp()));
        divertTacticsLog.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTacticsLog.getEndIp()));
        this.divertTacticsLogDao.saveOrUpdate(divertTacticsLog);
    }

    private void getConnector(long devid) {
        try {
            boolean isSsh = false;
            TelnetPara telPoto = this.aticDeviceService.getDeviceTelnetPara(devid);
            if (null == telPoto) {
                this.logger.info((Object)"@execCmd,Telnet paras not config");
                throw new LegoCheckedException(660010L);
            }
            if (0 == telPoto.getProtocolType()) {
                this.logger.info((Object)"@execCmd,prepare use TELNET exec");
                isSsh = false;
            } else {
                this.logger.info((Object)"@execCmd,prepare use SSH exec");
                isSsh = true;
            }
            if (isSsh) {
                this.sconn = this.getSshConn(telPoto);
                this.sconn.executeCommand("system-view");
            } else {
                this.tconn = this.getTelnetConn(telPoto);
                this.tconn.executeCommand("system-view");
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)"@execTelnet,EXE CLI ERROR:", (Throwable)e1);
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
    }

    @Override
    public Set<Long> getDevIdsByDivertIds(Long[] divertIds) {
        HashSet<Long> result = new HashSet<Long>();
        if (divertIds == null) {
            return result;
        }
        if (0L == divertIds[0]) {
            List<Long> devIds = this.divertTacticsDao.getDistinctDevIds();
            for (Long devId : devIds) {
                result.add(devId);
            }
        } else {
            for (Long each : divertIds) {
                DivertTactics divertTactics = this.divertTacticsDao.get(each);
                if (null == divertTactics) continue;
                result.add(divertTactics.getDeviceId());
            }
        }
        return result;
    }

    public List<DivertTacticsForm> getDivertTacticsByIp(String startIp, String endIp) {
        ArrayList<DivertTacticsForm> divertTacticsForms = new ArrayList<DivertTacticsForm>();
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertByIp(startIp, endIp);
        for (DivertTactics divertTactic : divertTactics) {
            DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
            AticUtil.copyProperties((Object)divertTactic, (Object)dtDivertTacticsForm);
            divertTacticsForms.add(dtDivertTacticsForm);
        }
        return divertTacticsForms;
    }

    @Override
    public List<DivertTacticsForm> getDivertTacticsStatusByIp(String startIp, String endIp) {
        ArrayList<DivertTacticsForm> divertTacticsForms = new ArrayList<DivertTacticsForm>();
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertStatusByIp(startIp, endIp);
        for (DivertTactics divertTactic : divertTactics) {
            DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
            AticUtil.copyProperties((Object)divertTactic, (Object)dtDivertTacticsForm);
            divertTacticsForms.add(dtDivertTacticsForm);
        }
        return divertTacticsForms;
    }

    public List<DivertTacticsForm> getDivertTacticsByZoneId(Long zoneId) {
        ArrayList<DivertTacticsForm> divertTacticsForms = new ArrayList<DivertTacticsForm>();
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        for (DivertTactics divertTactic : divertTactics) {
            DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
            AticUtil.copyProperties((Object)divertTactic, (Object)dtDivertTacticsForm);
            divertTacticsForms.add(dtDivertTacticsForm);
        }
        return divertTacticsForms;
    }

    private Ssh2Connector getSshConn(TelnetPara telPoto) {
        Ssh2Connector conn = new Ssh2Connector();
        String host = telPoto.getNode().getIpAddress();
        String username = telPoto.getLoginUser();
        StringBuffer password = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getLoginPwd());
        long loginTimeOut = telPoto.getLoginTimeout();
        int port = telPoto.getPort();
        long timeOut = 15L;
        this.logger.info((Object)("@execCmd,SSH paras : " + telPoto.toString()));
        try {
            conn.setHostKey(telPoto.getHostKey());
            conn.connect(host, port, username, password, loginTimeOut, timeOut);
            this.logger.info((Object)"@execCmd,SSH connect sueccess");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"@execCmd,Can not connect device by SSH! \n LegoCheckedException:", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)"@execCmd,Can not connect device by SSH! \n", (Throwable)e1);
            throw new LegoCheckedException(660010L, (Throwable)e1);
        }
        return conn;
    }

    private DivertTacticsLogForm getTacticsLog(DivertTactics divertTactics) {
        DivertTacticsLogForm divertTacticsLogForm = new DivertTacticsLogForm();
        divertTacticsLogForm.setZoneId(divertTactics.getZoneId());
        divertTacticsLogForm.setDeviceId(divertTactics.getDeviceId());
        divertTacticsLogForm.setOperator(divertTactics.getOperator());
        divertTacticsLogForm.setClientIp(divertTactics.getClientIp());
        String ipAddress = divertTactics.getDivertIp();
        if (ipAddress.contains("/")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("/"));
        }
        divertTacticsLogForm.setDivertIp(ipAddress);
        divertTactics.setDivertIp(ipAddress);
        String[] ipRange = IPUtil.getSubnetRange((String)ipAddress, (int)divertTactics.getMask());
        if (ipRange != null && ipRange.length == 2) {
            divertTacticsLogForm.setStartIp(ipRange[0]);
            divertTacticsLogForm.setEndIp(ipRange[1]);
        }
        if (!AticUtil.isNull((String)divertTactics.getVpnName())) {
            divertTacticsLogForm.setVpnName(divertTactics.getVpnName());
        } else {
            divertTacticsLogForm.setVpnName("--");
        }
        divertTacticsLogForm.setMask(divertTactics.getMask());
        divertTacticsLogForm.setLogTime(System.currentTimeMillis() / 1000L);
        divertTacticsLogForm.setDivertMode(divertTactics.getDivertMode());
        return divertTacticsLogForm;
    }

    private TelnetConnector getTelnetConn(TelnetPara telPoto) {
        TelnetConnector conn = new TelnetConnector();
        String host = telPoto.getNode().getIpAddress();
        String username = telPoto.getLoginUser();
        StringBuffer password = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getLoginPwd());
        int authMode = telPoto.getAuthMode();
        long loginTimeOut = telPoto.getLoginTimeout();
        int port = telPoto.getPort();
        long timeOut = 15L;
        this.logger.info((Object)("@execCmd,Telnet paras : " + telPoto.toString()));
        try {
            conn.connect(host, port, authMode, username, password, loginTimeOut, timeOut);
            this.logger.info((Object)"@execCmd,Telnet connect success");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"@execCmd,Can not connected by Telnet!\n", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)"@execCmd,Can not connect device by Telnet!", (Throwable)e1);
            throw new LegoCheckedException(660010L, (Throwable)e1);
        }
        return conn;
    }

    public int getZoneDivertState(long zoneId) {
        int startDivertFlag = 0;
        int stopDivertFlag = 0;
        List<DivertTactics> tasks = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        if (!tasks.isEmpty()) {
            for (DivertTactics each : tasks) {
                int mode;
                if (each.getNfaId() != 0L && (mode = this.zonePolicyApplyService.queryZoneDivertMode(Long.valueOf(zoneId))) == 1) {
                    return 3;
                }
                if (null != each.getDivertStatus() && 1 == each.getDivertStatus()) {
                    ++startDivertFlag;
                }
                if (null == each.getDivertStatus() || 0 != each.getDivertStatus()) continue;
                ++stopDivertFlag;
            }
            if (startDivertFlag > 0 && stopDivertFlag > 0) {
                return 2;
            }
            if (startDivertFlag > 0 && stopDivertFlag == 0) {
                return 1;
            }
            if (startDivertFlag == 0 && stopDivertFlag > 0) {
                return 0;
            }
            if (startDivertFlag == 0 && stopDivertFlag == 0) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean isExist(DivertTacticsForm divertTacticsForm) {
        return this.divertTacticsDao.isExist((DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics()));
    }

    public Boolean isHaveDivertTask(Long zoneId) {
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        if (!divertTactics.isEmpty()) {
            return true;
        }
        return false;
    }

    public Boolean isHaveDivertTask(Long zoneId, Long deviceId) {
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertByZoneIdAndNeId(zoneId, deviceId);
        if (!divertTactics.isEmpty()) {
            return true;
        }
        return false;
    }

    public Boolean isHaveStartDivertTask(Long zoneId) {
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        if (!divertTactics.isEmpty()) {
            for (DivertTactics divertTactic : divertTactics) {
                if (1 != divertTactic.getDivertStatus()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isHaveStartDivertTask(Long zoneId, Long deviceId) {
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertByZoneIdAndNeId(zoneId, deviceId);
        if (!divertTactics.isEmpty()) {
            for (DivertTactics divertTactic : divertTactics) {
                if (1 != divertTactic.getDivertStatus()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void modifyDivertVPN(Long zoneId, Long deviceId, String vpnName) {
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertByZoneIdAndNeId(zoneId, deviceId);
        if (!divertTactics.isEmpty()) {
            for (DivertTactics divertTactic : divertTactics) {
                if (null == divertTactic.getDeviceId() || 0 != divertTactic.getDivertStatus()) continue;
                this.logger.info((Object)("modify divert task deviceId=" + divertTactic.getDeviceId() + ", vpnName=" + divertTactic.getVpnName() + ", change after vpnName=" + vpnName));
                divertTactic.setVpnName(vpnName);
                this.divertTacticsDao.update(divertTactic);
            }
        }
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.divertTacticsDao.queryByPage(queryMap, start, pageSize);
        List divertTacticsList = page.getData();
        String detail = queryMap.get("detail");
        if (!AticUtil.isNull((String)detail)) {
            Iterator itor = divertTacticsList.iterator();
            while (itor.hasNext()) {
                DivertTactics each = (DivertTactics)itor.next();
                long nfaId = each.getNfaId();
                ISysQueryDetail sysQuery = (ISysQueryDetail)SysQueryFactory.getInstance().getThirdServiceByName("ISysQueryDetail");
                if (sysQuery != null) {
                    if (sysQuery.isContainDetail(nfaId, detail)) continue;
                    itor.remove();
                    continue;
                }
                this.logger.error((Object)"service SysQueryDetail is null");
            }
        }
        ArrayList<DivertTacticsForm> divertTacticFormList = new ArrayList<DivertTacticsForm>();
        for (DivertTactics divertTactics : divertTacticsList) {
            divertTacticFormList.add((DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()));
        }
        page.setData(divertTacticFormList);
        this.logger.info((Object)("query divert tactics list. size = " + divertTacticsList.size()));
        return page;
    }

    public void removeDivertForBackoutNe(Long zoneId, Long deviceId) {
        List<DivertTactics> divertTactics = this.divertTacticsDao.getDivertByZoneIdAndNeId(zoneId, deviceId);
        if (!divertTactics.isEmpty()) {
            for (DivertTactics divertTactic : divertTactics) {
                if (null == divertTactic.getDeviceId()) continue;
                this.divertTacticsDao.remove(divertTactic.getId());
                DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactic);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE, 4, 1, "");
            }
        }
    }

    @Override
    public void removeDivertTacticsByRestful(DivertTacticsForm divertTacticsForm) {
        if (null == divertTacticsForm) {
            this.logger.error((Object)"can't delete DivertTactics by null id");
            return;
        }
        this.divertTacticsDao.remove(divertTacticsForm.getId());
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_REST, 4, 1, "");
    }

    @Override
    public void removeDivertTactics(DivertTacticsForm divertTacticsForm) {
        if (null == divertTacticsForm) {
            this.logger.error((Object)"can't delete DivertTactics by null id");
            return;
        }
        this.divertTacticsDao.remove(divertTacticsForm.getId());
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE, 4, 1, "");
    }

    private void replayDivert(DivertTactics divertTactics, AticDevice device, int policy, int replayNum) {
        if (replayNum > 0) {
            DivertData divertData = new DivertData(divertTactics, policy, replayNum - 1);
            DivertRetryDataMangement.addRetryDivertData(device.getIpAddress(), divertData);
        }
    }

    @Override
    public void resetZoneNameForAddDefault(Long zoneId, Long devId) {
        List<DivertTactics> divertTacticsList = this.divertTacticsDao.getDivertListByDeviceId(devId);
        if (!divertTacticsList.isEmpty()) {
            for (DivertTactics divertTactics : divertTacticsList) {
                if (!AticConstants.ADD_DIVERT_ZONE_ID.equals(divertTactics.getZoneId())) continue;
                divertTactics.setZoneId(zoneId);
                this.divertTacticsDao.update(divertTactics);
            }
        }
    }

    public void resetZoneNameForDivert(long zoneId) {
        List<DivertTactics> divertTacticsList = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        if (!divertTacticsList.isEmpty()) {
            for (DivertTactics divertTactics : divertTacticsList) {
                this.logger.info((Object)("resetZoneName for " + divertTactics.getDeviceName()));
                divertTactics.setZoneId(AticConstants.ADD_DIVERT_ZONE_ID);
                this.divertTacticsDao.update(divertTactics);
            }
        }
    }

    public void resetZoneNameForDivert(long zoneId, Set<Long> deviceIds) {
        List<DivertTactics> divertTacticsList = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        if (!divertTacticsList.isEmpty()) {
            for (DivertTactics divertTactics : divertTacticsList) {
                if (!deviceIds.contains(divertTactics.getDeviceId())) continue;
                divertTactics.setZoneId(AticConstants.ADD_DIVERT_ZONE_ID);
                this.divertTacticsDao.update(divertTactics);
            }
        }
    }

    @Override
    public void respondMsgDelDevice(List<AticDeviceForm> deviceList) {
        for (AticDeviceForm device : deviceList) {
            try {
                if (null == device) continue;
                this.logger.info((Object)("device id: " + device.getMoId()));
                if (device.getDeviceType() != 1) continue;
                List<DivertTactics> divertTacticList = this.divertTacticsDao.getDivertListByDeviceId(device.getMoId());
                if (divertTacticList.isEmpty()) {
                    this.logger.info((Object)("no divert tactics existed while deleting firewall id = " + device.getMoId()));
                    continue;
                }
                for (DivertTactics divertTactics : divertTacticList) {
                    DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                    if (null == divertTacticsForm) {
                        this.logger.error((Object)"can't delete DivertTactics by null id");
                        continue;
                    }
                    this.logger.info((Object)("delete divert tactics while deleting firewall id = " + device.getMoId()));
                    this.divertTacticsDao.remove(divertTacticsForm.getId());
                    this.logger.info((Object)("device ip is " + this.getcleanedMessage(device.getIpAddress())));
                    this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    @Override
    public void saveDivertTactics(DivertTacticsForm divertTacticsForm) {
        if (null == divertTacticsForm) {
            this.logger.error((Object)"can't save null divertTactics");
            return;
        }
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        if (null != this.zoneDeviceService) {
            Long zoneId = divertTactics.getZoneId();
            Long deviceId = divertTactics.getDeviceId();
            if (null != zoneId && null != deviceId && (divertTactics.getVpnName() == null || "".equals(divertTactics.getVpnName()))) {
                String vpnName = "";
                ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
                if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                    vpnName = zoneDeviceForm.getVpnName();
                }
                divertTactics.setVpnName(vpnName);
            }
        }
        divertTactics.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp()));
        divertTactics.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp()));
        this.divertTacticsDao.saveOrUpdate(divertTactics);
        this.logger.info((Object)("save divertTactics, deviceName=" + divertTacticsForm.getDeviceName() + ", zoneIp=" + divertTacticsForm.getDivertIp()));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public BatchOperationResult startDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        HashMap<Long, DeviceProxy> proxyMap = new HashMap<Long, DeviceProxy>();
        DeviceProxy proxy = null;
        for (BatchOperation bo : boList) {
            DivertTactics divertTactics = null;
            DivertTacticsLogForm divertTacticsLogForm = null;
            try {
                divertTactics = this.divertTacticsDao.get(bo.getTargetId());
                if (null == divertTactics) {
                    bo.setErrorCode(571201L);
                    ++fail;
                    this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, this divert tactics not exists!"));
                    continue;
                }
                divertTacticsLogForm = this.getTacticsLog(divertTactics);
                divertTacticsLogForm.setOperator(operator);
                divertTacticsLogForm.setClientIp(clientIp);
                if (1 == divertTactics.getDivertStatus()) {
                    bo.setErrorCode(571206L);
                    ++fail;
                    this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, started already!"));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "already.start");
                    continue;
                }
                Long devId = divertTactics.getDeviceId();
                if (null == this.aticDeviceService.getDeviceByMoid(devId.longValue())) {
                    bo.setErrorCode(571205L);
                    ++fail;
                    this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, no device exists!"));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
                    continue;
                }
                proxy = (DeviceProxy)proxyMap.get(devId);
                if (proxy == null) {
                    proxy = DeviceProxyFactory.createDeviceProxy(devId, this.aticDeviceService);
                    proxyMap.put(devId, proxy);
                }
                String command = AticDiversionUtil.getDivertCommand(divertTactics, "DEPLOY");
                this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
                if (command == null || "".equals(command)) {
                    this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. zoneIp=" + divertTactics.getDivertIp() + ", deviceId=" + divertTactics.getDeviceId()));
                    continue;
                }
                String cmdResult = proxy.executeCommand(command);
                this.logger.info((Object)("deploy cmdResult is " + cmdResult));
                Integer errorCode = this.cmdResult(cmdResult);
                this.logger.info((Object)("deploy command result errorCode is " + errorCode));
                if (errorCode == 1) {
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                    if (device.getVersion().contains("V100R001") || device.getVersion().contains("V500R001C00")) {
                        if (IPUtil.isIpv4((String)divertTactics.getDivertIp()) && 32 == divertTactics.getMask() || IPUtil.isIpv6((String)divertTactics.getDivertIp()) && 128 == divertTactics.getMask()) {
                            Integer errorCodeOfDispaly;
                            String commandOfDisplay = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAY");
                            if (commandOfDisplay == null || "".equals(commandOfDisplay)) {
                                this.logger.info((Object)("the divert commandOfDisplay is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + ", deviceId=" + divertTactics.getDeviceId()));
                                continue;
                            }
                            String cmdResultOfDisplay = proxy.executeCommand(commandOfDisplay);
                            int firstLineBeginIndex = cmdResultOfDisplay.indexOf("\n");
                            if (-1 != firstLineBeginIndex) {
                                cmdResultOfDisplay = commandOfDisplay + cmdResultOfDisplay.substring(firstLineBeginIndex + 1, cmdResultOfDisplay.length());
                            }
                            if (1 == (errorCodeOfDispaly = this.cmdResultOfDispaly(cmdResultOfDisplay))) {
                                this.logger.info((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultOfDisplay);
                                divertTactics.setDivertStatus(1);
                                this.divertTacticsDao.saveOrUpdate(divertTactics);
                                continue;
                            }
                            this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultOfDisplay);
                            bo.setErrorCode((long)errorCodeOfDispaly.intValue());
                            ++fail;
                            continue;
                        }
                        this.logger.info((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, "");
                        divertTactics.setDivertStatus(1);
                        this.divertTacticsDao.saveOrUpdate(divertTactics);
                        continue;
                    }
                    String commandOfC20 = AticDiversionUtil.getDivertCommand(divertTactics, "DISPLAYOFC20");
                    if (commandOfC20 == null || "".equals(commandOfC20)) {
                        this.logger.info((Object)("the divert commandOfC20 is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + ", deviceId=" + divertTactics.getDeviceId()));
                        continue;
                    }
                    String cmdResultDisplayOfC20 = proxy.executeCommand(commandOfC20);
                    Integer errorCodeOfDisplayOfC20 = this.cmdResultOfDispaly(cmdResultDisplayOfC20);
                    int firstLineBeginIndex = cmdResultDisplayOfC20.indexOf("\n");
                    if (-1 != firstLineBeginIndex) {
                        cmdResultDisplayOfC20 = commandOfC20 + cmdResultDisplayOfC20.substring(firstLineBeginIndex + 1, cmdResultDisplayOfC20.length());
                    }
                    if (1 == errorCodeOfDisplayOfC20) {
                        this.logger.info((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultDisplayOfC20);
                        divertTactics.setDivertStatus(1);
                        this.divertTacticsDao.saveOrUpdate(divertTactics);
                        continue;
                    }
                    this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultDisplayOfC20);
                    bo.setErrorCode((long)errorCodeOfDisplayOfC20.intValue());
                    ++fail;
                    continue;
                }
                this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                if (570503 == errorCode) {
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResult);
                } else {
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(errorCode));
                }
                bo.setErrorCode((long)errorCode.intValue());
                ++fail;
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(e.getErrorCode()));
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                if (null == divertTactics || proxyMap.isEmpty() || !proxyMap.containsKey(divertTactics.getDeviceId())) continue;
                proxyMap.remove(divertTactics.getDeviceId());
            }
            catch (Exception e) {
                this.logger.error((Object)("start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "firewall.exception");
                ++fail;
                bo.setErrorCode(570507L);
                if (proxyMap.isEmpty() || !proxyMap.containsKey(divertTactics.getDeviceId())) continue;
                proxyMap.remove(divertTactics.getDeviceId());
            }
        }
        Collection proxies = proxyMap.values();
        Iterator iterator = proxies.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                proxy = (DeviceProxy)iterator.next();
                if (proxy == null) continue;
                proxy.close();
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("start divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public void stopAndDelDivert(DivertTacticsForm divertTacticsForm) {
        this.logger.info((Object)("remove the divert : " + this.getcleanedMessage(divertTacticsForm.toString()) + " by thread."));
        if (1 == divertTacticsForm.getDivertStatus()) {
            try {
                this.stopSigleDivertTactics(divertTacticsForm, false, 0);
            }
            catch (LegoCheckedException e) {
                Long errorCode = e.getErrorCode();
                if (571212 == errorCode.intValue()) {
                    this.removeDivertTactics(divertTacticsForm);
                    this.tellToStopAlarm(divertTacticsForm);
                }
                return;
            }
            catch (Exception e) {
                this.logger.error((Object)"stop divert tactics occurs error when deleting firewall info.", (Throwable)e);
                return;
            }
        }
        this.removeDivertTactics(divertTacticsForm);
    }

    private void stopAndDelDivertList(List<DivertTactics> divertTacticList) {
        for (DivertTactics divertTactics : divertTacticList) {
            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
            if (1 == divertTacticsForm.getDivertStatus()) {
                try {
                    this.stopSigleDivertTactics(divertTacticsForm, true, 0);
                }
                catch (LegoCheckedException e) {
                    Long errorCode = e.getErrorCode();
                    if (571212 == errorCode.intValue()) {
                        this.removeDivertTactics(divertTacticsForm);
                        this.tellToStopAlarm(divertTacticsForm);
                    }
                    this.resetZoneNameForDivert(divertTacticsForm.getZoneId());
                    continue;
                }
                catch (Exception e) {
                    this.resetZoneNameForDivert(divertTacticsForm.getZoneId());
                    this.logger.error((Object)"stop divert tactics occurs error when deleting firewall info.", (Throwable)e);
                    continue;
                }
            }
            this.removeDivertTactics(divertTacticsForm);
        }
    }

    public void stopAndDelDivertTacticsByZoneId(long zoneId) {
        List<DivertTactics> divertTacticList = this.divertTacticsDao.getDivertListByZoneId(zoneId);
        if (!divertTacticList.isEmpty()) {
            this.stopAndDelDivertList(divertTacticList);
        }
    }

    @Override
    public BatchOperationResult stopDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        Collection proxies;
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        HashMap<Long, DeviceProxy> proxyMap = new HashMap<Long, DeviceProxy>();
        DeviceProxy proxy2 = null;
        if (null != boList && !boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                DivertTactics divertTactics = null;
                DivertTacticsLogForm divertTacticsLogForm = null;
                try {
                    divertTactics = this.divertTacticsDao.get(bo.getTargetId());
                    if (null == divertTactics) {
                        this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, this divert tactics not exists!"));
                        bo.setErrorCode(571201L);
                        ++fail;
                        continue;
                    }
                    divertTactics.setOperator(operator);
                    divertTactics.setClientIp(clientIp);
                    divertTacticsLogForm = this.getTacticsLog(divertTactics);
                    if (0 == divertTactics.getDivertStatus()) {
                        this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, stopped already!"));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "already.stop");
                        bo.setErrorCode(571207L);
                        ++fail;
                        continue;
                    }
                    Long devId = divertTactics.getDeviceId();
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                    if (null == device) {
                        this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, no device exists!"));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "no.device");
                        bo.setErrorCode(571205L);
                        ++fail;
                        continue;
                    }
                    divertTactics.setDeviceName(device.getName());
                    this.logger.info((Object)("save divert tactics device name : " + divertTactics.getDeviceName()));
                    proxy2 = (DeviceProxy)proxyMap.get(devId);
                    if (proxy2 == null) {
                        proxy2 = DeviceProxyFactory.createDeviceProxy(devId, this.aticDeviceService);
                        proxyMap.put(devId, proxy2);
                    }
                    String command = AticDiversionUtil.getDivertCommand(divertTactics, "UNDEPLOY");
                    this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
                    if (command == null || "".equals(command)) {
                        this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. zoneIp=" + divertTactics.getDivertIp() + ", deviceId=" + divertTactics.getDeviceId()));
                        continue;
                    }
                    String cmdResult = proxy2.executeCommand(command);
                    this.logger.info((Object)("deploy cmdResult is " + cmdResult));
                    Integer errorCode = this.cmdResult(cmdResult);
                    this.logger.info((Object)("deploy command result errorCode is " + errorCode));
                    if (errorCode == 1) {
                        this.logger.info((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 4, 1, "");
                        divertTactics.setDivertStatus(0);
                        this.divertTacticsDao.saveOrUpdate(divertTactics);
                        this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
                        continue;
                    }
                    this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                    if (570503 == errorCode) {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, cmdResult);
                    } else {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(errorCode));
                    }
                    bo.setErrorCode((long)errorCode.intValue());
                    ++fail;
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    bo.setErrorCode(e.getErrorCode());
                    this.logger.error((Object)"stop divert tactics failed.", (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(e.getErrorCode()));
                    if (null != divertTactics) {
                        if (null != divertTactics.getDeviceId()) {
                            if (proxyMap.isEmpty() || !proxyMap.containsKey(divertTactics.getDeviceId())) continue;
                            proxyMap.remove(divertTactics.getDeviceId());
                            continue;
                        }
                        this.logger.error((Object)"stop divert tactics failed. deviceId is null.");
                        continue;
                    }
                    this.logger.error((Object)"stop divert tactics failed. divertTactics is null.");
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)"stop divert tactics failed.", (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "firewall.exception");
                    if (proxyMap.isEmpty() || !proxyMap.containsKey(divertTactics.getDeviceId())) continue;
                    proxyMap.remove(divertTactics.getDeviceId());
                }
            }
        }
        if ((proxies = proxyMap.values()) != null) {
            for (DeviceProxy proxy2 : proxies) {
                if (proxy2 == null) continue;
                proxy2.close();
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList == null ? 0 : boList.size());
        result.setSucceedCount(boList == null ? 0 : boList.size() - fail);
        this.logger.info((Object)("stop divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public DivertTacticsForm stopSigleDivertTactics(DivertTacticsForm divertTacticsForm, boolean isThread, int replayNum) {
        block35: {
            DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
            if (null == this.divertTacticsDao.get(divertTactics.getId())) {
                this.logger.error((Object)("stop divert tactics :" + divertTactics.getDivertIp() + " failed,  this divert does't exist."));
                throw new LegoCheckedException(571212L);
            }
            DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
            AticDevice device = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
            if (null == device) {
                this.logger.error((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed, no device exists!"));
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "no.device");
                throw new LegoCheckedException(571205L);
            }
            divertTactics.setDeviceName(device.getName());
            this.logger.info((Object)("save divert tactics device name : " + divertTactics.getDeviceName()));
            if (null != this.zoneDeviceService) {
                Long zoneId = divertTactics.getZoneId();
                Long deviceId = divertTactics.getDeviceId();
                if (null != zoneId && null != deviceId) {
                    String vpnName = "";
                    ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
                    if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                        vpnName = zoneDeviceForm.getVpnName();
                    }
                    divertTactics.setVpnName(vpnName);
                }
            }
            Integer errorCode = 570503;
            DeviceProxy proxy = null;
            String cmdResult = "";
            try {
                proxy = DeviceProxyFactory.createDeviceProxy(divertTactics.getDeviceId(), this.aticDeviceService);
                String command = AticDiversionUtil.getDivertCommand(divertTactics, "UNDEPLOY");
                if (null != divertTactics.getVpnName() && !"".equals(divertTactics.getVpnName())) {
                    divertTacticsLogForm.setVpnName(divertTactics.getVpnName());
                }
                this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
                if (command == null || "".equals(command)) {
                    if (!isThread) {
                        divertTactics.setDivertStatus(0);
                    }
                    this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. zoneIp=" + divertTactics.getDivertIp() + ", deviceId=" + divertTactics.getDeviceId()));
                    DivertTacticsForm divertTacticsForm2 = divertTacticsForm;
                    return divertTacticsForm2;
                }
                cmdResult = proxy.executeCommand(command);
                this.logger.info((Object)("deploy cmdResult is " + cmdResult));
                errorCode = this.cmdResult(cmdResult);
                if (errorCode == 1) {
                    this.logger.info((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " successfully."));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 4, 1, "");
                    divertTactics.setDivertStatus(0);
                    this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
                    break block35;
                }
                if (!isThread) {
                    divertTactics.setDivertStatus(0);
                }
                this.logger.error((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed."));
                throw new LegoCheckedException((long)errorCode.intValue());
            }
            catch (LegoCheckedException e) {
                if (!isThread) {
                    divertTactics.setDivertStatus(0);
                }
                this.logger.error((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed."), (Throwable)e);
                if (570503 == errorCode) {
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, cmdResult);
                } else {
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(e.getErrorCode()));
                }
                if (0 == replayNum) {
                    this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + this.getcleanedMessage(device.getIpAddress())));
                    this.divertAlarmHandler.divertAlarmStopFailed(divertTactics, device.getIpAddress());
                }
                if (571217L == e.getErrorCode()) {
                    try {
                        int sleepTime = AticDiversionUtil.getRetryDivertSleepTime();
                        this.logger.info((Object)("telnet auto dirver system busying, need sleep and sleepTime is " + sleepTime));
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        this.logger.error((Object)"telnet auto dirver system busying error");
                    }
                }
                if (isThread) {
                    this.replayDivert(divertTactics, device, 9, replayNum);
                }
                throw e;
            }
            catch (Exception e) {
                if (!isThread) {
                    divertTactics.setDivertStatus(0);
                }
                this.logger.error((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "firewall.exception");
                if (0 == replayNum) {
                    this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + this.getcleanedMessage(device.getIpAddress())));
                    this.divertAlarmHandler.divertAlarmStopFailed(divertTactics, device.getIpAddress());
                }
                if (isThread) {
                    this.replayDivert(divertTactics, device, 2, replayNum);
                }
                throw new LegoCheckedException(570507L, (Throwable)e);
            }
            finally {
                if (proxy != null) {
                    try {
                        proxy.close();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"proxy.close() is error", (Throwable)e);
                    }
                }
                divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                this.saveDivertTactics(divertTacticsForm);
                this.logger.info((Object)("save divertTactics, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
            }
        }
        return divertTacticsForm;
    }

    @Override
    public void stopAndDelDivertTacticsByRestful(List<DivertTacticsForm> divertTacticsFormList, boolean isThread, int replayNum) {
        HashMap divertTacticsMap = new HashMap();
        HashMap<Long, AticDevice> deviceMap = new HashMap<Long, AticDevice>();
        HashMap<Long, Boolean> deviceExistMap = new HashMap<Long, Boolean>();
        long startTime = System.currentTimeMillis();
        for (DivertTacticsForm divertTacticsForm : divertTacticsFormList) {
            String vpnName;
            DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
            if (null == this.divertTacticsDao.get(divertTactics.getId())) {
                this.logger.error((Object)("stop divert tactics :" + divertTactics.getDivertIp() + " failed,  this divert does't exist."));
                this.removeDivertTacticsByRestful(divertTacticsForm);
                if (0 != divertTacticsForm.getDivertMode()) continue;
                this.tellToStopAlarm(divertTacticsForm);
                continue;
            }
            Long deviceId = divertTactics.getDeviceId();
            if (null == deviceExistMap.get(deviceId)) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
                if (null == device) {
                    deviceExistMap.put(deviceId, false);
                    DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
                    this.logger.error((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed, no device exists!"));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 3, 0, "no.device");
                    this.removeDivertTacticsByRestful(divertTacticsForm);
                    this.logger.info((Object)("remove the divert,  deviceId=" + divertTactics.getDeviceId() + ", divertIp=" + divertTactics.getDivertIp() + ", mask=" + divertTactics.getMask()));
                    if (0 != divertTacticsForm.getDivertMode()) continue;
                    this.tellToStopAlarm(divertTacticsForm);
                    continue;
                }
                deviceExistMap.put(deviceId, true);
                deviceMap.put(deviceId, device);
                divertTactics.setDeviceName(device.getName());
            } else {
                if (!((Boolean)deviceExistMap.get(deviceId)).booleanValue()) {
                    DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
                    this.logger.error((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " failed, no device exists!"));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 3, 0, "no.device");
                    this.removeDivertTacticsByRestful(divertTacticsForm);
                    this.logger.info((Object)("remove the divert,  deviceId=" + divertTactics.getDeviceId() + ", divertIp=" + divertTactics.getDivertIp() + ", mask=" + divertTactics.getMask()));
                    if (0 != divertTacticsForm.getDivertMode()) continue;
                    this.tellToStopAlarm(divertTacticsForm);
                    continue;
                }
                divertTactics.setDeviceName(((AticDevice)deviceMap.get(deviceId)).getName());
            }
            if (null != this.zoneDeviceService) {
                Long zoneId = divertTactics.getZoneId();
                String vpnName2 = "";
                if (null != zoneId && null != deviceId) {
                    ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
                    if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                        vpnName2 = zoneDeviceForm.getVpnName();
                    }
                    divertTactics.setVpnName(vpnName2);
                }
            }
            if (null == (vpnName = AticDiversionUtil.calcDivertVPN(divertTactics))) {
                if (!isThread) {
                    divertTactics.setDivertStatus(0);
                }
                this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                if (0 != divertTacticsForm.getDivertStatus()) continue;
                this.removeDivertTacticsByRestful(divertTacticsForm);
                this.logger.info((Object)("remove the divert,  deviceId=" + divertTactics.getDeviceId() + ", divertIp=" + divertTactics.getDivertIp() + ", mask=" + divertTactics.getMask()));
                continue;
            }
            if (null == divertTacticsMap.get(deviceId)) {
                divertTacticsMap.put(deviceId, new ArrayList());
            }
            ((List)divertTacticsMap.get(deviceId)).add(divertTactics);
        }
        long endTime = System.currentTimeMillis();
        this.logger.info((Object)("stopAndDelDivertTacticsByRestful, init data use time=" + (endTime - startTime)));
        long deployStartTime = endTime;
        for (Map.Entry entry : divertTacticsMap.entrySet()) {
            Long deviceId = (Long)entry.getKey();
            List<DivertTactics> divertTacticsList = (List<DivertTactics>)entry.getValue();
            this.logger.info((Object)("deviceId is " + deviceId + ", the diverts size is " + divertTacticsList.size()));
            AticDevice device = (AticDevice)deviceMap.get(deviceId);
            RequestURLForm requestURLForm = RestDdosUtil.getRequestURLForm((AticDevice)device);
            boolean canDeploy = true;
            int deployTimes = 0;
            while (canDeploy) {
                String msg;
                DivertTacticsLogForm divertTacticsLogForm;
                canDeploy = false;
                this.logger.info((Object)("stop DeployTimes = " + ++deployTimes + ", deviceId is " + deviceId + ", the diverts size is " + divertTacticsList.size()));
                startTime = System.currentTimeMillis();
                String body = this.translateDivert(divertTacticsList, false);
                try {
                    List<DivertTactics> divertTacticsOKList;
                    DivertDeployResult divertDeployResult;
                    Result result = this.restfulDdosService.restDdosDeleteDivertTactics((Object)body, requestURLForm);
                    this.logger.info((Object)("stopAndDelDivertTacticsByRestful, restDdosDeleteDivertTactics() use time=" + (System.currentTimeMillis() - startTime)));
                    int errorCode = result.getStatusCode();
                    this.logger.info((Object)("deploy result is " + result.toString()));
                    if (errorCode == 201) {
                        for (DivertTactics divertTactics : divertTacticsList) {
                            this.logger.info((Object)("stop divert tactics : " + divertTactics.getDeviceName() + ", " + divertTactics.getDivertIp() + " successfully."));
                            DivertTacticsLogForm divertTacticsLogForm2 = this.getTacticsLog(divertTactics);
                            this.fillDivertLog(divertTacticsLogForm2, AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 4, 1, "");
                            divertTactics.setDivertStatus(0);
                            this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
                            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                            this.removeDivertTacticsByRestful(divertTacticsForm);
                            this.logger.info((Object)("remove the divert,  deviceId=" + divertTactics.getDeviceId() + ", divertIp=" + divertTactics.getDivertIp() + ", mask=" + divertTactics.getMask()));
                        }
                        continue;
                    }
                    RestErrorInfo errorInfo = RestDdosUtil.translateResult((Result)result);
                    this.logger.error((Object)("stop divert tactics failed, , errorCode" + errorCode + ", errorMessage=" + errorInfo.getErrorMessage() + ", errorPath=" + errorInfo.getErrorPath()));
                    if (StringUtils.isEmpty((String)errorInfo.getErrorPath()) || !errorInfo.getErrorPath().contains("ip-address")) {
                        throw new LegoCheckedException((long)this.cmdStatusCode(errorCode, errorInfo.getErrorMessage()));
                    }
                    if (AticDiversionUtil.isDeviceBusying(errorCode, errorInfo)) {
                        divertDeployResult = this.getFailDivertTacticsList(errorInfo, divertTacticsList);
                        divertTacticsOKList = divertDeployResult.getDivertTacticsOKList();
                        this.stopDivertTacticsAndLog(divertTacticsOKList, device);
                        divertDeployResult.addDivertTactics2UnExecListOnFirst(divertDeployResult.getDivertTacticsFail());
                        divertTacticsList = divertDeployResult.getDivertTacticsUnExecList();
                        throw new LegoCheckedException(571217L);
                    }
                    divertDeployResult = this.getFailDivertTacticsList(errorInfo, divertTacticsList);
                    divertTacticsOKList = divertDeployResult.getDivertTacticsOKList();
                    this.stopDivertTacticsAndLog(divertTacticsOKList, device);
                    DivertTactics divertTacticsFail = divertDeployResult.getDivertTacticsFail();
                    this.logger.error((Object)("stop divert tactics failed, deviceName=" + divertTacticsFail.getDeviceName() + ", zoneIp=" + divertTacticsFail.getDivertIp()));
                    this.fillDivertLog(this.getTacticsLog(divertTacticsFail), AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 3, 0, String.valueOf(this.cmdResult(errorInfo.getErrorMessage())));
                    this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + this.getcleanedMessage(device.getIpAddress())));
                    this.divertAlarmHandler.divertAlarmStopFailed(divertTacticsFail, device.getIpAddress());
                    divertTacticsList = divertDeployResult.getDivertTacticsUnExecList();
                    throw new LegoCheckedException((long)this.cmdResult(errorInfo.getErrorMessage()).intValue());
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"stop divert tactics happened exception.", (Throwable)e);
                    for (DivertTactics divertTactics : divertTacticsList) {
                        divertTacticsLogForm = this.getTacticsLog(divertTactics);
                        msg = "deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp();
                        if (!isThread) {
                            divertTactics.setDivertStatus(0);
                        }
                        this.logger.error((Object)("stop divert tactics : " + msg + " failed."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 3, 0, String.valueOf(e.getErrorCode()));
                        if (0 != replayNum) continue;
                        this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + msg));
                        this.divertAlarmHandler.divertAlarmStopFailed(divertTactics, device.getIpAddress());
                    }
                    if (isThread && replayNum > 0) {
                        canDeploy = true;
                        --replayNum;
                    }
                    if (!canDeploy || 571217L != e.getErrorCode()) continue;
                    int sleepTime = AticDiversionUtil.getRetryDivertSleepTime();
                    this.logger.error((Object)("because device system is busying, need sleep and sleepTime is " + sleepTime));
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        this.logger.error((Object)"sleep happened error.", (Throwable)e1);
                    }
                }
                catch (DocumentException e) {
                    this.logger.error((Object)"stop divert tactics happened exception.", (Throwable)e);
                    for (DivertTactics divertTactics : divertTacticsList) {
                        divertTacticsLogForm = this.getTacticsLog(divertTactics);
                        msg = "deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp();
                        if (!isThread) {
                            divertTactics.setDivertStatus(0);
                        }
                        this.logger.error((Object)("stop divert tactics : " + msg + " failed."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, 3, 0, "firewall.exception");
                        if (0 != replayNum) continue;
                        this.logger.error((Object)("enter the divertAlarmStartFailed alarm handle:" + msg));
                        this.divertAlarmHandler.divertAlarmStopFailed(divertTactics, device.getIpAddress());
                    }
                    if (!isThread || replayNum <= 0) continue;
                    canDeploy = true;
                    --replayNum;
                }
            }
        }
        this.logger.info((Object)("stopAndDelDivertTacticsByRestful, deploy total use time=" + (System.currentTimeMillis() - deployStartTime)));
    }

    @Override
    public void tellToStartAlarm(DivertTacticsForm divertTacticsForm) {
        DivertTactics divertTactics;
        AticDevice device;
        if (null != divertTacticsForm && null != (device = this.aticDeviceService.getDeviceByMoid((divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics())).getDeviceId().longValue()))) {
            divertTactics.setDeviceName(device.getName());
            this.divertAlarmHandler.divertAlarmStart(divertTactics, device.getIpAddress());
        }
    }

    @Override
    public void tellToStopAlarm(DivertTacticsForm divertTacticsForm) {
        DivertTactics divertTactics;
        AticDevice device;
        if (null != divertTacticsForm && null != (device = this.aticDeviceService.getDeviceByMoid((divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics())).getDeviceId().longValue()))) {
            divertTactics.setDeviceName(device.getName());
            this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
        }
    }

    @Override
    public void updateZoneNameForDivert(DivertTacticsForm divertTacticsForm, long zoneId) {
        DivertTactics divertTactics = this.divertTacticsDao.get(divertTacticsForm.getId());
        if (null != divertTactics) {
            divertTactics.setZoneId(zoneId);
            this.divertTacticsDao.update(divertTactics);
        }
    }

    @Override
    public DivertTacticsForm getDivertTacticsByZoneIp(Long deviceId, Long zoneId, String zoneIp) {
        DivertTactics divertTactic = this.divertTacticsDao.getDivertTacticsByZoneIp(deviceId, zoneId, zoneIp);
        if (null == divertTactic) {
            return null;
        }
        DivertTacticsForm divertTacticsForm = new DivertTacticsForm();
        AticUtil.copyProperties((Object)divertTactic, (Object)divertTacticsForm);
        return divertTacticsForm;
    }

    @Override
    public List<DivertTacticsForm> getConflictDivert(DivertTacticsForm divertTacticsForm) {
        List<DivertTactics> divertTacticsList = this.divertTacticsDao.getConflictDivert((DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics()));
        ArrayList<DivertTacticsForm> divertTacticFormList = new ArrayList<DivertTacticsForm>();
        for (DivertTactics divertTactics : divertTacticsList) {
            divertTacticFormList.add((DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()));
        }
        return divertTacticFormList;
    }

    @Override
    public List<DivertTacticsForm> getAllDivertTacticsByZoneIp(String startZoneIp, String endZoneIp) {
        List<DivertTactics> divertTacticsList = this.divertTacticsDao.getAllDivertTacticsByZoneIp(startZoneIp, endZoneIp);
        ArrayList<DivertTacticsForm> divertTacticFormList = new ArrayList<DivertTacticsForm>();
        for (DivertTactics divertTactics : divertTacticsList) {
            divertTacticFormList.add((DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm()));
        }
        return divertTacticFormList;
    }

    @Override
    public List<DivertTacticsForm> getDivertTacticsByIpList(List<StartEndIp> ipStrList) {
        ArrayList<DivertTacticsForm> divertTacticsForms = new ArrayList<DivertTacticsForm>();
        List<DivertTactics> divertTactics = this.divertTacticsDao.getAllDivertTacticsByZoneIpList(ipStrList);
        for (DivertTactics divertTactic : divertTactics) {
            DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
            AticUtil.copyProperties((Object)divertTactic, (Object)dtDivertTacticsForm);
            divertTacticsForms.add(dtDivertTacticsForm);
        }
        return divertTacticsForms;
    }

    @Override
    public DivertTacticsForm getDivertPolicy(Long divertId) {
        DivertTactics divertTactics = this.divertTacticsDao.get(divertId);
        DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
        AticUtil.copyProperties((Object)divertTactics, (Object)dtDivertTacticsForm);
        return dtDivertTacticsForm;
    }

    @Override
    public DivertTacticsForm getDivertPolicyByNfaId(Long nfaId) {
        DivertTactics divertTactics = this.divertTacticsDao.getByNfaId(nfaId);
        DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
        AticUtil.copyProperties((Object)divertTactics, (Object)dtDivertTacticsForm);
        return dtDivertTacticsForm;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setDivertTacticsDao(DivertTacticsDao divertTacticsDao) {
        this.divertTacticsDao = divertTacticsDao;
    }

    public void setDivertTacticsLogDao(DivertTacticsLogDao divertTacticsLogDao) {
        this.divertTacticsLogDao = divertTacticsLogDao;
    }

    public void setSconn(Ssh2Connector sconn) {
        this.sconn = sconn;
    }

    public void setTconn(TelnetConnector tconn) {
        this.tconn = tconn;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public TelnetConnector getTconn() {
        return this.tconn;
    }

    public Ssh2Connector getSconn() {
        return this.sconn;
    }

    public DivertTacticsDao getDivertTacticsDao() {
        return this.divertTacticsDao;
    }

    public DivertTacticsLogDao getDivertTacticsLogDao() {
        return this.divertTacticsLogDao;
    }

    public void setDivertAlarmHandler(DivertAlarmHandler divertAlarmHandler) {
        this.divertAlarmHandler = divertAlarmHandler;
    }

    public void setVpnDeviceService(IVpnDeviceService vpnDeviceService) {
        this.vpnDeviceService = vpnDeviceService;
    }

    public IRestfulDdosService getRestfulDdosService() {
        return this.restfulDdosService;
    }

    public void setRestfulDdosService(IRestfulDdosService restfulDdosService) {
        this.restfulDdosService = restfulDdosService;
    }
}

