/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.OutboundDivertTacticsLogDao;
import com.hs.atic.bis.model.OutboundDivertTacticsLog;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsLogService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OutboundDivertTacticsLogServiceImpl
implements IOutboundDivertTacticsLogService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private OutboundDivertTacticsLogDao outboundDivertTacticsLogDao;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.outboundDivertTacticsLogDao.queryByPage(queryMap, start, pageSize);
        ArrayList<OutboundDivertTacticsLogForm> outboundDivertLogFormList = new ArrayList<OutboundDivertTacticsLogForm>();
        for (OutboundDivertTacticsLog outboundDivertTacticsLog : page.getData()) {
            outboundDivertLogFormList.add((OutboundDivertTacticsLogForm)AticUtil.copyProperties((Object)outboundDivertTacticsLog, (Object)new OutboundDivertTacticsLogForm()));
        }
        page.setData(outboundDivertLogFormList);
        this.logger.info((Object)("query outbound divert tactics log list. size = " + outboundDivertLogFormList.size()));
        return page;
    }

    @Override
    public void respondMsgDelDevice(List<Long> firewallIdSet) {
        for (Long deviceId : firewallIdSet) {
            this.logger.info((Object)("delete outbound divert tactics  log while deleting firewall id = " + deviceId));
            this.outboundDivertTacticsLogDao.deleteByDeviceId(deviceId);
        }
    }

    @Override
    public void respondMsgDelDevice(Long deviceId) {
        this.logger.info((Object)("delete outbound divert tactics  log while deleting firewall id = " + deviceId));
        this.outboundDivertTacticsLogDao.deleteByDeviceId(deviceId);
    }

    @Override
    public int deleteLog(Long endTime) {
        return this.outboundDivertTacticsLogDao.betchDelete(endTime);
    }

    public OutboundDivertTacticsLogDao getOutboundDivertTacticsLogDao() {
        return this.outboundDivertTacticsLogDao;
    }

    public void setOutboundDivertTacticsLogDao(OutboundDivertTacticsLogDao outboundDivertTacticsLogDao) {
        this.outboundDivertTacticsLogDao = outboundDivertTacticsLogDao;
    }

    @Override
    public List<OutboundDivertTacticsLogForm> getOutboundLogsByDivertTacticsLogIdS(String logIds) {
        ArrayList<OutboundDivertTacticsLogForm> outboundDivertLogFormList = new ArrayList<OutboundDivertTacticsLogForm>();
        if (null == logIds || logIds.equals("")) {
            return null;
        }
        String[] logs = logIds.split(",");
        for (int i = 0; i < logs.length; ++i) {
            try {
                Long id = Long.valueOf(logs[i]);
                OutboundDivertTacticsLogForm outboundDivertTacticsLogForm = this.getById(id);
                if (null == outboundDivertTacticsLogForm) continue;
                outboundDivertLogFormList.add(outboundDivertTacticsLogForm);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Numberformat exception id = " + logs[i]), (Throwable)e);
            }
        }
        return outboundDivertLogFormList;
    }

    private OutboundDivertTacticsLogForm getById(Long id) {
        if (null == id) {
            this.logger.error((Object)"outbound divert tactics log by id. Id is null");
            return null;
        }
        OutboundDivertTacticsLog outbouddivertTacticsLog = this.outboundDivertTacticsLogDao.get(id);
        if (null == outbouddivertTacticsLog) {
            this.logger.warn((Object)"outbound divert tactics log by id, result is null");
            return null;
        }
        OutboundDivertTacticsLogForm outboundDivertTacticsLogForm = (OutboundDivertTacticsLogForm)AticUtil.copyProperties((Object)outbouddivertTacticsLog, (Object)new OutboundDivertTacticsLogForm());
        this.logger.info((Object)("get outboundDivertTacticsLogForm info by id successfuly. Id is : " + id));
        return outboundDivertTacticsLogForm;
    }

    @Override
    public OutboundDivertTacticsLog getLogDetail(Long logId) {
        OutboundDivertTacticsLog outboundDivertTacticsLog = this.outboundDivertTacticsLogDao.get(logId);
        if (null == outboundDivertTacticsLog) {
            this.logger.warn((Object)"outbound divert tactics log by id, result is null");
            return null;
        }
        return outboundDivertTacticsLog;
    }
}

