/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.OutboundDivertTacticsDao;
import com.hs.atic.bis.dao.OutboundDivertTacticsLogDao;
import com.hs.atic.bis.model.OutboundDivertTactics;
import com.hs.atic.bis.model.OutboundDivertTacticsLog;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsForm;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.DivertAlarmHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.nfa.util.NfaFilterUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.nfa.restful.model.DiverterObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OutboundDivertTacticsServiceImpl
implements IOutboundDivertTacticsService {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private OutboundDivertTacticsDao outboundDivertTacticsDao;
    private OutboundDivertTacticsLogDao outboundDivertTacticsLogDao;
    private IAticDeviceService aticDeviceService;
    private IZoneService zoneService;
    private DivertAlarmHandler divertAlarmHandler;
    private IRestfulNfaService restfulNfaService;

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.outboundDivertTacticsDao.queryByPage(queryMap, start, pageSize);
        List divertTacticsList = page.getData();
        ArrayList<OutboundDivertTacticsForm> divertTacticFormList = new ArrayList<OutboundDivertTacticsForm>();
        for (OutboundDivertTactics divertTactics : divertTacticsList) {
            divertTacticFormList.add((OutboundDivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new OutboundDivertTacticsForm()));
        }
        page.setData(divertTacticFormList);
        this.logger.info((Object)("query outbound divert tactics list. size = " + divertTacticsList.size()));
        return page;
    }

    @Override
    public List<OutboundDivertTacticsForm> queryBySourceIp(String sourceIp) {
        List<OutboundDivertTactics> divertTacticsList = this.outboundDivertTacticsDao.getBySourceIp(sourceIp);
        if (null == divertTacticsList) {
            return null;
        }
        ArrayList<OutboundDivertTacticsForm> divertTacticFormList = new ArrayList<OutboundDivertTacticsForm>();
        for (OutboundDivertTactics divertTactics : divertTacticsList) {
            divertTacticFormList.add((OutboundDivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new OutboundDivertTacticsForm()));
        }
        this.logger.info((Object)("query outbound divert tactics list. size = " + divertTacticsList.size()));
        return divertTacticFormList;
    }

    @Override
    public BatchOperationResult stopDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null != boList && !boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                OutboundDivertTactics divertTactics = null;
                OutboundDivertTacticsLogForm divertTacticsLogForm = null;
                DiverterObject[] diverterObjects = new DiverterObject[1];
                try {
                    divertTactics = this.outboundDivertTacticsDao.get(bo.getTargetId());
                    if (null == divertTactics) {
                        this.logger.error((Object)("stop outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, this divert tactics not exists!"));
                        bo.setErrorCode(571201L);
                        ++fail;
                        continue;
                    }
                    divertTactics.setOperator(operator);
                    divertTactics.setClientIp(clientIp);
                    divertTacticsLogForm = this.getTacticsLog(divertTactics);
                    if (0 == divertTactics.getDivertStatus()) {
                        this.logger.error((Object)("stop outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, stopped already!"));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "already.stop");
                        bo.setErrorCode(571207L);
                        ++fail;
                        continue;
                    }
                    Long devId = divertTactics.getDeviceId();
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                    if (null == device) {
                        this.logger.error((Object)("stop outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, no device exists!"));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "no.device");
                        bo.setErrorCode(571205L);
                        ++fail;
                        continue;
                    }
                    divertTactics.setDeviceName(device.getName());
                    this.logger.info((Object)("save outbound divert tactics device name : " + divertTactics.getDeviceName()));
                    diverterObjects[0] = new DiverterObject();
                    diverterObjects[0].setRuleId(divertTactics.getId());
                    NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId((Long)devId);
                    Result nfaResult = this.restfulNfaService.restNfaOutboundDivertTactics(nfaInfoForm, diverterObjects, "delete");
                    if (nfaResult.getStatusCode() == 200 && nfaResult.getJson().contains("ok")) {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 4, 1, nfaResult.getJson());
                        divertTactics.setDivertStatus(0);
                        this.outboundDivertTacticsDao.saveOrUpdate(divertTactics);
                        continue;
                    }
                    this.logger.error((Object)("stop outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, nfaResult.getJson());
                    bo.setErrorCode(571219L);
                    ++fail;
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    bo.setErrorCode(571219L);
                    this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(e.getErrorCode()));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "firewall.exception");
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList == null ? 0 : boList.size());
        result.setSucceedCount(boList == null ? 0 : boList.size() - fail);
        this.logger.info((Object)("stop outbound divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public BatchOperationResult startDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            OutboundDivertTactics divertTactics = null;
            OutboundDivertTacticsLogForm divertTacticsLogForm = null;
            DiverterObject[] diverterObjects = new DiverterObject[1];
            try {
                divertTactics = this.outboundDivertTacticsDao.get(bo.getTargetId());
                if (null == divertTactics) {
                    bo.setErrorCode(571201L);
                    ++fail;
                    this.logger.error((Object)("start outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, this divert tactics not exists!"));
                    continue;
                }
                divertTacticsLogForm = this.getTacticsLog(divertTactics);
                divertTacticsLogForm.setOperator(operator);
                divertTacticsLogForm.setClientIp(clientIp);
                if (1 == divertTactics.getDivertStatus()) {
                    bo.setErrorCode(571206L);
                    ++fail;
                    this.logger.error((Object)("start outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, started already!"));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "already.start");
                    continue;
                }
                Long devId = divertTactics.getDeviceId();
                if (null == this.aticDeviceService.getDeviceByMoid(devId.longValue())) {
                    bo.setErrorCode(571205L);
                    ++fail;
                    this.logger.error((Object)("start outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, no device exists!"));
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
                    continue;
                }
                diverterObjects[0] = this.fillNfaDivertObject(divertTactics);
                NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId((Long)devId);
                Result nfaResult = this.restfulNfaService.restNfaOutboundDivertTactics(nfaInfoForm, diverterObjects, "add");
                if (nfaResult.getStatusCode() == 200 && nfaResult.getJson().contains("ok")) {
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, nfaResult.getJson());
                    divertTactics.setDivertStatus(1);
                    this.outboundDivertTacticsDao.saveOrUpdate(divertTactics);
                    continue;
                }
                this.logger.error((Object)("start outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                bo.setErrorCode(571220L);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, nfaResult.getJson());
                ++fail;
                this.logger.info((Object)("divertOutboundAlarmStartFailed fail alarm " + this.getcleanedMessage(divertTactics.toString())));
                OutboundDivertTacticsForm divertTacticsForm = new OutboundDivertTacticsForm();
                divertTacticsForm.setZoneDesc(divertTactics.getZoneDesc());
                divertTacticsForm.setSourceIp(divertTactics.getSourceIp());
                divertTacticsForm.setProtocol(divertTactics.getProtocol());
                divertTacticsForm.setAction(divertTactics.getAction());
                divertTacticsForm.setZoneId(divertTactics.getZoneId());
                divertTacticsForm.setDeviceId(divertTactics.getDeviceId());
                divertTacticsForm.setSourceIp(divertTactics.getSourceIp());
                divertTacticsForm.setZoneDesc(divertTactics.getZoneDesc());
                this.divertAlarmHandler.divertOutboundAlarmStartFailed(divertTacticsForm);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("start outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(e.getErrorCode()));
                ++fail;
                bo.setErrorCode(571220L);
            }
            catch (Exception e) {
                this.logger.error((Object)("start outbound divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "firewall.exception");
                ++fail;
                bo.setErrorCode(570507L);
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("start outbound divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    private DiverterObject fillNfaDivertObject(OutboundDivertTactics outboundDivertTactics) {
        String desPorts;
        String sourcePorts;
        DiverterObject diverterObject = new DiverterObject();
        diverterObject.setRuleId(outboundDivertTactics.getId());
        diverterObject.setSourceIp(outboundDivertTactics.getSourceIp());
        diverterObject.setDestinationIp(outboundDivertTactics.getDesIp());
        diverterObject.setAction(outboundDivertTactics.getAction().intValue());
        if (null != outboundDivertTactics.getThreshold()) {
            if (outboundDivertTactics.getThreshold() / 1000000L == 0L) {
                diverterObject.setLimitRate(Long.valueOf(outboundDivertTactics.getThreshold() * 1000000L));
            } else {
                diverterObject.setLimitRate(outboundDivertTactics.getThreshold());
            }
        }
        diverterObject.setProtocol(outboundDivertTactics.getProtocol().intValue());
        if (null != outboundDivertTactics.getNextHop()) {
            diverterObject.setNextHop(outboundDivertTactics.getNextHop());
        }
        if (null != (sourcePorts = outboundDivertTactics.getSourcePort()) && !"".equals(sourcePorts)) {
            String[] sourceList = sourcePorts.split(",");
            diverterObject.setSourcePort(sourceList);
        }
        if (null != (desPorts = outboundDivertTactics.getDesPort()) && !"".equals(desPorts)) {
            String[] desList = desPorts.split(",");
            diverterObject.setDestinationPort(desList);
        }
        return diverterObject;
    }

    @Override
    public BatchOperationResult deleteDivertTactics(List<BatchOperation> boList, boolean isRestful, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            OutboundDivertTactics divertTactics = null;
            OutboundDivertTacticsLogForm divertTacticsLogForm = null;
            try {
                divertTactics = this.outboundDivertTacticsDao.get(bo.getTargetId());
                if (null == divertTactics) {
                    this.logger.error((Object)("delete outbound divert tactics :" + this.getcleanedMessage(bo.getTargetName()) + " failed,  this divert has not been existed."));
                    bo.setErrorCode(571201L);
                    ++fail;
                    continue;
                }
                divertTactics.setOperator(operator);
                divertTactics.setClientIp(clientIp);
                divertTacticsLogForm = this.getTacticsLog(divertTactics);
                Long errorCode = null;
                if (divertTactics.getDivertStatus() == 1) {
                    try {
                        this.stopSigleDivertTactics((OutboundDivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new OutboundDivertTacticsForm()), false);
                    }
                    catch (LegoCheckedException e) {
                        errorCode = e.getErrorCode();
                        if (571212 == errorCode.intValue()) {
                            this.logger.info((Object)"isStopDivert = true");
                        } else {
                            this.logger.info((Object)"isStopDivert = false");
                        }
                        ++fail;
                        bo.setErrorCode(errorCode.longValue());
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("stop outbound divert : " + divertTactics.getDeviceName() + " : " + divertTactics.getSourceIp() + " error when deleting outbound divert whose status is on."));
                        ++fail;
                        continue;
                    }
                }
                OutboundDivertTacticsForm divertTacticsForm = (OutboundDivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new OutboundDivertTacticsForm());
                this.removeDivertTactics(divertTacticsForm);
                this.logger.info((Object)("delete outbound divert tactics :" + this.getcleanedMessage(bo.getTargetName()) + " sucessfully."));
            }
            catch (Exception e) {
                this.logger.error((Object)("delete outbound divert tactics :" + this.getcleanedMessage(bo.getTargetName()) + " failed."), (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE, 3, 0, "del.exception");
                ++fail;
                bo.setErrorCode(570507L);
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("delete outbound divert result, success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public BatchOperationResult deleteAllDivertTactics(List<BatchOperation> boList, String operator, String clientIp) {
        BatchOperationResult result = new BatchOperationResult();
        OutboundDivertTacticsLogForm divertTacticsLogForm = new OutboundDivertTacticsLogForm();
        int fail = 0;
        if (null != boList && !boList.isEmpty()) {
            DiverterObject[] diverterObjects = new DiverterObject[1];
            OutboundDivertTactics outboundDivertTactics = this.outboundDivertTacticsDao.getByDeviceId(boList.get(0).getTargetId());
            if (outboundDivertTactics == null) {
                this.logger.error((Object)"outboundDivertTactics is null");
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 0, "firewall.exception");
                fail = boList.size();
                for (BatchOperation bo : boList) {
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(bo.getTargetId());
                    bo.setErrorCode(570507L);
                    if (null == device) continue;
                    bo.setTargetName(device.getName());
                }
                result.setResult(boList);
                result.setFailCount(fail);
                result.setTotalCount(boList.size());
                result.setSucceedCount(boList.size() - fail);
                this.logger.info((Object)("stop outbound divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
                return result;
            }
            divertTacticsLogForm.setClientIp(clientIp);
            divertTacticsLogForm.setOperator(operator);
            divertTacticsLogForm.setLogTime(System.currentTimeMillis() / 1000L);
            divertTacticsLogForm.setDeviceName(outboundDivertTactics.getDeviceName());
            divertTacticsLogForm.setDeviceId(outboundDivertTactics.getDeviceId());
            try {
                diverterObjects[0] = new DiverterObject();
                NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId((Long)outboundDivertTactics.getDeviceId());
                Result nfaResult = this.restfulNfaService.restNfaOutboundDivertTactics(nfaInfoForm, diverterObjects, "deleteAll");
                if (nfaResult.getStatusCode() == 200 && nfaResult.getJson().contains("ok")) {
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 4, 1, nfaResult.getJson());
                    this.outboundDivertTacticsDao.deleteAll();
                } else {
                    this.logger.error((Object)"stop outbound divert tactics failed.");
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 0, nfaResult.getJson());
                    fail = boList.size();
                    for (BatchOperation bo : boList) {
                        AticDevice device = this.aticDeviceService.getDeviceByMoid(bo.getTargetId());
                        bo.setErrorCode(571219L);
                        if (null == device) continue;
                        bo.setTargetName(device.getName());
                    }
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 0, String.valueOf(e.getErrorCode()));
                fail = boList.size();
                for (BatchOperation bo : boList) {
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(bo.getTargetId());
                    bo.setErrorCode(571219L);
                    if (null == device) continue;
                    bo.setTargetName(device.getName());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, 3, 0, "firewall.exception");
                fail = boList.size();
                for (BatchOperation bo : boList) {
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(bo.getTargetId());
                    bo.setErrorCode(570507L);
                    if (null == device) continue;
                    bo.setTargetName(device.getName());
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList == null ? 0 : boList.size());
        result.setSucceedCount(boList == null ? 0 : boList.size() - fail);
        this.logger.info((Object)("stop outbound divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public void saveOutboundDivertTactics(OutboundDivertTacticsForm outboundDivertTacticsForm) {
        if (null == outboundDivertTacticsForm) {
            this.logger.error((Object)"can't save null divertTactics");
            return;
        }
        OutboundDivertTactics divertTactics = (OutboundDivertTactics)AticUtil.copyProperties((Object)outboundDivertTacticsForm, (Object)new OutboundDivertTactics());
        divertTactics.setCreateTime(System.currentTimeMillis() / 1000L);
        this.outboundDivertTacticsDao.saveOrUpdate(divertTactics);
        this.logger.info((Object)("save divertTactics, deviceName=" + outboundDivertTacticsForm.getDeviceName() + ", zoneIp=" + outboundDivertTacticsForm.getSourceIp()));
    }

    @Override
    public void stopAndDelDivert(OutboundDivertTacticsForm outboundDivertTacticsForm) {
    }

    @Override
    public boolean respondMsgDelDevice(Long deviceId) {
        boolean flag = false;
        DiverterObject[] diverterObjects = new DiverterObject[1];
        OutboundDivertTactics outboundDivertTactics = this.outboundDivertTacticsDao.getByDeviceId(deviceId);
        try {
            if (null == outboundDivertTactics) {
                this.logger.error((Object)"stop outbound divert tactics failed.outboundDivertTactics is null");
                return flag;
            }
            diverterObjects[0] = new DiverterObject();
            NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId((Long)outboundDivertTactics.getDeviceId());
            Result nfaResult = this.restfulNfaService.restNfaOutboundDivertTactics(nfaInfoForm, diverterObjects, "deleteAll");
            this.outboundDivertTacticsDao.deleteAll();
            if (nfaResult.getStatusCode() == 200 && nfaResult.getJson().contains("ok")) {
                Result result = this.restfulNfaService.restNfaResetConfig(nfaInfoForm);
                flag = result.getStatusCode() == 200 && result.getJson().contains("ok");
            } else {
                flag = false;
                this.logger.error((Object)"stop outbound divert tactics failed.");
            }
            return flag;
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
            return flag;
        }
        catch (Exception e) {
            this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
            return flag;
        }
    }

    @Override
    public void cascadeDivertByZoneDel(List<BatchOperation> zoneDelResult) {
    }

    @Override
    public void deleteStaticDivertByPolicy(Long zoneId, Long firewallId) {
    }

    public int getZoneDivertState(long zoneId) {
        int startDivertFlag = 0;
        int stopDivertFlag = 0;
        List<OutboundDivertTactics> tasks = this.outboundDivertTacticsDao.getDivertListByZoneId(zoneId);
        if (!tasks.isEmpty()) {
            for (OutboundDivertTactics each : tasks) {
                if (null != each.getDivertStatus() && 1 == each.getDivertStatus()) {
                    ++startDivertFlag;
                }
                if (null == each.getDivertStatus() || 0 != each.getDivertStatus()) continue;
                ++stopDivertFlag;
            }
            if (startDivertFlag > 0 && stopDivertFlag > 0) {
                return 2;
            }
            if (startDivertFlag > 0 && stopDivertFlag == 0) {
                return 1;
            }
            if (startDivertFlag == 0 && stopDivertFlag > 0) {
                return 0;
            }
            if (startDivertFlag == 0 && stopDivertFlag == 0) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void fillDivertLog(OutboundDivertTacticsLogForm outboundDivertTacticsLogForm, int operType, int logLevel, int result, String remark) {
        if (null == outboundDivertTacticsLogForm) {
            return;
        }
        outboundDivertTacticsLogForm.setOperType(operType);
        outboundDivertTacticsLogForm.setLevel(logLevel);
        outboundDivertTacticsLogForm.setRemark(remark);
        outboundDivertTacticsLogForm.setResult(result);
        OutboundDivertTacticsLog divertTacticsLog = (OutboundDivertTacticsLog)AticUtil.copyProperties((Object)outboundDivertTacticsLogForm, (Object)new OutboundDivertTacticsLog());
        this.outboundDivertTacticsLogDao.saveOrUpdate(divertTacticsLog);
    }

    @Override
    public void removeDivertTactics(OutboundDivertTacticsForm outboundDivertTacticsForm) {
        if (null == outboundDivertTacticsForm) {
            this.logger.error((Object)"can't delete DivertTactics by null id");
            return;
        }
        this.outboundDivertTacticsDao.remove(outboundDivertTacticsForm.getId());
        OutboundDivertTactics divertTactics = (OutboundDivertTactics)AticUtil.copyProperties((Object)outboundDivertTacticsForm, (Object)new OutboundDivertTactics());
        OutboundDivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_DELETE, 4, 1, "");
    }

    @Override
    public void stopAndDelDivertTacticsByZoneId(long zoneId) {
    }

    @Override
    public void createDivertTactics(OutboundDivertTacticsForm outboundDivertTacticsForm) {
        OutboundDivertTactics outboundDivertTactics = (OutboundDivertTactics)AticUtil.copyProperties((Object)outboundDivertTacticsForm, (Object)new OutboundDivertTactics());
        if (null != outboundDivertTactics.getSourceIp() && !"".equals(outboundDivertTactics.getSourceIp())) {
            String[] ip = new String[2];
            if (outboundDivertTactics.getSourceIp().contains("/")) {
                ip = outboundDivertTactics.getSourceIp().split("/");
            } else if (IPUtil.isIpv4((String)outboundDivertTactics.getSourceIp())) {
                ip[0] = outboundDivertTactics.getSourceIp();
                ip[1] = "32";
            } else {
                ip[0] = outboundDivertTactics.getSourceIp();
                ip[1] = "128";
            }
            Long zoneId = this.zoneService.getZoneIdByIpAndMask(ip[0], Integer.parseInt(ip[1]));
            if (null != zoneId) {
                ZoneInfoForm zoneInfoForm = this.zoneService.getById(zoneId);
                outboundDivertTactics.setZoneId(zoneId);
                outboundDivertTactics.setZoneDesc(zoneInfoForm.getZoneDesc());
            } else {
                outboundDivertTactics.setZoneDesc("--");
            }
        }
        OutboundDivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(outboundDivertTactics);
        AticDevice firewall = this.aticDeviceService.getDeviceByMoid(outboundDivertTactics.getDeviceId().longValue());
        if (null == firewall) {
            this.logger.error((Object)("start divert tactics : " + outboundDivertTactics.getDeviceName() + ", " + outboundDivertTactics.getSourceIp() + " failed, no device exists!"));
            divertTacticsLogForm.setOperator(outboundDivertTactics.getOperator());
            divertTacticsLogForm.setClientIp(outboundDivertTactics.getClientIp());
            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
            outboundDivertTactics.setDivertStatus(0);
            throw new LegoCheckedException(571205L);
        }
        outboundDivertTactics.setDeviceName(firewall.getName());
        this.logger.info((Object)("save divert tactics device name : " + outboundDivertTactics.getDeviceName()));
        outboundDivertTactics.setDivertStatus(0);
        OutboundDivertTacticsForm dTForm = (OutboundDivertTacticsForm)AticUtil.copyProperties((Object)outboundDivertTactics, (Object)new OutboundDivertTacticsForm());
        if (this.isExist(dTForm)) {
            this.logger.error((Object)"the divert tactics has been existed!");
            throw new LegoCheckedException(571204L);
        }
        this.saveOutboundDivertTactics(dTForm);
        OutboundDivertTacticsLogForm divertTacticsLogForms = this.getTacticsLog(outboundDivertTactics);
        divertTacticsLogForms.setOperator(outboundDivertTacticsForm.getOperator());
        divertTacticsLogForms.setClientIp(outboundDivertTacticsForm.getClientIp());
        this.fillDivertLog(divertTacticsLogForms, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 4, 1, "");
        this.logger.info((Object)("save divertTactics : " + outboundDivertTactics.getDeviceName() + ", " + outboundDivertTactics.getSourceIp()));
    }

    @Override
    public List<OutboundDivertTactics> queryAll() {
        return this.outboundDivertTacticsDao.queryAll();
    }

    public boolean isExist(OutboundDivertTacticsForm outboundDivertTacticsForm) {
        return false;
    }

    private OutboundDivertTacticsLogForm getTacticsLog(OutboundDivertTactics outboundDivertTactics) {
        OutboundDivertTacticsLogForm outboundDivertTacticsLogForm = new OutboundDivertTacticsLogForm();
        if (null != outboundDivertTactics.getZoneId()) {
            outboundDivertTacticsLogForm.setZoneId(outboundDivertTactics.getZoneId());
        }
        outboundDivertTacticsLogForm.setDeviceId(outboundDivertTactics.getDeviceId());
        outboundDivertTacticsLogForm.setZoneDesc(outboundDivertTactics.getZoneDesc());
        outboundDivertTacticsLogForm.setDeviceName(outboundDivertTactics.getDeviceName());
        outboundDivertTacticsLogForm.setAction(outboundDivertTactics.getAction());
        outboundDivertTacticsLogForm.setSourceIp(outboundDivertTactics.getSourceIp());
        outboundDivertTacticsLogForm.setSourcePort(outboundDivertTactics.getSourcePort());
        outboundDivertTacticsLogForm.setDesIp(outboundDivertTactics.getDesIp());
        outboundDivertTacticsLogForm.setDesPort(outboundDivertTactics.getDesPort());
        outboundDivertTacticsLogForm.setNextHop(outboundDivertTactics.getNextHop());
        outboundDivertTacticsLogForm.setProtocol(outboundDivertTactics.getProtocol());
        if (null != outboundDivertTactics.getThreshold()) {
            outboundDivertTacticsLogForm.setThreshold(outboundDivertTactics.getThreshold());
        }
        outboundDivertTacticsLogForm.setOperator(outboundDivertTactics.getOperator());
        outboundDivertTacticsLogForm.setClientIp(outboundDivertTactics.getClientIp());
        outboundDivertTacticsLogForm.setLogTime(System.currentTimeMillis() / 1000L);
        outboundDivertTacticsLogForm.setDivertMode(outboundDivertTactics.getDivertMode());
        return outboundDivertTacticsLogForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public OutboundDivertTacticsDao getOutboundDivertTacticsDao() {
        return this.outboundDivertTacticsDao;
    }

    public void setOutboundDivertTacticsDao(OutboundDivertTacticsDao outboundDivertTacticsDao) {
        this.outboundDivertTacticsDao = outboundDivertTacticsDao;
    }

    public OutboundDivertTacticsLogDao getOutboundDivertTacticsLogDao() {
        return this.outboundDivertTacticsLogDao;
    }

    public void setOutboundDivertTacticsLogDao(OutboundDivertTacticsLogDao outboundDivertTacticsLogDao) {
        this.outboundDivertTacticsLogDao = outboundDivertTacticsLogDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public DivertAlarmHandler getDivertAlarmHandler() {
        return this.divertAlarmHandler;
    }

    public void setDivertAlarmHandler(DivertAlarmHandler divertAlarmHandler) {
        this.divertAlarmHandler = divertAlarmHandler;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    @Override
    public void deployAndSaveOutboundDivertTactics(OutboundDivertTacticsForm divertTacticsForm, boolean createAlarm) {
        block10: {
            if (null == divertTacticsForm) {
                this.logger.error((Object)"can't save null divertTactics");
                return;
            }
            if (null != divertTacticsForm.getDeviceId()) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(divertTacticsForm.getDeviceId().longValue());
                divertTacticsForm.setDeviceName(aticDevice.getName());
            }
            OutboundDivertTactics divertTactics = (OutboundDivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new OutboundDivertTactics());
            divertTactics.setCreateTime(System.currentTimeMillis() / 1000L);
            divertTactics.setDivertStatus(0);
            Serializable divertId = this.outboundDivertTacticsDao.save(divertTactics);
            divertTactics.setId(Long.valueOf(divertId.toString()));
            this.logger.info((Object)("save divertTactics, deviceName=" + divertTacticsForm.getDeviceName() + ", zoneIp=" + divertTacticsForm.getSourceIp()));
            OutboundDivertTacticsLogForm saveLogForm = this.getTacticsLog(divertTactics);
            saveLogForm.setOperator(divertTacticsForm.getOperator());
            saveLogForm.setClientIp(divertTacticsForm.getClientIp());
            this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 4, 1, "");
            DiverterObject[] diverterObjects = new DiverterObject[1];
            try {
                diverterObjects[0] = this.fillNfaDivertObject(divertTactics);
                NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId((Long)divertTactics.getDeviceId());
                Result nfaResult = this.restfulNfaService.restNfaOutboundDivertTactics(nfaInfoForm, diverterObjects, "add");
                if (nfaResult.getStatusCode() == 200 && nfaResult.getJson().contains("ok")) {
                    this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, nfaResult.getJson());
                    divertTactics.setDivertStatus(1);
                    this.outboundDivertTacticsDao.saveOrUpdate(divertTactics);
                    if (createAlarm) {
                        this.logger.info((Object)("deployAndSaveDivertTactics is successful alarm " + this.getcleanedMessage(divertTactics.toString())));
                        this.divertAlarmHandler.divertOutboundAlarmStart(divertTacticsForm);
                    }
                    break block10;
                }
                this.logger.error((Object)"start outbound divert tactics failed.");
                this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, nfaResult.getJson());
                if (createAlarm) {
                    this.logger.info((Object)("deployAndSaveDivertTactics fail alarm " + this.getcleanedMessage(divertTactics.toString())));
                    this.divertAlarmHandler.divertOutboundAlarmStartFailed(divertTacticsForm);
                }
                throw new LegoCheckedException(571220L);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"start outbound divert tactics failed.", (Throwable)e);
                this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(e.getErrorCode()));
                if (createAlarm) {
                    this.logger.info((Object)("deployAndSaveDivertTactics fail alarm " + this.getcleanedMessage(divertTactics.toString())));
                    this.divertAlarmHandler.divertOutboundAlarmStartFailed(divertTacticsForm);
                }
                throw new LegoCheckedException(571220L);
            }
            catch (Exception e) {
                this.logger.error((Object)"start divert tactics failed.", (Throwable)e);
                this.fillDivertLog(saveLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "firewall.exception");
                if (createAlarm) {
                    this.logger.info((Object)("deployAndSaveDivertTactics fail alarm " + this.getcleanedMessage(divertTactics.toString())));
                    this.divertAlarmHandler.divertOutboundAlarmStartFailed(divertTacticsForm);
                }
                throw new LegoCheckedException(570507L);
            }
        }
    }

    @Override
    public OutboundDivertTacticsForm stopSigleDivertTactics(OutboundDivertTacticsForm divertTacticsForm, boolean isThread) {
        OutboundDivertTactics divertTactics = (OutboundDivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new OutboundDivertTactics());
        if (null == this.outboundDivertTacticsDao.get(divertTactics.getId())) {
            this.logger.error((Object)("stop divert tactics :" + divertTactics.getSourceIp() + " failed,  this divert does't exist."));
            throw new LegoCheckedException(571212L);
        }
        OutboundDivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
        try {
            DiverterObject[] diverterObjects = new DiverterObject[1];
            divertTacticsLogForm = this.getTacticsLog(divertTactics);
            if (0 == divertTactics.getDivertStatus()) {
                this.logger.error((Object)"stop divert tactics failed, stopped already!");
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "already.stop");
                throw new LegoCheckedException(571207L);
            }
            Long devId = divertTactics.getDeviceId();
            AticDevice device = this.aticDeviceService.getDeviceByMoid(devId.longValue());
            if (null == device) {
                this.logger.error((Object)"stop divert tactics failed, no device exists!");
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "no.device");
                throw new LegoCheckedException(571205L);
            }
            divertTactics.setDeviceName(device.getName());
            this.logger.info((Object)("save divert tactics device name : " + divertTactics.getDeviceName()));
            diverterObjects[0] = new DiverterObject();
            diverterObjects[0].setRuleId(divertTactics.getId());
            NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId((Long)devId);
            Result nfaResult = this.restfulNfaService.restNfaOutboundDivertTactics(nfaInfoForm, diverterObjects, "delete");
            if (nfaResult.getStatusCode() != 200 || !nfaResult.getJson().contains("ok")) {
                this.logger.error((Object)"stop outbound divert tactics failed.");
                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, nfaResult.getJson());
                this.divertAlarmHandler.divertOutboundAlarmResumeFailed(divertTacticsForm);
                throw new LegoCheckedException(571219L);
            }
            this.logger.info((Object)"stop outbound divert tactics success.");
            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 4, 1, nfaResult.getJson());
            divertTactics.setDivertStatus(0);
            divertTacticsForm.setDivertStatus(Integer.valueOf(0));
            this.outboundDivertTacticsDao.saveOrUpdate(divertTactics);
            this.divertAlarmHandler.divertOutboundAlarmResume(divertTacticsForm);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(e.getErrorCode()));
            this.divertAlarmHandler.divertOutboundAlarmResumeFailed(divertTacticsForm);
            throw new LegoCheckedException(571219L);
        }
        catch (Exception e) {
            this.logger.error((Object)"stop outbound divert tactics failed.", (Throwable)e);
            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "firewall.exception");
            this.divertAlarmHandler.divertOutboundAlarmResumeFailed(divertTacticsForm);
            throw new LegoCheckedException(570507L);
        }
        this.logger.info((Object)("save divertTactics, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getSourceIp()));
        return divertTacticsForm;
    }

    @Override
    public Set<Long> getDevIdsByDivertIds(Long[] divertIds) {
        HashSet<Long> result = new HashSet<Long>();
        if (divertIds == null) {
            return result;
        }
        List<Long> devIds = this.outboundDivertTacticsDao.getDistinctDevIds();
        for (Long devId : devIds) {
            result.add(devId);
        }
        return result;
    }

    public OutboundDivertTacticsForm queryAutoDivertByZoneId(Long zoneId) {
        OutboundDivertTactics divertTactics = this.outboundDivertTacticsDao.getDivertTacticsByZoneId(zoneId);
        OutboundDivertTacticsForm outboundDivertTacticsForm = null;
        if (null != divertTactics) {
            outboundDivertTacticsForm = (OutboundDivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new OutboundDivertTacticsForm());
        }
        return outboundDivertTacticsForm;
    }
}

