/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.analysis.util.SysOptLogAnalysisUtil;
import com.hs.atic.bis.service.DivertTacticsLogServiceImpl;
import com.hs.atic.system.util.SystemUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.Calendar;
import java.util.Date;

public class DivertLogHoldManager
extends Thread {
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private int beforeDay = 0;
    private boolean isAlive = true;
    private DivertTacticsLogServiceImpl divertTacticsLog;

    @Override
    public void run() {
        logger.info((Object)"DeleteLogDataThread run!");
        while (this.isAlive) {
            if (this.isTime2Run(this.getCurrentDay()).booleanValue()) {
                try {
                    this.deleteDivertLogData();
                }
                catch (Exception e) {
                    logger.error((Object)"divertLogHoldManager some errors happend", (Throwable)e);
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)("DeleteLogDataThread InterruptedException error: " + e));
            }
        }
        logger.info((Object)"DeleteLogDataThread stop!");
    }

    public void deleteDivertLogData() {
        try {
            logger.info((Object)"start deleteDivertLogData");
            Integer divertlogHoldTime = SystemUtil.getLogHoldTime().getTacticsLogTime();
            Long dataKeepTime = SystemUtil.getDataKeepTime((int)1, (int)divertlogHoldTime);
            Long currentTime = System.currentTimeMillis() / 1000L;
            Long endTime = currentTime - dataKeepTime;
            if (this.divertTacticsLog == null) {
                logger.error((Object)"deleteDivertLogData error");
                this.processOpeLog(0, false, "", "lego.err.570507", "atic.bis.divert.tactics.log.list", true);
            } else {
                int totalNum = this.divertTacticsLog.deleteLog(endTime);
                String logTime = AticUtil.convertTimeLong((Long)endTime);
                logger.info((Object)("deleteDivertLogData totalNum" + totalNum + ", the time before " + logTime));
                this.processOpeLog(totalNum, true, logTime, "", "atic.bis.divert.tactics.log.list", true);
            }
        }
        catch (LegoCheckedException lego) {
            logger.error((Object)"deleteDivertLogData error", (Throwable)lego);
            this.processOpeLog(0, false, "", "lego.err." + lego.getErrorCode(), "atic.bis.divert.tactics.log.list", true);
        }
        catch (Exception e) {
            logger.error((Object)"deleteDivertLogData error", (Throwable)e);
            this.processOpeLog(0, false, "", "lego.err.570507", "atic.bis.divert.tactics.log.list", true);
        }
    }

    private void processOpeLog(int num, Boolean sucess, String time, String errorInfo, String target, boolean targetLocal) {
        ISysOptLog sysOptLogMgr = SysOptLogAnalysisUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation("atic.bis.divert.tactics.log.timeDel");
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("atic.bis.divert.tactics.log.timeDel.success");
            String[] para = new String[]{time, String.valueOf(num)};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(errorInfo);
        }
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    public void setAlive(boolean isAliveBool) {
        logger.info((Object)("DeleteLogDataThread isAlive: " + isAliveBool));
        this.isAlive = isAliveBool;
    }

    public void setDivertTacticsLog(DivertTacticsLogServiceImpl divertTacticsLog) {
        this.divertTacticsLog = divertTacticsLog;
    }

    private int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(6);
        return day;
    }

    private Boolean isTime2Run(int currentDay) {
        int hour;
        Calendar cal = Calendar.getInstance();
        if (currentDay > this.beforeDay && (hour = cal.get(11)) >= 3) {
            this.beforeDay = currentDay;
            return true;
        }
        return false;
    }
}

