/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.ConfigBlackholeNp;
import java.util.List;

public class BlackholeAlarmHandler {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private IAlarmService alarmService;
    private PageSizeConfigService pageSizeConfigService;
    private int defaultUnBolockTime = 0;

    public void blackholeAlarmReport(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240814");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmReport error", (Throwable)e);
        }
    }

    public void blackholeAlarmReportFailed(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240828");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmReport error", (Throwable)e);
        }
    }

    public void blackholeAlarmReportStopFailed(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240830");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmReport error", (Throwable)e);
        }
    }

    public void blackholeAlarmAPIReportStopFailed(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[6];
            alarmParam[0] = deviceName;
            alarmParam[1] = divertIp;
            alarmParam[2] = deviceIp;
            alarmParam[3] = String.valueOf(this.defaultUnBolockTime) + " min";
            alarmParam[4] = "--";
            alarmObject.setAlarmId("0x0000000803240835");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAPIAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAPIAlarmReport error", (Throwable)e);
        }
    }

    public void blackholeAlarmBoardReport(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmBoardReport error", (Throwable)e);
        }
    }

    public void blackholeAPIAlarmBoardReport(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240836");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAPIAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAPIAlarmBoardReport error", (Throwable)e);
        }
    }

    public void blackholeAlarmBoardReportFailed(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240829");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmBoardReport error", (Throwable)e);
        }
    }

    public void blackholeAPIAlarmBoardReportFailed(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240834");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAPIAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAPIAlarmBoardReport error", (Throwable)e);
        }
    }

    public void blackholeAlarmBoardReportStopFailed(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240831");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmBoardReport error", (Throwable)e);
        }
    }

    public void blackholeNpAlarmBoardReport(DivertBlackholeForm divertBlackhole, ConfigBlackholeNp configBlackholeNp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{divertBlackhole.getDeviceName(), divertBlackhole.getDeviceIP(), divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask(), String.valueOf(configBlackholeNp.getTimeLong()) + " min", "com.hs.atic.alart.blackhole.confirm.stepbystep"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(divertBlackhole.getDeviceId());
            alarmObject.setMoName(divertBlackhole.getDeviceName());
            alarmObject.setMoIp(divertBlackhole.getDeviceIP());
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport Np error, divertIp=" + divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask() + ", deviceIp=" + divertBlackhole.getDeviceIP()), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmBoardReport error", (Throwable)e);
        }
    }

    public void blackholeNpAlarmBoardClear(DivertBlackholeForm divertBlackhole, ConfigBlackholeNp configBlackholeNp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{divertBlackhole.getDeviceName(), divertBlackhole.getDeviceIP(), divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask(), String.valueOf(configBlackholeNp.getTimeLong()) + " min", "com.hs.atic.alart.blackhole.confirm.stepbystep"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(divertBlackhole.getDeviceId());
            alarmObject.setMoName(divertBlackhole.getDeviceName());
            alarmObject.setMoIp(divertBlackhole.getDeviceIP());
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport Np error, divertIp=" + divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask() + ", deviceIp=" + divertBlackhole.getDeviceIP()), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"divertStopAlarm  error", (Throwable)e);
        }
    }

    private void findBlackHoleWhiteTime() {
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("unblockTime");
        this.defaultUnBolockTime = null != sysConfigs && !sysConfigs.isEmpty() ? Integer.parseInt(((PageSizeConfig)sysConfigs.get(0)).getSysValue()) : 30;
    }

    public void blackholeAlarmClear(String zoneName, String deviceName, String deviceIp, String divertIp, String vpn, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240814");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmClear error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmClear  error", (Throwable)e);
        }
    }

    public void blackholeAlarmBoardClear(String deviceName, String deviceIp, String divertIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardClear error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAlarmBoardClear  error", (Throwable)e);
        }
    }

    public void blackholeAlarmAPIBoardClear(String deviceName, String deviceIp, String divertIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240836");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAPIAlarmBoardClear error, divertIp=" + divertIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"blackholeAPIAlarmBoardClear  error", (Throwable)e);
        }
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public PageSizeConfigService getPageSizeConfigService() {
        return this.pageSizeConfigService;
    }

    public void setPageSizeConfigService(PageSizeConfigService pageSizeConfigService) {
        this.pageSizeConfigService = pageSizeConfigService;
    }

    public int getDefaultUnBolockTime() {
        return this.defaultUnBolockTime;
    }

    public void setDefaultUnBolockTime(int defaultUnBolockTime) {
        this.defaultUnBolockTime = defaultUnBolockTime;
    }
}

