/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.rmi.IpStateData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class BlackholeDataBuffer {
    private static final int TASK_MAX_SIZE = 10000;
    private static final int BATCH_SIZE = 100;
    private static BlackholeDataBuffer instance;
    private static List<IpStateData> ipStateList;
    private static ReentrantLock lock;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);

    private BlackholeDataBuffer() {
    }

    public static BlackholeDataBuffer getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new BlackholeDataBuffer();
            }
            BlackholeDataBuffer blackholeDataBuffer = instance;
            return blackholeDataBuffer;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIpStateData(List<IpStateData> list) {
        lock.lock();
        try {
            for (IpStateData data : list) {
                if (ipStateList.size() < 10000) {
                    ipStateList.add(data);
                    continue;
                }
                this.logger.error((Object)"The size of buffer has exceed 10000, drop some blackhole task.");
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void addIpStateData(IpStateData data) {
        lock.lock();
        try {
            if (ipStateList.size() < 10000) {
                ipStateList.add(data);
            } else {
                this.logger.error((Object)"The size of buffer has exceed 10000, drop blackhole task.");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public List<IpStateData> getIpStateData() {
        lock.lock();
        try {
            ArrayList<IpStateData> result = new ArrayList<IpStateData>(100);
            if (ipStateList.size() > 100) {
                result.addAll(ipStateList.subList(0, 100));
                ipStateList.subList(0, 100).clear();
            } else {
                result.addAll(ipStateList);
                ipStateList.clear();
            }
            ArrayList<IpStateData> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        ipStateList = new ArrayList<IpStateData>(10000);
        lock = new ReentrantLock();
    }
}

