/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.sdk.bis.form.BlackholeWhiteTimeForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class BlackholeWhiteTimeDataBuffer {
    private static final int TASK_MAX_SIZE = 100000;
    private static BlackholeWhiteTimeDataBuffer instance;
    private static List<BlackholeWhiteTimeForm> ipStateList;
    private static ReentrantLock lock;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);

    private BlackholeWhiteTimeDataBuffer() {
    }

    public static BlackholeWhiteTimeDataBuffer getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new BlackholeWhiteTimeDataBuffer();
            }
            BlackholeWhiteTimeDataBuffer blackholeWhiteTimeDataBuffer = instance;
            return blackholeWhiteTimeDataBuffer;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIpStateData(List<BlackholeWhiteTimeForm> blackholeWhiteTimeForms) {
        lock.lock();
        try {
            for (BlackholeWhiteTimeForm blackholeWhiteTimeForm : blackholeWhiteTimeForms) {
                if (ipStateList.size() < 100000) {
                    ipStateList.add(blackholeWhiteTimeForm);
                    continue;
                }
                this.logger.error((Object)"The size of buffer has exceed 100000, drop blackhole white time .");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void addIpStateData(BlackholeWhiteTimeForm blackholeWhiteTimeForm) {
        lock.lock();
        try {
            if (ipStateList.size() < 100000) {
                ipStateList.add(blackholeWhiteTimeForm);
            } else {
                this.logger.error((Object)"The size of buffer has exceed 100000, drop blackhole white time .");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public List<BlackholeWhiteTimeForm> getIpStateData() {
        lock.lock();
        try {
            ArrayList<BlackholeWhiteTimeForm> result = new ArrayList<BlackholeWhiteTimeForm>();
            result.addAll(ipStateList);
            ArrayList<BlackholeWhiteTimeForm> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    public void removeIpStateDate(List<BlackholeWhiteTimeForm> blackholeWhiteTimeForms) {
        lock.lock();
        try {
            ipStateList.removeAll(blackholeWhiteTimeForms);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        ipStateList = new ArrayList<BlackholeWhiteTimeForm>(100000);
        lock = new ReentrantLock();
    }
}

