/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class CloudCleanUtil {
    public static final String CLOUD_CLEAN_SP_CTCC = "CTCC";
    public static final String CLOUD_CLEAN_SP_HW = "HW";
    public static final String CLOUD_CLEAN_METHOD_CTCC_ENABLE = "blockIP";
    public static final String CLOUD_CLEAN_METHOD_CTCC_DISABLE = "unblockIP";
    public static final String CLOUD_CLEAN_METHOD_HW_EVENT = "/api/events/";
    public static final String CLOUD_CLEAN_METHOD_CTCC_ACCOUNT = "getAccountInfo";
    public static final String CLOUD_CLEAN_METHOD_HW_ACCOUNT = "/api/profiling/";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private static final CloudCleanUtil INSTANCE = new CloudCleanUtil();

    public static CloudCleanUtil getInstance() {
        return INSTANCE;
    }

    public void enableCloudClean4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, Map<String, String> params) {
        String ip = params.get("ipMask");
        if (null != params.get("ipMask")) {
            ip = ip.split("/")[0];
        }
        String paramStr = "[\"" + ip + "\"," + params.get("zone") + "," + params.get("unblockTime") + "]";
        String json = CloudCleanUtil.getInstance().connectRestful4CTCC(targetURL, accessKey, secretKey, CLOUD_CLEAN_METHOD_CTCC_ENABLE, paramStr);
        if (CloudCleanUtil.validateResult(json)) {
            JSONObject obj1 = JSONObject.fromObject((Object)json);
            if (obj1.containsKey((Object)"result")) {
                JSONObject obj2 = JSONObject.fromObject((Object)obj1.getString("result"));
                JSONArray array = JSONArray.fromObject((Object)obj2.getString("errorList"));
                if (!array.isEmpty()) {
                    JSONObject obj3 = JSONObject.fromObject((Object)array.getJSONObject(0));
                    CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj3.getString("code")));
                    logger.info((Object)("enableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj3.getString("code"))));
                }
            } else if (obj1.containsKey((Object)"error")) {
                JSONObject obj4 = JSONObject.fromObject((Object)obj1.getString("error"));
                CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj4.getString("code")));
                logger.info((Object)("enableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj4.getString("code"))));
            } else {
                logger.error((Object)("enableCloudClean4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(json)));
                if (obj1.containsKey((Object)"code")) {
                    String code = obj1.getString("code");
                    CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(code));
                }
            }
        } else {
            throw new LegoCheckedException(571961L);
        }
    }

    public static void disableCloudClean4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String params) {
        String paramStr = "[\"" + params + "\"]";
        String json = CloudCleanUtil.getInstance().connectRestful4CTCC(targetURL, accessKey, secretKey, CLOUD_CLEAN_METHOD_CTCC_DISABLE, paramStr);
        if (CloudCleanUtil.validateResult(json)) {
            JSONObject jsonObject = JSONObject.fromObject((Object)json);
            if (jsonObject.containsKey((Object)"code")) {
                JSONObject obj5;
                JSONArray jsonArray;
                JSONObject obj4;
                if (jsonObject.containsKey((Object)"result") && (obj4 = JSONObject.fromObject((Object)jsonObject.getString("result"))).containsKey((Object)"errorList") && !(jsonArray = obj4.getJSONArray("errorList")).isEmpty() && (obj5 = jsonArray.getJSONObject(0)).containsKey((Object)"code") && 409 == Integer.parseInt(obj5.getString("code"))) {
                    logger.warn((Object)("this blackhole is disabled. param : " + params));
                    return;
                }
                String code = jsonObject.getString("code");
                CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(code));
                logger.info((Object)("disableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(code)));
            } else if (jsonObject.containsKey((Object)"error")) {
                JSONObject obj4 = JSONObject.fromObject((Object)jsonObject.getString("error"));
                CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj4.getString("code")));
                logger.info((Object)("disableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj4.getString("code"))));
            } else {
                logger.error((Object)("disableCloudClean4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(json)));
            }
        } else {
            throw new LegoCheckedException(571961L);
        }
    }

    public String enableCloudClean4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, Map<String, String> params) {
        String curFlow = params.get("curFlow");
        if (null == curFlow) {
            curFlow = "";
        }
        String json = "{\"curr_bandwidth\": \"" + curFlow + "\", \"attack_type\": \"\", \"cidr\": \"" + params.get("ipMask") + "\", \"clean_country\": \"\", \"action\": \"" + params.get("defendAction") + "\"}";
        String result = "";
        try {
            result = this.connectRestByPost(targetURL, CLOUD_CLEAN_METHOD_HW_EVENT, json, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, json, null));
        }
        catch (LegoCheckedException e) {
            try {
                result = this.connectRestByPost(targetURL, CLOUD_CLEAN_METHOD_HW_EVENT, json, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, json, null));
            }
            catch (LegoCheckedException exception) {
                throw new LegoCheckedException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        String eventId = null;
        if (CloudCleanUtil.validateResult(result)) {
            eventId = JSONObject.fromObject((Object)result).getString("id");
            logger.info((Object)("enableCloudClean4HW, eventId=" + eventId));
        }
        return eventId;
    }

    public void disableCloudClean4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String eventId) {
        logger.info((Object)("disableCloudClean4HW start for eventId " + eventId));
        String action = CLOUD_CLEAN_METHOD_HW_EVENT;
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            logger.error((Object)"cannot disableCloudClean4HW because eventId is null");
            return;
        }
        action = action + eventId + "/";
        String result = "";
        try {
            result = this.connectRestByDel(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId));
        }
        catch (LegoCheckedException e) {
            try {
                result = this.connectRestByDel(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId));
            }
            catch (LegoCheckedException exception) {
                try {
                    result = this.connectRestByDel(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId));
                }
                catch (LegoCheckedException exception1) {
                    logger.error((Object)("disableCloudClean4HW failed, eventId=" + eventId));
                    throw new LegoCheckedException(exception1.getErrorCode(), (Throwable)exception1);
                }
            }
        }
        if (CloudCleanUtil.validateResult(result)) {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            String id = jsonObject.getString("id");
            String startTime = jsonObject.getString("start_time");
            String endTime = jsonObject.getString("end_time");
            logger.info((Object)("disableCloudClean4HW success, eventId=" + id + ", startTime=" + startTime + ", endTime=" + endTime));
        }
    }

    public String getCloudCleanStatus4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String eventId) {
        String action = CLOUD_CLEAN_METHOD_HW_EVENT;
        String status = null;
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            logger.error((Object)"getCloudCleanStatus4HW failed, eventId is null");
            return status;
        }
        action = action + eventId + "/";
        String result = "";
        try {
            result = this.connectRestByGet(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId));
        }
        catch (LegoCheckedException e) {
            try {
                result = this.connectRestByGet(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId));
            }
            catch (LegoCheckedException exception) {
                throw new LegoCheckedException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        if (CloudCleanUtil.validateResult(result)) {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            String id = jsonObject.getString("id");
            String startTime = jsonObject.getString("start_time");
            String endTime = jsonObject.getString("end_time");
            status = jsonObject.getString("status");
            logger.info((Object)("getCloudCleanStatus4HW, eventId=" + id + ", status=" + status + ", startTime=" + startTime + ", endTime=" + endTime));
        }
        return status;
    }

    public Map<String, String> getAccountInfo4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey) {
        HashMap<String, String> accountInfo = null;
        String json = this.connectRestful4CTCC(targetURL, accessKey, secretKey, CLOUD_CLEAN_METHOD_CTCC_ACCOUNT, "");
        if (CloudCleanUtil.validateResult(json)) {
            JSONObject obj1 = JSONObject.fromObject((Object)json);
            if (obj1.containsKey((Object)"code")) {
                CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj1.getString("code")));
                JSONObject obj2 = JSONObject.fromObject((Object)obj1.getString("result"));
                JSONObject obj3 = JSONObject.fromObject((Object)obj2.getString("account"));
                String name = obj3.containsKey((Object)"name") ? obj3.getString("name") : "";
                String amount = obj3.containsKey((Object)"amount") ? obj3.getString("amount") : "";
                String remainAmount = obj3.containsKey((Object)"remainAmount") ? obj3.getString("remainAmount") : "";
                String remainChannel = obj3.containsKey((Object)"remainChannel") ? obj3.getString("remainChannel") : "";
                accountInfo = new HashMap<String, String>();
                accountInfo.put("name", name);
                accountInfo.put("amount", amount);
                accountInfo.put("remainAmount", remainAmount);
                accountInfo.put("remainChannel", remainChannel);
                logger.info((Object)("getAccountInfo4CTCC, name=" + CloudCleanUtil.getcleanedMessage(name) + ", amount=" + amount + ", remainAmount=" + remainAmount + ", remainChannel=" + CloudCleanUtil.getcleanedMessage(remainChannel)));
            } else if (obj1.containsKey((Object)"error")) {
                JSONObject obj4 = JSONObject.fromObject((Object)obj1.getString("error"));
                CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj4.getString("code")));
                logger.info((Object)("getAccountInfo4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj4.getString("code"))));
            } else {
                logger.error((Object)("getAccountInfo4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(json)));
            }
        } else {
            throw new LegoCheckedException(571961L);
        }
        return accountInfo;
    }

    public Map<String, String> getAccountInfo4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey) {
        JSONObject obj1;
        HashMap<String, String> accountInfo = null;
        String json = this.connectRestByGet(targetURL, CLOUD_CLEAN_METHOD_HW_ACCOUNT, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_ACCOUNT, null, null));
        if (CloudCleanUtil.validateResult(json) && (obj1 = JSONObject.fromObject((Object)json)).containsKey((Object)"clean_tokens")) {
            JSONObject obj2 = JSONObject.fromObject((Object)obj1.getString("clean_tokens"));
            String name = obj1.containsKey((Object)"customer_name") ? obj1.getString("customer_name") : "";
            String total = obj2.containsKey((Object)"total") ? obj2.getString("total") : "";
            String remaining = obj2.containsKey((Object)"remaining") ? obj2.getString("remaining") : "";
            accountInfo = new HashMap<String, String>();
            accountInfo.put("name", name);
            accountInfo.put("total", total);
            accountInfo.put("remaining", remaining);
            logger.info((Object)("getAccountInfo4HW, name=" + CloudCleanUtil.getcleanedMessage(name) + ", total=" + total + ", remaining=" + CloudCleanUtil.getcleanedMessage(remaining)));
        }
        return accountInfo;
    }

    private String connectRestful4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String method, String params) {
        String result = null;
        InputStream in = null;
        int statusCode = -1;
        if (!targetURL.startsWith("https")) {
            throw new LegoCheckedException(571974L);
        }
        if (StringUtils.isEmpty((CharSequence)params)) {
            params = "[]";
        }
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            Map<String, String> authInfo = CloudCleanUtil.buildAuthInfo4CTCC(accessKey, secretKey, method, params);
            HttpPost postMethod = new HttpPost(targetURL);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            postMethod.setConfig(globalConfig);
            postMethod.setHeader("Content-type", "text/json");
            postMethod.setHeader("Json-Rpc-Tonce", authInfo.get("tonce"));
            postMethod.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContexts.custom().build();
            sslcontext.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslcontext, null, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier())).build();
            String json = "{\"method\":\"" + method + "\",\"params\":" + params + "}";
            logger.info((Object)"connectRestful4CTCC targetURL ");
            logger.info((Object)"connectRestful4CTCC json is:");
            StringEntity myEntity = new StringEntity(json, ContentType.create((String)"text/plain", (String)"UTF-8"));
            postMethod.setEntity((HttpEntity)myEntity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestful4CTCC, statusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB, "utf-8");
            }
            logger.info((Object)("connectRestful4CTCC, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (ClientProtocolException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)("connectRestful4CTCC close in error" + e.getMessage()));
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)("httpClient close in error" + e.getMessage()));
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)("response close in error" + e.getMessage()));
                }
            }
        }
        return result;
    }

    private static Map<String, String> buildAuthInfo4CTCC(StringBuffer accessKey, StringBuffer secretKey, String method, String params) {
        HashMap<String, String> authInfo = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() * 1000L);
        StringBuffer signature = new StringBuffer();
        signature.append("tonce=").append(timestamp).append("&accesskey=").append(accessKey).append("&method=").append(method).append("&params=").append(params);
        String hmacStr = CloudCleanUtil.hmac256(signature, secretKey);
        String auth = CloudCleanUtil.getBASE64(accessKey + ":" + hmacStr);
        authInfo.put("tonce", timestamp);
        authInfo.put("auth", auth);
        return authInfo;
    }

    private static Map<String, String> buildAuthInfo4HW(StringBuffer accessKey, StringBuffer secretKey, String method, String json, String eventId) {
        HashMap<String, String> authInfo = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        StringBuffer signature = new StringBuffer();
        if (StringUtils.isEmpty((CharSequence)json)) {
            json = "{}";
        }
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            signature.append(method).append(json);
        } else {
            signature.append(method).append(eventId).append("/").append(json);
        }
        String hmacStr = CloudCleanUtil.hmac256(signature, secretKey);
        String auth = CloudCleanUtil.getBASE64(accessKey + ":" + hmacStr);
        authInfo.put("tonce", timestamp);
        authInfo.put("auth", auth);
        return authInfo;
    }

    private String connectRestByPost(String url, String action, String json, Map<String, String> authInfo) {
        String result = null;
        InputStream in = null;
        int statusCode = -1;
        CloseableHttpClient httpClient = null;
        if (!url.startsWith("https")) {
            return null;
        }
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            HttpPost method = new HttpPost(url + action);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            method.setConfig(globalConfig);
            method.setHeader("Content-type", "application/json");
            method.setHeader("Date", authInfo.get("tonce"));
            method.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContexts.custom().build();
            sslcontext.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, (HostnameVerifier)new TrustAnyHostnameVerifier());
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            StringEntity myEntity = new StringEntity(json, ContentType.create((String)"text/plain", (String)"UTF-8"));
            method.setEntity((HttpEntity)myEntity);
            response = httpClient.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestByPost, StatusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB);
            }
            logger.info((Object)("connectRestByPost, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (ClientProtocolException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)("connectRestByPost close in error" + e.getMessage()));
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)("response close in error" + e.getMessage()));
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)("httpClient close in error" + e.getMessage()));
                }
            }
        }
        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_HW, statusCode);
        return result;
    }

    private String connectRestByGet(String url, String action, Map<String, String> authInfo) {
        String result = null;
        int statusCode = -1;
        InputStream in = null;
        CloseableHttpClient httpClient = null;
        if (!url.startsWith("https")) {
            return null;
        }
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            HttpGet method = new HttpGet(url + action);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            method.setConfig(globalConfig);
            method.setHeader("Content-type", "application/json");
            method.setHeader("Date", authInfo.get("tonce"));
            method.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContexts.custom().build();
            sslcontext.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, (HostnameVerifier)new TrustAnyHostnameVerifier());
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            response = httpClient.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestByGet, StatusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB);
            }
            logger.info((Object)("connectRestByGet, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (ClientProtocolException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)("connectRestByGet close in error" + e.getMessage()));
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)("response close in error" + e.getMessage()));
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)("httpClient close in error" + e.getMessage()));
                }
            }
        }
        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_HW, statusCode);
        return result;
    }

    private String connectRestByDel(String url, String action, Map<String, String> authInfo) {
        String result = null;
        int statusCode = -1;
        InputStream in = null;
        CloseableHttpClient httpClient = null;
        if (!url.startsWith("https")) {
            return null;
        }
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            HttpDelete method = new HttpDelete(url + action);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            method.setConfig(globalConfig);
            method.setHeader("Content-type", "application/json");
            method.setHeader("Date", authInfo.get("tonce"));
            method.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContexts.custom().build();
            sslcontext.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, (HostnameVerifier)new TrustAnyHostnameVerifier());
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            response = httpClient.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestByDel, StatusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB);
            }
            logger.info((Object)("connectRestByDel, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestByDel error" + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestByDel error" + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("connectRestByDel error" + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestByDel error" + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)("connectRestByDel close in error" + e.getMessage()));
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)("response close in error" + e.getMessage()));
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)("httpClient close in error" + e.getMessage()));
                }
            }
        }
        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_HW, statusCode);
        return result;
    }

    private static String hmac256(StringBuffer macData, StringBuffer macKey) {
        String result = null;
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
            byte[] secretByte = macKey.toString().getBytes("UTF-8");
            byte[] dataBytes = macData.toString().getBytes("UTF-8");
            SecretKeySpec secret = new SecretKeySpec(secretByte, "HMACSHA256");
            mac.init(secret);
            byte[] doFinal = mac.doFinal(dataBytes);
            byte[] hexB = new Hex().encode(doFinal);
            result = new String(hexB, "utf-8");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("hmac256 method is error" + e.getMessage()));
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("hmac256 method is error" + e.getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("hmac256 method is error" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("hmac256 method is error" + e.getMessage()));
        }
        return result;
    }

    private static void dealStatusCode(String sp, int code) {
        if (-1 == code) {
            throw new LegoCheckedException(571971L);
        }
        if (200 == code) {
            return;
        }
        if (CLOUD_CLEAN_SP_HW.equals(sp)) {
            if (401 == code) {
                throw new LegoCheckedException(571951L);
            }
            if (404 == code) {
                throw new LegoCheckedException(571954L);
            }
            if (402 == code) {
                throw new LegoCheckedException(571952L);
            }
            if (403 == code) {
                throw new LegoCheckedException(571953L);
            }
            throw new LegoCheckedException(571968L);
        }
        if (405 == code) {
            throw new LegoCheckedException(571964L);
        }
        if (401 == code) {
            throw new LegoCheckedException(571961L);
        }
        if (403 == code) {
            throw new LegoCheckedException(571962L);
        }
        if (404 == code) {
            throw new LegoCheckedException(571963L);
        }
        if (410 == code) {
            throw new LegoCheckedException(571965L);
        }
        if (415 == code) {
            throw new LegoCheckedException(571966L);
        }
        if (420 == code) {
            throw new LegoCheckedException(571967L);
        }
        if (205 == code) {
            throw new LegoCheckedException(571969L);
        }
        if (500 == code) {
            throw new LegoCheckedException(571968L);
        }
        if (430 == code) {
            throw new LegoCheckedException(571970L);
        }
        throw new LegoCheckedException(571968L);
    }

    private static String getBASE64(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Base64.encodeBase64((byte[])str.getBytes("utf-8")), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            return null;
        }
    }

    private static boolean validateResult(String json) {
        boolean result = false;
        if (null != json) {
            if ((json = json.trim()).startsWith("{") && json.endsWith("}") && json.contains(":")) {
                result = true;
            } else {
                logger.error((Object)("validateResult, json content is illegal, json=" + CloudCleanUtil.getcleanedMessage(json)));
                throw new LegoCheckedException(571971L);
            }
        }
        return result;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }

    static class TrustAnyTrustManager
    implements X509TrustManager {
        TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

