/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.bis.dao.OutboundDivertTacticsDao;
import com.hs.atic.bis.dao.OutboundDivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.bis.model.OutboundDivertTactics;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsForm;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.OutboundDivertData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DivertOutboundThread
extends Thread {
    private static final int I_WANNA_SLEEP_FOR_A_WHILE = 100;
    private static final int BATCH_SIZE = 20;
    private static final int TEN_THOUSAND = 10000;
    private static final int FIVE_MILLION = 5000000;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private List<OutboundDivertData> nowProcessing = new ArrayList<OutboundDivertData>();
    private AticDevice device;
    private boolean active = true;
    private OutboundDivertTacticsLogDao outboundDivertTacticsLogDao;
    private OutboundDivertTacticsDao outboundDivertTacticsDao;
    private IOutboundDivertTacticsService outboundDivertTacticsService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private ISysOptLog sysLogService;

    public DivertOutboundThread(AticDevice device, OutboundDivertTacticsLogDao divertTacticsLogDao, OutboundDivertTacticsDao divertTacticsDao, IOutboundDivertTacticsService divertTacticsService, IZonePolicyApplyService zonePolicyApplyService) {
        this.setName("DivertThread_" + device.getIpAddress());
        this.device = device;
        this.outboundDivertTacticsLogDao = divertTacticsLogDao;
        this.outboundDivertTacticsDao = divertTacticsDao;
        this.outboundDivertTacticsService = divertTacticsService;
        this.zonePolicyApplyService = zonePolicyApplyService;
        this.logger.info((Object)("construct a divert thread, deviceIp=" + this.getcleanedMessage(device.getIpAddress())));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                this.startOrStopDivertFromQueue();
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    private void startOrStopDivertFromQueue() {
        while (this.active) {
            List<OutboundDivertData> result = this.getBatchData();
            while (!result.isEmpty()) {
                OutboundDivertData outboundDivertData = result.remove(0);
                this.logger.info((Object)("begin to process, zoneIp=" + outboundDivertData.getDevDivert().getSourceIp() + ", zoneId=" + outboundDivertData.getDevDivert().getZoneId() + ", deviceIp=" + this.getcleanedMessage(this.device.getIpAddress())));
                try {
                    if (98 == outboundDivertData.getPolicy()) {
                        this.stopDivert(outboundDivertData);
                        continue;
                    }
                    this.startDivert(outboundDivertData);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    String remark = "firewall.exception";
                    if (this.outboundDivertTacticsLogDao.queryAndDeleteLog(5000000, 10000)) {
                        this.writeSyslog(outboundDivertData.getDevDivert(), 10000);
                    }
                    this.outboundDivertTacticsLogDao.saveDivertLog(outboundDivertData.getDevDivert(), outboundDivertData.getPolicy(), remark, 3);
                }
            }
        }
    }

    private void writeSyslog(OutboundDivertTactics outboundDivertTactics, int limit) {
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.log.auto.delete");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(outboundDivertTactics.getClientIp());
        sysLog.setTarget("atic.bis.divert.tactics.log.auto.tactics.divertlog");
        sysLog.setTargetLocal(Boolean.valueOf(true));
        sysLog.setOperator(outboundDivertTactics.getOperator());
        sysLog.setDetail("atic.bis.divert.tactics.log.auto.delete.success");
        String[] para = new String[]{String.valueOf(limit)};
        sysLog.setDetailPara(para);
        sysLog.setResult(1);
        this.sysLogService.writeOptLog(sysLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OutboundDivertData> getBatchData() {
        List<OutboundDivertData> list = this.nowProcessing;
        synchronized (list) {
            ArrayList<OutboundDivertData> result = new ArrayList<OutboundDivertData>();
            if (this.nowProcessing.size() > 20) {
                result.addAll(this.nowProcessing.subList(0, 20));
                this.nowProcessing.subList(0, 20).clear();
            } else {
                result.addAll(this.nowProcessing);
                this.nowProcessing.clear();
            }
            return result;
        }
    }

    private void startDivert(OutboundDivertData outboundDivertData) {
        OutboundDivertTactics outboundDivertTactics = outboundDivertData.getDevDivert();
        long deviceId = outboundDivertTactics.getDeviceId();
        String zoneIp = outboundDivertTactics.getSourceIp();
        this.logger.info((Object)("startDivert, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneIp=" + zoneIp));
        if (IPUtil.isIpv4((String)zoneIp)) {
            outboundDivertTactics.setSourceIp(zoneIp + "/32");
        } else {
            outboundDivertTactics.setSourceIp(zoneIp + "/128");
        }
        OutboundDivertTactics divertInDB = this.outboundDivertTacticsDao.getDivertTacticsByZoneIp(deviceId, zoneIp);
        if (null != divertInDB) {
            if (divertInDB.getDivertStatus() == 0 && divertInDB.getDivertMode() != 2) {
                this.logger.info((Object)("start exist off divert , deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneIp=" + outboundDivertTactics.getSourceIp() + ", RAM divertMode =" + outboundDivertTactics.getDivertMode() + ", DB divertMode =" + divertInDB.getDivertMode() + ", divertStatus=" + divertInDB.getDivertStatus()));
            } else {
                this.logger.info((Object)("Repeated divert task and return, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneIp=" + outboundDivertTactics.getSourceIp() + ", RAM divertMode =" + outboundDivertTactics.getDivertMode() + ", DB divertMode =" + divertInDB.getDivertMode() + ", divertStatus=" + divertInDB.getDivertStatus()));
                return;
            }
        }
        outboundDivertTactics.setOperator("system");
        String clientIp = System.getProperty("nms.server.host");
        outboundDivertTactics.setClientIp(clientIp);
        outboundDivertTactics.setProtocol(0);
        ZonePolicyApplyForm zonePolicyApplyForm = this.zonePolicyApplyService.queryByZoneId(outboundDivertTactics.getZoneId());
        if (null != zonePolicyApplyForm) {
            outboundDivertTactics.setZoneDesc(zonePolicyApplyForm.getZoneDesc());
            outboundDivertTactics.setZoneId(zonePolicyApplyForm.getZoneId());
            outboundDivertTactics.setDeviceName(zonePolicyApplyForm.getDeviceNames());
            outboundDivertTactics.setNextHop(zonePolicyApplyForm.getOutBoundNextHop());
            outboundDivertTactics.setAction(zonePolicyApplyForm.getOutBoundFilterAction());
            outboundDivertTactics.setThreshold(zonePolicyApplyForm.getOutBoundFilterLimit());
        }
        if (null != outboundDivertTactics.getDivertMode()) {
            try {
                this.logger.info((Object)"outbounddivert mode is auto, deploy and save it");
                OutboundDivertTacticsForm form = (OutboundDivertTacticsForm)AticUtil.copyProperties((Object)outboundDivertTactics, (Object)new OutboundDivertTacticsForm());
                this.outboundDivertTacticsService.deployAndSaveOutboundDivertTactics(form, true);
            }
            catch (Exception e) {
                this.logger.error((Object)("start divert failed, zoneIp = " + outboundDivertTactics.getSourceIp()), (Throwable)e);
            }
        }
    }

    private void stopDivert(OutboundDivertData outboundDivertData) {
        OutboundDivertTactics outboundDivertTactics = outboundDivertData.getDevDivert();
        String zoneIp = outboundDivertTactics.getSourceIp();
        this.logger.info((Object)("stopDivert, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneId=" + outboundDivertTactics.getZoneId() + ", zoneIp=" + zoneIp));
        OutboundDivertTactics outboundDivertInDB = this.outboundDivertTacticsDao.getDivertTacticsByZoneIp(outboundDivertTactics.getDeviceId(), zoneIp);
        if (outboundDivertInDB == null) {
            this.logger.info((Object)("Cannot find outbounddivertTask and return, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneId=" + outboundDivertTactics.getZoneId() + ", zoneIp=" + zoneIp));
            return;
        }
        if (outboundDivertInDB.getDivertMode() == 2) {
            return;
        }
        outboundDivertInDB.setOperator("system");
        String clientIp = System.getProperty("nms.server.host");
        outboundDivertInDB.setClientIp(clientIp);
        OutboundDivertTacticsForm outboundDivertTacticsForm = (OutboundDivertTacticsForm)AticUtil.copyProperties((Object)outboundDivertInDB, (Object)new OutboundDivertTacticsForm());
        if (1 == outboundDivertTacticsForm.getDivertStatus()) {
            try {
                this.logger.info((Object)"divert status is on, stop it first.");
                outboundDivertTacticsForm = this.outboundDivertTacticsService.stopSigleDivertTactics(outboundDivertTacticsForm, true);
                if (0 == outboundDivertTacticsForm.getDivertStatus()) {
                    this.outboundDivertTacticsService.removeDivertTactics(outboundDivertTacticsForm);
                    this.logger.info((Object)("remove the divert : " + outboundDivertTactics + " by thread."));
                }
            }
            catch (LegoCheckedException e) {
                Long errorCode = e.getErrorCode();
                if (571212 == errorCode.intValue()) {
                    this.outboundDivertTacticsService.removeDivertTactics(outboundDivertTacticsForm);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("stop divert failed, zoneIp = " + outboundDivertTactics.getSourceIp()), (Throwable)e);
            }
        }
    }

    private OutboundDivertTactics composeDivertTactics(long deviceId, long zoneId, String zoneIp, String vpnName) {
        OutboundDivertTactics divertTactics = new OutboundDivertTactics();
        divertTactics.setDeviceId(deviceId);
        divertTactics.setZoneId(zoneId);
        divertTactics.setCreateTime(Calendar.getInstance().getTimeInMillis() / 1000L);
        divertTactics.setSourceIp(zoneIp);
        divertTactics.setDivertMode(1);
        return divertTactics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayDivertData(OutboundDivertData divertData) {
        this.logger.info((Object)("replay to nowProcessing, pkId=" + divertData.getDevDivert().getId() + ", zoneIp=" + divertData.getDevDivert().getSourceIp()));
        String zoneIp = divertData.getDevDivert().getSourceIp();
        List<OutboundDivertData> list = this.nowProcessing;
        synchronized (list) {
            for (OutboundDivertData nowData : this.nowProcessing) {
                if (!nowData.getDevDivert().getSourceIp().equals(zoneIp)) continue;
                return;
            }
            this.nowProcessing.add(divertData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDivertData(List<OutboundDivertData> divertDataList) {
        this.logger.info((Object)("Add divertDataList to nowProcessing, size=" + divertDataList.size()));
        List<OutboundDivertData> list = this.nowProcessing;
        synchronized (list) {
            this.nowProcessing.addAll(divertDataList);
        }
    }

    public void replayData4Thread(DivertTactics divertTactics, int policy, int replayNum) {
        Long zoneId = divertTactics.getZoneId();
        String zoneIp = divertTactics.getStartIp();
        String vpnName = divertTactics.getVpnName();
        OutboundDivertTactics divertT = this.composeDivertTactics(this.device.getMoId(), zoneId, zoneIp, vpnName);
        this.replayDivertData(new OutboundDivertData(divertT, policy, replayNum));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public AticDevice getDevice() {
        return this.device;
    }

    public void setDevice(AticDevice device) {
        this.device = device;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

