/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.util.DivertOutboundThread;
import com.huawei.atic.device.model.AticDevice;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class DivertOutboundThreadPool {
    private static Map<String, DivertOutboundThread> threadPool = new ConcurrentHashMap<String, DivertOutboundThread>();

    private DivertOutboundThreadPool() {
    }

    public static void put(String deviceIp, DivertOutboundThread thread) {
        threadPool.put(deviceIp, thread);
    }

    public static DivertOutboundThread get(String deviceIp) {
        return threadPool.get(deviceIp);
    }

    public static void remove(String deviceIp) {
        threadPool.get(deviceIp).setActive(false);
        threadPool.remove(deviceIp);
    }

    public static Set<String> getAllDivertDeviceIp() {
        HashSet<String> deviceIpSet = new HashSet<String>();
        deviceIpSet.addAll(threadPool.keySet());
        return deviceIpSet;
    }

    public static Set<AticDevice> getAllDivertDevice() {
        HashSet<AticDevice> deviceSet = new HashSet<AticDevice>();
        for (DivertOutboundThread divertThread : threadPool.values()) {
            deviceSet.add(divertThread.getDevice());
        }
        return deviceSet;
    }
}

