/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.util.ZoneInfoData;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class ZoneThread
extends Thread {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private static final int SLEEP_TIME = 1000;
    private static ZoneThread thread = null;
    private static ReentrantLock lock = new ReentrantLock();
    private List<ZoneInfoData> nowProcessing = new ArrayList<ZoneInfoData>();
    private Boolean isActive = false;
    private IDivertTacticsService divertTacticsService;
    private IZoneService zoneService;

    private ZoneThread(IDivertTacticsService divertTacticsService, IZoneService zoneService) {
        this.divertTacticsService = divertTacticsService;
        this.zoneService = zoneService;
        this.setName("update divert zoneName");
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public static ZoneThread getInstance(IDivertTacticsService divertTacticsService, IZoneService zoneService) {
        lock.lock();
        try {
            if (null == thread) {
                thread = new ZoneThread(divertTacticsService, zoneService);
            }
            ZoneThread zoneThread = thread;
            return zoneThread;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void run() {
        while (this.isActive.booleanValue()) {
            block5: {
                try {
                    this.updateDivertZoneNameFromQueue();
                }
                catch (Exception e) {
                    LOGGER.error((Object)(this.getClass().getSimpleName() + "'s run method failed:"), (Throwable)e);
                    if (null == lock) break block5;
                    lock.unlock();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"sleep failed:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateDivertZoneNameFromQueue() {
        isEmpty = false;
        try {
            ZoneThread.lock.lock();
            isEmpty = this.nowProcessing.isEmpty();
        }
        catch (Exception e1) {
            ZoneThread.LOGGER.error((Object)"lock exception", (Throwable)e1);
        }
        finally {
            ZoneThread.lock.unlock();
        }
lbl13:
        // 8 sources

        block16: while (this.isActive.booleanValue() && !isEmpty) {
            zoneInfoData = null;
            try {
                ZoneThread.lock.lock();
                zoneInfoData = this.nowProcessing.remove(0);
                isEmpty = this.nowProcessing.isEmpty();
                ZoneThread.LOGGER.info((Object)("in THREAD'S FromQueue method <----> zoneInfoData zoneId=" + zoneInfoData.getZoneId() + " ,devId=" + zoneInfoData.getDevId() + " ,type=" + zoneInfoData.getProType()));
                switch (zoneInfoData.getProType()) {
                    case 1: {
                        this.updateDivertZoneNameBySaveZone(zoneInfoData);
                        ** break;
                    }
                    case 2: {
                        this.updateDivertZoneNameByUpdateZone(zoneInfoData);
                        ** break;
                    }
                    case 3: {
                        this.updateDivertZoneNameByDefaultZoneAdd(zoneInfoData);
                        ** break;
                    }
                    case 4: {
                        this.updateDivertMode(zoneInfoData);
                        ** break;
                    }
                    default: {
                        ZoneThread.LOGGER.warn((Object)("enter default the type is " + zoneInfoData.getProType()));
                        continue block16;
                    }
                }
            }
            catch (Exception e) {
                ZoneThread.LOGGER.error((Object)"FromQueue method failed!", (Throwable)e);
            }
            finally {
                ZoneThread.lock.unlock();
            }
        }
    }

    private void updateDivertMode(ZoneInfoData zoneInfoData) {
        Long zoneId = zoneInfoData.getZoneId();
        if (null == zoneId) {
            LOGGER.info((Object)"zone id is null");
            return;
        }
        List divertTacticsForms = this.divertTacticsService.getDivertTacticsByZoneId(zoneId);
        for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
            if (2 == divertTacticsForm.getDivertMode()) continue;
            LOGGER.info((Object)("before update divert mode device is " + divertTacticsForm.getDeviceName() + "zoneid is " + divertTacticsForm.getZoneId() + "divertMode is " + divertTacticsForm.getDivertMode()));
            divertTacticsForm.setDivertMode(zoneInfoData.getDivertMode());
            LOGGER.info((Object)("after update divert mode device is " + divertTacticsForm.getDeviceName() + "zoneid is " + divertTacticsForm.getZoneId() + "divertMode is " + divertTacticsForm.getDivertMode()));
            this.divertTacticsService.saveDivertTactics(divertTacticsForm);
        }
    }

    private void updateDivertZoneNameBySaveZone(ZoneInfoData zoneInfoData) {
        Long zoneId = zoneInfoData.getZoneId();
        if (null == zoneId) {
            LOGGER.info((Object)"zone id is null");
            return;
        }
        List zoneIpForms = this.zoneService.findIpByZoneId(zoneId);
        for (ZoneIpForm zoneIpForm : zoneIpForms) {
            String startIp = zoneIpForm.getStartIp();
            String endIp = zoneIpForm.getEndIp();
            List divertTacticsForms = this.divertTacticsService.getDivertTacticsByIp(startIp, endIp);
            for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                divertTacticsForm.setZoneId(zoneId);
                this.divertTacticsService.updateZoneNameForDivert(divertTacticsForm, zoneId);
                LOGGER.info((Object)("update ZoneName For Divert .zoneId =" + zoneId + ",devip = " + divertTacticsForm.getDivertIp()));
            }
        }
    }

    private void updateDivertZoneNameByUpdateZone(ZoneInfoData zoneInfoData) {
        Long zoneId = zoneInfoData.getZoneId();
        if (null == zoneId) {
            LOGGER.info((Object)"zone id is null");
            return;
        }
        ZoneInfoForm zoneInfoForm = this.zoneService.getZoneNOIpById(zoneId);
        List zoneIpForms = this.zoneService.findIpByZoneId(zoneId);
        HashMap<Long, DivertTacticsForm> divertMap = new HashMap<Long, DivertTacticsForm>();
        List dTForms = this.divertTacticsService.getDivertTacticsByZoneId(zoneId);
        for (DivertTacticsForm divertTacticsForm : dTForms) {
            divertTacticsForm.setOperator("system");
            divertTacticsForm.setClientIp(System.getProperty("nms.server.host"));
            divertMap.put(divertTacticsForm.getId(), divertTacticsForm);
        }
        for (ZoneIpForm zoneIpForm : zoneIpForms) {
            String startIp = zoneIpForm.getStartIp();
            String endIp = zoneIpForm.getEndIp();
            List divertTacticsForms = this.divertTacticsService.getDivertTacticsByIp(startIp, endIp);
            for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                if (divertMap.containsKey(divertTacticsForm.getId())) {
                    divertMap.remove(divertTacticsForm.getId());
                }
                divertTacticsForm.setZoneId(zoneId);
                this.divertTacticsService.updateZoneNameForDivert(divertTacticsForm, zoneId);
            }
        }
        if (null != zoneInfoForm && zoneInfoForm.getZoneType().intValue() == Constant.ZONE_TYPE_OF_NOTDEFAULT.intValue()) {
            for (Map.Entry entry : divertMap.entrySet()) {
                this.divertTacticsService.stopAndDelDivert((DivertTacticsForm)entry.getValue());
            }
        }
    }

    private void updateDivertZoneNameByDefaultZoneAdd(ZoneInfoData zoneInfoData) {
        Long zoneId = zoneInfoData.getZoneId();
        Long devId = zoneInfoData.getDevId();
        if (null == zoneId || null == devId) {
            LOGGER.info((Object)"zone id or devId is null");
            return;
        }
        this.divertTacticsService.resetZoneNameForAddDefault(zoneId, devId);
    }

    public void addZone(ZoneInfoData zoneInfoData) {
        lock.lock();
        try {
            this.nowProcessing.add(zoneInfoData);
        }
        finally {
            lock.unlock();
        }
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }
}

