/*
 * Decompiled with CFR 0.152.
 */
package com.restful.impl;

import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.form.BlackholeWhiteTimeForm;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.service.IBlackHoleWhiteTimeService;
import com.hs.atic.sdk.bis.service.IBlackholeNpService;
import com.hs.atic.sdk.bis.service.IDivertBlackholeService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.restful.model.BlackholeNpInfo;
import com.restful.model.RestBlackholeInfo;
import com.restful.model.RestBlackholeNPInfo;
import com.restful.model.RestZoneIpInfo;
import com.restful.service.RestBlackholeDivertService;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestLogInfo;
import com.restful.util.RestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.struts2.ServletActionContext;

@Path(value="ddos/blackhole")
@Produces(value={"application/json"})
public class RestBlackholeDivertServiceImpl
implements RestBlackholeDivertService {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    private IDivertBlackholeService divertBlackholeService;
    private IAticDeviceService aticDeviceService;
    private IBlackHoleWhiteTimeService blackHoleWhiteTimeService;
    private IBlackholeNpService blackholeNpService;

    public IBlackholeNpService getBlackholeNpService() {
        return this.blackholeNpService;
    }

    public void setBlackholeNpService(IBlackholeNpService blackholeNpService) {
        this.blackholeNpService = blackholeNpService;
    }

    public void setDivertBlackholeService(IDivertBlackholeService divertBlackholeService) {
        this.divertBlackholeService = divertBlackholeService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IDivertBlackholeService getDivertBlackholeService() {
        return this.divertBlackholeService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public IBlackHoleWhiteTimeService getBlackHoleWhiteTimeService() {
        return this.blackHoleWhiteTimeService;
    }

    public void setBlackHoleWhiteTimeService(IBlackHoleWhiteTimeService blackHoleWhiteTimeService) {
        this.blackHoleWhiteTimeService = blackHoleWhiteTimeService;
    }

    @Override
    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createBlackholeDivert(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole");
        String requestMsg = "createBlackholeDivert by zoneip. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole");
            requestMsg = "createBlackholeDivert by zoneip. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        logInfo.setUrl(url);
        logInfo.setJson(json);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.create.blackholedivert.byzoneip");
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.create.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        String apiName = "createBlackholeDivert";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            return response;
        }
        RestZoneIpInfo restZoneIpInfo = null;
        try {
            this.checkJson(json);
            restZoneIpInfo = (RestZoneIpInfo)JSONUtil.getInstance().fromJSON(json, RestZoneIpInfo.class);
            this.checkIpMask(restZoneIpInfo);
        }
        catch (Exception e) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholedivert.byzoneip");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        List<String> requestZoneIps = restZoneIpInfo.getZoneIp();
        ArrayList<String> zoneIps = new ArrayList<String>();
        Iterator<String> iterator = requestZoneIps.iterator();
        while (iterator.hasNext()) {
            String zoneIpTemp;
            String zoneIp = zoneIpTemp = iterator.next();
            String mask = null;
            if (zoneIp.contains("/")) {
                String[] zoneIpDetails = zoneIp.split("/");
                zoneIp = zoneIpDetails[0].trim();
                mask = zoneIpDetails[1].trim();
            } else {
                zoneIp = zoneIp.trim();
            }
            if (IPUtil.isIpv4((String)zoneIp) && (null == mask || "32".equals(mask))) {
                zoneIps.add(zoneIp + "/32");
                continue;
            }
            if (IPUtil.isIpv6((String)zoneIp) && (null == mask || "128".equals(mask))) {
                zoneIps.add(IPUtil4Atic.convert2CompleteIp((String)zoneIp) + "/128");
                continue;
            }
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("the blackhole ip format is not correct. blackhole ip is " + zoneIp));
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholedivert.byzoneip");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        try {
            List cleanNeList = this.aticDeviceService.getCleanDevice();
            for (String zoneIp : zoneIps) {
                for (AticDevice cleanNe : cleanNeList) {
                    HashMap<String, String> conditionMap = new HashMap<String, String>();
                    String[] zoneIpDetails = zoneIp.split("/");
                    conditionMap.put("blackIP", zoneIpDetails[0]);
                    conditionMap.put("deviceId", String.valueOf(cleanNe.getMoId()));
                    Paging page = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
                    List divertBlackholes = page.getData();
                    if (null != divertBlackholes && !divertBlackholes.isEmpty()) {
                        if (0 != ((DivertBlackholeForm)divertBlackholes.get(0)).getEnableStatus()) continue;
                        this.divertBlackholeService.startDivertBlackholeVty((DivertBlackholeForm)divertBlackholes.get(0));
                        continue;
                    }
                    this.createAndDeployBlackholeDivert(zoneIp, cleanNe, this.divertBlackholeService);
                }
            }
        }
        catch (LegoCheckedException e) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            if (e.getErrorCode() == 571211L) {
                responseCode = 409;
                responseBuilder = responseBuilder.status(responseCode);
            } else {
                responseCode = 500;
                responseBuilder = responseBuilder.status(responseCode);
            }
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("deploy the blackhole diversion failed. zoneIps is " + requestZoneIps), (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholedivert.byzoneip");
            return responseBuilder.build();
        }
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        responseCode = 201;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"createBlackholeDivert by zoneip succeed");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholedivert.byzoneip");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    private void createAndDeployBlackholeDivert(String blackIP, AticDevice device, IDivertBlackholeService currentDivertBlackholeService) {
        DivertBlackholeForm divertBlackholeForm = new DivertBlackholeForm();
        divertBlackholeForm.setBlackIPAndMask(blackIP);
        String[] zoneIpDetails = blackIP.split("/");
        divertBlackholeForm.setBlackIP(zoneIpDetails[0]);
        divertBlackholeForm.setBlackMask(zoneIpDetails[1]);
        divertBlackholeForm.setEnableStatus(1);
        divertBlackholeForm.setEnableTime(System.currentTimeMillis());
        divertBlackholeForm.setDetail("1");
        divertBlackholeForm.setMode(0);
        divertBlackholeForm.setNexthopIP("NULL 0");
        divertBlackholeForm.setDeviceId(device.getMoId());
        divertBlackholeForm.setDeviceName(device.getName());
        divertBlackholeForm.setDeviceIP(device.getIpAddress());
        currentDivertBlackholeService.createAndDeployDivertBlackholeVty(divertBlackholeForm);
    }

    @Override
    @DELETE
    @Path(value="/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteBlackholeDivertByTime(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/delete");
        String requestMsg = "deleteBlackholeDivert by zoneip. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String responseMsg = null;
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/delete");
            requestMsg = "deleteBlackholeDivert by zoneip. restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = "null";
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        RestBlackholeInfo restBlackholeInfo = null;
        try {
            this.checkJson(json);
            restBlackholeInfo = (RestBlackholeInfo)JSONUtil.getInstance().fromJSON(json, RestBlackholeInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholedivert.byzoneip");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        try {
            if (!IPUtil.isIpv4((String)restBlackholeInfo.getZoneIp()) && !IPUtil.isIpv6((String)restBlackholeInfo.getZoneIp())) {
                responseCode = 400;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
                detailPara[2] = responseCode + "";
                RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
                responseBuilder = responseBuilder.status(responseCode);
                return responseBuilder.build();
            }
        }
        catch (IllegalArgumentException e) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        catch (RuntimeException e) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        conditionMap.put("blackIP", restBlackholeInfo.getZoneIp());
        Paging page = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
        List divertBlackholeForms = page.getData();
        if (page.getData().isEmpty()) {
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed. becuase the ivert ip not exist.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        try {
            for (DivertBlackholeForm divertBlackholeForm : divertBlackholeForms) {
                this.divertBlackholeService.stopAndDeleteDivertBlackhole(divertBlackholeForm);
            }
            BlackholeWhiteTimeForm blackholeWhiteTimeForm = new BlackholeWhiteTimeForm();
            long time = restBlackholeInfo.getTime();
            if (time < 0L) {
                time = -1L;
            }
            blackholeWhiteTimeForm.setBlackholeIp(restBlackholeInfo.getZoneIp());
            blackholeWhiteTimeForm.setBlackholeMask(IPUtil.isIpv4((String)restBlackholeInfo.getZoneIp()) ? 32 : 128);
            blackholeWhiteTimeForm.setWhiteTime(time);
            blackholeWhiteTimeForm.setStopTime(System.currentTimeMillis());
            this.blackHoleWhiteTimeService.saveBWhiteTime(blackholeWhiteTimeForm);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete the blackhole diversion failed.", (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteBlackholeDivert by zoneip succeed.");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    @Override
    @DELETE
    @Path(value="/{zone_ip}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteBlackholeDivert(@PathParam(value="zone_ip") String zoneIp) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/{zone_ip}");
        String requestMsg = "deleteBlackholeDivert by zoneip. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/{zone_ip}");
            requestMsg = "deleteBlackholeDivert by zoneip. restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = "null";
        logInfo.setUrl(url);
        logInfo.setJson(zoneIp);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.delete.blackholedivert.byzoneip");
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        String apiName = "deleteBlackholeDivert";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            return response;
        }
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        try {
            if (!IPUtil.isIpv4((String)zoneIp) && !IPUtil.isIpv6((String)zoneIp)) {
                VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
                responseCode = 400;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
                detailPara[2] = responseCode + "";
                RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
                responseBuilder = responseBuilder.status(responseCode);
                return responseBuilder.build();
            }
        }
        catch (IllegalArgumentException e) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        catch (RuntimeException e) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal parameter.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        conditionMap.put("blackIP", zoneIp);
        Paging page = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
        List divertBlackholeForms = page.getData();
        if (page.getData().isEmpty()) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed. becuase the ivert ip not exist.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        try {
            for (DivertBlackholeForm divertBlackholeForm : divertBlackholeForms) {
                this.divertBlackholeService.stopAndDeleteDivertBlackholeVty(divertBlackholeForm);
            }
        }
        catch (LegoCheckedException e) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete the blackhole diversion failed.", (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteBlackholeDivert by zoneip succeed.");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholedivert.byzoneip");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    private void checkJson(String json) {
        if (null != json && json.trim().length() > 5000) {
            throw new IllegalArgumentException("the parameters of json is more than 5000.");
        }
    }

    public void checkIpMask(RestZoneIpInfo zoneIpInfo) {
        List<String> requestZoneIps = zoneIpInfo.getZoneIp();
        for (String zoneIpTemp : requestZoneIps) {
            String zoneIp = zoneIpTemp;
            if (zoneIp.contains("/")) {
                String[] zoneIpDetails = zoneIp.split("/");
                zoneIp = zoneIpDetails[0].trim();
            } else {
                zoneIp = zoneIp.trim();
            }
            if (IPUtil.isIpv4((String)zoneIp) || IPUtil.isIpv6((String)zoneIp)) continue;
            throw new IllegalArgumentException("illegal parameter.");
        }
    }

    @Override
    @POST
    @Path(value="/createnp")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createBlackholeNp(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/createnp");
        String requestMsg = "createBlackholeNp . restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/createnp");
            requestMsg = "createBlackholeNp. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = "blackholeNp";
        LOG.info((Object)("createBlackholeNp json is :" + json));
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.create.blackholeNp");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        ArrayList<BlackholeNpForm> blackholeNpForms = new ArrayList<BlackholeNpForm>();
        try {
            RestBlackholeNPInfo restNpInfo = (RestBlackholeNPInfo)JSONUtil.getInstance().fromJSON(json, RestBlackholeNPInfo.class);
            if (restNpInfo.getNpIps().size() > 0) {
                for (BlackholeNpInfo bInfo : restNpInfo.getNpIps()) {
                    String zoneIp = bInfo.getNpIp();
                    int timeLong = bInfo.getTime();
                    int threshold = bInfo.getThreshold();
                    if (timeLong < 0 || threshold < 0) {
                        throw new IllegalArgumentException("illegal parameter.");
                    }
                    BlackholeNpForm blackholeNpForm = new BlackholeNpForm();
                    blackholeNpForm.setNpIp(this.checkBlackholeIpAndSalt(zoneIp));
                    blackholeNpForm.setTimeLong(Integer.valueOf(timeLong));
                    blackholeNpForm.setBlackholeThreshold(Integer.valueOf(threshold));
                    blackholeNpForms.add(blackholeNpForm);
                }
            }
            if (blackholeNpForms.size() > 1000) {
                throw new IllegalArgumentException("illegal parameter.");
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNp");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        try {
            this.blackholeNpService.batchSaveNP(blackholeNpForms);
        }
        catch (LegoCheckedException e) {
            responseMsg = "create or update blackhole NP faild";
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.");
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNp");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"create blackholeNp succeed");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNp");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    @Override
    @POST
    @Path(value="/getnp")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response queryBlackholeNpByIp(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/getnp");
        String requestMsg = "query blackholeNP by zoneip. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/getnp");
            requestMsg = "query blackholeNP by zoneip. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.query.blackholeNP.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        RestZoneIpInfo restZoneIpInfo = null;
        try {
            restZoneIpInfo = (RestZoneIpInfo)JSONUtil.getInstance().fromJSON(json, RestZoneIpInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.blackholeNP.byzoneip");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        ArrayList<String> zoneIps = new ArrayList<String>();
        try {
            List<String> requestZoneIps = restZoneIpInfo.getZoneIp();
            for (String string : requestZoneIps) {
                zoneIps.add(this.checkBlackholeIpAndSalt(string));
            }
            if (zoneIps.size() > 1000) {
                throw new IllegalArgumentException("illegal parameter");
            }
        }
        catch (IllegalArgumentException e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.blackholeNP.byzoneip");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        try {
            ArrayList<BlackholeNpForm> tempList = new ArrayList<BlackholeNpForm>();
            List<BlackholeNpForm> blackholeNpForms = this.blackholeNpService.queryBlackholeNPFormByIps(zoneIps);
            if (blackholeNpForms != null && blackholeNpForms.size() > 0) {
                for (BlackholeNpForm blackholeNpForm : blackholeNpForms) {
                    if (null == blackholeNpForm.getNpIp()) continue;
                    String[] ipAndMask = blackholeNpForm.getNpIp().split("/");
                    blackholeNpForm.setNpIp(ipAndMask[0]);
                    tempList.add(blackholeNpForm);
                }
            }
            StringBuilder stringBuilder = new StringBuilder("{\"npIps\":[");
            for (int i = 0; i < tempList.size(); ++i) {
                stringBuilder.append("{\"npIp\": \"").append(((BlackholeNpForm)tempList.get(i)).getNpIp()).append("\" ,\"time\": \"").append(((BlackholeNpForm)tempList.get(i)).getTimeLong()).append("\" ,\"threshold\": \"").append(((BlackholeNpForm)tempList.get(i)).getBlackholeThreshold()).append("\"}");
                if (i == tempList.size() - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append("]}");
            responseMsg = stringBuilder.toString();
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"query Blackhole NP by zoneip failed.", (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.blackholeNP.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"query Blackhole NP by zoneip succeed");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.query.blackholeNP.byzoneip");
        return Response.ok((Object)responseMsg).build();
    }

    @Override
    @DELETE
    @Path(value="/deletenp/{zone_ip}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteBlackholeNP(@PathParam(value="zone_ip") String zoneIp) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/deletenp/{zone_ip}");
        String requestMsg = "deleteBlackholeNp by zoneip. restful request is null";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/deletenp/{zone_ip}");
            requestMsg = "deleteBlackholeNp by zoneip. restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = zoneIp;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.delete.blackholenp.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        try {
            zoneIp = this.checkBlackholeIpAndSalt(zoneIp);
        }
        catch (IllegalArgumentException e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteBlackholeNp by zoneip");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholenp.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        try {
            BlackholeNpForm blackholeNpForm = this.blackholeNpService.getBlackholeNPFormByIp(zoneIp);
            if (null != blackholeNpForm.getNpIp()) {
                HashMap<String, String> conditionMap = new HashMap<String, String>();
                String[] zoneIpDetails = zoneIp.split("/");
                conditionMap.put("blackIP", zoneIpDetails[0]);
                conditionMap.put("blackMask", zoneIpDetails[1]);
                Paging page = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
                List divertBlackholeForms = page.getData();
                if (divertBlackholeForms.isEmpty()) {
                    this.blackholeNpService.deleteBlackholeNpByIp(zoneIp);
                } else {
                    for (DivertBlackholeForm divertBlackholeForm : divertBlackholeForms) {
                        this.divertBlackholeService.stopAndDeleteDivertBlackhole(divertBlackholeForm);
                    }
                    this.blackholeNpService.deleteBlackholeNpByIp(zoneIp);
                }
            }
        }
        catch (LegoCheckedException e) {
            responseMsg = "deleteBlackholeNp by zoneip faild";
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("deleteBlackholeNp by zoneip =" + zoneIp), (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholenp.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteBlackholenp by zoneip succeed.");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholenp.byzoneip");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/createnpdivert")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createBlackholeNPDivert(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/createnpdivert");
        String requestMsg = "createBlackholeNPDivert by zoneip. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/createnpdivert");
            requestMsg = "createBlackholeNPDivert by zoneip. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        LOG.info((Object)("createBlackholeNPDivert json is :" + json));
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.create.blackholeNPDivert.byzoneip");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        String zoneIp = "";
        try {
            this.checkJson(json);
            RestBlackholeInfo restZoneIpInfo = (RestBlackholeInfo)JSONUtil.getInstance().fromJSON(json, RestBlackholeInfo.class);
            zoneIp = this.checkIpAndSalt(restZoneIpInfo.getZoneIp());
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNPDivert.byzoneip");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        StringBuilder faildDeviceName = new StringBuilder();
        try {
            List cleanNeList = this.aticDeviceService.getCleanDevice();
            for (AticDevice cleanNe : cleanNeList) {
                HashMap<String, String> conditionMap = new HashMap<String, String>();
                String[] zoneIpDetails = zoneIp.split("/");
                conditionMap.put("blackIP", zoneIpDetails[0]);
                conditionMap.put("blackMask", zoneIpDetails[1]);
                conditionMap.put("deviceId", String.valueOf(cleanNe.getMoId()));
                DivertBlackholeForm divertBlackholeForm = this.queryDivertBlackholeForm(this.divertBlackholeService, conditionMap);
                if (null != divertBlackholeForm) {
                    if (divertBlackholeForm.getBlackholeMode() != 2 || 0 != divertBlackholeForm.getEnableStatus()) continue;
                    try {
                        this.divertBlackholeService.startDivertBlackhole(divertBlackholeForm);
                    }
                    catch (LegoCheckedException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                divertBlackholeForm = new DivertBlackholeForm();
                divertBlackholeForm.setBlackIPAndMask(zoneIp);
                divertBlackholeForm.setBlackIP(zoneIpDetails[0]);
                divertBlackholeForm.setBlackMask(zoneIpDetails[1]);
                divertBlackholeForm.setEnableStatus(0);
                divertBlackholeForm.setEnableTime(System.currentTimeMillis());
                divertBlackholeForm.setDetail("1");
                divertBlackholeForm.setMode(0);
                divertBlackholeForm.setNexthopIP("NULL 0");
                divertBlackholeForm.setBlackholeMode(2);
                divertBlackholeForm.setDeviceId(cleanNe.getMoId());
                divertBlackholeForm.setDeviceName(cleanNe.getName());
                divertBlackholeForm.setDeviceIP(cleanNe.getIpAddress());
                try {
                    this.divertBlackholeService.createAndDeployDivertBlackhole(divertBlackholeForm);
                }
                catch (LegoCheckedException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    divertBlackholeForm = this.queryDivertBlackholeForm(this.divertBlackholeService, conditionMap);
                    if (null == divertBlackholeForm) {
                        faildDeviceName.append(cleanNe.getName()).append(",");
                    }
                    if (null == divertBlackholeForm || divertBlackholeForm.getEnableStatus() != 0) continue;
                    faildDeviceName.append(cleanNe.getName()).append(",");
                    this.divertBlackholeService.removeBlackholeNpOfDeployFail(divertBlackholeForm);
                }
            }
        }
        catch (RuntimeException e) {
            responseCode = 500;
            responseBuilder = responseBuilder.status(responseCode);
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("deploy the blackholedivertnp diversion failed. zoneIps is " + zoneIp), (Exception)e);
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNPDivert.byzoneip");
            return responseBuilder.build();
        }
        catch (Exception e) {
            responseCode = 500;
            responseBuilder = responseBuilder.status(responseCode);
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("deploy the blackholedivertnp diversion failed. zoneIps is " + zoneIp), (Exception)e);
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNPDivert.byzoneip");
            return responseBuilder.build();
        }
        if (faildDeviceName.length() > 0) {
            responseCode = 466;
            responseMsg = "create blackholedivertnp faild.faildDeviceNames:" + faildDeviceName.substring(0, faildDeviceName.length() - 1);
            responseBuilder.entity((Object)responseMsg);
        } else {
            responseCode = 200;
        }
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"createBlackholeNpDivert by zoneip succeed");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.create.blackholeNPDivert.byzoneip");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    @Override
    @DELETE
    @Path(value="/delnpdivert")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteBlackholeNPDivert(String json) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/blackhole/delnpdivert");
        String requestMsg = "delete blackholeNPDivert. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/blackhole/delnpdivert");
            requestMsg = "delete blackholeNPDivert. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)"restful", (String)"atic.restful.delete.blackholeNPDivert.byzoneIp");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token, userName :" + userName + ". " + requestMsg));
        String zoneIp = "";
        int inforce = -1;
        try {
            this.checkJson(json);
            new JSONObject();
            JSONObject jsonObject = JSONObject.fromObject((Object)json);
            zoneIp = this.checkIpAndSalt((String)jsonObject.get("zone_ip"));
            inforce = (Integer)jsonObject.get("inforce");
            if (inforce != 0 && inforce != 1) {
                throw new IllegalArgumentException("illegal parameter.");
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholeNPDivert.byzoneIp");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        StringBuilder deivceName = new StringBuilder();
        StringBuilder deleteFailed = new StringBuilder();
        try {
            String[] zoneIpDetails = zoneIp.split("/");
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            conditionMap.put("blackIP", zoneIpDetails[0]);
            conditionMap.put("blackMask", zoneIpDetails[1]);
            Paging page = this.divertBlackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
            List divertBlackholeForms = page.getData();
            if (!divertBlackholeForms.isEmpty()) {
                for (DivertBlackholeForm divertBlackholeForm : divertBlackholeForms) {
                    if (divertBlackholeForm.getBlackholeMode() != 2) continue;
                    try {
                        if (inforce == 1) {
                            this.divertBlackholeService.stopAndDeleteDivertBlackhole(divertBlackholeForm);
                            continue;
                        }
                        if (this.blackholeNpService.isBlackholeThresholdTransfinite(divertBlackholeForm)) {
                            deivceName.append(divertBlackholeForm.getDeviceName()).append(",");
                            continue;
                        }
                        this.divertBlackholeService.stopAndDeleteDivertBlackhole(divertBlackholeForm);
                    }
                    catch (LegoCheckedException e) {
                        deleteFailed.append(divertBlackholeForm.getDeviceName()).append(",");
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete the blackholenpdivert failed.", (Exception)e);
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholeNPDivert.byzoneIp");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        if (deleteFailed.length() > 0) {
            responseCode = 467;
            responseMsg = "deleteBlackholeNpDivert by zoneip.failed deviceNames:" + deleteFailed.substring(0, deleteFailed.length() - 1);
        } else if (deivceName.length() > 0) {
            responseCode = 444;
            responseMsg = "current flow exceed threshold.deviceNames:" + deivceName.substring(0, deivceName.length() - 1);
        } else {
            responseCode = 200;
        }
        responseBuilder.entity((Object)responseMsg);
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"deleteBlackholeNpDivert by zoneip succeed.");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, (String)userName, (String)"atic.restful.delete.blackholeNPDivert.byzoneIp");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    private String checkIpAndSalt(String zoneIp) {
        if (zoneIp.isEmpty()) {
            throw new IllegalArgumentException("illegal parameter.");
        }
        int mask = 0;
        if (zoneIp.contains("/")) {
            String[] zoneIpDetails = zoneIp.split("/");
            zoneIp = zoneIpDetails[0].trim();
            mask = Integer.parseInt(zoneIpDetails[1].trim());
        } else {
            zoneIp = zoneIp.trim();
        }
        if (!IPUtil.isIpv4((String)zoneIp) || mask < 8 || mask > 32) {
            throw new IllegalArgumentException("illegal parameter.");
        }
        zoneIp = zoneIp + "/" + mask;
        return zoneIp;
    }

    private String checkBlackholeIpAndSalt(String zoneIp) {
        if (zoneIp.isEmpty()) {
            throw new IllegalArgumentException("illegal parameter.");
        }
        String mask = null;
        if (zoneIp.contains("/")) {
            String[] zoneIpDetails = zoneIp.split("/");
            zoneIp = zoneIpDetails[0].trim();
            mask = zoneIpDetails[1].trim();
        } else {
            zoneIp = zoneIp.trim();
        }
        if (!IPUtil.isIpv4((String)zoneIp) || null != mask && !"32".equals(mask)) {
            throw new IllegalArgumentException("illegal parameter.");
        }
        zoneIp = zoneIp + "/32";
        return zoneIp;
    }

    private DivertBlackholeForm queryDivertBlackholeForm(IDivertBlackholeService blackholeService, Map<String, String> conditionMap) {
        DivertBlackholeForm divertBlackholeForm = null;
        Paging page = blackholeService.queryByPage(conditionMap, 0, Integer.MAX_VALUE);
        List divertBlackholes = page.getData();
        if (null != divertBlackholes && !divertBlackholes.isEmpty()) {
            divertBlackholeForm = (DivertBlackholeForm)divertBlackholes.get(0);
        }
        return divertBlackholeForm;
    }

    private Response handleOverAPInvokeLimit(RestLogInfo logInfo) {
        int responseCode = 423;
        String responseMsg = "exceed concurrent api call limit.";
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.logExit(logInfo);
    }

    private Response logExit(RestLogInfo logInfo) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        String[] params = new String[]{logInfo.getTerminalIp(), logInfo.getUserName(), logInfo.getOperation(), logInfo.getTarget()};
        String[] detailPara = new String[]{logInfo.getUrl(), logInfo.getJson(), logInfo.getResponseDetail()};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)logInfo.getResponseCode(), (String[])params, (boolean)logInfo.isTargetLocal());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        responseBuilder.entity((Object)logInfo.getResponseMsg());
        return responseBuilder.build();
    }
}

