/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.hibernate;

import com.hs.lego.cbb.user.dao.IRoleDao;
import com.hs.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;
import java.util.List;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class RoleDaoImpl
extends HibernateDaoSupport
implements IRoleDao {
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addRoleInfo(RoleInfo roleinfo) {
        Object object = this.lock;
        synchronized (object) {
            return (Long)this.getHibernateTemplate().save((Object)roleinfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(long roleId) {
        Object object = this.lock;
        synchronized (object) {
            RoleInfo roleInfo = this.getRoleInfRelUser(roleId, Boolean.TRUE);
            if (null != roleInfo) {
                if (null != roleInfo.getUserSet() && !roleInfo.getUserSet().isEmpty()) {
                    throw new LegoCheckedException(296L);
                }
            } else {
                throw new LegoCheckedException(201L);
            }
            this.getHibernateTemplate().delete((Object)roleInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleInfo getRoleById(long iRoleId, boolean isFetchOper) {
        Object object = this.lock;
        synchronized (object) {
            RoleInfo oRole = null;
            if (isFetchOper) {
                String hql = "FROM RoleInfo u left join fetch u.operationSet where u.roleId = ?";
                List allUserList = this.getHibernateTemplate().find(hql, new Object[]{iRoleId});
                if (null != allUserList && !allUserList.isEmpty()) {
                    oRole = (RoleInfo)allUserList.get(0);
                }
            } else {
                oRole = (RoleInfo)this.getHibernateTemplate().get(RoleInfo.class, (Serializable)Long.valueOf(iRoleId));
            }
            if (null == oRole) {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(204L, pama);
            }
            return oRole;
        }
    }

    @Override
    public RoleInfo getRoleInfRelUser(long iRoleId, boolean isFetchUser) {
        RoleInfo oRole = null;
        if (isFetchUser) {
            String hql = "FROM RoleInfo r left join fetch r.userSet where r.roleId =? ";
            List allUserList = this.getHibernateTemplate().find(hql, new Object[]{iRoleId});
            if (null != allUserList && !allUserList.isEmpty()) {
                oRole = (RoleInfo)allUserList.get(0);
            }
        } else {
            oRole = (RoleInfo)this.getHibernateTemplate().get(RoleInfo.class, (Serializable)Long.valueOf(iRoleId));
        }
        if (null == oRole) {
            throw new LegoCheckedException(201L);
        }
        return oRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updataRole(RoleInfo roleInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.getHibernateTemplate().update((Object)roleInfo);
        }
    }

    @Override
    public List<RoleInfo> getAllRoles(boolean isFetchOper) {
        String hql = "FROM RoleInfo";
        List tmpSingleRoleInfolst = this.getHibernateTemplate().find(hql, new Object[0]);
        return tmpSingleRoleInfolst;
    }

    @Override
    public void checkRoleNameSingle(String roleName) {
        String hql = "FROM RoleInfo where roleName=?";
        List result = this.getHibernateTemplate().find(hql, new Object[]{roleName});
        if (!result.isEmpty()) {
            throw new LegoCheckedException(259L);
        }
    }
}

