/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.hibernate;

import com.hs.lego.cbb.user.dao.IUserDao;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.List;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class UserDaoImpl
extends HibernateDaoSupport
implements IUserDao {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);

    @Override
    public Long addUser(UserInfo user) {
        Long userId = null;
        try {
            userId = (Long)this.getHibernateTemplate().save((Object)user);
        }
        catch (Exception e) {
            this.log.error((Object)("add user error" + e.getMessage()));
        }
        return userId;
    }

    @Override
    public void deleteUser(long userId) {
        UserInfo user = (UserInfo)this.getHibernateTemplate().get(UserInfo.class, (Serializable)Long.valueOf(userId));
        if (null == user) {
            throw new LegoCheckedException(201L);
        }
        this.getHibernateTemplate().delete((Object)user);
    }

    @Override
    public List<UserInfo> getAllUser(boolean isFetchRole) {
        List allUserList = null;
        String hql = "FROM UserInfo";
        allUserList = this.getHibernateTemplate().find(hql, new Object[0]);
        return allUserList;
    }

    @Override
    public UserInfo getUserInfoById(long userId, boolean isFetchRole) {
        UserInfo userInfo = null;
        if (isFetchRole) {
            String hql = "FROM UserInfo u left join fetch u.rolesSet where u.id = ?";
            List allUserList = this.getHibernateTemplate().find(hql, new Object[]{userId});
            if (null != allUserList && !allUserList.isEmpty()) {
                userInfo = (UserInfo)allUserList.get(0);
            }
            this.log.debug((Object)("checkUserIsAdmin,hql=" + hql));
        } else {
            userInfo = (UserInfo)new HibernateTemplate(this.getSessionFactory()).get(UserInfo.class, (Serializable)Long.valueOf(userId));
        }
        if (null == userInfo) {
            String[] pama = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(204L, pama);
        }
        return userInfo;
    }

    @Override
    public UserInfo getUserByName(String name, boolean isAddUser) {
        UserInfo userInfo = null;
        String hql = "FROM UserInfo u where u.userName=?";
        List allUserList = this.getHibernateTemplate().find(hql, new Object[]{name});
        if (null != allUserList && !allUserList.isEmpty()) {
            userInfo = (UserInfo)allUserList.get(0);
        }
        if (null == userInfo && !isAddUser) {
            throw new LegoCheckedException(201L);
        }
        return userInfo;
    }

    @Override
    public UserInfo checkUser(String userName, String pwd, boolean isFetchRole) {
        List allUserList;
        UserInfo userInfo = null;
        if (isFetchRole) {
            String hql = "FROM UserInfo u left join fetch u.rolesSet where u.userName=? and u.userPwd=?";
            allUserList = this.getHibernateTemplate().find(hql, new Object[]{userName, pwd});
        } else {
            String hql = "FROM UserInfo u where u.userName=? and u.userPwd=?";
            allUserList = this.getHibernateTemplate().find(hql, new Object[]{userName, pwd});
        }
        if (null != allUserList && !allUserList.isEmpty()) {
            userInfo = (UserInfo)allUserList.get(0);
        }
        if (null == userInfo) {
            throw new LegoCheckedException(201L);
        }
        return userInfo;
    }

    @Override
    public void updataUser(UserInfo user) {
        if (null != user) {
            UserInfo userInfo = this.getUserInfoById(user.getId(), false);
            Boolean isLock = userInfo.isIsLock();
            user.setIsLock(isLock);
            this.getHibernateTemplate().merge((Object)user);
        } else {
            this.log.error((Object)"this parameter is null");
        }
    }
}

