/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service;

import com.hs.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.hs.lego.cbb.user.sdk.model.RadiusAuthenInfo;
import com.hs.lego.cbb.user.sdk.model.Role;
import com.hs.lego.cbb.user.sdk.model.SystemSecPolicy;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.model.UserAcl;
import com.hs.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.hs.lego.cbb.user.sdk.model.UserSecPolicy;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.cbb.user.service.common.ObjectConvertor;
import com.hs.lego.cbb.user.service.notes.IBroadcastServices;
import com.hs.lego.cbb.user.service.operation.IOperationService;
import com.hs.lego.cbb.user.service.roleservice.IRoleService;
import com.hs.lego.cbb.user.service.security.IAuthorityService;
import com.hs.lego.cbb.user.service.security.ISecurity;
import com.hs.lego.cbb.user.service.security.ThirdAuthorityFactory;
import com.hs.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.hs.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.hs.lego.cbb.user.thirdauth.sdk.IThirdAuthority;
import com.hs.lego.cbb.user.thirdauth.sdk.model.RadiusServerModel;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.comm.SortUnit;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AddressUtil;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import com.hs.lego.integrate.user.service.UserIntegrateFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserMgrImpl
implements IUserMgr {
    private static final long SIXTY = 60L;
    private static final Object LOCK = new Object();
    private static final String DEFAULT_USERNAME = "--";
    private final Object lockOne = new Object();
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private long tokenLegalTime = 0L;
    private IAuthorityService authorityService;
    private IRoleService roleService;
    private IUserService userService;
    private IUserRelMoService userRelMoService;
    private ISecurity security;
    private IUserLoginLocalCache cacheService;
    private IBroadcastServices broadcastServices;
    private IOperationService operationService;
    private IDataProtectService dataProtectService;

    @Override
    public int addRoleInfo(Role oRole, List<Long> mapOpts) {
        return this.roleService.addRoleInfo(oRole, mapOpts);
    }

    @Override
    public void deleteRole(long roleId) {
        this.roleService.deleteRole(roleId);
    }

    @Override
    public BatchOperationResult batchDelRoles(List<BatchOperation> list) {
        return this.roleService.batchDelRoles(list);
    }

    @Override
    public Role getRoleInf(long iRoleId) {
        return this.roleService.getRoleInf(iRoleId);
    }

    @Override
    public Role getRoleInfRelUser(long iRoleId, boolean isFetchUser) {
        return this.roleService.getRoleInfRelUser(iRoleId, true);
    }

    @Override
    public int updataRole(Role oRole, List<Long> mapOpts) {
        return this.roleService.updataRole(oRole, mapOpts);
    }

    @Override
    public List<Role> getAllRole() {
        return this.roleService.getAllRoles(false);
    }

    @Override
    public Paging getAllRole(int start, int length, SortUnit su) {
        return this.roleService.getAllRoles(start, length, su);
    }

    @Override
    public RootDataElement getOptTree(Long roleId) {
        return this.operationService.getOptTree(roleId);
    }

    public List<OperationInfo> getAllOperation() {
        return this.operationService.getAllOpt();
    }

    @Override
    public int addUserInfo(User oUserInfo) {
        String userName = oUserInfo.getUserName();
        if (userName.equalsIgnoreCase(DEFAULT_USERNAME)) {
            throw new LegoCheckedException(291L);
        }
        UserInfo userInfo = ObjectConvertor.getUserInfo(oUserInfo, this.dataProtectService);
        Set<UserAclInfo> userAclInfoSet = ObjectConvertor.getUserAclInfo(oUserInfo.getUserAclSet());
        userInfo.setUserAcls(userAclInfoSet);
        long newUserId = this.userService.addUserInfo(userInfo, oUserInfo.getRolesIdsSet(), oUserInfo.getMoAuthIdsSet(), oUserInfo.getMoGroupIdsSet());
        oUserInfo.setUserID(newUserId);
        return (int)newUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUser(long userId, long operatorUserId) {
        Object object = this.lockOne;
        synchronized (object) {
            User ui;
            List<User> onlineUserList = this.getAllOnlineUser();
            if (null != onlineUserList && !onlineUserList.isEmpty()) {
                for (User onlineUser : onlineUserList) {
                    if (onlineUser.getUserID() != userId) continue;
                    throw new LegoCheckedException(285L);
                }
            }
            if (null != (ui = this.getUserInfo(userId)) && null != ui.getIsAdmin() && ui.getIsAdmin().equalsIgnoreCase("true")) {
                throw new LegoCheckedException(297L);
            }
            this.security.unLockUserInCache(userId);
            if (userId != operatorUserId) {
                this.userService.deleteUser(userId);
            }
        }
    }

    @Override
    public void deleteUser(Long[] userIds, long operatorUserId) {
        Long[] longArray = userIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long i2 = longArray[i];
            this.deleteUser(i2, operatorUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult batchDeleteUser(List<BatchOperation> list, long operatorUserId) {
        Object object = this.lockOne;
        synchronized (object) {
            BatchOperationResult result = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int fail = 0;
            int operCount = 0;
            if (null != list) {
                operCount = list.size();
                for (BatchOperation batchOperation : list) {
                    try {
                        this.deleteUser(batchOperation.getTargetId(), operatorUserId);
                    }
                    catch (LegoCheckedException ce) {
                        ++fail;
                        batchOperation.setErrorCode(ce.getErrorCode());
                        if (ce.getErrorCode() == 204L) {
                            String[] args = new String[]{"lego.lab.log.oprationuser"};
                            batchOperation.setDetailParam(args);
                        }
                    }
                    catch (LegoUncheckedException ue) {
                        ++fail;
                        batchOperation.setErrorCode(ue.getErrorCode());
                    }
                    catch (Exception e) {
                        ++fail;
                        batchOperation.setErrorCode(102L);
                    }
                    resultList.add(batchOperation);
                }
                result.setResult(resultList);
                result.setFailCount(fail);
                result.setTotalCount(operCount);
                result.setSucceedCount(operCount - fail);
            }
            return result;
        }
    }

    @Override
    public List<User> getAllUser() {
        List<UserInfo> allUserInfoList = this.userService.getAllUser();
        ArrayList<User> allUserList = new ArrayList<User>();
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            String userLockKey = "USER_LOCK" + temp.getUserName();
            if (null != this.cacheService && this.cacheService.containsKey(userLockKey, true)) {
                temp.setIsLock("true");
            }
            allUserList.add(temp);
        }
        return allUserList;
    }

    @Override
    public List<User> getAllUserExt() {
        List<UserInfo> allUserInfoList = this.userService.getAllUser();
        ArrayList<User> allUserList = new ArrayList<User>();
        User user = new User();
        user.setUserName(DEFAULT_USERNAME);
        user.setDescription(DEFAULT_USERNAME);
        allUserList.add(user);
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            allUserList.add(temp);
        }
        return allUserList;
    }

    @Override
    public Paging getAllUser(Map<String, String> map, int iStart, int iLength) {
        Paging pag = this.userService.getAllUser(map, iStart, iLength);
        List allUserInfoList = pag.getData();
        ArrayList<User> allUserList = new ArrayList<User>();
        for (UserInfo userInfo : allUserInfoList) {
            User temp = this.getUser(userInfo, false, true);
            String userLockKey = "USER_LOCK" + temp.getUserName();
            if (null != this.cacheService && this.cacheService.containsKey(userLockKey, true)) {
                temp.setIsLock("true");
            }
            allUserList.add(temp);
        }
        pag.setData(allUserList);
        return pag;
    }

    private User getUser(UserInfo info, boolean isFetchRole, boolean isBaseUser) {
        User userTemp = ObjectConvertor.getUser(info, isFetchRole, isBaseUser);
        if (null != userTemp && !isBaseUser) {
            List<UserRelMoInfo> relMoList = this.userRelMoService.getUserAllRelMO(info.getId());
            HashSet<Long> moAuthIdsSet = new HashSet<Long>();
            HashSet<Long> moGroupIdsSet = new HashSet<Long>();
            for (UserRelMoInfo userRelMoInfo : relMoList) {
                if (userRelMoInfo.isIsGroup()) {
                    moGroupIdsSet.add(userRelMoInfo.getId().getMoId());
                    continue;
                }
                moAuthIdsSet.add(userRelMoInfo.getId().getMoId());
            }
            Set<UserAclInfo> userAclInfoSet = info.getUserAcls();
            Set<UserAcl> userAclSet = ObjectConvertor.getUserAcl(userAclInfoSet);
            userTemp.setUserAclSet(userAclSet);
            userTemp.setMoAuthIdsSet(moAuthIdsSet);
            userTemp.setMoGroupIdsSet(moGroupIdsSet);
        }
        return userTemp;
    }

    @Override
    public User getUserInfo(long id) {
        UserInfo userInfo = this.userService.getUserInfoById(id, true);
        User temp = this.getUser(userInfo, true, false);
        return temp;
    }

    @Override
    public void updataUser(User user) {
        if (user.getUserPassword() != null && !"".equals(user.getUserPassword().trim()) && !"null".equals(user.getUserPassword())) {
            user.setMustModifyPwd(true);
        }
        this.userService.updataUser(user);
        this.broadcastServices.noteUserChange(user);
    }

    @Override
    public Set<Integer> getThirdUserAuthType() {
        return ThirdAuthorityFactory.getInstance().getAuthorityType();
    }

    @Override
    public Boolean userLockState(String userName) {
        Boolean lockState = Boolean.FALSE;
        String userLockKey = "USER_LOCK" + userName;
        if (null != this.cacheService && this.cacheService.containsKey(userLockKey, true)) {
            lockState = Boolean.TRUE;
        }
        return lockState;
    }

    @Override
    public Boolean userLockState(long userId) {
        Boolean lockState = Boolean.FALSE;
        UserInfo userInfotemp = null;
        try {
            userInfotemp = this.userService.getUserInfoById(userId, false);
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
        if (null != userInfotemp) {
            lockState = this.userLockState(userInfotemp.getUserName());
        }
        return lockState;
    }

    @Override
    public final User login(String hostIP, String userName, String pwd) {
        UserInfo userInfo = null;
        User user = null;
        userInfo = UserIntegrateFactory.getInstance().getUserService().login(hostIP, userName, pwd);
        if (null != userInfo) {
            List<String> onlineUserList;
            UserLoginPolicyInfo temp = this.security.getLoginPolicy();
            if (null != temp && 0 == temp.getIntercurrentLogin() && null != (onlineUserList = this.authorityService.getOnlineUserSession(userInfo.getId())) && !onlineUserList.isEmpty()) {
                throw new LegoCheckedException(310L);
            }
            boolean checkLoginIP = false;
            checkLoginIP = userInfo.isIsAdmin() && AddressUtil.checkLocalIP((String)hostIP) ? true : this.security.checkIP(hostIP, userInfo.getUserAcls());
            if (checkLoginIP) {
                String sessionId = this.authorityService.generateSessionId(userInfo, hostIP);
                user = ObjectConvertor.getUser(userInfo, sessionId);
            } else {
                throw new LegoCheckedException(265L);
            }
        }
        if (null != user) {
            user.setMoAuthIdsSet(null);
            user.setMoAutSeth(null);
            user.setMoGroupIdsSet(null);
            user.setMoGroupIdsSet(null);
            user.setRolesIdsSet(null);
            user.setRolesSet(null);
        }
        return user;
    }

    @Override
    public User login(User user) {
        return this.login(user.getIpAdr(), user.getUserName(), user.getUserPassword());
    }

    @Override
    public Boolean checkUserPsw(String userName, String pwd) {
        return this.authorityService.checkUserPsw(userName, pwd);
    }

    @Override
    public Boolean checkUserPsw(String userName, String pwd, boolean pwdEncrypt) {
        return this.authorityService.checkUserPsw(userName, pwd, pwdEncrypt);
    }

    @Override
    public void logout(String sessionId) {
        this.authorityService.logout(sessionId);
    }

    @Override
    public void logoutOtherMgr(User user) {
        UserInfo userInfo = null;
        try {
            userInfo = this.userService.getUserInfoByName(user.getUserName(), false);
        }
        catch (Exception e) {
            this.log.error((Object)"getUserInfoByName error ", (Throwable)e);
        }
        if (null == userInfo) {
            return;
        }
        List<String> onlineUserList = this.authorityService.getOnlineUserSession(userInfo.getId());
        if (null != onlineUserList && !onlineUserList.isEmpty()) {
            for (String onlineUser : onlineUserList) {
                this.logout(onlineUser);
            }
        } else {
            return;
        }
    }

    @Override
    public Boolean checkTimeOut(String sessionId) {
        return this.authorityService.checkTimeout(sessionId, false);
    }

    @Override
    public Boolean checkTimeOut(String sessionId, boolean prolongTime) {
        if (UserIntegrateFactory.getInstance().getTokenService() != null) {
            UserIntegrateFactory.getInstance().getTokenService().validToken(sessionId);
        }
        return this.authorityService.checkTimeout(sessionId, prolongTime);
    }

    @Override
    public List<User> getAllOnlineUser() {
        return this.authorityService.getAllOnlineUser();
    }

    @Override
    public List<User> getAllOnlineUser(String sortFile, String sortType) {
        return this.authorityService.getAllOnlineUser(sortFile, sortType);
    }

    @Override
    public Paging getAllOnlineUser(String sortFile, String sortType, int pageStart, int pageSize) {
        Paging paging = new Paging();
        List<User> list = this.authorityService.getAllOnlineUser(sortFile, sortType);
        ArrayList<User> pagUser = new ArrayList<User>();
        if (null != list && !list.isEmpty()) {
            int listSize = list.size();
            if (listSize >= pageStart + pageSize) {
                for (int index = pageStart; index < pageStart + pageSize; ++index) {
                    pagUser.add(list.get(index));
                }
            } else {
                for (int index = pageStart; index < list.size(); ++index) {
                    pagUser.add(list.get(index));
                }
            }
            paging.setCount(listSize);
            paging.setData(pagUser);
        }
        return paging;
    }

    @Override
    public List<Long> getUserGrandObjects(User userInfo) {
        return UserIntegrateFactory.getInstance().getUserService().getAuthSecurityobj(userInfo);
    }

    @Override
    public List<Long> getUserGrandObjects(long userId) {
        return this.getUserGrandObjects(this.getUserInfo(userId));
    }

    @Override
    public Boolean checkUserGrandObject(long userId, long moId) {
        return this.authorityService.checkUserGrandObject(userId, moId);
    }

    @Override
    public void grandObjectToUser(long userId, Set<Long> moIds) {
        this.userRelMoService.addUserRelMo(userId, moIds, null);
        try {
            if (!this.checkUserIsAdmin(userId).booleanValue()) {
                this.broadcastServices.grandObjectToUser(userId, moIds);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"send message erro ", (Throwable)ex);
        }
    }

    @Override
    public void unchainObjectToUser(long userId, Set<Long> moIds) {
        this.userRelMoService.deleteUserRelMO(userId, moIds, null);
        try {
            if (!this.checkUserIsAdmin(userId).booleanValue()) {
                this.broadcastServices.unchainObjectToUser(userId, moIds);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"send message erro ", (Throwable)ex);
        }
    }

    @Override
    public List<?> getUserAllRelMO(String userId) {
        return this.userRelMoService.getUserAllRelMO(userId);
    }

    public void delManageObject(Set<Long> moIds) {
        this.userRelMoService.deleteManageObject(moIds, null);
    }

    @Override
    public Boolean checkUserRight(long userId, String opName) {
        return this.authorityService.checkUserRight(userId, opName);
    }

    public Map checkUserRight(long userId, List<String> opNames) {
        return this.authorityService.checkUserRight(userId, opNames);
    }

    @Override
    public Boolean checkUserIsAdmin(long userId) {
        return this.authorityService.checkUserIsAdmin(userId);
    }

    @Override
    public Boolean checkUserIsViewAllOperLog(long userId) {
        return this.authorityService.checkUserIsAdmin(userId) != false || this.authorityService.checkUserIsAuditor(userId) != false;
    }

    @Override
    public Boolean checkUserIsAuditor(long userId) {
        return this.authorityService.checkUserIsAuditor(userId);
    }

    @Override
    public Set<String> getUserAllOpids(User userInfo) {
        return this.getUserAllOpNames(userInfo.getUserID());
    }

    @Override
    public Set<String> getUserAllOpids(long userId) {
        return this.getUserAllOpNames(userId);
    }

    @Override
    public Set<String> getUserAllOpNames(long userId) {
        return this.authorityService.getUserAllOpNames(userId);
    }

    @Override
    public void modifyPassword(User userInfo) {
        UserInfo userInfotemp = this.userService.getUserInfoById(userInfo.getUserID(), false);
        if (null == userInfotemp) {
            String[] pama = new String[]{"lego.lab.usr"};
            throw new LegoCheckedException(204L, pama);
        }
        String enPwd = this.dataProtectService.sdpProtectPwd(userInfo.getUserPassword());
        userInfotemp.setUserPwd(enPwd);
        userInfotemp.setMustModiPassword(false);
        this.userService.updataUser(userInfotemp);
    }

    @Override
    public void modifyPassword(String oldPwd, String newPwd, long userId) {
        UserInfo userInfo = this.userService.getUserInfoById(userId, false);
        userInfo.setUserPwd(newPwd);
        userInfo.setMustModiPassword(false);
        this.userService.updataUser(userInfo);
    }

    public void modifyPassword(String oldPwd, String newPwd, long userId, Boolean first) {
        UserInfo userInfo = this.userService.getUserInfoById(userId, false);
        if (null == userInfo) {
            return;
        }
        if (first.booleanValue()) {
            boolean oldPwdRight = this.dataProtectService.sdpVerifyPwd(oldPwd, userInfo.getUserPwd());
            if (oldPwdRight) {
                String enPwd = this.dataProtectService.sdpProtectPwd(newPwd);
                userInfo.setUserPwd(enPwd);
                userInfo.setMustModiPassword(false);
                this.userService.updataUser(userInfo);
            } else {
                throw new LegoCheckedException(283L);
            }
        }
    }

    @Override
    public void resetPassword(User userInfo) {
        UserInfo userInfotemp = this.userService.getUserInfoById(userInfo.getUserID(), false);
        String enPwd = this.dataProtectService.sdpProtectPwd(userInfo.getUserPassword());
        userInfotemp.setUserPwd(enPwd);
        userInfotemp.setMustModiPassword(false);
        this.userService.updataUser(userInfotemp);
    }

    @Override
    public void resetPassword(String newPwd, long userId) {
        UserInfo userInfotemp = this.userService.getUserInfoById(userId, false);
        String enPwd = this.dataProtectService.sdpProtectPwd(newPwd);
        userInfotemp.setUserPwd(enPwd);
        userInfotemp.setMustModiPassword(false);
        this.userService.updataUser(userInfotemp);
    }

    @Override
    public void lockUser(User userInfo) {
        this.security.lockUser(userInfo.getUserID());
    }

    @Override
    public void lockUser(long userId) {
        this.security.lockUser(userId);
    }

    @Override
    public void lockUser(Long[] userIds) {
        if (null != userIds) {
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long i2 = longArray[i];
                this.security.lockUser(i2);
            }
        }
    }

    @Override
    public void unLockUser(User userInfo) {
        this.security.unLockUser(userInfo.getUserID());
    }

    @Override
    public void unLockUser(long userId) {
        this.security.unLockUser(userId);
    }

    @Override
    public void unLockUser(Long[] userIds) {
        if (null != userIds) {
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long i2 = longArray[i];
                this.security.unLockUser(i2);
            }
        }
    }

    @Override
    public BatchOperationResult lockUser(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.lockUser(batchOperation.getTargetId());
                    List<String> onLineUserSessionList = this.authorityService.getOnlineUserSession(batchOperation.getTargetId());
                    if (onLineUserSessionList != null && !onLineUserSessionList.isEmpty()) {
                        for (String onLineUserSession : onLineUserSessionList) {
                            this.logout(onLineUserSession);
                        }
                    }
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public BatchOperationResult unLockUser(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.unLockUser(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public void forceLogout(String sessionId) {
        this.logout(sessionId);
    }

    @Override
    public boolean verifyDefaultPwd(StringBuffer pucPlainText) {
        return this.userService.verifyDefaultPwd(pucPlainText);
    }

    @Override
    public SystemSecPolicy getSystemSecPolicy() {
        SystemSecPolicy secPolicy = new SystemSecPolicy();
        UserSecPolicy userPolicy = this.getUserSecPolicy();
        UserLoginPolicy loginPolicy = this.getLoginPolicy();
        secPolicy.setUserSecPolicy(userPolicy);
        secPolicy.setUserLoginPolicy(loginPolicy);
        return secPolicy;
    }

    @Override
    public void updateSystemSecPolicy(SystemSecPolicy policy) {
        UserSecPolicy userPolicy = policy.getUserSecPolicy();
        UserLoginPolicy loginPolicy = policy.getUserLoginPolicy();
        this.updateUserSecPolicy(userPolicy);
        this.updateLoginPolicy(loginPolicy);
    }

    @Override
    public UserLoginPolicy getLoginPolicy() {
        UserLoginPolicyInfo info = this.security.getLoginPolicy();
        UserLoginPolicy temp = ObjectConvertor.getUserLoginPolicy(info);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLoginPolicy(UserLoginPolicy policy) {
        Object object = LOCK;
        synchronized (object) {
            this.tokenLegalTime = 60000L * (long)policy.getSessionTimeOut();
        }
        UserLoginPolicyInfo info = ObjectConvertor.getUserLoginPolicy(policy);
        this.security.updateLoginPolicy(info);
    }

    @Override
    public UserSecPolicy getUserSecPolicy() {
        UserSecPolicyInfo info = this.security.getUserSecPolicy();
        UserSecPolicy temp = ObjectConvertor.getUserSecPolicy(info);
        return temp;
    }

    @Override
    public void updateUserSecPolicy(UserSecPolicy policy) {
        UserSecPolicyInfo info = ObjectConvertor.getUserSecPolicy(policy);
        this.security.updateUserSecPolicy(info);
    }

    public void setAuthorityService(IAuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setRoleService(IRoleService roleService) {
        this.roleService = roleService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public IAuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public IRoleService getRoleService() {
        return this.roleService;
    }

    public IUserService getUserService() {
        return this.userService;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public void setBroadcastServices(IBroadcastServices broadcastServices) {
        this.broadcastServices = broadcastServices;
    }

    public IOperationService getOperationService() {
        return this.operationService;
    }

    public void setOperationService(IOperationService operationService) {
        this.operationService = operationService;
    }

    @Override
    public Map<String, Set<String>> getUrlOperMap() {
        return this.userService.getUrlOperMap();
    }

    @Override
    public void addIntegrateSession(User user) {
        this.authorityService.addIntegrateSession(user);
    }

    @Override
    public void delIntegrateSession(String session) {
        this.authorityService.logout(session);
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    @Override
    public User loginSystem(String hostIP, String userName, String pwd) {
        UserInfo userInfo = null;
        User user = null;
        userInfo = this.authorityService.login(hostIP, userName, pwd);
        if (null != userInfo) {
            boolean checkLoginIP = false;
            checkLoginIP = userInfo.isIsAdmin() && AddressUtil.checkLocalIP((String)hostIP) ? true : this.security.checkIP(hostIP, userInfo.getUserAcls());
            if (checkLoginIP) {
                user = ObjectConvertor.getUser(userInfo, null);
            } else {
                throw new LegoCheckedException(265L);
            }
        }
        if (null != user) {
            user.setMoAuthIdsSet(null);
            user.setMoAutSeth(null);
            user.setMoGroupIdsSet(null);
            user.setMoGroupIdsSet(null);
            user.setRolesIdsSet(null);
            user.setRolesSet(null);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSessionEffectiveTime() {
        Object object = LOCK;
        synchronized (object) {
            if (0L == this.getTokenLegalTime()) {
                UserLoginPolicy usrLogPolicy = this.getLoginPolicy();
                this.setTokenLegalTime(60000L * (long)usrLogPolicy.getSessionTimeOut());
            }
            return this.getTokenLegalTime();
        }
    }

    @Override
    public UserInfo getUserInfoByName(String username) {
        UserInfo userInfo = null;
        try {
            userInfo = this.userService.getUserInfoByName(username, false);
        }
        catch (Exception e) {
            this.log.error((Object)"getUserInfoByName error ", (Throwable)e);
        }
        return userInfo;
    }

    @Override
    public RootDataElement getOptTreeByUser(Long userId) {
        return this.operationService.getOptTreeByUser(userId);
    }

    @Override
    public Set<Long> getAllOptId(Long userId) {
        return this.operationService.getAllOptId(userId);
    }

    public long getTokenLegalTime() {
        return this.tokenLegalTime;
    }

    public void setTokenLegalTime(long tokenLegalTime) {
        this.tokenLegalTime = tokenLegalTime;
    }

    @Override
    public RadiusAuthenInfo getRadiusAuthenInfo(User user) {
        RadiusAuthenInfo authInfo = new RadiusAuthenInfo();
        UserInfo userInfo = this.getUserInfoByName(user.getUserName());
        IThirdAuthority thirdAuthorityByType = ThirdAuthorityFactory.getInstance().getThirdAuthorityByType(userInfo.getPasswordModel());
        if (null != thirdAuthorityByType) {
            RadiusServerModel radius = thirdAuthorityByType.getRadiusService();
            authInfo.setRadius(radius);
        }
        return authInfo;
    }

    public IUserRelMoService getUserRelMoService() {
        return this.userRelMoService;
    }

    public ISecurity getSecurity() {
        return this.security;
    }

    public IUserLoginLocalCache getCacheService() {
        return this.cacheService;
    }

    public IBroadcastServices getBroadcastServices() {
        return this.broadcastServices;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }
}

