/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service;

import com.hs.lego.cbb.user.dao.IRoleDao;
import com.hs.lego.cbb.user.dao.IUserDao;
import com.hs.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.cbb.user.service.common.ObjectConvertor;
import com.hs.lego.cbb.user.service.common.SystemInitializeUserThread;
import com.hs.lego.cbb.user.service.userrelmo.UserRelMoService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserService
implements IUserService {
    private static final long DEFALT_ID = 1L;
    private IUserDao userDao;
    private IRoleDao roleDao;
    private ICommonDao commonDao;
    private SystemInitializeUserThread systemInitUser;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private UserRelMoService userRelMoService;
    private IDataProtectService dataProtectService;
    private final Object lock = new Object();

    @Override
    public void initSysUser() {
        UserInfo info = null;
        try {
            info = this.getUserInfoById(1L, false);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        if (null == info) {
            UserInfo defaultUser = this.systemInitUser.getDefaultUserInfo();
            this.userDao.addUser(defaultUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addUserInfo(UserInfo oUserInfo) {
        Object object = this.lock;
        synchronized (object) {
            UserInfo userInfo = null;
            try {
                userInfo = this.userDao.getUserByName(oUserInfo.getUserName(), true);
            }
            catch (Exception e) {
                this.log.error((Object)"user is Exist");
            }
            if (null != userInfo) {
                throw new LegoCheckedException(263L);
            }
            long setTime = System.currentTimeMillis();
            oUserInfo.setSetTime(setTime);
            long userId = this.userDao.addUser(oUserInfo);
            oUserInfo.setId(userId);
            return userId;
        }
    }

    @Override
    public long addUserInfo(UserInfo oUserInfo, Set<Long> roleIds, Set<Long> moIds, Set<Long> moGroupIds) {
        HashSet<RoleInfo> roleSet = null;
        if (null != roleIds) {
            roleSet = new HashSet<RoleInfo>();
            for (long i : roleIds) {
                RoleInfo info = null;
                try {
                    info = this.roleDao.getRoleById(i, false);
                }
                catch (Exception e) {
                    this.log.info((Object)"role is not Exist");
                }
                if (null == info) continue;
                roleSet.add(info);
            }
        }
        if (null == roleSet || roleSet.isEmpty()) {
            throw new LegoCheckedException(262L);
        }
        oUserInfo.setRolesSet(roleSet);
        long newUserId = this.addUserInfo(oUserInfo);
        this.userRelMoService.addUserRelMo(newUserId, moIds, moGroupIds);
        return newUserId;
    }

    @Override
    public void deleteUser(long userId) {
        this.userDao.deleteUser(userId);
        this.userRelMoService.deleteMOByUserId(userId);
    }

    @Override
    public void deleteUser(Long[] userIds) {
        if (null != userIds && userIds.length > 0) {
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long itemp = longArray[i];
                this.deleteUser(itemp);
            }
        } else {
            this.log.info((Object)"userIds is null");
        }
    }

    @Override
    public List<UserInfo> getAllUser() {
        return this.userDao.getAllUser(false);
    }

    @Override
    public Paging getAllUser(Map<String, String> map, int iStart, int iLength) {
        Paging roPaging = new Paging();
        if (null != map) {
            String hql = this.getHqlByCondition(map);
            List userList = this.commonDao.findPage(hql, iStart, iLength);
            StringBuffer buffer = new StringBuffer("select count(*) from UserInfo ");
            roPaging.setCount((int)this.commonDao.getTotalCount(buffer.toString()));
            roPaging.setData(userList);
        }
        return roPaging;
    }

    @Override
    public UserInfo getFullUserInfoById(Long userId) {
        UserInfo userInfo = this.userDao.getUserInfoById(userId, true);
        if (null != userInfo && !userInfo.isIsAdmin()) {
            Set<RoleInfo> rolesSet = userInfo.getRolesSet();
            HashSet<RoleInfo> rolesSetTemp = new HashSet<RoleInfo>();
            for (RoleInfo roleInfo : rolesSet) {
                RoleInfo temp = this.roleDao.getRoleById(roleInfo.getRoleId(), true);
                rolesSetTemp.add(temp);
            }
            userInfo.setRolesSet(rolesSetTemp);
        }
        return userInfo;
    }

    @Override
    public UserInfo getUserInfoByName(String userName, boolean isFetchRole) {
        return this.userDao.getUserByName(userName, isFetchRole);
    }

    @Override
    public UserInfo getUserInfoById(long userId, boolean isFetchRole) {
        return this.userDao.getUserInfoById(userId, isFetchRole);
    }

    @Override
    public void updataUser(UserInfo userInfo) {
        UserInfo ui = this.userDao.getUserInfoById(userInfo.getId(), false);
        if (!(userInfo.getPasswordModel() != 0 || ui != null && ui.getUserPwd() != null && ui.getUserPwd().equals(userInfo.getUserPwd()))) {
            long setTime = System.currentTimeMillis();
            userInfo.setSetTime(setTime);
        }
        this.userDao.updataUser(userInfo);
    }

    @Override
    public void updataUser(User user) {
        UserInfo oUserInfo = this.coventUser(user);
        if (null == user.getUserPassword() || "".equals(user.getUserPassword())) {
            UserInfo info = this.getUserInfoById(user.getUserID(), false);
            oUserInfo.setUserPwd(info.getUserPwd());
        }
        Set<UserAclInfo> userAclInfoSet = ObjectConvertor.getUserAclInfo(user.getUserAclSet());
        oUserInfo.setUserAcls(userAclInfoSet);
        this.updataUser(oUserInfo);
        Set moIds = user.getMoAuthIdsSet();
        Set moGroupIds = user.getMoGroupIdsSet();
        this.userRelMoService.deleteMOByUserId(user.getUserID());
        this.userRelMoService.addUserRelMo(oUserInfo.getId(), moIds, moGroupIds);
    }

    private UserInfo coventUser(User user) {
        UserInfo oUserInfo = null;
        oUserInfo = ObjectConvertor.getUserInfo(user, this.dataProtectService);
        Set roleIds = null;
        roleIds = user.getRolesIdsSet();
        if (null != roleIds) {
            HashSet<RoleInfo> roleSet = new HashSet<RoleInfo>();
            Iterator iterator = roleIds.iterator();
            while (iterator.hasNext()) {
                long i = (Long)iterator.next();
                RoleInfo roleInfTemp = this.roleDao.getRoleById(i, false);
                if (roleInfTemp != null) {
                    roleSet.add(roleInfTemp);
                    continue;
                }
                throw new LegoCheckedException(262L);
            }
            oUserInfo.setRolesSet(roleSet);
        }
        return oUserInfo;
    }

    private String getFile(String file) {
        String rtnFile = "";
        rtnFile = file.equalsIgnoreCase("userName") ? "userName" : (file.equalsIgnoreCase("description") ? "userDes" : file);
        return rtnFile;
    }

    public void setUserDao(IUserDao userDao) {
        this.userDao = userDao;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    public void setRoleDao(IRoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public void setSystemInitUser(SystemInitializeUserThread systemInitUser) {
        this.systemInitUser = systemInitUser;
    }

    public void setUserRelMoService(UserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    private String getHqlByCondition(Map<String, String> map) {
        if (null == map) {
            return "FROM UserInfo ";
        }
        StringBuffer sBufQObj = new StringBuffer("FROM UserInfo ");
        Set<Map.Entry<String, String>> condition = map.entrySet();
        String order = "";
        String fileName = "";
        boolean first = false;
        for (Map.Entry<String, String> entry : condition) {
            String key = entry.getKey();
            String filevalue = entry.getValue();
            String value = this.getFile(filevalue);
            if (key.equalsIgnoreCase("DESC") || key.equalsIgnoreCase("ASC")) {
                order = key;
                fileName = "order by " + value + " ";
                continue;
            }
            if (!first) {
                sBufQObj.append(" where ");
                sBufQObj.append(key + " like '*");
                sBufQObj.append(value);
                sBufQObj.append("*'");
                first = true;
                continue;
            }
            sBufQObj.append("  and ");
            sBufQObj.append(key + " like '*");
            sBufQObj.append(value);
            sBufQObj.append("*'");
        }
        sBufQObj.append(fileName);
        sBufQObj.append(order);
        return sBufQObj.toString();
    }

    @Override
    public boolean verifyDefaultPwd(StringBuffer pucPlainText) {
        String pwd = this.systemInitUser.getDefaultUserProtectPwd();
        return this.dataProtectService.sdpVerifyPwd(DataProtectServiceConst.sdpDecryptLocalBuffer((String)pucPlainText.toString()), pwd);
    }

    @Override
    public Map<String, Set<String>> getUrlOperMap() {
        return this.systemInitUser.getUrlOperMap();
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

