/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.common;

import com.hs.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.hs.lego.cbb.user.sdk.model.OptAuth;
import com.hs.lego.cbb.user.sdk.model.Role;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.model.UserAcl;
import com.hs.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.hs.lego.cbb.user.sdk.model.UserSecPolicy;
import com.hs.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.util.AddressUtil;
import java.util.HashSet;
import java.util.Set;

public final class ObjectConvertor {
    private ObjectConvertor() {
    }

    public static UserInfo getUserInfo(User user, IDataProtectService sdp) {
        UserInfo userInfo = new UserInfo();
        if (null != user) {
            userInfo.setId(user.getUserID());
            userInfo.setUserDes(user.getDescription());
            userInfo.setUserName(user.getUserName());
            userInfo.setSelectResView(user.getSelectType());
            int passwordModle = user.getPasswordModel();
            if (passwordModle == UserAuthorityType.local.getValue()) {
                if (null != user.getUserPassword() && !"".equals(user.getUserPassword())) {
                    userInfo.setUserPwd(user.getUserPassword());
                } else {
                    userInfo.setUserPwd("");
                }
            }
            userInfo.setPasswordModel(passwordModle);
            if (null == user.getIsAdmin() || "".equals(user.getIsAdmin())) {
                userInfo.setIsAdmin(false);
            } else if ("true".equals(user.getIsAdmin())) {
                userInfo.setIsAdmin(true);
            } else {
                userInfo.setIsAdmin(false);
            }
            userInfo.setMustModiPassword(user.isMustModifyPwd());
            userInfo.setSetTime(user.getSetTime());
        }
        return userInfo;
    }

    public static User getUser(UserInfo userInfo, boolean isFetchRole, boolean isBaseUserInfo) {
        User user = null;
        if (null != userInfo) {
            user = new User();
            user.setUserID(userInfo.getId().longValue());
            user.setDescription(userInfo.getUserDes());
            user.setUserName(userInfo.getUserName());
            user.setSelectType(userInfo.getSelectResView().intValue());
            int passwordModle = userInfo.getPasswordModel();
            if (!isBaseUserInfo && passwordModle == UserAuthorityType.local.getValue()) {
                user.setUserPassword(userInfo.getUserPwd());
            }
            if (!isBaseUserInfo && passwordModle == UserAuthorityType.radius.getValue()) {
                userInfo.setMustModiPassword(false);
            }
            user.setPasswordModel(passwordModle);
            if (userInfo.isIsAdmin()) {
                user.setIsAdmin("true");
            } else {
                user.setIsAdmin("false");
            }
            if (userInfo.isIsLock()) {
                user.setIsLock("true");
            } else {
                user.setIsLock("false");
            }
            user.setMustModifyPwd(userInfo.isMustModiPassword());
            if (isFetchRole) {
                user.getRolesSet().clear();
                Set<RoleInfo> uerinfoRoleSet = userInfo.getRolesSet();
                if (null != uerinfoRoleSet) {
                    for (RoleInfo roleInfo : uerinfoRoleSet) {
                        Role roleTemp = ObjectConvertor.translateBoRoleInfo(roleInfo, false);
                        user.getRolesSet().add(roleTemp);
                    }
                }
            }
            user.setSetTime(userInfo.getSetTime());
        }
        return user;
    }

    public static User getUser(UserInfo userInfo, String sessionId) {
        User user = ObjectConvertor.getUser(userInfo, false, false);
        if (null != user) {
            user.setSession(sessionId);
        }
        return user;
    }

    public static Role translateBoRoleInfo(RoleInfo roleInfo, boolean isFetchOperat) {
        Role role = new Role();
        role.setCreaterID(roleInfo.getCreatorId());
        role.setRoleID(roleInfo.getRoleId().longValue());
        role.setCreateTime(roleInfo.getCreatTime());
        role.setRoleDes(roleInfo.getRoleDescription());
        role.setRoleName(roleInfo.getRoleName());
        if (roleInfo.isIsDefault()) {
            role.setBuDefault("true");
        } else {
            role.setBuDefault("false");
        }
        if (null == role.getOptsSet()) {
            HashSet theSet = new HashSet();
            role.setOptsSet(theSet);
        } else {
            role.getOptsSet().clear();
        }
        return role;
    }

    public static OptAuth translateBoOperation(OperationInfo oOptInfo) {
        OptAuth tmpOpt = new OptAuth();
        tmpOpt.setOptID(oOptInfo.getOpId().longValue());
        tmpOpt.setSerialNumber(oOptInfo.getSerialNumber());
        tmpOpt.setOptName(oOptInfo.getOpName());
        tmpOpt.setUrl(oOptInfo.getOpURL());
        tmpOpt.setMaster(oOptInfo.isIsMaster());
        return tmpOpt;
    }

    public static RoleInfo translatePoRole(Role role) {
        RoleInfo tmpRoleInfo = new RoleInfo();
        tmpRoleInfo.setCreatorId(role.getCreaterID());
        tmpRoleInfo.setRoleId(role.getRoleID());
        tmpRoleInfo.setCreatTime(role.getCreateTime());
        tmpRoleInfo.setRoleDescription(role.getRoleDes());
        tmpRoleInfo.setRoleName(role.getRoleName());
        if (null == role.getBuDefault() || "".equals(role.getBuDefault())) {
            tmpRoleInfo.setIsDefault(false);
        } else if ("true".equals(role.getBuDefault())) {
            tmpRoleInfo.setIsDefault(true);
        } else {
            tmpRoleInfo.setIsDefault(false);
        }
        OperationInfo tmpOptInfo = new OperationInfo();
        if (null != role.getOptsSet()) {
            if (null == tmpRoleInfo.getOperationSet()) {
                HashSet<OperationInfo> theSet = new HashSet<OperationInfo>();
                tmpRoleInfo.setOperationSet(theSet);
            } else {
                tmpRoleInfo.getOperationSet().clear();
            }
            for (OptAuth tmpOpt : role.getOptsSet()) {
                tmpOptInfo.setOpId(tmpOpt.getOptID());
                tmpOptInfo.setSerialNumber(tmpOpt.getSerialNumber());
                tmpOptInfo.setOpName(tmpOpt.getOptName());
                tmpOptInfo.setOpURL(tmpOpt.getUrl());
                tmpOptInfo.setIsMaster(tmpOpt.isMaster());
                tmpRoleInfo.getOperationSet().add(tmpOptInfo);
            }
        }
        return tmpRoleInfo;
    }

    public static Set<UserAclInfo> getUserAclInfo(Set<UserAcl> infoSet) {
        HashSet<UserAclInfo> set = new HashSet<UserAclInfo>();
        if (null == infoSet) {
            return set;
        }
        for (UserAcl info : infoSet) {
            UserAclInfo userAclInfo = new UserAclInfo();
            long aclId = info.getUserAclId();
            if (0L != aclId) {
                userAclInfo.setId(aclId);
            }
            long lStartIp = 0L;
            long lEndIp = 0L;
            String strStartIp = info.getStrStartIp();
            String strEndIp = info.getStrEndIp();
            if (!"".equals(strStartIp) && !"".equals(strEndIp)) {
                lStartIp = AddressUtil.ipToLong((String)strStartIp);
                lEndIp = AddressUtil.ipToLong((String)strEndIp);
            }
            userAclInfo.setStartIp(lStartIp);
            userAclInfo.setEndIp(lEndIp);
            userAclInfo.setDes(info.getDes());
            set.add(userAclInfo);
        }
        return set;
    }

    public static Set<UserAcl> getUserAcl(Set<UserAclInfo> userAclInfoSet) {
        HashSet<UserAcl> userAclSet = new HashSet<UserAcl>();
        if (null == userAclInfoSet) {
            return userAclSet;
        }
        for (UserAclInfo info : userAclInfoSet) {
            UserAcl userAcl = new UserAcl();
            if (null == info) continue;
            long aclId = info.getId();
            userAcl.setUserAclId(aclId);
            long lStartIp = info.getStartIp();
            long lEndIp = info.getEndIp();
            String strStartIp = AddressUtil.longToIP((long)lStartIp);
            String strEndIp = AddressUtil.longToIP((long)lEndIp);
            userAcl.setStrEndIp(strEndIp);
            userAcl.setStrStartIp(strStartIp);
            userAcl.setDes(info.getDes());
            userAclSet.add(userAcl);
        }
        return userAclSet;
    }

    public static UserLoginPolicy getUserLoginPolicy(UserLoginPolicyInfo info) {
        UserLoginPolicy policy = null;
        if (null != info) {
            policy = new UserLoginPolicy();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(policyId);
            }
            policy.setDes(info.getDes());
            policy.setLgoinCount(info.getLgoinCount());
            policy.setLockTime(info.getLockTime());
            policy.setIntercurrentLogin(info.getIntercurrentLogin());
            policy.setUnseal(info.getUnseal());
            policy.setSessionTimeOut(info.getSessionTimeOut());
            policy.setLgoinInterval(info.getLgoinInterval());
        }
        return policy;
    }

    public static UserLoginPolicyInfo getUserLoginPolicy(UserLoginPolicy info) {
        UserLoginPolicyInfo policy = null;
        if (null != info) {
            policy = new UserLoginPolicyInfo();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(policyId);
            }
            policy.setDes(info.getDes());
            policy.setLgoinCount(info.getLgoinCount());
            policy.setUnseal(info.getUnseal());
            policy.setLockTime(info.getLockTime());
            policy.setIntercurrentLogin(info.getIntercurrentLogin());
            policy.setSessionTimeOut(info.getSessionTimeOut());
            policy.setLgoinInterval(info.getLgoinInterval());
        }
        return policy;
    }

    public static UserSecPolicy getUserSecPolicy(UserSecPolicyInfo info) {
        UserSecPolicy policy = null;
        if (null != info) {
            policy = new UserSecPolicy();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(info.getId());
            }
            policy.setComplex(info.getComplex());
            policy.setPswLenth(info.getPswLenth());
            policy.setUnseal(info.getUnseal());
            policy.setUsefulLife(info.getUsefulLife());
        }
        return policy;
    }

    public static UserSecPolicyInfo getUserSecPolicy(UserSecPolicy info) {
        UserSecPolicyInfo policy = null;
        if (null != info) {
            policy = new UserSecPolicyInfo();
            long policyId = info.getId();
            if (policyId > 0L) {
                policy.setId(info.getId());
            }
            policy.setComplex(info.getComplex());
            policy.setPswLenth(info.getPswLenth());
            policy.setUnseal(info.getUnseal());
            policy.setUsefulLife(info.getUsefulLife());
        }
        return policy;
    }

    public static String getRoleBoProByRoleVoPro(String roleVoProName) {
        if ("roleName".equals(roleVoProName)) {
            return "roleName";
        }
        if ("roleDes".equals(roleVoProName)) {
            return "roleDescription";
        }
        if ("roleID".equals(roleVoProName)) {
            return "roleId";
        }
        return "roleName";
    }
}

