/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.common;

import com.hs.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.cbb.user.service.security.ISecurity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AddressUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SystemInitializeUserThread
implements Runnable {
    private static final String DEFALT_USER_NAME = "admin";
    private static final String DEFAULT_PROPERTIES = "/confUser.properties";
    private static final Properties PROPS = new Properties();
    private static final Map<String, Set<String>> URL_OPER_MAP = new HashMap<String, Set<String>>();
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private static boolean propertyInit = false;
    private transient ISecurity security;
    private transient IUserService userService;
    private ICommonDao commonDao;
    private IDataProtectService dataProtectService;
    private String defaultUserProtectPwd = null;

    public void afterPropertiesSet() {
        this.initSysUser();
        this.initSysLoginPolicy();
        this.initUrlOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUrlOperation() {
        File file = new File("");
        String path = file.getAbsolutePath();
        Properties props = new Properties();
        String currentPath = path + File.separator + "resources" + File.separator + "urlConf";
        InputStream inputStream = null;
        File files = new File(currentPath);
        File[] fileArray = files.listFiles();
        if (this.checkFileValid(files) || null == fileArray) {
            return;
        }
        try {
            for (File propertiesFile : fileArray) {
                if (this.checkPropertyFileValid(propertiesFile)) continue;
                inputStream = new FileInputStream(propertiesFile);
                props.load(inputStream);
                inputStream.close();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String[] urls;
                    Object operation = entry.getKey();
                    for (String url : urls = entry.getValue().toString().split(";")) {
                        if (null == url || url.isEmpty()) continue;
                        Set<String> valueSet = URL_OPER_MAP.get(url);
                        if (null == valueSet) {
                            valueSet = new HashSet<String>();
                        }
                        valueSet.add(operation.toString());
                        URL_OPER_MAP.put(url, valueSet);
                    }
                }
            }
        }
        catch (FileNotFoundException fe) {
            log.error((Object)"file not found exception");
        }
        catch (IOException iex) {
            log.error((Object)"IOException error");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"IOException error");
                }
            }
            this.doFinally(props);
        }
    }

    private void doFinally(Properties props) {
        if (null != props) {
            props.clear();
        }
    }

    private boolean checkPropertyFileValid(File propertiesFile) {
        return !propertiesFile.isFile() || !propertiesFile.getName().endsWith("properties");
    }

    private boolean checkFileValid(File files) {
        return !files.exists() || !files.isDirectory();
    }

    private void initSysUser() {
        UserInfo userInfo = null;
        UserAclInfo aclInfo = null;
        try {
            userInfo = this.userService.getUserInfoByName(DEFALT_USER_NAME, false);
        }
        catch (Exception e) {
            log.error((Object)"System not exist user");
        }
        if (null == userInfo) {
            this.initProperty();
            log.info((Object)"initProperty");
            UserInfo defaultUser = this.getDefaultUserInfo();
            log.info((Object)("defaultUser:" + defaultUser.getUserName()));
            aclInfo = this.getDefaultUserAclInfo();
            log.info((Object)("aclInfo:" + aclInfo.getId()));
            defaultUser.addTouserAcls(aclInfo);
            log.info((Object)"addTouserAcls:");
            this.commonDao.saveOrUpdate((Object)defaultUser);
            log.info((Object)"commonDao.saveOrUpdate:");
        }
    }

    private void initSysLoginPolicy() {
        UserLoginPolicyInfo info = this.security.getLoginPolicy();
        if (null == info) {
            this.initProperty();
            UserLoginPolicyInfo defaultLoginPolicy = this.getDefaultLoginPolicy();
            this.commonDao.save((Object)defaultLoginPolicy);
        } else if (null == info.getIntercurrentLogin()) {
            info.setIntercurrentLogin(0);
            this.commonDao.update((Object)info);
        }
        UserSecPolicyInfo secInfo = this.security.getUserSecPolicy();
        if (null == secInfo) {
            this.initProperty();
            UserSecPolicyInfo defaultSecPolicy = this.getDefaultSecPolicy();
            this.commonDao.save((Object)defaultSecPolicy);
        }
    }

    private void initProperty() {
        if (propertyInit) {
            return;
        }
        InputStream stream = null;
        try {
            String path = SystemInitializeUserThread.class.getResource(DEFAULT_PROPERTIES).toString();
            log.info((Object)("path = " + path));
            stream = SystemInitializeUserThread.class.getResourceAsStream(DEFAULT_PROPERTIES);
            if (null != stream) {
                PROPS.load(stream);
            }
        }
        catch (IOException e) {
            log.error((Object)"read default.properties fail.");
        }
        catch (Exception e) {
            log.error((Object)"read default.properties fail.", (Throwable)e);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException error");
            }
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)PROPS);
        System.setProperties(sysProps);
        log.debug((Object)PROPS);
        propertyInit = true;
    }

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public UserInfo getDefaultUserInfo() {
        UserInfo info = new UserInfo();
        String userName = this.getProperty("sys.defalt.userName", "");
        info.setIsAdmin(true);
        info.setUserName(userName);
        info.setUserPwd(this.getDefaultUserProtectPwd());
        info.setMustModiPassword(true);
        info.setPasswordModel(0);
        long setTime = System.currentTimeMillis();
        info.setSetTime(setTime);
        return info;
    }

    public String getDefaultUserProtectPwd() {
        if (this.defaultUserProtectPwd == null) {
            this.initProperty();
        }
        this.defaultUserProtectPwd = this.dataProtectService.sdpProtectPwd(new StringBuffer(this.dataProtectService.sdpDecryptInitData(this.getProperty("sys.defalt.userPwd", ""))));
        return this.defaultUserProtectPwd;
    }

    public UserLoginPolicyInfo getDefaultLoginPolicy() {
        UserLoginPolicyInfo info = new UserLoginPolicyInfo();
        int lgoinInterval = this.getInt("system.login.policy.lgoinInterval");
        int lgoinCount = this.getInt("system.login.policy.lgoinCount");
        int lockTime = this.getInt("system.login.policy.lockTime");
        int intercurrentLogin = this.getInt("system.login.policy.intercurrentLogin");
        int unseal = this.getInt("system.login.policy.unseal");
        int sessionTimeOut = this.getInt("system.login.policy.sessionTimeOut");
        info.setId(1L);
        info.setLgoinCount(lgoinCount);
        info.setLgoinInterval(lgoinInterval);
        info.setLockTime(lockTime);
        info.setIntercurrentLogin(intercurrentLogin);
        info.setSessionTimeOut(sessionTimeOut);
        info.setUnseal(unseal);
        return info;
    }

    public UserSecPolicyInfo getDefaultSecPolicy() {
        UserSecPolicyInfo info = new UserSecPolicyInfo();
        int pswLenth = this.getInt("system.sec.policy.pswLenth");
        int unseal = this.getInt("system.sec.policy.unseal");
        int usefulLife = this.getInt("system.sec.policy.usefulLife");
        String complex = this.getProperty("system.sec.policy.complex", "");
        info.setComplex(complex);
        info.setPswLenth(pswLenth);
        info.setUnseal(unseal);
        info.setUsefulLife(usefulLife);
        info.setId(1L);
        return info;
    }

    public UserAclInfo getDefaultUserAclInfo() {
        UserAclInfo info = new UserAclInfo();
        String startIp = this.getProperty("system.sec.acl.startip", "");
        String endIp = this.getProperty("system.sec.acl.endip", "");
        long lStartIp = AddressUtil.ipToLong((String)startIp);
        long lEndIp = AddressUtil.ipToLong((String)endIp);
        info.setEndIp(lEndIp);
        info.setStartIp(lStartIp);
        return info;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    public Map<String, Set<String>> getUrlOperMap() {
        if (null == URL_OPER_MAP || URL_OPER_MAP.isEmpty()) {
            this.initUrlOperation();
        }
        return URL_OPER_MAP;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    @Override
    public void run() {
        this.afterPropertiesSet();
    }
}

