/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.notes;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.service.notes.IBroadcastServices;
import com.hs.lego.cbb.user.service.notes.SendMessageMgr;
import com.hs.lego.comm.internal.jms.MessageTopic;
import java.util.HashMap;
import java.util.Set;

public class BroadcastServices
implements IBroadcastServices {
    private SendMessageMgr sendMessageMgr;

    public void setSendMessageMgr(SendMessageMgr sendMessageMgr) {
        this.sendMessageMgr = sendMessageMgr;
    }

    @Override
    public void noteAddUser(User userInfo) {
        Set set = userInfo.getMoAuthIdsSet();
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        map.put(userInfo.getUserID(), set);
        this.sendMessageMgr.sendMessage(4001L, map, MessageTopic.COMMAND);
    }

    @Override
    public void noteDelUser(Long userId) {
        this.sendMessageMgr.sendMessage(4003L, userId, MessageTopic.COMMAND);
    }

    @Override
    public void noteUserChange(User userInfo) {
        Set set = userInfo.getMoAuthIdsSet();
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        map.put(userInfo.getUserID(), set);
        this.sendMessageMgr.sendMessage(4002L, map, MessageTopic.COMMAND);
    }

    @Override
    public void grandObjectToUser(long userId, Set<Long> moIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        map.put(userId, moIds);
        this.sendMessageMgr.sendMessage(4004L, map, MessageTopic.COMMAND);
    }

    @Override
    public void unchainObjectToUser(long userId, Set<Long> moIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        map.put(userId, moIds);
        this.sendMessageMgr.sendMessage(4005L, map, MessageTopic.COMMAND);
    }

    public SendMessageMgr getSendMessageMgr() {
        return this.sendMessageMgr;
    }
}

