/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.notes;

import com.hs.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDeviceForm;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.beans.factory.InitializingBean;

public class UserReceiveMessageMgr
extends MessageTaskManager
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private IUserRelMoService userRelMoService = null;
    private IMessageCenter messageCenter = null;

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(116L);
        return mrs;
    }

    public void onMessage(MessageUnit message) {
        if (null == message) {
            return;
        }
        int messageCode = (int)message.getCmdcode();
        if (116L == (long)messageCode) {
            if (message.getSourceAppName().equals("com.huawei.atic.secne.service.impl.ClusterServiceImpl")) {
                return;
            }
            ArrayList deviceList = (ArrayList)message.getObj();
            HashSet<Long> deviceIdList = new HashSet<Long>();
            for (AticDeviceForm aticDeviceForm : deviceList) {
                deviceIdList.add(aticDeviceForm.getMoId());
            }
            try {
                this.userRelMoService.deleteManageObject(deviceIdList, null);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"delete user relation mo is error", (Throwable)ex);
            }
        }
    }

    public IUserRelMoService getUserRelMoService() {
        return this.userRelMoService;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public void afterPropertiesSet() {
        this.messageCenter.addSubscriberTo((MessageTaskManager)this);
    }
}

