/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.operation;

import com.hs.lego.cbb.user.dao.IOperationDao;
import com.hs.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.hs.lego.cbb.user.service.operation.IOperationService;
import com.hs.lego.cbb.user.service.operation.ProductsOperationFilterFactory;
import com.hs.lego.cbb.user.service.roleservice.IRoleService;
import com.hs.lego.cbb.user.thirdauth.sdk.IProductsOperationFilter;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.tree.DataElement;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import com.hs.lego.nem.topo.sdk.model.UIElement;
import com.hs.lego.nem.topo.sdk.model.UIStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class OperationService
implements IOperationService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private IOperationDao operationDao;
    private IRoleService roleService;

    @Override
    public List<OperationInfo> getAllOpt() {
        if (this.operationDao != null) {
            List<OperationInfo> all = this.operationDao.getAllOpt();
            Collection<IProductsOperationFilter> collection = ProductsOperationFilterFactory.getInstance().getThirdAuthority();
            if (collection != null && !collection.isEmpty()) {
                for (IProductsOperationFilter filter : collection) {
                    all = filter.getAllOpt(all);
                }
            }
            return all;
        }
        LOGGER.error((Object)"operationDao is null");
        return null;
    }

    @Override
    public RootDataElement getOptTree(Long roleId) {
        Set<OperationInfo> set = null;
        if (-1L == roleId) {
            return this.getOptTree();
        }
        if (this.roleService != null) {
            RoleInfo role = this.roleService.getRole(roleId);
            set = role.getOperationSet();
        } else {
            LOGGER.error((Object)"roleService is null");
        }
        RootDataElement rootTree = new RootDataElement();
        List<OperationInfo> result = this.getAllOpt();
        if (null != result && null != set) {
            rootTree = this.getOptTree(result, set);
        }
        return rootTree;
    }

    @Override
    public RootDataElement getOptTree() {
        List<OperationInfo> result = this.getAllOpt();
        RootDataElement rootTree = this.getOptTree(result);
        return rootTree;
    }

    protected DataElement createDataElement(OperationInfo op, int index) {
        int topoTypeGroup = 3;
        DataElement dataEle = new DataElement();
        dataEle.setDisName(op.getOpName());
        dataEle.setEleType(Long.valueOf(topoTypeGroup));
        dataEle.setId(op.getOpId());
        dataEle.setEntityId("" + op.getOpId());
        dataEle.addStyle(new UIStyle("sortId", "" + index));
        dataEle.addStyle(new UIStyle("ctrlSel", String.valueOf(op.isIsMaster())));
        return dataEle;
    }

    private RootDataElement getOptTree(Collection<OperationInfo> result) {
        TreeSet<OperationInfo> treeSet = new TreeSet<OperationInfo>();
        if (null == result) {
            LOGGER.error((Object)"result is null");
            return new RootDataElement();
        }
        for (OperationInfo op : result) {
            String serialNumber = op.getSerialNumber();
            if (serialNumber.equalsIgnoreCase("None")) continue;
            treeSet.add(op);
        }
        RootDataElement rootTree = new RootDataElement();
        HashMap<String, DataElement> dataMap = new HashMap<String, DataElement>();
        int sortId = 0;
        for (OperationInfo op : treeSet) {
            DataElement curDataEle = this.createDataElement(op, ++sortId);
            String serialNumber = op.getSerialNumber();
            if (serialNumber.equalsIgnoreCase("None")) continue;
            int pos = serialNumber.lastIndexOf(45);
            if (pos == -1) {
                rootTree.addChildEle((UIElement)curDataEle);
                dataMap.put(serialNumber, curDataEle);
                continue;
            }
            String parentStr = serialNumber.substring(0, pos);
            DataElement parentEle = (DataElement)dataMap.get(parentStr);
            if (parentEle != null) {
                parentEle.addChildEle((UIElement)curDataEle);
            }
            dataMap.put(serialNumber, curDataEle);
        }
        return rootTree;
    }

    private RootDataElement getOptTree(Collection<OperationInfo> allOpt, Collection<OperationInfo> fliter) {
        ArrayList<OperationInfo> result = new ArrayList<OperationInfo>();
        for (OperationInfo opt : fliter) {
            String[] serialArr;
            int serialArrLen;
            String serialNumber = opt.getSerialNumber();
            if (serialNumber.equalsIgnoreCase("None") || (serialArrLen = (serialArr = serialNumber.split("-")).length) <= 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(serialArr[0]);
            for (int i = 0; i < serialArrLen; ++i) {
                if (i != 0) {
                    sb.append("-" + serialArr[i]);
                }
                for (OperationInfo temp : allOpt) {
                    if (!temp.getSerialNumber().equals(sb.toString())) continue;
                    result.add(temp);
                }
            }
        }
        return this.getOptTree(result);
    }

    public IOperationDao getOperationDao() {
        return this.operationDao;
    }

    public void setOperationDao(IOperationDao operationDao) {
        this.operationDao = operationDao;
    }

    public void setRoleService(IRoleService roleService) {
        this.roleService = roleService;
    }

    @Override
    public RootDataElement getOptTreeByUser(Long userId) {
        RootDataElement rootTree = new RootDataElement();
        if (this.operationDao == null) {
            return rootTree;
        }
        Set<OperationInfo> allOpts = this.operationDao.getAllOpt(userId);
        if (allOpts == null || allOpts.isEmpty()) {
            return rootTree;
        }
        List<OperationInfo> result = this.getAllOpt();
        if (result != null) {
            rootTree = this.getOptTree(result, allOpts);
        }
        return rootTree;
    }

    @Override
    public Set<Long> getAllOptId(Long userId) {
        HashSet<Long> set = new HashSet<Long>();
        if (this.operationDao == null) {
            return set;
        }
        Collection<OperationInfo> allOpts = null;
        allOpts = userId == null ? this.operationDao.getAllOpt() : this.operationDao.getAllOpt(userId);
        if (allOpts == null || allOpts.isEmpty()) {
            return set;
        }
        for (OperationInfo opt : allOpts) {
            if (opt.getOpName() == null || opt.getOpName().startsWith("lego.sys.operatorMgr.operator") || opt.getOpName().startsWith("lego.sys.role")) continue;
            set.add(opt.getOpId());
        }
        return set;
    }
}

