/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.operation;

import com.hs.lego.cbb.user.thirdauth.sdk.IProductsOperationFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ProductsOperationFilterFactory
implements InitializingBean,
DisposableBean {
    private static final Object LOCK = new Object();
    private static ProductsOperationFilterFactory sInstance = null;
    private Map<String, IProductsOperationFilter> serviceMap = new HashMap<String, IProductsOperationFilter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductsOperationFilterFactory getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == sInstance) {
                sInstance = new ProductsOperationFilterFactory();
            }
            return sInstance;
        }
    }

    public void afterPropertiesSet() {
        if (null != this.serviceMap) {
            this.serviceMap.clear();
        }
    }

    public void destroy() {
        if (null != this.serviceMap) {
            this.serviceMap.clear();
        }
    }

    public void onBind(IProductsOperationFilter service, Map<?, ?> properties) {
        this.serviceMap.put(service.getFilterName(), service);
    }

    public void unBind(IProductsOperationFilter service, Map<?, ?> properties) {
        this.serviceMap.remove(service.getFilterName());
    }

    public IProductsOperationFilter getThirdAuthorityByType(String filterName) {
        IProductsOperationFilter thirdAuthority = null;
        if (null != this.serviceMap) {
            thirdAuthority = this.serviceMap.get(filterName);
        }
        return thirdAuthority;
    }

    public Collection<IProductsOperationFilter> getThirdAuthority() {
        Collection<IProductsOperationFilter> set = null;
        if (null != this.serviceMap) {
            set = this.serviceMap.values();
        }
        return set;
    }
}

