/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.roleservice;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.dao.IRoleDao;
import com.hs.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.model.Role;
import com.hs.lego.cbb.user.service.common.ObjectConvertor;
import com.hs.lego.cbb.user.service.roleservice.IRoleService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.comm.SortUnit;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoleService
implements IRoleService {
    private Log log;
    private IRoleDao roleDao;
    private ICommonDao commDao;
    private final Object lock = new Object();

    public RoleService() {
        this.log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addRoleInfo(Role oRole, List<Long> mapOpts) {
        Object object = this.lock;
        synchronized (object) {
            this.roleDao.checkRoleNameSingle(oRole.getRoleName());
            RoleInfo tmpRoleInfo = ObjectConvertor.translatePoRole(oRole);
            HashSet<OperationInfo> operationSet = new HashSet<OperationInfo>();
            for (Long m : mapOpts) {
                operationSet.add(new OperationInfo(m));
            }
            tmpRoleInfo.setOperationSet(operationSet);
            this.roleDao.addRoleInfo(tmpRoleInfo);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(long roleId) {
        Object object = this.lock;
        synchronized (object) {
            this.roleDao.deleteRole(roleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult batchDelRoles(List<BatchOperation> list) {
        Object object = this.lock;
        synchronized (object) {
            BatchOperationResult result = new BatchOperationResult();
            ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
            int fail = 0;
            int operCount = 0;
            if (null != list) {
                operCount = list.size();
                for (BatchOperation batchOperation : list) {
                    try {
                        this.deleteRole(batchOperation.getTargetId());
                    }
                    catch (LegoCheckedException e) {
                        ++fail;
                        batchOperation.setErrorCode(e.getErrorCode());
                    }
                    catch (LegoUncheckedException e) {
                        ++fail;
                        batchOperation.setErrorCode(e.getErrorCode());
                    }
                    catch (Exception e) {
                        ++fail;
                        batchOperation.setErrorCode(102L);
                    }
                    resultList.add(batchOperation);
                }
                result.setResult(resultList);
                result.setFailCount(fail);
                result.setTotalCount(operCount);
                result.setSucceedCount(operCount - fail);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role getRoleInf(long iRoleId) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<OperationInfo> tmpOptInfo = new HashSet<OperationInfo>();
            RoleInfo roleInfo = new RoleInfo();
            AticUtil.copyProperties((Object)this.roleDao.getRoleById(iRoleId, true), (Object)roleInfo);
            Set<OperationInfo> optSet = roleInfo.getOperationSet();
            roleInfo.setOperationSet(tmpOptInfo);
            Role oRole = ObjectConvertor.translateBoRoleInfo(roleInfo, true);
            HashSet<Long> optIdsSet = new HashSet<Long>();
            if (null != optSet && !optSet.isEmpty()) {
                for (OperationInfo opt : optSet) {
                    optIdsSet.add(opt.getOpId());
                }
            }
            oRole.setOptIdsSet(optIdsSet);
            return oRole;
        }
    }

    @Override
    public RoleInfo getRole(long iRoleId) {
        return this.roleDao.getRoleById(iRoleId, true);
    }

    @Override
    public Role getRoleInfRelUser(long iRoleId, boolean isFetchUser) {
        Role oRole = new Role();
        RoleInfo roleInfo = this.roleDao.getRoleById(iRoleId, true);
        try {
            roleInfo = this.roleDao.getRoleInfRelUser(iRoleId, isFetchUser);
        }
        catch (Exception e) {
            this.log.info((Object)"the roleInfo  is empty!");
        }
        if (null != roleInfo.getUserSet() && !roleInfo.getUserSet().isEmpty()) {
            for (UserInfo userInfo : roleInfo.getUserSet()) {
                oRole.getUserSet().add(ObjectConvertor.getUser(userInfo, false, false));
            }
        }
        return oRole;
    }

    @Override
    public int updataRole(Role oRole, List<Long> mapOpts) {
        RoleInfo tmpRoleInfo = this.roleDao.getRoleById(oRole.getRoleID(), true);
        tmpRoleInfo.setOperationSet(new HashSet<OperationInfo>());
        RoleInfo tmpRoleInfoFromPo = ObjectConvertor.translatePoRole(oRole);
        tmpRoleInfo.setCreatorId(tmpRoleInfoFromPo.getCreatorId());
        tmpRoleInfo.setCreatTime(tmpRoleInfoFromPo.getCreatTime());
        tmpRoleInfo.setRoleDescription(tmpRoleInfoFromPo.getRoleDescription());
        tmpRoleInfo.setRoleName(tmpRoleInfoFromPo.getRoleName());
        HashSet<OperationInfo> operationSet = new HashSet<OperationInfo>();
        for (Long m : mapOpts) {
            operationSet.add(new OperationInfo(m));
        }
        tmpRoleInfo.setOperationSet(operationSet);
        this.roleDao.updataRole(tmpRoleInfo);
        return 0;
    }

    @Override
    public List<Role> getAllRoles(boolean isFetchRole) {
        List<RoleInfo> lstSingleRoleInfo = null;
        ArrayList<Role> lstRole = new ArrayList<Role>();
        lstSingleRoleInfo = this.roleDao.getAllRoles(isFetchRole);
        String sCount = "select count(*) from UserIdAndRoleId as ur where ur.id.relRoleId = ";
        int iCount = 0;
        for (RoleInfo tmpRoleInfo : lstSingleRoleInfo) {
            Role tmpRole = ObjectConvertor.translateBoRoleInfo(tmpRoleInfo, false);
            try {
                iCount = (int)this.commDao.getTotalCount(sCount + tmpRoleInfo.getRoleId().toString());
                tmpRole.setUserNum(iCount);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
            }
            lstRole.add(tmpRole);
        }
        return lstRole;
    }

    @Override
    public Paging getAllRoles(int start, int length, SortUnit su) {
        List lstSingleRoleInfo = null;
        ArrayList<Role> lstRole = new ArrayList<Role>();
        Paging rolepaging = new Paging();
        String rolepagehql = "FROM RoleInfo ";
        if (null != su) {
            rolepagehql = rolepagehql + " as d order by d." + ObjectConvertor.getRoleBoProByRoleVoPro(su.getFieldName()) + " " + su.getSortType();
        }
        String sCount = "select count(*) from UserIdAndRoleId as ur where ur.id.relRoleId = ";
        String couthql = "select count(*) from RoleInfo";
        try {
            lstSingleRoleInfo = this.commDao.findPage(rolepagehql, start, length);
            int iCount = 0;
            for (RoleInfo tmpRoleInfo : lstSingleRoleInfo) {
                Role tmpRole = ObjectConvertor.translateBoRoleInfo(tmpRoleInfo, false);
                iCount = (int)this.commDao.getTotalCount(sCount + tmpRoleInfo.getRoleId().toString());
                tmpRole.setUserNum(iCount);
                lstRole.add(tmpRole);
            }
            rolepaging.setData(lstRole);
            rolepaging.setCount((int)this.commDao.getTotalCount(couthql));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return rolepaging;
    }

    public void setRoleDao(IRoleDao mRoleDao) {
        this.roleDao = mRoleDao;
    }

    public ICommonDao getCommDao() {
        return this.commDao;
    }

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }
}

