/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.security;

import com.hs.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.cbb.user.service.common.SessionGeneratorUtil;
import com.hs.lego.cbb.user.service.security.IAuthorityService;
import com.hs.lego.cbb.user.service.security.ISecurity;
import com.hs.lego.cbb.user.service.security.LoginFailCounter;
import com.hs.lego.cbb.user.service.security.ThirdAuthorityFactory;
import com.hs.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.hs.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.hs.lego.cbb.user.thirdauth.sdk.IThirdAuthority;
import com.hs.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.SortList;
import com.hs.lego.core.sdk.util.TimeUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class AuthorityService
implements IAuthorityService {
    private static final int DEFULT_TIME_OUT = 30;
    private static final int MINUTE_SECOND = 60;
    private static final int MIN_SESSION_TIMEOUT = 1;
    private static final String USER_LOCK = "USER_LOCK";
    private static final String USER_LOGIN_FAIL = "USER_LOGIN_FAIL";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private ISecurity security;
    private IUserLoginLocalCache cacheService;
    private transient IUserRelMoService userRelMoService;
    private String onlineSessionIdList = "onlineSessionIdList";
    private IThirdAuthority thirdAuthority;
    private IUserService userService;
    private IDataProtectService dataProtectService;

    @Override
    public UserInfo login(String hostIp, String userName, String pwd) {
        boolean temporaryLock = this.checkTemporaryLock(userName);
        if (temporaryLock) {
            throw new LegoCheckedException(284L);
        }
        boolean isOverMaxOnlineCount = this.checkOnlineCount(userName);
        if (isOverMaxOnlineCount) {
            throw new LegoCheckedException(260L);
        }
        UserInfo userInfo = this.checkUserPswRight(userName, pwd, false);
        if (null != userInfo) {
            this.dealLoginFailInfo(userName, userInfo);
            return userInfo;
        }
        this.doLoginFail(userName, hostIp);
        throw new LegoCheckedException(256L);
    }

    private void dealLoginFailInfo(String userName, UserInfo userInfo) {
        String loginFailKey;
        if (userInfo.isIsLock()) {
            throw new LegoCheckedException(293L);
        }
        if (null != this.cacheService && this.cacheService.containsKey(loginFailKey = USER_LOGIN_FAIL + userName, true)) {
            this.cacheService.remove(loginFailKey);
        }
    }

    @Override
    public String generateSessionId(UserInfo userInfo, String hostIp) {
        String sessionId = SessionGeneratorUtil.generateSessionId(userInfo.getId(), hostIp);
        User onlineUser = new User();
        onlineUser.setLoginDate(TimeUtil.getCurrentDate());
        onlineUser.setLoginTime(System.currentTimeMillis());
        onlineUser.setUserID(userInfo.getId().longValue());
        onlineUser.setIpAdr(hostIp);
        onlineUser.setSession(sessionId);
        onlineUser.setUserName(userInfo.getUserName());
        try {
            UserLoginPolicyInfo temp = this.security.getLoginPolicy();
            int saveTime = 0;
            int sessionTimeOut = 0;
            if (null != temp) {
                sessionTimeOut = temp.getSessionTimeOut();
                if (sessionTimeOut < 1) {
                    sessionTimeOut = 30;
                }
                saveTime = 60 * sessionTimeOut;
            } else {
                saveTime = 1800;
            }
            if (null != this.cacheService) {
                ConcurrentSkipListSet set;
                this.cacheService.put(sessionId, onlineUser, saveTime);
                if (!this.cacheService.containsKey(this.onlineSessionIdList)) {
                    set = new ConcurrentSkipListSet();
                    this.cacheService.put(this.onlineSessionIdList, set);
                }
                if (this.cacheService.containsKey(this.onlineSessionIdList)) {
                    set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
                    set.add(sessionId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return sessionId;
    }

    @Override
    public UserInfo login(UserInfo userInfo) {
        return this.login("", userInfo.getUserName(), userInfo.getUserPwd());
    }

    @Override
    public final Boolean checkUserPsw(String userName, String pwd) {
        boolean passwordRight = Boolean.FALSE;
        UserInfo userInfo = this.checkUserPswRight(userName, pwd, false);
        if (null != userInfo) {
            passwordRight = Boolean.TRUE;
        }
        return passwordRight;
    }

    @Override
    public final Boolean checkUserPsw(String userName, String pwd, boolean pwdEncrypt) {
        boolean passwordRight = Boolean.FALSE;
        UserInfo userInfo = this.checkUserPswRight(userName, pwd, true);
        if (null != userInfo) {
            passwordRight = Boolean.TRUE;
        }
        return passwordRight;
    }

    private UserInfo checkUserPswRight(String userName, String pwd, boolean pwdEncrypt) {
        boolean passwordRight = false;
        UserInfo userInfo = null;
        try {
            userInfo = this.userService.getUserInfoByName(userName, false);
        }
        catch (Exception e) {
            return userInfo;
        }
        if (null == userInfo) {
            return userInfo;
        }
        if (userInfo.isIsLock()) {
            throw new LegoCheckedException(293L);
        }
        if (userInfo.getPasswordModel().intValue() != UserAuthorityType.local.getValue()) {
            this.thirdAuthority = ThirdAuthorityFactory.getInstance().getThirdAuthorityByType(userInfo.getPasswordModel());
            if (null == this.thirdAuthority) {
                throw new LegoCheckedException(292L);
            }
            try {
                passwordRight = this.thirdAuthority.userAuthority(userInfo.getUserName(), pwd);
            }
            catch (LegoCheckedException ex) {
                if (ex.getErrorCode() == 256L) {
                    return null;
                }
                throw ex;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"checkUserPswRight cause Exception", (Throwable)ex);
                throw new LegoCheckedException(102L, (Throwable)ex);
            }
            if (passwordRight) {
                return userInfo;
            }
            return null;
        }
        boolean result = this.dataProtectService.sdpVerifyPwd(DataProtectServiceConst.sdpDecryptLocalBuffer((String)pwd), userInfo.getUserPwd());
        if (!result) {
            return null;
        }
        return userInfo;
    }

    @Override
    public void logout(String sessionId) {
        ConcurrentSkipListSet set;
        if (null == this.cacheService) {
            return;
        }
        if (this.cacheService.containsKey(sessionId, true)) {
            this.cacheService.remove(sessionId);
        }
        if (this.cacheService.containsKey(this.onlineSessionIdList) && (set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList)).contains(sessionId)) {
            set.remove(sessionId);
        }
    }

    @Override
    public List<String> getOnlineUserSession(long userId) {
        ArrayList<String> onLineUserSessionList = new ArrayList<String>();
        if (null == this.cacheService) {
            return null;
        }
        if (this.cacheService.containsKey(this.onlineSessionIdList)) {
            ConcurrentSkipListSet set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
            for (String temp : set) {
                if (this.cacheService.containsKey(temp, true)) {
                    User tempUser = (User)this.cacheService.get(temp, true);
                    if (tempUser.getUserID() != userId) continue;
                    onLineUserSessionList.add(tempUser.getSession());
                    continue;
                }
                set.remove(temp);
            }
        }
        return onLineUserSessionList;
    }

    @Override
    public List<User> getAllOnlineUser() {
        if (null == this.cacheService) {
            return null;
        }
        ArrayList<User> allOnLineUser = new ArrayList<User>();
        if (this.cacheService.containsKey(this.onlineSessionIdList)) {
            ConcurrentSkipListSet set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
            for (String temp : set) {
                if (this.cacheService.containsKey(temp, true)) {
                    User tempUser = (User)this.cacheService.get(temp, true);
                    String stayTime = TimeUtil.getInterval((long)tempUser.getLoginTime());
                    tempUser.setStayTime(stayTime);
                    allOnLineUser.add(tempUser);
                    continue;
                }
                set.remove(temp);
            }
        }
        return allOnLineUser;
    }

    @Override
    public List<User> getAllOnlineUser(String sortFile, String sortType) {
        String sort = sortType;
        List<User> list = this.getAllOnlineUser();
        String methodName = "";
        SortList sortList = new SortList();
        if (sortFile.equals("ipAdr")) {
            methodName = "getIpAdr";
        } else if (sortFile.equals("userName")) {
            methodName = "getUserName";
        } else if (sortFile.equals("stayTime")) {
            sort = this.turnOver(sortType);
            methodName = "getLoginTime";
        } else if (sortFile.equals("loginDate")) {
            methodName = "getLoginDate";
        }
        if (null != list) {
            sortList.sort(list, methodName, sort);
        }
        return list;
    }

    @Override
    public boolean checkTimeout(String sessionId, boolean prolongTime) {
        if (null == this.cacheService) {
            LOGGER.debug((Object)"cacheService is null");
            return true;
        }
        Boolean result = Boolean.TRUE;
        if (prolongTime) {
            if (this.cacheService.containsKey(sessionId)) {
                result = Boolean.FALSE;
            }
        } else if (this.cacheService.containsKey(sessionId, true)) {
            result = Boolean.FALSE;
        }
        LOGGER.debug((Object)("checkTimeout result is : " + result + " prolongTime is : " + prolongTime));
        return result;
    }

    @Override
    public final Map checkUserRight(long userId, List<String> opIds) {
        UserInfo user = null;
        try {
            user = this.userService.getFullUserInfoById(userId);
        }
        catch (Exception e) {
            LOGGER.info((Object)("user is null" + e));
        }
        if (null == user) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (null != opIds) {
            for (String i : opIds) {
                map.put(i, this.checkUserRight(userId, i));
            }
        }
        return map;
    }

    @Override
    public final boolean checkUserRight(long userId, String opId) {
        boolean hasRight = false;
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            hasRight = Boolean.TRUE;
            return hasRight;
        }
        UserInfo user = null;
        try {
            user = this.userService.getFullUserInfoById(userId);
        }
        catch (Exception e) {
            LOGGER.info((Object)("user is null" + e));
        }
        if (null == user) {
            return hasRight;
        }
        Set<RoleInfo> roleSet = user.getRolesSet();
        if (null == roleSet) {
            return hasRight;
        }
        for (RoleInfo role : roleSet) {
            Set<OperationInfo> operSet = role.getOperationSet();
            if (null == operSet) {
                return hasRight;
            }
            for (OperationInfo operInfo : operSet) {
                if (!opId.equalsIgnoreCase(operInfo.getOpName())) continue;
                hasRight = true;
                return hasRight;
            }
        }
        return hasRight;
    }

    @Override
    public final Boolean checkUserIsAdmin(long userId) {
        Boolean result = Boolean.FALSE;
        UserInfo user = null;
        try {
            user = this.userService.getUserInfoById(userId, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        if (null != user) {
            result = user.isIsAdmin();
        }
        return result;
    }

    @Override
    public final Boolean checkUserIsAuditor(long userId) {
        Set<RoleInfo> roleSet;
        Boolean result = Boolean.FALSE;
        UserInfo user = null;
        try {
            user = this.userService.getUserInfoById(userId, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        if (null != user && null != (roleSet = user.getRolesSet()) && !roleSet.isEmpty()) {
            for (RoleInfo role : roleSet) {
                if (role.getRoleId() != 3L) continue;
                result = Boolean.TRUE;
                return result;
            }
        }
        return result;
    }

    @Override
    public List<Long> getUserGrandObjects(UserInfo userInfo) {
        return this.getUserGrandObjects(userInfo.getId());
    }

    @Override
    public List<Long> getUserGrandObjects(long userId) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            list.add(-1L);
        } else {
            List<UserRelMoInfo> relMoList = this.userRelMoService.getUserAllRelMO(userId);
            for (UserRelMoInfo userRelMoInfo : relMoList) {
                list.add(userRelMoInfo.getId().getMoId());
            }
        }
        return list;
    }

    @Override
    public final Boolean checkUserGrandObject(long userId, long moId) {
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            return Boolean.TRUE;
        }
        return this.userRelMoService.checkUserRight(userId, moId);
    }

    @Override
    public final Set<String> getUserOpids(UserInfo userInfo) {
        return this.getUserAllOpNames(userInfo.getId());
    }

    @Override
    public final Set<String> getUserOpids(int userId) {
        return this.getUserAllOpNames(userId);
    }

    @Override
    public final Set<String> getUserAllOpNames(long userId) {
        HashSet<String> set = new HashSet<String>();
        UserInfo user = null;
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            return null;
        }
        try {
            user = this.userService.getFullUserInfoById(userId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"get user is error");
        }
        if (null == user) {
            set.add(null);
            return set;
        }
        Set<RoleInfo> roleSet = user.getRolesSet();
        if (null == roleSet) {
            return set;
        }
        for (RoleInfo role : roleSet) {
            Set<OperationInfo> operSet = role.getOperationSet();
            if (null == operSet) continue;
            for (OperationInfo operInfo : operSet) {
                set.add(operInfo.getOpName());
            }
        }
        return set;
    }

    private boolean checkTemporaryLock(String userName) {
        boolean isLock = Boolean.FALSE;
        UserLoginPolicyInfo loginPolicyInfo = this.security.getLoginPolicy();
        if (null == loginPolicyInfo || loginPolicyInfo.getUnseal() < 1) {
            return isLock;
        }
        String userLockKey = USER_LOCK + userName;
        if (null == this.cacheService) {
            return isLock;
        }
        if (this.cacheService.containsKey(userLockKey, true)) {
            isLock = Boolean.TRUE;
        }
        return isLock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doLoginFail(String userName, String hostIp) {
        UserLoginPolicyInfo loginPolicyInfo = this.security.getLoginPolicy();
        if (null == loginPolicyInfo || loginPolicyInfo.getUnseal() < 1) {
            return;
        }
        String loginFailKey = USER_LOGIN_FAIL + userName;
        int loginFainlCount = 0;
        String userLockKey = USER_LOCK + userName;
        LoginFailCounter loginFailUser = (LoginFailCounter)this.cacheService.get(loginFailKey, true);
        if (null == loginFailUser) {
            loginFailUser = new LoginFailCounter();
            Date failTodate = TimeUtil.getAftertime((int)loginPolicyInfo.getLgoinInterval());
            this.cacheService.put(loginFailKey, loginFailUser, failTodate);
        }
        loginFainlCount = loginFailUser.getCount();
        loginFailUser.setCount(++loginFainlCount);
        if (loginFainlCount >= loginPolicyInfo.getLgoinCount()) {
            block7: {
                int lockTime = loginPolicyInfo.getLockTime();
                if (lockTime >= 0) {
                    Date lockToDate = TimeUtil.getAftertime((int)lockTime);
                    this.cacheService.put(userLockKey, userLockKey, lockToDate);
                    this.cacheService.remove(loginFailKey);
                    this.writeOptLog(userName, hostIp);
                    throw new LegoCheckedException(284L);
                }
                try {
                    this.security.lockUser(userName);
                    this.writeOptLog(userName, hostIp);
                }
                catch (LegoCheckedException ex) {
                    if (ex.getErrorCode() != 201L) break block7;
                    Date lockToDate = TimeUtil.getAftertime((int)1800);
                    this.cacheService.put(userLockKey, userLockKey, lockToDate);
                    this.cacheService.remove(loginFailKey);
                    this.writeOptLog(userName, hostIp);
                    throw new LegoCheckedException(284L, (Throwable)ex);
                }
            }
            this.cacheService.remove(loginFailKey);
            throw new LegoCheckedException(284L);
        }
        loginFailUser.setCount(loginFainlCount);
        if (loginFainlCount == loginPolicyInfo.getLgoinCount() - 1) {
            throw new LegoCheckedException(282L);
        }
    }

    private String turnOver(String sortType) {
        if (sortType.equalsIgnoreCase("desc")) {
            return "asc";
        }
        return "desc";
    }

    @Override
    public void clearLoginFailHistory() {
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    @Override
    public void addIntegrateSession(User user) {
        if (null != this.cacheService) {
            ConcurrentSkipListSet set;
            this.cacheService.put(user.getSession(), user, 30000);
            if (!this.cacheService.containsKey(this.onlineSessionIdList)) {
                set = new ConcurrentSkipListSet();
                this.cacheService.put(this.onlineSessionIdList, set);
            }
            if (this.cacheService.containsKey(this.onlineSessionIdList)) {
                set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
                set.add(user.getSession());
            }
        }
    }

    private void writeOptLog(String userName, String hostIp) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(new Date());
        oOptLog.setLevel(2);
        oOptLog.setModule("lego.dic.module.user");
        oOptLog.setOperation("lego.lab.log.func.loguserlock");
        oOptLog.setResult(1);
        oOptLog.setOperator(userName);
        oOptLog.setTerminalIp(hostIp);
        oOptLog.setTarget(userName);
        oOptLog.setTargetLocal(Boolean.valueOf(false));
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    private boolean checkOnlineCount(String userName) {
        boolean isOverMax = Boolean.FALSE;
        List<User> userList = this.getAllOnlineUser();
        int count = 0;
        if (null == userList) {
            return isOverMax;
        }
        for (User oneUser : userList) {
            if (!oneUser.getUserName().equals(userName)) continue;
            ++count;
        }
        int maxCount = 50;
        if (count >= maxCount) {
            isOverMax = Boolean.TRUE;
        }
        return isOverMax;
    }
}

